<?php
//Asthis Verification Code
class AVCode
{
	private $VCodeImage;
	private $imageWidth;
	private $imageHeight;
	private $codeLenght;
	private $codeFont;

	public $VCode;
	public $AVCodeError = array();

	public function __construct($imageWidth = '100', $imageHeight = '40', $codeLenght ='4', $codeFont = '')
	{
		$this->imageWidth = $imageWidth;
		$this->imageHeight = $imageHeight;
		$this->codeLenght = $codeLenght;
		$this->codeFont = $codeFont;
		$this->create_VCode();
		$this->create_VCodeImage();
	}

	private function create_VCode()
	{
		$this->VCode = $this->random_char($this->codeLenght);
	}

	private function create_VCodeImage()
	{
		//create canvas
		$this->VCodeImage = imagecreatetruecolor($this->imageWidth, $this->imageHeight);
		$bgColor = imagecolorallocate($this->VCodeImage, mt_rand(192, 255), mt_rand(192, 255), mt_rand(192, 255));
		imagefill($this->VCodeImage, 0, 0, $bgColor);

		//create jam
		$jamPointNum = floor($this->imageWidth * $this->imageHeight / 20);
		for($i = 0; $i < $jamPointNum; $i++)
		{
			$jamColor = imagecolorallocate($this->VCodeImage, mt_rand(128, 192), mt_rand(128, 192), mt_rand(128, 192));
			imagesetpixel($this->VCodeImage, mt_rand(0, $this->imageWidth), mt_rand(0, $this->imageHeight), $jamColor);
		}
		$jamArcNum = $this->codeLenght * 2;
		for($i = 0; $i < 10; $i++)
		{
			$jamColor = imagecolorallocate($this->VCodeImage, mt_rand(128, 192), mt_rand(128, 192), mt_rand(128, 192));
			imagearc($this->VCodeImage, mt_rand(-10, $this->imageWidth), mt_rand(-10, $this->imageHeight), mt_rand(30, 300), mt_rand(20, 200), mt_rand(0, 360), mt_rand(0, 360), $jamColor);
		}

		//write text
		for($i = 0; $i < $this->codeLenght; $i++)
		{
			if(0 == strlen($this->codeFont))
			{
				$fontSize = rand(4, 6);
				$x = floor($this->imageWidth / $this->codeLenght) * $i + 3;
				$y = mt_rand(0, $this->imageHeight - 15);
				$charColor = imagecolorallocate($this->VCodeImage, mt_rand(0, 128), mt_rand(0, 128), mt_rand(0, 128));
				imagechar($this->VCodeImage, $fontSize, $x, $y, $this->VCode[rand(0, $this->codeLenght - 1)], $charColor);
			}
			else
			{
				$fontSize = rand($this->imageHeight / 2, $this->imageHeight / 3 * 2);
				$x = floor($this->imageWidth / $this->codeLenght) * $i + 3;
				$y = mt_rand($this->imageHeight / 2, $this->imageHeight);
				$charColor = imagecolorallocate($this->VCodeImage, mt_rand(0, 128), mt_rand(0, 128), mt_rand(0, 128));
				imagettftext($this->VCodeImage, $fontSize, mt_rand(-10, 10), $x, $y, $charColor, $this->codeFont, $this->VCode[$i]);
			}

		}
	}

	public function show_VCodeImage()
	{
		if(imagetypes() & IMG_PNG)
		{
			header("Content-Type:image/png");
			header('Content-Disposition:attachment; filename=VCode.png');
			imagepng($this->VCodeImage);
		}
		elseif(imagetypes() & IMG_GIF)
		{
			header("Content-Type:image/gif");
			header('Content-Disposition:attachment; filename=VCode.gif');
			imagegif($this->VCodeImage);
		}
		elseif(imagetypes() & IMG_JPEG)
		{
			header("Content-Type:image/jpeg");
			header('Content-Disposition:attachment; filename=VCode.jpg');
			imagejpeg($this->VCodeImage);
		}
		else
		{
			$this->AVCodeError[] = "Image type match failed.\r\n";
		}
	}

	private function random_char($length)
	{
		$hash = '';
		$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$max = strlen($chars) - 1;
		for($i = 0; $i < $length; $i++)
		{
			$hash .= $chars[mt_rand(0, $max)];
		}
		return $hash;
	}

	public function __destruct()
	{
		if(!empty($this->VCodeImage))
		{
			imagedestroy($this->VCodeImage);
		}
	}

	public function __toString()
	{
		return 'Asthis Verification Code Class';
	}
}
/**
Usage:
----------------------------------------
session_start();
require_once('./lib/AVCode.class.php');
$codeFont =  './static/font/438-CAI978.ttf';
$vc = new AVCode(80, 30, 4, $codeFont);
$vc->show_VCodeImage();
$_SESSION['VCode']['user_seed'] = $vc->VCode;
*/
?>