<?php
if(!defined('D_S'))
{
	define('D_S', DIRECTORY_SEPARATOR);
}
if(!defined('SITE_ROOT'))
{
	define('SITE_ROOT', dirname(dirname(__FILE__)).'/');
}
if(!defined('LOG_DIR'))
{
	define('LOG_DIR', SITE_ROOT.'data/log/');
}

//Asthis Log
class Alog
{
	private $logDir = LOG_DIR;
	private $logType = 'default/';
	private $logExtension = '.log';
	private $naming = 'd'; //d: date(Ymd) + random char, other: depend on the naming char.
	public $logFileName;
	public $AlogError= array();

	public function __construct($config = array())
	{
		$classVar = get_class_vars(get_class($this));
		foreach($config as $k => $v)
		{
			if(array_key_exists($k, $classVar))
			{
				$this->$k = $v;
			}
		}
		$this->logDir = rtrim($this->logDir, '\\/').D_S;
		$this->logType = rtrim($this->logType, '\\/').D_S;
		$this->dir_writable($this->logDir);
		$this->dir_writable($this->logDir.$this->logType);
	}

	public function set_logType($logType)
	{
		$this->logType = rtrim($logType, '\\/').D_S;;
		$this->dir_writable($this->logDir.$this->logType);
	}

	public function write_log($logContent)
	{
		if(!empty($this->AlogError))
		{
			return false;
		}

		if('d' == $this->naming)
		{
			$logFileSet = scandir($this->logDir.$this->logType);
			$fileName = date('Ymd').random_char(8).$this->logExtension;
			foreach($logFileSet as $lfs)
			{
				if(preg_match('/'.date('Ymd').'/', $lfs))
				{
					$fileName = $lfs;
				}
			}
		}
		else
		{
			$fileName = $this->naming.$this->logExtension;
		}

		$this->logFileName=$this->logDir.$this->logType.$fileName;
		if(!empty($logContent))
		{
			$logTitle = date("[Y-m-d H:i:s] [").$_SERVER["HTTP_HOST"].$_SERVER["REQUEST_URI"]."]\r\n";
			@file_put_contents($this->logFileName, $logTitle, FILE_APPEND);
			$this->write_logContent($logContent);
		}
	}

	private function write_logContent($logContent)
	{
		if(is_array($logContent))
		{
			foreach($logContent as $lc)
			{
				$this->write_logContent($lc);
			}
		}
		else
		{
			@file_put_contents($this->logFileName, $logContent."\r\n", FILE_APPEND);
		}
	}

	private function dir_writable($dir)
	{
		if(!is_dir($dir))
		{
			mkdir($dir, 0777);
		}
		if(is_dir($dir)) {
			if($fp = fopen("{$dir}/test.txt", 'w'))
			{
				fclose($fp);
				unlink("{$dir}/test.txt");
			}
			else
			{
				$this->AlogError[] = "dir is read only: ".$dir;
			}
		}
	}

	public function __toString()
	{
		return 'Asthis Log Class';
	}
}

/**
Usage:
----------------------------------------
require_once('./lib/Alog.class.php');
$logDir = SITE_ROOT.'data/log/';
$logType ='a';
$_config['log']=array('logDir' => $logDir, 'logType' => $logType);
$_alog = new Alog($_config['log']);
$_alog->set_logType('admin');
$_alog->write_log('log string or log array');
*/
?>