<?php
//Asthis Page
class Apage
{
	private $totalNum;
	private $pageSize;
	private $totalPage;
	private $currentPage;
	public $limit;
	public $pageAttr;
	private $config;

	public function __construct($totalNum, $pageSize = 10, $pageAttr = 'href')
	{
		$this->totalNum = $totalNum;
		$this->pageSize = $pageSize;
		$this->totalPage = ceil($totalNum / $pageSize);
		$this->currentPage = (is_numeric($_GET['page']) && $_GET['page'] > 0 && $_GET['page'] <= $this->totalPage) ? $_GET['page'] : 1;
		$this->limit = $this->set_limit();
		$this->pageAttr = $pageAttr;
	}

	private function set_limit()
	{
		return 'LIMIT '.($this->currentPage - 1) * $this->pageSize. ', '.$this->pageSize;
	}

	private function get_pageUri($page)
	{
		parse_str($_SERVER['QUERY_STRING'], $argument);
		$argument["page"] = $page;
		return $url = $_SERVER['PHP_SELF'].'?'.http_build_query($argument);
	}

	//f:first, p:previous, c:current, n:next, e:end, t:totalPage&toalNum
	public function show_pageNum($config = array('f','p','c', 'n', 'e', 't'), $nearNum = 3)
	{
		$pageNum = '';
		foreach($config as $c)
		{
			switch($c)
			{
				case 'f':
					$pageNum .= $this->show_f();
					break;
				case 'p':
					$pageNum .= $this->show_p();
					break;
				case 'c':
					$pageNum .= $this->show_c($nearNum);
					break;
				case 'n':
					$pageNum .= $this->show_n();
					break;
				case 'e':
					$pageNum .= $this->show_e();
					break;
				case 't':
					$pageNum .= $this->show_t();
					break;
				default:
					break;
			}
		}
		return $pageNum;
	}

	private function show_f()
	{
		if(1 < $this->currentPage)
		{
			return '<a '.$this->pageAttr.'="'.$this->get_pageUri(1).'" class="firstPage">'.lang('firstPage')."</a>\r\n";
		}
		else
		{
			return '<span class="firstPage">'.lang('firstPage')."</span>\r\n";
		}
	}

	private function show_p()
	{
		if(1 < $this->currentPage)
		{
			return '<a '.$this->pageAttr.'="'.$this->get_pageUri($this->currentPage - 1).'" class="previousPage">'.lang('previousPage')."</a>\r\n";
		}
		else
		{
			return '<span class="previousPage">'.lang('previousPage')."</span>\r\n";
		}
	}

	private function show_c($nearNum)
	{
		$pageList = '';
		for($i = $nearNum; $i > 0; $i--)
		{
			if(($this->currentPage - $i) > 0)
			{
				$pageList .= '<a '.$this->pageAttr.'="'.$this->get_pageUri($this->currentPage - $i).'" class="pageList">'.($this->currentPage - $i)."</a>\r\n";
			}
		}
		$pageList .= '<span class="currentPage">'.$this->currentPage."</span>\r\n";
		for($i = 1; $i < $nearNum + 1; $i++)
		{
			if(($this->currentPage + $i) < ($this->totalPage + 1))
			$pageList .= '<a '.$this->pageAttr.'="'.$this->get_pageUri($this->currentPage + $i).'" class="pageList">'.($this->currentPage + $i)."</a>\r\n";
		}
		return $pageList;
	}

	private function show_n()
	{
		if($this->totalPage > $this->currentPage)
		{
			return '<a '.$this->pageAttr.'="'.$this->get_pageUri($this->currentPage + 1).'" class="nextPage">'.lang('nextPage')."</a>\r\n";
		}
		else
		{
			return '<span class="nextPage">'.lang('nextPage')."</span>\r\n";
		}
	}

	private function show_e()
	{
		if($this->totalPage > $this->currentPage)
		{
			return '<a '.$this->pageAttr.'="'.$this->get_pageUri($this->totalPage).'" class="endPage">'.lang('endPage')."</a>\r\n";
		}
		else
		{
			return '<span class="endPage">'.lang('endPage')."</span>\r\n";
		}
	}

	private function show_t()
	{
		return '<span class="total">'.lang('total').$this->totalPage.lang('page').'/'.$this->totalNum.lang('items')."</span>\r\n";
	}

	public function __toString()
	{
		return 'Asthis Page Class';
	}
}

/**
Usage:
----------------------------------------
$page = new Apage($totalNum, 5);

echo $sql = "SELECT * FROM `#@__system` {$page->limit}";
$_ada->query($sql);

echo '<table>';
while($row=mysql_fetch_assoc($_ada->result))
{
		echo '<tr>';
		echo '<td>'.$row["name"].'</td>';
		echo '<td>'.$row["value"].'</td>';
		echo '</tr>';
}
echo '<tr><td colspan="2" align="right">'.$page->show_pageNum().'</td></tr>';
echo '</table>';
*/
?>