<?php
if(!defined('D_S'))
{
	define('D_S', DIRECTORY_SEPARATOR);
}
//Asthis upload
//Alog.class support
class Aupload
{
	private $uploadDir;
	private $maxUploadSize = 2000000;
	private $typeSet = array('gif', 'jpg', 'jpeg', 'png');
	private $logSwitch = false;
	private $typeGetMethod = '2'; //1: extension, 2: file header info
	private $naming = '2'; //0:original, 1:random char, 2:date('YmdHis') + random char

	public $AuploadError;

	public function __construct($config = array())
	{
		$classVar = get_class_vars(get_class($this));
		foreach($config as $k => $v)
		{
			if(array_key_exists($k, $classVar))
			{
				$this->$k = $v;
			}
		}
		$this->set_uploadDir($this->uploadDir);
	}

	public function set_uploadDir($uploadDir)
	{
		$uploadDir = rtrim($uploadDir, "\\/").D_S;
		if(!dir_writable($uploadDir))
		{
			$this->AuploadError['code'][] = "-1";
			$this->AuploadError['msg'][] = "upload dir is read only.";
			return false;
		}
		$this->uploadDir = $uploadDir;
		return true;
	}

	public function upload($field, $uploadDir = '')
	{
		$this->AuploadError = array();
		if(!empty($uploadDir))
		{
			$this->set_uploadDir($uploadDir);
		}
		if(isset($_FILES[$field]))
		{
			$name = $_FILES[$field]['name'];
			$tmpName = $_FILES[$field]['tmp_name'];
			$error = $_FILES[$field]['error'];
			$size = $_FILES[$field]['size'];
			if('1' == $this->typeGetMethod)
			{
				$type = $this->get_fileType($name);
			}
			else
			{
				$type = $this->get_fileRealType($tmpName);
			}

			$this->check_error($this->error);
			$this->check_size($this->size);
			$this->check_fileType($type, $this->typeSet);

			if(empty($this->AuploadError))
			{
				$newName = $this->get_newName($name, $type, $this->naming);
				$this->save_file($tmpName, $newName);
			}
			if(empty($this->AuploadError))
			{
				$uploadFile['name'] = $newName;
				$uploadFile['type'] = $type;
				$uploadFile['size'] = $size;
				return $uploadFile;
			}
		}
		return NULL;
	}

	private function check_error($error)
	{
		if(is_array($error))
		{
			foreach($error as $e)
			{
				$this->check_error($e);
			}
		}
		elseif($error > 0)
		{
			switch($error)
			{
				case 1:
					$this->AuploadError['code'][] = "1";
					$this->AuploadError['msg'][] = "file size exceeds php.ini define.";
					break;
				case 2:
					$this->AuploadError['code'][] = "2";
					$this->AuploadError['msg'][] = "file size exceeds HTML form define.";
					break;
				case 3:
					$this->AuploadError['code'][] = "3";
					$this->AuploadError['msg'][] = "only partially uploaded.";
					break;
				case 4:
					$this->AuploadError['code'][] = "4";
					$this->AuploadError['msg'][] = "no file was uploaded.";
					break;
				case 6:
					$this->AuploadError['code'][] = "6";
					$this->AuploadError['msg'][] = "missing a temporary folder.";
					break;
				case 7:
					$this->AuploadError['code'][] = "7";
					$this->AuploadError['msg'][] = "failed to write file to disk.";
					break;
				default:
					$this->AuploadError['code'][] = "8";
					$this->AuploadError['msg'][] = "unknow error.";
			}
		}
	}

	private function check_size($size)
	{
		if(is_array($size))
		{
			foreach($size as $s)
			{
				$this->check_size($s);
			}
		}
		elseif($this->maxUploadSize < $size)
		{
			$this->AuploadError['code'][] = "-2";
			$this->AuploadError['msg'][] = "file size exceeds class define: ".byte_format($this->maxUploadSize);
		}
	}

	private function check_fileType($type, $typeSet)
	{
		if(is_array($type))
		{
			foreach($type as $t)
			{
				$this->check_fileType($t, $typeSet);
			}
		}
		else
		{
			if(!in_array($type, $typeSet))
			{
				$this->AuploadError['code'][] = "-3";
				$this->AuploadError['msg'][] = "file type is not allowed: {$type}";
			}
		}
	}

	private function get_newName($name, $type, $naming)
	{
		if('0' == $naming)
		{
			$newName = $name;
		}
		elseif('1' == $naming)
		{
			if(is_array($name))
			{
				foreach($name as $k => $name)
				{
					$newName[$k] = random_char(16).'.'.$type[$k];
				}
			}
			else
			{
				$newName = random_char(16).'.'.$type;
			}
		}
		else
		{
			if(is_array($name))
			{
				foreach($name as $k => $name)
				{
					$newName[$k] = date('YmdHis').random_char(4).'.'.$type[$k];
				}
			}
			else
			{
				$newName = date('YmdHis').random_char(4).'.'.$type;
			}
		}
		return $newName;
	}

	private function save_file($tmpName, $newName)
	{
		if(is_array($tmpName))
		{
			foreach($tmpName as $k => $tn)
			{
				if(!move_uploaded_file($tn, $this->uploadDir.$newName[$k]))
				{
					$this->AuploadError['code'][] = "-4";
					$this->AuploadError['msg'][] = "upload failed.";
				}
			}
		}
		elseif(is_uploaded_file($tmpName))
		{
			if(!move_uploaded_file($tmpName, $this->uploadDir.$newName))
			{
				$this->AuploadError['code'][] = "-4";
				$this->AuploadError['msg'][] = "upload failed.";
			}
		}
		else
		{
			$this->AuploadError['code'][] = "-5";
			$this->AuploadError['msg'][] = "tmpFile is not uploaded file.";
		}
	}

	private function get_fileType($fileName)
	{
		if(!empty($fileName) && !is_dir($fileName))
		{
			$fileName = explode('.', $fileName);
			return $fileType = strtolower($fileName[count($fileName) - 1]);
		}
		return NULL;
	}

	private function get_fileRealType($fileName)
	{
		if(file_exists($fileName))
		{
			$file = fopen($fileName, "rb");
			$bin = fread($file, 2);
			fclose($file);
			$strInfo = @unpack("c2chars", $bin);
			$typeCode = intval($strInfo['chars1'].$strInfo['chars2']);
			$fileType = '';
			switch($typeCode)
			{
				case 7790:
					$fileType = 'exe';
					break;
				case 7784:
					$fileType = 'midi';
					break;
				case 8297:
					$fileType = 'rar';
					break;
				case 255216:
					$fileType = 'jpg';
					break;
				case -1:
					$fileType = 'jpg';
					break;
				case 7173:
					$fileType = 'gif';
					break;
				case 6677:
					$fileType = 'bmp';
					break;
				case 8075:
					$fileType = 'zip';
					break;
				case 13780:
					$fileType = 'png';
					break;
				case -11980:
					$fileType = 'png';
					break;
				default:
					$fileType = 'unknown';
			}
			return $fileType;
		}
		return NULL;
	}

	private function log()
	{
		if($this->logSwitch)
		{
			$AuploadAlog = new Alog(array('logType' => 'Aupload'));
			$AuploadAlog->write_log($this->AuploadError['msg']);
		}
	}

	public function __destruct()
	{
		$this->log();
	}

	public function __toString()
	{
		return 'Asthis Upload Class';
	}
}
/**
Usage:
----------------------------------------
$field = 'upload_file';
$field1 = 'upload_file_1';
$uploadDir = './upload/';
$uploadDir1 = './upload1/';

$_aupload = new Aupload(array(
		'uploadDir' => $uploadDir,
		'maxUploadSize' => '1000000',
		'typeSet' => array('gif', 'jpg', 'png'))
	);
print_r($upload = $_aupload->upload($field));
print_r($upload = $_aupload->upload($field1, $uploadDir1));
----------------------------------------
<form action="" method="post" enctype="multipart/form-data">
<input type="hidden" name="MAX_FILE_SIZE" value="1000000" />
<input name="upload_file[]" type="file" accept="up_field" size="20" />
<input name="upload_file[]" type="file" accept="up_field" size="20" />
<input name="upload_file_1" type="file" accept="up_field" size="20" />
<input type="submit" />
</form>
*/
?>