<?php
//get client real ip
function get_ip()
{
	$ip=false;
	if(!empty($_SERVER['HTTP_CLIENT_IP']))
	{
		$ip = $_SERVER['HTTP_CLIENT_IP'];
	}
	if(!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
	{
		$ips = explode (',', $_SERVER['HTTP_X_FORWARDED_FOR']);
		if($ip)
		{
			array_unshift($ips, $ip);
			$ip = FALSE;
		}
		for($i = 0; $i < count($ips); $i++)
		{
			if(!preg_match("/^(10|172\.16|192\.168)\./", $ips[$i]))
			{
				$ip = $ips[$i];
				break;
			}
		}
	}
	return ($ip ? $ip : $_SERVER['REMOTE_ADDR']);
}

//cut string
function cut_str($str, $len)
{
	//Get the display width of the string.
	$i = 0;
	$j = 0;
	$strWidth = 0;
	do
	{
		if(ord($str[$i]) > 224)
		{
			$strWidth += 2;
			$i += 3;
		}
		elseif(ord($str[$i] > 192))
		{
			$strWidth += 2;
			$i += 2;
		}
		else
		{
			$strWidth++;
			$i++;
		}
	} while($i < strlen($str));
	//IF the display width is shorter than you want ,return the string.
	if($strWidth < $len)
	{
		return $str;
	}
	else
	{
		$i = 0;
		$j = 0;
		$newWord = '';
		do
		{
			//If the character is a Chinese
			if(ord($str[$i]) > 224)
			{
				$newWord .= $str[$i].$str[$i+1].$str[$i+2];
				$i = $i + 3;
				$j = $j + 2;
			}
			//If the character is a symble
			elseif(ord($str[$i] > 192))
			{
				$newWord .= $str[$i].$str[$i+1];
				$i = $i + 2;
				$j = $j + 2;
			}
			//If the character is a alpha
			else
			{
				$newWord .= $str[$i];
				$i++;
				$j++;
			}
		} while($j < $len);
		return $newWord;
	}
}

function judge_str($str, $type = 'email')
{
	switch($type)
	{
		case 'email':
			$reg = "/[a-z0-9]([a-z0-9]*[-_\.]?[a-z0-9]+)*@([a-z0-9]*[-_]?[a-z0-9]+)+[\.][a-z]{2,3}([\.][a-z]{2})?/i";
			break;
		case 'ip':
			$reg = "/[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}/";
			break;
		case 'chinese':
			$reg = "/^[\w\x80-\xff]+$/i";
			break;
		default:
			$reg = '';
			break;
	}
	if('' != $reg)
	{
		return preg_match($reg, $str);
	}
	return false;
}

//human treat dateline
function get_dateStr($dateline)
{
	$timeDif = intval(time() - $dateline);
	$now = getdate();
	$todayPassTime = $now['seconds'] + $now['minutes'] * 60 + $now['hours'] * 60 * 60;

	if($timeDif < 0)
	{
		return lang('inTheFuture');
	}
	elseif($timeDif < 60)
	{
		$timeDif = $timeDif == 0 ? 1 : $timeDif;
		return $timeDif.lang('secondAgo');
	}
	elseif($timeDif < 3600)
	{
		$timeDif = intval($timeDif / 60);
		return $timeDif.lang('minuteAgo');
	}
	elseif($timeDif < $todayPassTime)
	{
		$timeDif = intval($timeDif / 3600);
		return $timeDif.lang('hourAgo');
	}
	elseif($timeDif < $todayPassTime + 3600 * 24)
	{
		return lang('yesterday').date(' H:i:s', $dateline);
	}
	elseif($timeDif < 3600 * 24 * 7)
	{
		$timeDif = intval($timeDif / 3600 / 24);
		return $timeDif.lang('dayAgo');
	}
	return date('Y-m-d H:i:s', $dateline);
}

function add_slashes($str)
{
	if(!get_magic_quotes_gpc())
	{
		if(is_array($str))
		{
			foreach($str as $k => $v)
			{
			$b[$k] = add_slashes($v);
			}
			return $b;
		}
		else
		{
			return addslashes($str);
		}
	}
	return $str;
}

function trim_array($a = array(), $charList = '')
{
	if(0 == strlen($charList))
	{
		foreach($a as $k => $v)
		{
			$a[$k] = trim($v);
		}
	}
	else
	{
		foreach($a as $k => $v)
		{
			$a[$k] = trim($v, $charList);
		}
	}
	return $a;
}

function filter_str($str)
{
	return $str;
}

function filter_num($num)
{
	return intval($num);
}

function filter_html($html)
{
	$html = strip_tags($html);
	$html = str_replace("\n", '', $html);
	$html = str_replace("\r", '', $html);
	$html = str_replace("\"", '&Prime;', $html);
	$html = str_replace("'", '&prime;', $html);
	return $html;
}

function set_cookie($name, $value, $keep = 0)
{
	global $_system;
	$keep = $keep ? (time() + $keep) : 0;
	setcookie(md5($_system['cookie_salt'].md5($name)), $value, $keep);
}

function get_cookie($name)
{
	global $_system;
	if(!empty($_COOKIE[md5($_system['cookie_salt'].md5($name))]))
	{
		return $_COOKIE[md5($_system['cookie_salt'].md5($name))];
	}
	return false;
}

function empty_cookie($name = '')
{
	global $_system;
	if(0 == strlen($name))
	{
		foreach($_COOKIE as $k => $v)
		{
			setcookie($k, NULL);
		}
	}
	else
	{
		set_cookie($name,  $_COOKIE[md5($_system['cookie_salt'].md5($name))], -1);
	}
}

function get_env($varName)
{
	if(isset($_SERVER[$varName]))
	{
		return $_SERVER[$varName];
	}
	elseif(isset($_ENV[$varName]))
	{
		return $_ENV[$varName];
	}
	elseif(getenv($varName))
	{
		return getenv($varName);
	}
	elseif(function_exists('apache_getenv') && apache_getenv($varName, true))
	{
		return apache_getenv($varName, true);
	}
	return false;
}

function encrypt($str)
{
	if(0 != strlen($str))
	{
		return md5(md5($str).SITE_SEED);
	}
	return false;
}

//random charset
function random_char($length)
{
	$hash = '';
	$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz';
	$max = strlen($chars) - 1;
	for($i = 0; $i < $length; $i++)
	{
		$hash .= $chars[mt_rand(0, $max)];
	}
	return $hash;
}

/* 目录是否可写 */
function dir_writable($dir)
{
	if(!is_dir($dir))
	{
		mk_dir($dir, 0777);
	}
	if(is_dir($dir))
	{
		if($fp = @fopen("$dir/test.txt", 'w'))
		{
			@fclose($fp);
			@unlink(realpath("$dir/test.txt"));
			return true;
		}
	}
	return false;
}

/* 创建可写目录(尝试检测上一级目录) */
function mk_dir($dir, $mode = 0777)
{
	if(is_dir($dir) || @mkdir($dir, $mode))
	{
		return true;
	}
	if(!@mkdir(dirname($dir), 0777))
	{
		return false;
	}
	return @mkdir($dir, $mode);
}

function byte_format($bytes)
{
	if($bytes >= 1024 * 1024 *1024)
	{
		$bytes = @number_format($bytes / (1024 * 1024 * 1024), 2).' GB';
	}
	elseif($bytes >= 1024 * 1024)
	{
		$bytes = @number_format($bytes / (1024 * 1024), 2).' MB';
	}
	elseif($bytes >= 1024)
	{
		$bytes = @number_format($bytes / 1024, 2).' KB';
	}
	else
	{
		$bytes = $bytes.' Bytes';
	}
	return $bytes;
}

//url rewrite
//echo url_rwrt('index', array('m' => 'article', 'id' => '10'));
function url_rwrt($file, $params = array())
{
	$url = $file;
	if(substr($url, -4) != '.php')
	{
		$url .= '.php';
	}
	if(!empty($params) && is_array($params))
	{
		$url .= '?'.http_build_query($params);
	}
	return $url;
}

/* 获取文件夹列表 */
function list_dir($dir)
{
	$items = array();
	$files = glob($dir.'/*');
	if(is_array($files))
	{
		$names = include_once($dir.'/_names.php');
		foreach($files as $v)
		{
			if(is_file($v))
			{
				continue;
			}
			$v = basename($v);
			$n = isset($names[$v]) ? $names[$v] : $v;
			$items[] = array('dir' => $v, 'name' => $n);
		}
	}
	return $items;
}

?>