<?php
/** 截取字符 */
function msubstr($str, $start = 0, $length, $charset = "utf-8", $suffix = false)
{
	if(function_exists("mb_substr"))
	{
		if($suffix && strlen($str) > $length)
		{
			return mb_substr($str, $start, $length, $charset)."...";
		}
		else
		{
			return mb_substr($str, $start, $length, $charset);
		}
	}
	elseif(function_exists('iconv_substr'))
	{
		if ($suffix && strlen($str) > $length)
		{
			return iconv_substr($str, $start, $length, $charset)."...";
		}
		else
		{
			return iconv_substr($str, $start, $length, $charset);
		}
	}
	$re['utf-8'] = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
	$re['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
	$re['gbk'] = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
	$re['big5'] = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
	preg_match_all($re[$charset], $str, $match);
	$slice = join("", array_slice($match[0], $start, $length));
	if($suffix)
	{
		return $slice."…";
	}
	return $slice;
}

/* human treat dateline */
function get_dateStr($dateline){
	$timeDif = intval(time() - $dateline);
	$now = getdate();
	$todayPassTime = $now['seconds'] + $now['minutes'] * 60 + $now['hours'] * 60 * 60;

	if ($timeDif < 0)
	{
		return "未来";
	}
	elseif ($timeDif < 60)
	{
		$timeDif = $timeDif == 0 ? 1 : $timeDif;
		return $timeDif."秒前";
	}
	elseif ($timeDif < 3600)
	{
		$timeDif = intval($timeDif / 60);
		return $timeDif."分钟前";
	}
	elseif ($timeDif < $todayPassTime)
	{
		$timeDif = intval($timeDif / 3600);
		return $timeDif."小时前";
	}
	elseif ($timeDif < $todayPassTime + 3600 * 24)
	{
		return "昨天".date(' H:i:s', $dateline);
	}
	elseif ($timeDif < 3600 * 24 * 7)
	{
		$timeDif = intval($timeDif / 3600 / 24);
		return $timeDif."天前";
	}
	return date('Y-m-d H:i:s', $dateline);
}

/** 获取客户端IP地址 */
function get_ip()
{
	$ip=false;
	if(!empty($_SERVER['HTTP_CLIENT_IP']))
	{
		$ip = $_SERVER['HTTP_CLIENT_IP'];
	}
	if(!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
	{
		$ips = explode (',', $_SERVER['HTTP_X_FORWARDED_FOR']);
		if($ip)
		{
			array_unshift($ips, $ip);
			$ip = FALSE;
		}
		for($i = 0; $i < count($ips); $i++)
		{
			if(!preg_match("/^(10|172\.16|192\.168)\./", $ips[$i]))
			{
				$ip = $ips[$i];
				break;
			}
		}
	}
	$ip = $ip ? $ip : $_SERVER['REMOTE_ADDR'];
	preg_match("/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/", $ip) or $ip = 'unknown';
	return $ip;
}

/* 获取文件夹列表 */
function list_dir($dir)
{
	$items = array();
	$files = glob($dir.'/*');
	if(is_array($files))
	{
		$names = include_once($dir.'/_names.php');
		foreach($files as $v)
		{
			if(is_file($v))
			{
				continue;
			}
			$v = basename($v);
			$n = isset($names[$v]) ? $names[$v] : $v;
			$items[] = array('dir' => $v, 'name' => $n);
		}
	}
	return $items;
}

?>