<?php
class AdCtrlr extends AdminCtrlr
{
	public function ad_list()
	{
		$m_f = M('Ad');
		$_GET[C('VAR_PAGE')] = ((isset($_GET[C('VAR_PAGE')]) && (int)$_GET[C('VAR_PAGE')] > 0) ? (int)$_GET[C('VAR_PAGE')] : 1);

		$rowsNum = $m_f->count();
		$p = new Page($rowsNum, 10, U('Ad/ad_list?'.C('VAR_PAGE').'=_page_'));
		define('PAGE_LIST', $p->show());
		$limit = $p->get_limit();
		$_AL = $m_f->get_adList($limit);

		foreach($_AL as $k => $v)
		{
			$_AL[$k]['edit_url'] = U('Ad/ad_edit?ad_id='.$v['ad_id']);
			$_AL[$k]['delete_url'] = U('Ad/ad_delete_do?ad_id='.$v['ad_id']);
		}
		$this->assign('_AL', $_AL);

		$_F['id'] = 'adListForm';
		$_F['a']['delete'] = U('Ad/ad_delete_do');
		$_F['a']['add'] = U('Ad/ad_add');
		$this->assign('_F', $_F);

		$this->display('ad_list');
	}

	public function ad_add()
	{
		$_F['id'] = 'adAddForm';
		$_F['a'] = U('Ad/ad_add_do');
		$this->assign('_F', $_F);
		$this->display('ad_add');
	}

	public function ad_add_do()
	{
		$m_f = M('Ad');
		if(!$m_f->add_ad())
		{
			$this->error(L('ADD_FAILED'), U('Ad/ad_list'));
			exit();
		}
		$this->success(L('ADD_SUCCESS'), U('Ad/ad_list'));
	}

	public function ad_edit()
	{
		$adId = (int)$_GET['ad_id'];
		$m_f = M('Ad');
		$_A = $m_f->get_adInfo($adId);
		if($_A)
		{
			$_F['id'] = 'adEditForm';
			$_F['a'] = U('Ad/ad_edit_do');
			$this->assign('_F', $_F);
			$this->assign('_A', $_A);
			$this->display('ad_edit');
		}
		else
		{
			$this->error(L('ITEM_NOT_EXSIT'), U('Ad/ad_list'));
		}
	}

	public function ad_edit_do()
	{
		$m_f = M('Ad');
		if(!$m_f->edit_ad())
		{
			$this->error(L('EDIT_FAILED'), U('Ad/ad_list'));
			exit();
		}
		$this->success(L('EDIT_SUCCESS'), U('Ad/ad_list'));
	}

	public function ad_delete_do()
	{
		$adId = ((int)$_GET['ad_id'] ? (int)$_GET['ad_id'] : $_POST['ad_id']);
		$m_f = M('Ad');
		if(!$m_f->delete_ad($adId))
		{
			$this->error(L('DELETE_FAILED'), U('Ad/ad_list'));
			exit();
		}
		$this->success(L('DELETE_SUCCESS'), U('Ad/ad_list'));
	}

}
?>