<?php
class CategoryCtrlr extends AdminCtrlr
{
	public function category_list()
	{
		$m_c = M('Category');
		$_CL = $m_c->get_categoryList();
		if(!empty($_CL))
		{
			foreach($_CL as $k => $v)
			{
				$_CL[$k]['edit_url'] = U('Category/category_edit?category_id='.$v['category_id']);
				$_CL[$k]['add_sub_url'] = U('Category/category_add?c_parent_id='.$v['category_id']);
				$_CL[$k]['view_article_url'] = U('Article/article_list?category_id='.$v['category_id']);
				$_CL[$k]['add_article_url'] = U('Article/article_add?category_id='.$v['category_id']);
				$_CL[$k]['delete_url'] = U('Category/category_delete_do?category_id='.$v['category_id']);
				if(!empty($v['c_sub']))
				{
					foreach($v['c_sub'] as $m => $n)
					{
						$_CL[$k]['c_sub'][$m]['edit_url'] = U('Category/category_edit?category_id='.$n['category_id']);
						$_CL[$k]['c_sub'][$m]['view_article_url'] = U('Article/article_list?category_id='.$n['category_id']);
						$_CL[$k]['c_sub'][$m]['add_article_url'] = U('Article/article_add?category_id='.$n['category_id']);
						$_CL[$k]['c_sub'][$m]['delete_url'] = U('Category/category_delete_do?category_id='.$n['category_id']);
					}
				}
			}
		}
		$this->assign('_CL', $_CL);

		$_F['id'] = 'categoryListForm';
		$_F['a']['delete'] = U('Category/category_delete_do');
		$_F['a']['add'] = U('Category/category_add');
		$this->assign('_F', $_F);

		$this->display('category_list');
	}

	public function category_add()
	{
		$m_c = M('Category');
		$_CL = $m_c->where('`c_parent_id` = 0')->order('`c_display_order`, `category_id` DESC')->select();
		$this->assign('_CL', $_CL);
		$_F['id'] = 'categoryAddForm';
		$_F['a'] = U('Category/category_add_do');
		$this->assign('_F', $_F);
		$this->display('category_add');
	}

	public function category_add_do()
	{
		$m_c = M('Category');
		if(!$m_c->add_category())
		{
			$this->error(L('ADD_FAILED'), U('Category/category_list'));
			exit();
		}
		$this->success(L('ADD_SUCCESS'), U('Category/category_list'));
	}

	public function category_edit()
	{
		$categoryId = (int)$_GET['category_id'];
		$m_c = M('Category');
		$_C = $m_c->get_categoryInfo($categoryId);
		if($_C)
		{
			$_CL = '';
			if(empty($_C['c_sub']))
			{
				$_CL = $m_c->where('`c_parent_id` = 0')->order('`c_display_order`, `category_id` DESC')->select();
				if(!empty($_CL))
				{
					foreach($_CL as $k => $v)
					{
						if($v['category_id'] == $_C['category_id'])
						{
							unset($_CL[$k]);
						}
					}
				}
			}
			$_F['id'] = 'categoryEditForm';
			$_F['a'] = U('Category/category_edit_do');
			$this->assign('_F', $_F);
			$this->assign('_C', $_C);
			$this->assign('_CL', $_CL);
			$this->display('category_edit');
		}
		else
		{
			$this->error(L('ITEM_NOT_EXSIT'), U('Category/category_list'));
		}
	}

	public function category_edit_do()
	{
		$m_c = M('Category');
		if(!$m_c->edit_category())
		{
			$this->error(L('EDIT_FAILED'), U('Category/category_list'));
			exit();
		}
		$this->success(L('EDIT_SUCCESS'), U('Category/category_list'));
	}

	public function category_delete_do()
	{
		$categoryId = ((int)$_GET['category_id'] ? (int)$_GET['category_id'] : $_POST['category_id']);
		$m_c = M('Category');
		if(!$m_c->delete_category($categoryId))
		{
			$this->error(L('DELETE_FAILED'), U('Category/category_list'));
			exit();
		}
		$this->success(L('DELETE_SUCCESS'), U('Category/category_list'));
	}

}
?>