<?php
class OptionCtrlr extends AdminCtrlr
{
	public function index(){}

	/** 网站信息 */
	public function site_info()
	{
		$m_o = M('Option');
  		$_V = $m_o->get_option(
 			array(
			'site_name',
			'site_keywords',
			'site_description',
			'site_domain',
			'site_copyright',
			'site_icpno',
			'site_stat_code',
			'comment_switch',
			'guestbook_switch'
		));
		$this->assign('_V', $_V);
		$_F['id'] = 'optionForm';
		$_F['a'] = U('Option/site_info_do');
		$this->assign('_F', $_F);
		$this->display('option_site_info');
	}

	/** 网站信息保存 */
	public function site_info_do()
	{
		$m_o = M('Option');
		if(!$m_o->save_option($_POST))
		{
			$this->error(L('EDIT_FAILED'), U('Option/site_info'));
			exit();
		}
		$this->success(L('EDIT_SUCCESS'), U('Option/site_info'));
	}

	/** URL类型 */
	public function url_type()
	{
		$_C = require dirname(PFA_PATH).'/cfg/comm.php';
		$_F['id'] = 'optionForm';
		$_F['a'] = U('Option/url_type_do');
		$this->assign('_F', $_F);
		$this->assign('_C', $_C);
		$this->display('option_url_type');
	}

	/** 保存URL类型 */
	public function url_type_do()
	{
		$cfgFile = dirname(PFA_PATH).'/cfg/comm.php';
		$_C = require $cfgFile;
		$_C['URL_TYPE'] = (int)$_POST['url_type'];
		$_C['URL_ROUTER'] = ((int)$_POST['url_router'] ? true : false);

		$content = var_export($_C,true);
		$content = "<?php\nreturn $content;\n?>";

		if(!@file_put_contents($cfgFile, $content))
		{
			$this->error(L('EDIT_FAILED'), U('Option/url_type'));
			exit();
		}
		$this->success(L('EDIT_SUCCESS'), U('Option/url_type'));
	}

	/** 分页大小 */
	public function page_size()
	{
		$m_o = M('Option');
		$_V = $m_o->get_option(
			array(
			'page_size'
		));
		$this->assign('_V', $_V);
		$_F['id'] = 'optionForm';
		$_F['a'] = U('Option/page_size_do');
		$this->assign('_F', $_F);
		$this->display('option_page_size');
	}

	/** 分页大小保存 */
	public function page_size_do()
	{
		$m_o = M('Option');
		if(!$m_o->save_option($_POST))
		{
			$this->error(L('EDIT_FAILED'), U('Option/page_size'));
			exit();
		}
		$this->success(L('EDIT_SUCCESS'), U('Option/page_size'));
	}

	/** 过滤规则 */
	public function filter_rule()
	{
		$m_o = M('Option');
		$_V = $m_o->get_option(
			array(
			'filter_rule'
		));
		$T_S = '';
		foreach($_V['filter_rule']['o_value']['words'] as $w)
		{
			$T_S .= $w."\n";
		}
		$_V['filter_rule']['o_value']['words'] = trim($T_S);
		$this->assign('_V', $_V);
		$_F['id'] = 'optionForm';
		$_F['a'] = U('Option/filter_rule_do');
		$this->assign('_F', $_F);
		$this->display('option_filter_rule');
	}

	/** 过滤规则保存 */
	public function filter_rule_do()
	{
		$_POST['filter_rule']['words'] = $this->trim_postArray(explode("\n", $_POST['filter_rule']['words']));
		$m_o = M('Option');
		if(!$m_o->save_option($_POST))
		{
			$this->error(L('EDIT_FAILED'), U('Option/filter_rule'));
			exit();
		}
		$this->success(L('EDIT_SUCCESS'), U('Option/filter_rule'));
	}

	/** 缩略图规则 */
	public function thumb_rule()
	{
		$m_o = M('Option');
		$_V = $m_o->get_option(
			array(
			'thumb_rule'
		));
		$this->assign('_V', $_V);
		$_F['id'] = 'optionForm';
		$_F['a'] = U('Option/thumb_rule_do');
		$this->assign('_F', $_F);
		$this->display('option_thumb_rule');
	}

	/** 缩略图规则保存 */
	public function thumb_rule_do()
	{
		$m_o = M('Option');
		if(!$m_o->save_option($_POST))
		{
			$this->error(L('EDIT_FAILED'), U('Option/thumb_rule'));
			exit();
		}
		$this->success(L('EDIT_SUCCESS'), U('Option/thumb_rule'));
	}

	/** 管理员 */
	public function administrator()
	{
		$m_o = M('Option');
		$_V = $m_o->get_option(
			array(
			'administrator'
		));
		$this->assign('_V', $_V);
		$_F['id'] = 'optionForm';
		$_F['a'] = U('Option/administrator_do');
		$this->assign('_F', $_F);
		$this->display('option_administrator');
	}

	/** 管理员信息保存 */
	public function administrator_do()
	{
		$m_o = M('Option');
		$_V = $m_o->get_option(
			array(
			'administrator'
		));
		if($_V['administrator']['o_value']['password'] !=
			md5(substr(md5($_POST['administrator']['password_old']),0,30)))
		{
			$this->error(L('PASSWORD_NOT_MATCH'), U('Option/administrator'));
			exit();
		}
		if('' != $_POST['administrator']['password_new'] &&
			$_POST['administrator']['password_new'] != $_POST['administrator']['password_again'])
		{
			$this->error(L('PASSWORD_AGAIN_NOT_MATCH'), U('Option/administrator'));
			exit();
		}
		if('' != $_POST['administrator']['password_new'])
		{
			$_POST['administrator']['password']	= md5(substr(md5($_POST['administrator']['password_new']),0,30));
		}
		unset($_POST['administrator']['password_old']);
		unset($_POST['administrator']['password_new']);
		unset($_POST['administrator']['password_again']);
		$m_o = M('Option');
		if(!$m_o->save_option($_POST))
		{
			$this->error(L('EDIT_FAILED'), U('Option/administrator'));
			exit();
		}
		$this->success(L('EDIT_SUCCESS'), U('Option/administrator'));
	}

	/* 过滤post数据中多行数组中的空白行 */
	private function trim_postArray($postArr)
	{
		$arr = array();
		foreach($postArr as $k => $v)
		{
			$v = trim($v);
			if('' !== $v)
			{
				$arr[] = $v;
			}
		}
		return $arr;
	}

}
?>