<?php
class ArticleModl extends Modl
{
	/** 获取列表 */
	public function get_articleList($limit = '', $where)
	{
		$articleList = $this->join('__CATEGORY__ AS c ON c.category_id = __ARTICLE__.category_id')
			->where($where)->order('`article_id` DESC')->limit($limit)->select();
		return $articleList;
	}

	/** 获取信息 */
	public function get_articleInfo($articleId = 0)
	{
		$articleInfo = $this->join('__CATEGORY__ AS c ON c.category_id = __ARTICLE__.category_id')
		->where('__ARTICLE__.`article_id` = '.$articleId)->select();
		return $articleInfo[0];
	}

	/* 添加 */
	public function add_article(){
		$this->create();
		$article_id = $this->insert();
		return $article_id;
	}

	/** 编辑 */
	public function edit_article()
	{
		$this->create();
		$this->update();/* TODOupdate返回值*/
		return true;
	}

	/** 删除 */
	public function delete_article($articleId)
	{
		if(is_array($articleId))
		{
			$articleId = implode(',',$articleId);
		}
		$return = $this->delete($articleId);
		return $return;
	}

	/** 上传缩略图 */
	public function upload_thumb()
	{
		$uploadDir = dirname(PFA_PATH).D_S.'u'.D_S.date('Ym/d');
		$thumbDir = dirname(PFA_PATH).D_S.'u'.D_S.date('Ym/d');
		$u_params = array();
		$u_params['uploadDir'] = $uploadDir;
		$_u = new Upload($u_params);
		$upload = $_u->do_upload('a_thumb_upload');
		if(!is_null($upload))
		{
			$m_o = M('Option');
			$o_t = $m_o->get_option('thumb_rule');
			$o_t = $o_t['thumb_rule']['o_value'];
			$t_params['sourceDir'] = $uploadDir;
			$t_params['outputDir'] = $thumbDir;
			$_i = new Image($t_params);
			$thumb = $_i->thumbnail($upload['name'], $o_t['width'], $o_t['height'], $o_t['prefix'], $o_t['keep_prop']);
			@unlink($uploadDir.D_S.$upload['name']);
			if(!is_null($thumb))
			{
				 return ROOT.'/u/'.date('Ym/d').'/'.$thumb['name'];
			}
		}
	}

}
?>