<?php
class CategoryModl extends Modl
{
	/* 获取分类列表 */
	public function get_categoryList()
	{
		$where['c_parent_id'] = array('EQ', 0);
		$categoryList = $this->where($where)->order('`c_display_order`, `category_id`')->select();
		if(!empty($categoryList))
		{
			foreach($categoryList as $k => $v)
			{
				$categoryList[$k]['c_sub'] = $this->where('c_parent_id = '.$v['category_id'])->order('`c_display_order`, `category_id`')->select();
			}
		}
		return $categoryList;
	}

	/* 获取分类信息 */
	public function get_categoryInfo($categoryId = 0)
	{
		$categoryInfo = $this->find($categoryId);
		$categoryInfo['c_sub'] = $this->where('c_parent_id = '.$categoryId)->order('`c_display_order`, `category_id`')->select();
		return $categoryInfo;
	}

	/* 添加 */
	public function add_category(){
		$this->create();
		$category_id = $this->insert();
		return $category_id;
	}

	/* 编辑 */
	public function edit_category()
	{
		$this->create();
		$this->update();/* TODOupdate返回值*/
		return true;
	}

	/* 删除 */
	public function delete_category($categoryId)
	{
		if(is_array($categoryId))
		{
			$subId = array();
			foreach($categoryId as $id)
			{
				$sub = $this->where('`c_parent_id` ='.$id)->select();
				if(!empty($sub))
				{
					foreach($sub as $sub)
					{
						$subId[] = $sub['category_id'];
					}
				}
			}
			$categoryId = array_merge($categoryId, $subId);
			$categoryId = implode(',',$categoryId);
		}
		else
		{
			$subId = array();
			$sub = $this->where('`c_parent_id` ='.$categoryId)->select();
			if(!empty($sub))
			{
				foreach($sub as $sub)
				{
					$subId[] = $sub['category_id'];
				}
			}
			$categoryId = implode(',',$subId).','.$categoryId;
		}
		$return = $this->delete($categoryId);
		return $return;
	}

}
?>