<?php
class OptionModl extends Modl
{
	/** 获取系统参数 $optionKey为array或者字符串 */
	public function get_option($key = null)
	{
		$option = array();
		if(is_string($key))
		{
			$where['o_key'] = array('EQ', $key);
			$o = $this->where($where)->limit(1)->select();
			$o = $o[0];
			if(0 != $o['o_is_array'])
			{
				$option[$key]['o_value'] = json_decode($o['o_value'], true);
			}
			else
			{
				$option[$key]['o_value'] = $o['o_value'];
			}
			$option[$key]['o_name'] = $o['o_name'];
			$option[$key]['o_description'] = $o['o_description'];
		}
		elseif(is_array($key))
		{
			foreach($key as $key)
			{
				$o = $this->get_option($key);
				$option[$key]['o_value'] = $o[$key]['o_value'];
				$option[$key]['o_name'] = $o[$key]['o_name'];
				$option[$key]['o_description'] = $o[$key]['o_description'];
			}
		}
		return $option;
	}

	/** 保存参数 */
	public function save_option($option)
	{
		$option = $this->deal_mq($option);
		if(is_array($option))
		{
			foreach($option as $k => $v)
			{
				$where['o_key'] = array('EQ', $k);
				$o = $this->where($where)->limit(1)->select();
				$o = $o[0];
				if(0 == $o['o_is_array'])
				{
					$this->where($where)->set_field('o_value',$v);
				}
				elseif(1 == $o['o_is_array'])
				{
					$this->where($where)->set_field('o_value',json_encode($v));
				}
			}
			return true;
		}
		return false;
	}

	/** 处理MAGIC_QUOTES_GPC 和模型的creat不要同时使用 */
	private function deal_mq($data)
	{
		if(is_array($data))
		{
			foreach($data as $k => $v)
			{
				$data[$k] = $this->deal_mq($v);
			}
		}
		elseif(is_string($data))
		{
			$data = (MAGIC_QUOTES_GPC ? stripslashes($data) : $data);
		}
		return $data;
	}

}
?>