<?php
function check_install_lock()
{
	if(file_exists(INSTALL_LOCK_FILE))
	{
		echo L('softHasBeenInstalled');
		exit();
	}
}

function check_system(&$systemItems, &$checkNextStep)
{
	$systemItems['os']['c'] = PHP_OS;
	$systemItems['phpVersion']['c'] = PHP_VERSION;
	$systemItems['uploadMaxFilesize']['c'] = @ini_get('file_uploads') ? ini_get('upload_max_filesize') : 'unknow';
	$temp = function_exists('gd_info') ? gd_info() : array('GD Version' => L('nonsupport'));
	$systemItems['gdVersion']['c'] = empty($temp['GD Version']) ? 'inexistence' : rtrim(ltrim($temp['GD Version'], 'bundled ('),'compatible)');
	unset($temp);
	if(function_exists('diskFreeSpace'))
	{
		$systemItems['diskSpace']['c'] = floor(diskFreeSpace(dirname(APP_PATH)) / (1024*1024)).'M';
	}
	else
	{
		$systemItems['diskSpace']['c'] = 'unknow';
	}

	foreach($systemItems as $k => $v)
	{
		if ($v['r'] != 'noLimit' && ($systemItems[$k]['c'] - $v['r']) < 0)
		{
			$systemItems[$k]['s'] = 0;
			$checkNextStep = 0;
		}
		else
		{
			$systemItems[$k]['s'] = 1;
		}
	}
}

function check_dirfile(&$dirfileItems, &$checkNextStep)
{
	foreach($dirfileItems as $k => $v)
	{
		$path = dirname(APP_PATH).$v['path'];
		if('dir' == $v['type'])
		{
			if(!mk_dir($path))
			{
				if(is_dir($path))
				{
					$dirfileItems[$k]['c'] = 'readOnly';
				}
				else
				{
					$dirfileItems[$k]['c'] = 'inexistence';
				}
				$dirfileItems[$k]['s'] = 0;
				$checkNextStep = 0;
			}
			else
			{
				$dirfileItems[$k]['c'] = 'writable';
				$dirfileItems[$k]['s'] = 1;
			}
		}
		else
		{
			if(file_exists($path))
			{
				if(is_writable($path))
				{
					$dirfileItems[$k]['c'] = 'writable';
					$dirfileItems[$k]['s'] = 1;
				}
				else
				{
					$dirfileItems[$k]['c'] = 'readOnly';
					$dirfileItems[$k]['s'] = 0;
					$checkNextStep = 0;
				}
			}
			else
			{
				if(mk_dir(dirname($path)))
				{
					$dirfileItems[$k]['s'] = 1;
					$dirfileItems[$k]['c'] = 'writable';
				}
				else
				{
					$dirfileItems[$k]['s'] = 0;
					$checkNextStep = 0;
					$dirfileItems[$k]['c'] = 'inexistence';
				}
			}
		}
	}
}

function check_function(&$functionItems, &$checkNextStep)
{
	foreach ($functionItems as $k => $v)
	{
		if (function_exists($v['name']))
		{
			$functionItems[$k]['s'] = 1;
		}
		else
		{
			$functionItems[$k]['s'] = 0;
			$checkNextStep = 0;
		}
	}
}

function check_post($p)
{
	$errorMessage = '';
	foreach ($p as $k => $v)
	{
		if (0 == strlen($v))
		{
			$errorMessage .= "\r\n".L($k).L('noEmpty').'<br />';
		}
	}
	return $errorMessage;
}

function check_db($dbHost, $dbUser, $dbPw, $dbDb, $dbPrefix)
{
	$errorMessage = '';
	if (!@mysql_connect($dbHost, $dbUser, $dbPw))
	{
		$errno = mysql_errno();
		if (1045 == $errno)
		{
			$errorMessage = L('dbErrno1045');
		}
		elseif (2003 == $errno)
		{
			$errorMessage = L('dbErrno2003');
		}
		else
		{
			$errorMessage = L('dbConnectError');
		}
	}
	elseif (!@mysql_select_db($dbDb))
	{
		@mysql_query("CREATE DATABASE `{$dbDb}` DEFAULT CHARACTER SET utf8 COLLATE utf8_general_ci") or $errorMessage = L('dbDbInexistence');
	}
	elseif ($query = mysql_query("SHOW TABLES FROM `{$dbDb}`"))
	{
		while ($row = mysql_fetch_row($query))
		{
			if (preg_match("/^{$dbPrefix}/", $row[0]))
			{
				$errorMessage = L('dbPrefixExist');
			}
		}
	}
	return $errorMessage;
}

function trim_array($a = array(), $charList = '')
{
	if (0 == strlen($charList))
	{
		foreach ($a as $k => $v)
		{
			$a[$k] = trim($v);
		}
	}
	else
	{
		foreach ($a as $k => $v)
		{
			$a[$k] = trim($v, $charList);
		}
	}
	return $a;
}

function random($length)
{
	$hash = '';
	$chars = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789abcdefghijklmnopqrstuvwxyz';
	$max = strlen($chars) - 1;
	for ($i = 0; $i < $length; $i++)
	{
		$hash .= $chars[mt_rand(0, $max)];
	}
	return $hash;
}

function connect_db($dbHost, $dbUser, $dbPw, $dbDb)
{
	@mysql_connect($dbHost, $dbUser, $dbPw);
	@mysql_select_db($dbDb);
	@mysql_query('SET NAMES '.SOFT_DB_CHARSET);

}

function run_sql($sqlFile)
{
	$sqlFile = file($sqlFile);
	$sql = '';
	foreach ($sqlFile as $row)
	{
		if (substr($row, 0, 2) != '--' && substr($row, 0, 2) != '/*' && substr($row, 0, 1) != '#' && trim($row) != '')
		{
			$sql .= $row;
		}
	}
	$sql = str_replace('prefix_', $_POST['dbPrefix'], $sql);
	$query = trim_array(explode(";\n", $sql));

	$c = 1;
	$t = count($query);
	foreach ($query as $q)
	{
		$table = '';
		preg_match('/`\w*`/', $q, $table);
		$m = L('installSuccess');
		if ('DROP TABLE' == substr(strtoupper($q), 0, 10))
		{
			$m = L('dropTable').$table[0];
		}
		if ('CREATE TABLE' == substr(strtoupper($q), 0, 12))
		{
			$m = L('createTable').$table[0];
		}
		if ('INSERT INTO' == substr(strtoupper($q), 0, 11))
		{
			$m = L('insertDataInto').$table[0];
		}
		if ('SET SQL_MODE' == substr(strtoupper($q), 0, 12))
		{
			$m = L('setSqlMode');
		}
		$b = round($c/$t*100, 0);
		mysql_query($q);
		show_progress($m, $b);
		$c++;
	}
}

function show_progress($message, $barLength)
{
	echo "<script type=\"text/javascript\">show_progress('{$message}', '{$barLength}%');</script>\r\n";
	@ob_flush();
	@flush();
}

function save_define_file($defineFile, $define)
{
	$s = "<?php\r\n";
	foreach ($define as $k => $v)
	{
		$s .= "define('".$k."', '".$v."');\r\n";
	}
	$s .= '?>';
	@file_put_contents($defineFile, $s);
}

function save_config_file($filename, $array='')
{
	if(is_array($array))
	{
		$content = var_export($array, true);
	}
	else
	{
		$content = $array;
	}
	$content = "<?php\r\nreturn $content;\r\n?>";
	@file_put_contents($filename, $content);
}

function install_lock()
{
	date_default_timezone_set(C('DEFAULT_TIMEZONE'));
	$s = "<?php\r\n";
	$s .= "//install information\r\n";
	$s .= "//----------------------------------------\r\n";
	$s .= "//soft: ".SOFT_NAME." ".SOFT_CODE_NAME." ".SOFT_CHARSET." version".SOFT_VERSION."\r\n";
	$s .= "//installation language: ".$_GET[C('VAR_LANG')]."\r\n";
	$s .= "//host: ".__APP__."\r\n";
	$s .= "//time: ".date('Y-m-d H:i:s T', time())."\r\n";
	$s .= "header(\"location:".__APP__."\");\r\n";
	$s .= "?>";
	@file_put_contents(INSTALL_LOCK_FILE, $s);
}
?>