<?php
//soft version info
define('SOFT_NAME', 'Alog');
define('SOFT_CHARSET', 'utf-8');
define('SOFT_DB_CHARSET', 'UTF8');
define('SOFT_CODE_NAME', 'Ben');
define('SOFT_VERSION', '3.0.0.16');
define('SOFT_COPYRIGHT_YEAR', '2012');
define('SOFT_AUTHOR', 'asthis.net');
define('SOFT_AUTHOR_URL', 'http://dev.asthis.net/');
define('SOFT_UPDATE_URL', 'http://dev.asthis.net/updateinfo/alog.js');
//soft install file
define('INSTALL_LOCK_FILE', dirname(APP_PATH).D_S.'runtime'.D_S.LOG_DIR.D_S."install.lock.php");
define('SQL_FILE', DATA_PATH."/data.sql");
define('DEFINE_FILE', dirname(APP_PATH).D_S.CFG_DIR.D_S.'define.php');
define('CONFIG_FILE', dirname(APP_PATH).D_S.CFG_DIR.D_S.'comm.php');
//site install info
define('SITE_MANAGE_PATH', '/admin');
define('ADMIN_CONFIG_FILE', dirname(APP_PATH).D_S.SITE_MANAGE_PATH.D_S.CFG_DIR.D_S.'comm.php');

class IndexCtrlr extends Ctrlr
{
	protected $tpl_var;
	protected $systemItems;
	protected $dirfileItems;
	protected $functionItems;

	//choose language
	public function index()
	{
		//template var
		$this->tpl_var = array(
			'soft_name' => SOFT_NAME,
			'soft_charset' => SOFT_CHARSET,
			'soft_code_name' => SOFT_CODE_NAME,
			'soft_version' => SOFT_VERSION,
			'soft_copyright_year' => SOFT_COPYRIGHT_YEAR,
			'soft_author' => SOFT_AUTHOR,
			'soft_author_url' => SOFT_AUTHOR_URL,
			'soft_update_url' => SOFT_UPDATE_URL,
			'site_url' => dirname(__APP__),
			'site_manage_url' => dirname(__APP__).SITE_MANAGE_PATH,
			'tpl_path' => __THEME__
		);

		//install config
		$this->systemItems = array(
			'os' => array('r' => 'noLimit', 'b' => 'unix'),
			'phpVersion' => array('r' => '5.1', 'b' => '5.2'),
			'uploadMaxFilesize' => array('r' => 'noLimit', 'b' => '2M'),
			'gdVersion' => array('r' => '2.0', 'b' => '2.0'),
			'diskSpace' => array('r' => '20M', 'b' => 'noLimit')
		);
		$this->dirfileItems = array(
			'runtimeDir' => array('type' => 'dir', 'path' => './runtime'),
			'htmlDir' => array('type' => 'dir', 'path' => './html'),
			'configDir' => array('type' => 'dir', 'path' => './cfg'),
			'defineFile' => array('type' => 'file', 'path' => './cfg/defines.php'),
			'configFile' => array('type' => 'file', 'path' => './cfg/comm.php'),
		);
		$this->functionItems = array(
			array('name' => 'file_get_contents'),
			array('name' => 'scandir')
		);

		check_install_lock();

		$this->assign('tpl_var', $this->tpl_var);

		if (!isset($_GET[C('VAR_LANG')]))
		{
			$this->step0();
		}
		else
		{
			$step = isset($_POST['step']) ? $_POST['step'] : 1;
			switch ($step)
			{
				case '1':
					$this->step1();
					break;
				case '2':
					$this->step2();
					break;
				case '3':
					$this->step3();
					break;
				case '4':
					$this->step4();
					break;
				case '5':
					$errorMessage = check_post(trim_array($_POST));
					$errorMessage .= check_db($_POST['dbHost'],
											$_POST['dbUser'],
											$_POST['dbPw'],
											$_POST['dbDb'],
											$_POST['dbPrefix']);
					if ('' != $errorMessage)
					{
						$this->step4($errorMessage);
					}
					else
					{
						$this->step5();
					}
					break;
				case '6':
					$this->step6();
					break;
				default:
					$this->step1();
					break;
			}
		}
	}

	public function step0()
	{
		$langSet = require_cache(LANG_PATH.D_S.'lang_set.php');
		$selectHight = count($langSet) > 5 ? count($langSet) : 5;
		$hal = strtolower(substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 5));
		$this->assign('selectHight', $selectHight);
		$this->assign('hal', $hal);
		$this->assign('langSet', $langSet);
		$this->display('index');
	}

	//show introduce
	public function step1()
	{
		$this->display('step1');
	}
	//show license
	public function step2()
	{
		$this->display('step2');
	}
	//check environment
	public function step3()
	{
		$checkNextStep = true;
		check_system($this->systemItems, $checkNextStep);
		check_dirfile($this->dirfileItems, $checkNextStep);
		check_function($this->functionItems, $checkNextStep);
		foreach($this->systemItems as $k => $v)
		{
			$this->systemItems[L($k)]['r'] = L($v['r']);
			$this->systemItems[L($k)]['b'] = L($v['b']);
			$this->systemItems[L($k)]['c'] = L($v['c']);
			if (1 == $v['s'])
			{
				$this->systemItems[L($k)]['c_c'] = 'class="y"';
			}
			else
			{
				$this->systemItems[L($k)]['c_c'] = 'class="n"';
			}
			unset($this->systemItems[$k]);
		}
		foreach($this->dirfileItems as $k => $v)
		{
			$this->dirfileItems[L($k)]['type'] = L($v['type']);
			$this->dirfileItems[L($k)]['c'] = L($v['c']);
			$this->dirfileItems[L($k)]['path'] = $v['path'];
			if (1 == $v['s'])
			{
				$this->dirfileItems[L($k)]['c_c'] = 'class="y"';
			}
			else
			{
				$this->dirfileItems[L($k)]['c_c'] = 'class="n"';
			}
			unset($this->dirfileItems[$k]);
		}
		foreach($this->functionItems as $k => $v)
		{
			if (1 == $v['s'])
			{
				$this->functionItems[$k]['c_c'] = 'class="y"';
				$this->functionItems[$k]['s'] = L('support');
			}
			else
			{
				$this->functionItems[$k]['c_c'] = 'class="n"';
				$this->functionItems[$k]['s'] = L('nonsupport');
			}
		}
		$this->assign('checkNextStep', $checkNextStep);
		$this->assign('systemItems', $this->systemItems);
		$this->assign('dirfileItems', $this->dirfileItems);
		$this->assign('functionItems', $this->functionItems);
		$this->display('step3');
	}
	//setup installation
	public function step4($errorMessage = '')
	{
		$formV['dbHost'] = isset($_POST['dbHost']) ? $_POST['dbHost'] : 'localhost';
		$formV['dbUser'] = isset($_POST['dbUser']) ? $_POST['dbUser'] : 'root';
		$formV['dbPw'] = isset($_POST['dbPw']) ? $_POST['dbPw'] : '';
		$formV['dbDb'] = isset($_POST['dbDb']) ? $_POST['dbDb'] : strtolower(SOFT_NAME);
		$formV['dbPrefix'] = isset($_POST['dbPrefix']) ? $_POST['dbPrefix'] : strtolower(SOFT_NAME).'_';
		$formV['founderName'] = isset($_POST['founderName']) ? $_POST['founderName'] : 'admin';
		$formV['founderEmail'] = isset($_POST['founderEmail']) ? $_POST['founderEmail'] : '';
		$formV['founderPw'] = isset($_POST['founderPw']) ? $_POST['founderPw'] : '';
		$this->assign('formV', $formV);
		$this->assign('errorMessage', $errorMessage);
		$this->display('step4');
	}
	//write data
	function step5()
	{
		/* 替换管理员信息 */
		$administrator = $_POST['founderName'];
		$password = md5(substr(md5($_POST['founderPw']),0,30));
		$sql = file_get_contents(SQL_FILE);
		$sql = str_replace(array('{-time-}','{-ip-}','{-ausr-}','{-apwd-}'),array(time(),get_ip(),$administrator,$password), $sql);
		@file_put_contents(SQL_FILE, $sql);

		$this->display('step5');

		connect_db($_POST['dbHost'], $_POST['dbUser'], $_POST['dbPw'], $_POST['dbDb']);
		run_sql(SQL_FILE);

		$siteSeed = random(8);
		$define = array(
			'SOFT_NAME' => SOFT_NAME,
			'SOFT_CODE_NAME' => SOFT_CODE_NAME,
			'SOFT_VERSION' => SOFT_VERSION,
			'SOFT_CHARSET' => SOFT_CHARSET,
			'SOFT_AUTHOR' => SOFT_AUTHOR,
			'SOFT_AUTHOR_URL' => SOFT_AUTHOR_URL,
			'SOFT_UPDATE_URL' => SOFT_UPDATE_URL,
			'SITE_SEED' => $siteSeed
		);
		//save_define_file(DEFINE_FILE, $define);

		$s = array(
			'URL_TYPE' => 4, /* 1:普通模式 2:PATHINFO模式 3:REWRITE模式 4:兼容模式 */
			'URL_ROUTER' => false, /* 是否开启URL路由 */
			'DB_USER' => $_POST['dbUser'], /* 用户名 */
			'DB_PWD' => $_POST['dbPw'], /* 密码 */
			'DB_HOST' => $_POST['dbHost'], /* 服务器地址 */
			'DB_NAME' => $_POST['dbDb'], /* 数据库名 */
			'DB_CHARSET' => SOFT_DB_CHARSET, /* 数据库默认编码 */
			'DB_PREFIX' => $_POST['dbPrefix'], /* 数据库表前缀 */
			'SOFT_NAME' => SOFT_NAME,
			'SOFT_CODE_NAME' => SOFT_CODE_NAME,
			'SOFT_VERSION' => SOFT_VERSION,
			'SOFT_CHARSET' => SOFT_CHARSET,
			'SOFT_AUTHOR' => SOFT_AUTHOR,
			'SITE_SEED' => $siteSeed
		);
		save_config_file(CONFIG_FILE, $s);
		save_config_file(ADMIN_CONFIG_FILE, $s);
		/* 删除runtime文件 */
		$runtimeFile = dirname(APP_PATH).D_S.'runtime'.D_S."~runtime.php";
		$adminRuntimeFile = APP_PATH.D_S.'runtime'.D_S."~runtime.php";
		@unlink($runtimeFile);
		@unlink($adminRuntimeFile);
	}
	//lock installation
	function step6()
	{
		install_lock();
		$this->display('step6');
	}
}
?>