<?php
class CommentCtrlr extends CommonCtrlr
{
	/** 添加回复 */
	public function add()
	{
		$m_o = M('Option');
		$_POST['c_author'] = msubstr(htmlspecialchars($_POST['c_author']), 0, 64);
		$_POST['c_content'] = $this->deal_content($_POST['c_content']);
		$_POST['c_status'] = $m_o->filter_check(array($_POST['c_content'], $_POST['c_author']));
		$_POST['c_add_ip'] = get_ip();
		$_POST['c_add_time'] = time();
		$_POST['article_id'] = ((int)$_POST['article_id'] ? (int)$_POST['article_id'] : 0);

		$returnUrl = get_url('article', $_POST['article_id']);
		/* 验证码不对 */
		if(!isset($_SESSION))
		{
			session_start();
		}
		if(!isset($_SESSION['v_code']) || strtolower($_SESSION['v_code']) != strtolower($_POST['v_code']))
		{
			unset($_SESSION['v_code']); /* 判断后删除验证码 */
			$this->error(L('ERROR_VCODE'), $returnUrl);
			exit();
		}
		unset($_SESSION['v_code']); /* 判断后删除验证码 */
		/* 操作间隔太短 */
		if(!interval('', C('INTERVAL')))
		{
			$this->error(L('TIME_INTERVAL_ERROR'), $returnUrl);
			exit();
		}
		/* article_id 不对*/
		if(!(0 < $_POST['article_id']) || '' == $_POST['c_author'] || '' == $_POST['c_content'])
		{
			$this->error(L('ERROR_FROM'), $returnUrl);
			exit();
		}
		/* 写入数据 */
		$m_c = M('Comment');
		if(!$m_c->add())
		{
			$this->error(L('ERROR_UNKNOWN'), $returnUrl);
			exit();
		}
		interval();
		$this->success(L('COMMENT_ADD_SUCCESS'), $returnUrl);
	}

	/** 处理内容 */
	private function deal_content($content)
	{
		$m_o = M('Option');
		$tags = $m_o->get_option('filter_rules/allow_tags');
		return $content = strip_tags($content, $tags);
	}

}
?>