<?php
class GuestbookCtrlr extends CommonCtrlr
{
	public function index()
	{
		$_GET[C('VAR_PAGE')] = ((isset($_GET[C('VAR_PAGE')]) && (int)$_GET[C('VAR_PAGE')] > 0) ? (int)$_GET[C('VAR_PAGE')] : 1);

		$m_o = M('Option');
		$pageSize['guestbook'] = $m_o->get_option('page_size/guestbook');
		$pageSize['a_hot'] = $m_o->get_option('page_size/a_hot');
		$pageSize['a_commend'] = $m_o->get_option('page_size/a_commend');

		$m_g = M('Guestbook');
		$rowsNum = $m_g->count_guestbook();
		$url_str = U('Guestbook/index?'.C('VAR_PAGE').'=_page_');
		$p = new Page($rowsNum, $pageSize['guestbook'], $url_str);
		define('PAGE_LIST', $p->show());
		$limit = $p->get_limit();
		/* 留言列表 */
		$_GL = $m_g->get_guestbookList($limit);
		$this->assign('_GL', $_GL);

		/* 文章列表 */
		$_AL = array();
		$m_a = M('Article');
		$_AL['hot'] = $m_a->get_articleList('hot', $pageSize['a_hot']);
		$_AL['commend'] = $m_a->get_articleList('commend', $pageSize['a_commend']);
		$this->assign('_AL', $_AL);

		$_GI['f_action'] = U('Guestbook/add');
		$this->assign('_GI', $_GI);

		/* 当前位置 */
		$_ON['type'] = 'guestbook';
		$this->assign('_ON', $_ON);

		$this->display('guestbook');
	}

	/** 添加留言 */
	public function add()
	{
		$m_o = M('Option');
		$_POST['g_author'] = msubstr(htmlspecialchars($_POST['g_author']), 0, 64);
		$_POST['g_email'] = msubstr(htmlspecialchars($_POST['g_email']), 0, 255);
		$_POST['g_content'] = $this->deal_content($_POST['g_content']);
		$_POST['g_status'] = $m_o->filter_check(array($_POST['g_content'], $_POST['g_author']));
		$_POST['g_add_ip'] = get_ip();
		$_POST['g_add_time'] = time();

		$returnUrl = U('Guestbook/index');
		/* 验证码不对 */
		if(!isset($_SESSION))
		{
			session_start();
		}
		if(!isset($_SESSION['v_code']) || strtolower($_SESSION['v_code']) != strtolower($_POST['v_code']))
		{
			unset($_SESSION['v_code']); /* 判断后删除验证码 */
			$this->error(L('ERROR_VCODE'), $returnUrl);
			exit();
		}
		unset($_SESSION['v_code']); /* 判断后删除验证码 */
		/* 操作间隔太短 */
		if(!interval('', C('INTERVAL')))
		{
			$this->error(L('TIME_INTERVAL_ERROR'), $returnUrl);
			exit();
		}
		/* article_id 不对*/
		if('' == $_POST['g_author'] || '' == $_POST['g_email'] || '' == $_POST['g_content'])
		{
			$this->error(L('ERROR_FROM'), $returnUrl);
			exit();
		}
		/* 写入数据 */
		$m_g = M('Guestbook');
		if(!$m_g->add())
		{
			$this->error(L('ERROR_UNKNOWN'), $returnUrl);
			exit();
		}
		interval();
		$this->success(L('GUESTBOOK_ADD_SUCCESS'), $returnUrl);
	}

	/** 处理内容 */
	private function deal_content($content)
	{
		$m_o = M('Option');
		$tags = $m_o->get_option('filter_rules/allow_tags');
		return $content = strip_tags($content, $tags);
	}

}
?>