<?php
class ArticleModl extends Modl
{
	/** 获取文章列表 */
	public function get_articleList($type = 'new', $limit = '', $categoryId = 0)
	{
		$where = array();
		$order = '';
		if(0 < $categoryId)
		{
			$m_c = M('Category');
			$subCategory = $m_c->where("`c_parent_id` = '".$categoryId."'")->select();
			if(!empty($subCategory))
			{
				$subCategoryId = '';
				foreach($subCategory as $sc)
				{
					$subCategoryId .= $sc['category_id'].',';
				}
				$categoryId = $subCategoryId.$categoryId;
				$where['__ARTICLE__.category_id'] = array('IN', $categoryId);
			}
			else
			{
				$where['__ARTICLE__.category_id'] = array('EQ', $categoryId);
			}
		}
		switch($type)
		{
			case 'new':
				$order = '`a_add_time` DESC';
				break;
			case 'hot':
				$order = '`a_view_count` DESC, `article_id` DESC';
				break;
			case 'commend':
				$where['__ARTICLE__.a_flag_c'] = array('EQ', 1);
				$order = '`article_id` DESC';
				break;
			case 'picture':
				$where['__ARTICLE__.a_flag_p'] = array('EQ', 1);
				$order = '`article_id` DESC';
				break;
			case 'lucky':
				$order = 'rand()';
				break;
			default:
				$order = '`article_id` DESC';
				break;
		}
		$articleList = $this->join('__CATEGORY__ AS c ON c.category_id = __ARTICLE__.category_id')
		->where($where)->order($order)->limit($limit)->select();
		if(!empty($articleList))
		{
			foreach($articleList as $k => $v)
			{
				$articleList[$k]['c_url'] = get_url('category', $v['category_id']);
				$articleList[$k]['a_url'] = get_url('article', $v['article_id']);
			}
		}
		return $articleList;
	}

	/** 获取文章信息 */
	public function get_articleInfo($articleId)
	{
		$articleInfo = $this->join('__CATEGORY__ AS c ON c.category_id = __ARTICLE__.category_id')->find($articleId);
		if(!empty($articleInfo))
		{
			if(0 < $articleInfo['c_parent_id'])
			{
				$m_c = M('Category');
				$articleInfo['c_parent'] = $m_c->field('category_id, c_name')->find($articleInfo['c_parent_id']);
				$articleInfo['c_parent']['c_url'] = get_url('category', $articleInfo['c_parent']['category_id']);
			}
			else
			{
				$articleInfo['c_parent'] = null;
			}
			$articleInfo['c_url'] = get_url('category', $articleInfo['category_id']);
			$articleInfo['a_url'] = get_url('article', $articleInfo['article_id']);
			$articleInfo['a_abstract'] = $articleInfo['a_abstract'] ? $articleInfo['a_abstract'] : get_abstract($articleInfo['a_content']);
		}
		return $articleInfo;
	}

	/** 增加查看次数 */
	public function inc_view($articleId)
	{
		return $this->field_inc('a_view_count', 'article_id ='.$articleId);
	}

	/** 增加支持次数 */
	public function inc_support($articleId)
	{
		return $this->field_inc('a_support_count', 'article_id ='.$articleId);
	}

	/** 文章计数 */
	public function count_article($categoryId)
	{
		$m_c = M('Category');
		$subCategory = $m_c->where("`c_parent_id` = '".$categoryId."'")->select();
		if(!empty($subCategory))
		{
			$subCategoryId = '';
			foreach($subCategory as $sc)
			{
				$subCategoryId .= $sc['category_id'].',';
			}
			$categoryId = $subCategoryId.$categoryId;
			$where['__ARTICLE__.category_id'] = array('IN', $categoryId);
		}
		else
		{
			$where['__ARTICLE__.category_id'] = array('EQ', $categoryId);
		}
		return $this->where($where)->count();
	}

}
?>