<?php
class CategoryModl extends Modl
{
	/* 获取分类列表 */
	public function get_categoryList()
	{
		$categoryList = F('_category_list');
		if(!$categoryList)
		{
			$where['__CATEGORY__.c_parent_id'] = array('EQ', 0);
			$order = '`c_display_order`, `category_id`';
			$categoryList = $this->where($where)->order($order)->select();
			if(!empty($categoryList))
			{
				foreach($categoryList as $k => $v)
				{
					$categoryList[$k]['c_url'] = get_url('category', $v['category_id']);
					$categoryList[$k]['c_sub'] = $this->where('c_parent_id = '.$v['category_id'])->order($order)->select();
					if(!empty($categoryList[$k]['c_sub']))
					{
						foreach($categoryList[$k]['c_sub'] as $m => $n)
						{
							$categoryList[$k]['c_sub'][$m]['c_url'] = get_url('category', $n['category_id']);
						}
					}
				}
			}
			F('_category_list', $categoryList);
		}
		return $categoryList;
	}

	/* 获取分类信息 */
	public function get_categoryInfo($categoryId = 0)
	{
		$categoryInfo = F('_category_info_'.$categoryId);
		if(!$categoryInfo)
		{
			$categoryInfo = $this->find($categoryId);
			if(!empty($categoryInfo))
			{
				if(0 < $categoryInfo['c_parent_id'])
				{
					$categoryInfo['c_parent'] = $this->field('category_id, c_name')->find($categoryInfo['c_parent_id']);
					$categoryInfo['c_parent']['c_url'] = get_url('category', $categoryInfo['c_parent']['category_id']);
				}
				else
				{
					$categoryInfo['c_parent'] = null;
				}
				$categoryInfo['c_url'] = get_url('category', $categoryId);
			}
			$categoryInfo['c_sub'] = $this->where('c_parent_id = '.$categoryId)->order('`c_display_order`, `category_id`')->select();
			if(!empty($categoryInfo['c_sub']))
			{
				foreach($categoryInfo['c_sub'] as $k => $v)
				{
					$categoryInfo['c_sub'][$k]['c_url'] = get_url('category', $v['category_id']);
				}
			}
			F('_category_info_'.$categoryId, $categoryInfo);
		}
		return $categoryInfo;
	}

}
?>