<?php
class OptionModl extends Modl
{
	/** 获取系统参数 $optionKey为array或者字符串('page_size'或者'page_size/post') */
	public function get_option($optionKey = null)
	{
		$option = array();
		$optionAll = F('_option');
		if(!$optionAll)
		{
			$optionAll = array();
			$o = $this->select();
			foreach($o as $v)
			{
				if(0 != $v['o_is_array'])
				{
					$optionAll[$v['o_key']] = json_decode($v['o_value'], true);
				}
				else
				{
					$optionAll[$v['o_key']] = $v['o_value'];
				}

			}
			F('_option', $optionAll);
		}
		if(is_string($optionKey))
		{
			$o = $optionAll;
			$key = explode('/', $optionKey);
			foreach($key as $key)
			{
				$o = $o[$key];
			}
			$option = $o;
		}
		elseif(is_array($optionKey))
		{
			foreach($optionKey as $key)
			{
				$option[$key] = $this->get_option($key);
			}
		}
		else
		{
			$option = $optionAll;
		}
		return $option;
	}

	/** 内容过滤 */
	public function filter($content)
	{
		$o_f = $this->get_option('filter_rule');
		if(!$content or !$o_f['switch'])
		{
			return $content;
		}
		if(is_array($content))
		{
			foreach($content as $key => $val)
			{
				$content[$key] = $this->filter_content($val);
			}
			return $content;
		}
		else
		{
			foreach($o_f['words'] as $word)
			{
				$word = trim($word);
				if(empty($word))
				{
					continue;
				}
				$replaceStr = '';
				$wordLen = mstrlen($word);
				for($i = 0; $i < $wordLen; $i++)
				{
					$replaceStr .=  $o_f['replace'];
				}
				$content = str_replace($word, $replaceStr, $content);
			}
			return $content;
		}
	}

	/** 过滤检查 */
	public function filter_check($content)
	{
		$o_f = $this->get_option('filter_rule');
		if(!$content or !$o_f['switch'])
		{
			return 1;
		}
		if(is_array($content))
		{
			foreach($content as $c)
			{
				if(!$this->filter_check($c))
				{
					return 0;
				}
			}
			return 1;
		};
		foreach($o_f['words'] as $word)
		{
			$word = trim($word);
			if(empty($word))
			{
				continue;
			}
			if(strstr($content, $word))
			{
				return 0;
			}
		}
		return 1;
	}

}
?>