<?php
/**
 *--------------------------------------------------
 * 常量定义
 *--------------------------------------------------
 * @program     : PFA
 * @create      : 2012-3-2 13:28:41
 * @description :
 */

if(!defined('PFA_PATH')) exit();

/* 版本信息 */
define('PFA_VERSION', '1.0.0');
define('PFA_RELEASE', '20120303');

if(version_compare(PHP_VERSION,'5.4.0','<'))
{
	@set_magic_quotes_runtime(0);
	define('MAGIC_QUOTES_GPC', get_magic_quotes_gpc() ? true : false);
}
define('IS_CGI', substr(PHP_SAPI, 0, 3)=='cgi' ? 1 : 0);
define('IS_WIN', strstr(PHP_OS, 'WIN') ? 1 : 0);
define('IS_CLI', PHP_SAPI == 'cli'? 1 : 0);
if(!IS_CLI)
{
	if(!defined('_PHP_FILE_')) /* 当前文件名 */
	{
		if(IS_CGI) /* CGI/FASTCGI模式下 */
		{
			$_temp = explode('.php', $_SERVER["PHP_SELF"]);
			define('_PHP_FILE_', rtrim(str_replace($_SERVER["HTTP_HOST"],'',$_temp[0].'.php'),'/'));
		}
		else
		{
			define('_PHP_FILE_', rtrim($_SERVER["SCRIPT_NAME"],'/'));
		}
	}
	if(!defined('ROOT')) /* 网站URL根目录 */
	{
		if(APP_PATH != dirname(PFA_PATH))
		{
			$_root = dirname(dirname(_PHP_FILE_)); /* 应用名称与目录名称相同时使用 */
		}
		else
		{
			$_root = dirname(_PHP_FILE_);
		}
		define('ROOT', (($_root == '/' || $_root == '\\') ? '' : $_root));
	}
	if(!defined('APP_ROOT')) /* 应用URL根目录 */
	{
		$_root = dirname(_PHP_FILE_);
		define('APP_ROOT', (($_root == '/' || $_root == '\\') ? '' : $_root));
	}
	define('URL_COMMON', 1); /* 普通模式 */
	define('URL_PATHINFO', 2); /* PATHINFO模式 */
	define('URL_REWRITE', 3); /* REWRITE模式 */
	define('URL_COMPAT', 4); /* 兼容模式 */
}

/* 分隔符 */
define('D_S', DIRECTORY_SEPARATOR);
define('P_S', PATH_SEPARATOR);

/* 设置目录 */
define('HTML_DIR', 'html');
define('CFG_DIR', 'cfg');
define('COMM_DIR', 'comm');
define('LIB_DIR', 'lib');
define('LIB_CTRLR_DIR', 'ctrlr');
define('LIB_MODL_DIR', 'modl');
define('LANG_DIR', 'lang');
define('TPL_DIR', 'tpl');
define('CACHE_DIR', 'cache'); /* 模板缓存目录 */
define('TEMP_DIR', 'temp'); /* 数据缓存目录 Cache类 S() */
define('DATA_DIR', 'data'); /* 数据文件目录 F() */
define('LOG_DIR', 'log'); /* 日志目录 */
define('PUBLIC_DIR', 'public'); /* 公共文件目录 */

/* 设置路径 */
define('HTML_PATH', APP_PATH.D_S.HTML_DIR);
define('CFG_PATH', APP_PATH.D_S.CFG_DIR);
define('COMM_PATH', APP_PATH.D_S.COMM_DIR);
define('LIB_PATH', APP_PATH.D_S.LIB_DIR);
define('LIB_CTRLR_PATH', LIB_PATH.D_S.LIB_CTRLR_DIR);
define('LIB_MODL_PATH', LIB_PATH.D_S.LIB_MODL_DIR);
define('LANG_PATH', APP_PATH.D_S.LANG_DIR);
define('TPL_PATH', APP_PATH.D_S.TPL_DIR);
define('CACHE_PATH', RUNTIME_PATH.D_S.CACHE_DIR);
define('TEMP_PATH', RUNTIME_PATH.D_S.TEMP_DIR);
define('DATA_PATH', RUNTIME_PATH.D_S.DATA_DIR);
define('LOG_PATH', RUNTIME_PATH.D_S.LOG_DIR);
if(APP_PATH != dirname(PFA_PATH))
{
	define('PUBLIC_PATH', dirname(PFA_PATH).D_S.PUBLIC_DIR); /* 公用文件夹目录放置根目录下 */
}
else
{
	define('PUBLIC_PATH', APP_PATH.D_S.PUBLIC_DIR); /* 公用文件夹目录放置应用目录下 */
}

define('PFA_EXT_PATH', PFA_PATH.D_S.'lib/ext'); /* PFA扩展类库目录 */
define('PFA_VENDER_PATH', PFA_PATH.D_S.'vendor'); /* PFA第三方类库目录 */
?>