<?php
/**
 *--------------------------------------------------
 * PHP Frame AsThis 公用函数
 *--------------------------------------------------
 * @program     : PHP Frame AsThis
 * @create      : 2012-2-28 12:05:04
 * @description :
 */

if(!defined('PFA_PATH')) exit();

/** 获取环境信息 */
function get_env($varName)
{
	if(isset($_SERVER[$varName]))
	{
		return $_SERVER[$varName];
	}
	elseif(isset($_ENV[$varName]))
	{
		return $_ENV[$varName];
	}
	elseif(getenv($varName))
	{
		return getenv($varName);
	}
	elseif(function_exists('apache_getenv') && apache_getenv($varName, true))
	{
		return apache_getenv($varName, true);
	}
	return false;
}

/** 批量创建目录 */
function mkdirs($dirs, $mode = 0777)
{
	foreach ($dirs as $dir)
	{
		if(!is_dir($dir)) mk_dir($dir, $mode);
	}
}

/** 创建可写目录(尝试检测上一级目录) */
function mk_dir($dir, $mode = 0777)
{
	if(is_dir($dir) || @mkdir($dir, $mode))
	{
		return true;
	}
	if(!@mkdir($dir, $mode))
	{
		mk_dir(dirname($dir), $mode);
		@mkdir($dir, $mode);
	}
}

/** 删除目录中的文件 $self:是否删除目录 */
function del_dir($dir, $self = true)
{
	if(is_dir($dir) == false)
	{
		exit("The Directory Is Not Exist!");
	}
	$handle = opendir($dir);
	while(($file = readdir($handle)) !== false)
	{
		if($file != "." && $file != "..")
		{
			is_dir("$dir/$file") ? del_dir("$dir/$file") : @unlink("$dir/$file");
		}
	}
	if(readdir($handle) == false)
	{
		closedir($handle);
		if($self)
		{
			@rmdir($dir);
		}
	}
}

/** 目录是否可写 */
function dir_writable($dir)
{
	if(!is_dir($dir))
	{
		mk_dir($dir, 0777);
	}
	if(is_dir($dir)) {
		if($fp = @fopen("$dir/test.txt", 'w'))
		{
			@fclose($fp);
			@unlink("$dir/test.txt");
			return true;
		}
	}
	return false;
}

/** 自动加载类 */
function __autoload($classname)
{
	/* 加载应用的Ctrlr类和Modl类 */
	if('Modl' == substr($classname, -4))
	{
		$classfile = LIB_MODL_PATH.D_S.$classname.'.class.php';
		require_cache($classfile);
	}
	elseif('Ctrlr' == substr($classname, -5))
	{
		$classfile = LIB_CTRLR_PATH.D_S.$classname.'.class.php';
		require_cache($classfile);
	}
	else
	{
		$include_path = get_include_path();
		$include_path .= P_S.PFA_EXT_PATH; /* PFA扩展类库目录 */
		$include_path .= P_S.PFA_VENDER_PATH; /* PFA第三方类库目录 */
		/* 根据自动加载路径设置尝试搜索 */
		if(C('APP_AUTOLOAD_PATH'))
		{
			$paths = str_replace(',', P_S, C('APP_AUTOLOAD_PATH'));
			$include_path .= P_S.$paths;
		}
		set_include_path($include_path);
		import($classname);
	}
	return;
}

/** 设置和获取统计 */
function N($key, $step = 0)
{
	static $_num = array();
	if(!isset($_num[$key]))
	{
		$_num[$key] = 0;
	}
	if(empty($step))
	{
		return $_num[$key];
	}
	else
	{
		$_num[$key] = $_num[$key] + (int)$step;
	}
}

/** 实例化Modl */
function M($name = '')
{
	static $_modl = array();
	if(empty($name))
	{
		return new Modl;
	}
	if(isset($_modl[$name]))
	{
		return $_modl[$name];
	}
	$OriClassName = $name;
	$className = $name.'Modl';
	if(class_exists($className))
	{
		$modl = new $className();
	}
	else
	{
		$modl = new Modl($name);
	}
	$_modl[$OriClassName] = $modl;
	return $modl;
}

/** 简单类型数据(字符串,数组)快速文件数据读取和保存 */
function F($name, $value = '', $path = DATA_PATH)
{
	static $_cache = array();
	$path = rtrim($path, "/\\").D_S;
	$filename = $path.$name.'.php';
	if('' !== $value)
	{
		if(is_null($value))
		{
			return @unlink($filename); /* 删除缓存 */
		}
		else
		{
			$dir = dirname($filename); /* 缓存数据 */
			if(!is_dir($dir))
			{
				mk_dir($dir); /* 目录不存在则创建 */
			}
			$_cache[$name] = $value;
			return file_put_contents($filename, strip_whitespace("<?php\nreturn ".var_export($value, true).";\n?>"));
		}
	}
	if(isset($_cache[$name]))
	{
		return $_cache[$name];
	}
	if(is_file($filename)) /* 获取缓存数据 */
	{
		$value = include $filename;
		$_cache[$name] = $value;
		return $value;
	}
	return false;
}

/** 全局缓存设置和读取 */
function S($name, $value = '', $expire = null, $options = null)
{
	$type = isset($options['cacheType']) ? $options['cacheType'] : '';
	static $_cache = array();
	$cache = Cache::connect($options);
	if ('' !== $value)
	{
		if(is_null($value)) /* 删除缓存 */
		{
			$result = $cache->del($name);
			if($result)
			{
				unset($_cache[$type.'_'.$name]);
			}
			return $result;
		}
		else /* 缓存数据 */
		{
			$cache->set($name, $value, $expire);
			$_cache[$type.'_'.$name] = $value;
		}
		return;
	}
	if(isset($_cache[$type.'_'.$name]))
	{
		return $_cache[$type.'_'.$name];
	}
	/* 获取缓存数据 */
	$value = $cache->get($name);
	$_cache[$type.'_'.$name] = $value;
	return $value;
}

/** 获取,定义语言(不区分大小写) */
function L($name = null, $value = null)
{
	static $_lang = array();
	if(empty($name)) /* 无参数时获取所有 */
	{
		return $_lang;
	}
	/* 获取或定义 */
	if(is_string($name))
	{
		$name = strtoupper($name);
		if(is_null($value))
		{
			return isset($_lang[$name]) ? $_lang[$name] : $name;
		}
		$_lang[$name] = $value; /* 语言定义 */
		return;
	}
	/* 批量定义 */
	if (is_array($name))
	{
		$_lang = array_merge($_lang, array_change_key_case($name, CASE_UPPER));
	}
	return;
}

/** 获取,定义配置 */
function C($name = null, $value = null)
{
	static $_config = array();
	if(empty($name)) /* 无参数时获取所有 */
	{
		return $_config;
	}
	/* 获取或定义 */
	if (is_string($name))
	{
		$name = strtolower($name);
		if (!strpos($name, '.'))
		{
			if (is_null($value))
			{
				return isset($_config[$name]) ? $_config[$name] : null;
			}
			$_config[$name] = is_array($value) ? array_change_key_case($value) : $value;
			return;
		}
		/* 二维数组 */
		$name = explode('.', $name);
		if (is_null($value))
		{
			return isset($_config[$name[0]][$name[1]]) ? $_config[$name[0]][$name[1]] : null;
		}
		$_config[$name[0]][$name[1]] = $value;
		return;
	}
	/* 批量设置 */
	if (is_array($name))
	{
		foreach ($name as $key => $val)
		{
			if(is_array($val))
			{
				$name[$key] = array_change_key_case($val);
			}
		}
		return $_config = array_merge($_config, array_change_key_case($name));
	}
	return null; /* 避免非法参数 */
}

/** URL组装 支持不同模式和路由 */
function U($url, $params = array(), $suffix = true)
{
	if(0 === strpos($url, '/'))
	{
		$url = substr($url, 1);
	}
	if(!strpos($url, '://')) /* 没有指定项目名 使用当前项目名 */
	{
		$url = APP_NAME.'://'.$url;
	}
	/* 分析URL地址 */
	$array = parse_url($url);
	$app = isset($array['scheme']) ? $array['scheme'] : APP_NAME;
	if(isset($array['path']))
	{
		$actn = substr($array['path'], 1);
		if(!isset($array['host']))
		{
			$ctrlr = CTRLR_NAME;
		}
		else
		{
			$ctrlr = $array['host'];
		}
	}
	else /* 只指定操作 */
	{
		$ctrlr = CTRLR_NAME;
		$actn = $array['host'];
	}
	if(isset($array['query']))
	{
		parse_str($array['query'], $query);
		$params = array_merge($query, $params);
	}
	if(C('URL_TYPE') > 1)
	{
		$depr = C('URL_PATHINFO_DEPR');
		$str = $depr;
		foreach($params as $var => $val)
		{
			$str .= $var.$depr.$val.$depr;
		}
		$str = substr($str, 0, -1);
		$ctrlr = isset($ctrlr) ? $ctrlr.$depr : "";
		$url = str_replace(APP_NAME, $app, strip_tags(PHP_FILE)).'/'.$ctrlr.$actn.$str;
		if($suffix && C('URL_HTML_SUFFIX'))
		{
			$url .= C('URL_HTML_SUFFIX');
		}
	}
	else /* 普通模式 */
	{
		$params = http_build_query($params);
		$params = !empty($params) ? '&' . $params : '';
		$url = str_replace(APP_NAME, $app, strip_tags(PHP_FILE)).'?'.C('VAR_CTRLR').'='.$ctrlr.'&'.C('VAR_ACTN').'='.$actn.$params;
	}
	return $url;
}

/** 优化require_once */
function require_cache($filename)
{
	static $_importFiles = array();
	$filename = realpath($filename);
	if(!isset($_importFiles[$filename]) && file_exists($filename))
	{
		return $_importFiles[$filename] = require $filename;
	}
}

/** 导入函数(文件名中包含'.'时用'#'替换) */
function load($name, $baseUrl = '', $ext = '.php')
{
	$name = str_replace(array('.', '#'), array('/', '.'), $name);
	if(empty($baseUrl))
	{
		$baseUrl = COMM_PATH; /* 加载应用公共目录 */
	}
	$baseUrl = rtrim($baseUrl, '/\\').D_S;
	require_cache($baseUrl.$name.$ext);
}

/** 导入类(文件名中包含'.'时用'#'替换) */
function import($class, $baseUrl = '', $ext='.class.php')
{
	static $_file = array();
	static $_class = array();
	$class = str_replace(array('.', '#'), array('/', '.'), $class);
	if(isset($_file[$class.$baseUrl]))
	{
		return true;
	}
	else
	{
		$_file[$class.$baseUrl] = true;
	}
	if(empty($baseUrl)) /* 默认导入set_include_path路径中的文件 */
	{
		$include_path = get_include_path();
		$paths = explode(P_S, $include_path);
		foreach($paths as $path)
		{
			$classfile = $path.D_S.$class.$ext;
			/* 区分文件名大小写 */
			if(basename(realpath($classfile)) == basename($classfile))
			{
				return require_cache($classfile);
			}
		}
	}
	if(substr($baseUrl, -1) != '/')
	{
		$baseUrl .= '/';
	}
	$classfile = $baseUrl.$class.$ext;
	if($ext == '.class.php' && is_file($classfile))
	{
		/* 类冲突检测 */
		$class = basename($classfile, $ext);
		if(isset($_class[$class]))
		{
			halt(L('_CLASS_CONFLICT_').' : '.$_class[$class].' '.$classfile);
		}
		$_class[$class] = $classfile;
	}
	return require_cache($classfile);
}

/** 取得对象实例 */
function get_instance($class, $classAargs = array(), $method = '', $methodArgs = array())
{
	static $_instance = array();
	$identify = empty($classAargs) ? $class : $class.get_guid_string($classAargs);
	if(!isset($_instance[$identify]))
	{
		if(class_exists($class))
		{
			$o = new $class($classAargs);
			if(method_exists($o, $method))
			{
				if(!empty($args))
				{
					$_instance[$identify] = call_user_func_array(array(&$o, $method), $methodArgs);
				}
				else
				{
					$_instance[$identify] = $o->$method();
				}
			}
			else
			{
				if('' == $method)
				{
					$_instance[$identify] = $o;
				}
				else
				{
					halt(L('_METHOD_NOT_EXIST_').' : '.$method);
				}
			}
		}
		else
		{
			halt(L('_CLASS_NOT_EXIST_').' : '.$class);
		}
	}
	return $_instance[$identify];
}

/** 从各类型变量生成唯一标识号 */
function get_guid_string($mix)
{
	if(is_object($mix) && function_exists('spl_object_hash'))
	{
		return spl_object_hash($mix);
	}
	elseif(is_resource($mix))
	{
		$mix = get_resource_type($mix).strval($mix);
	}
	else
	{
		$mix = serialize($mix);
	}
	return md5($mix);
}

/** 去除代码中的空白和注释 */
function strip_whitespace($content)
{
	$stripStr = '';
	$tokens = token_get_all($content); /* 分析php源码 */
	$last_space = false;
	for($i = 0, $j = count($tokens); $i < $j; $i++)
	{
		if(is_string($tokens[$i]))
		{
			$last_space = false;
			$stripStr .= $tokens[$i];
		}
		else
		{
			switch($tokens[$i][0])
			{
				/* 过滤各种PHP注释 */
				case T_COMMENT:
				case T_DOC_COMMENT:
					break;
				/* 过滤多个空格 */
				case T_WHITESPACE:
					if(!$last_space)
					{
						$stripStr .= ' ';
						$last_space = true;
					}
					break;
				case T_START_HEREDOC:
					$stripStr .= "<<<PFA\n";
					break;
				case T_END_HEREDOC:
					$stripStr .= "PFA;\n";
					for($k = $i+1; $k < $j; $k++)
					{
						if(is_string($tokens[$k]) && $tokens[$k] == ";")
						{
							$i = $k;
							break;
						}
						else if($tokens[$k][0] == T_CLOSE_TAG)
						{
							break;
						}
					}
					break;
				default:
					$last_space = false;
					$stripStr .= $tokens[$i][1];
			}
		}
	}
	return $stripStr;
}

//[RUNTIME]
/** 编译文件 */
function compile($filename)
{
	$content = file_get_contents($filename);
	/* 替换预编译指令 */
	$content = preg_replace('/\/\/\[RUNTIME\](.*?)\/\/\[\/RUNTIME\]/s', '', $content);
	$content = substr(trim($content), 5);
	if('?>' == substr($content, -2))
	{
		$content = substr($content, 0, -2);
	}
	return $content;
}

/** 根据数组生成常量定义 */
function array_define($array)
{
	$content = '';
	foreach ($array as $key => $val)
	{
		$key = strtoupper($key);
		$content .= 'if(!defined(\''.$key.'\')) ';
		if(is_int($val) || is_float($val))
		{
			$content .= "define('".$key."',".$val. ");";
		}
		elseif(is_bool($val))
		{
			$val = ($val) ? 'true' : 'false';
			$content .= "define('".$key."',".$val.");";
		}
		elseif(is_string($val))
		{
			$content .= "define('".$key."','".addslashes($val)."');";
		}
	}
	return $content;
}
//[/RUNTIME]

/** 命名风格转换 0:AaaBbb -> aaa_bbb, 1:aaa_bbb -> AaaBbb */
function parse_name($name, $type = 0)
{
	if($type)
	{
		return ucfirst(preg_replace("/_([a-zA-Z])/e", "strtoupper('\\1')", $name));
	}
	else
	{
		$name = preg_replace("/[A-Z]/", "_\\0", $name);
		return strtolower(trim($name, "_"));
	}
}

/** 友好变量输出 */
function dump($var, $echo = true, $label = null, $strict = true)
{
	$label = ($label === null) ? '' : rtrim($label).' ';
	if(!$strict)
	{
		if(ini_get('html_errors'))
		{
			$output = print_r($var, true);
			$output = "\n<pre>\n".$label.htmlspecialchars($output, ENT_QUOTES)."</pre>\n";
		}
		else
		{
			$output = $label.print_r($var, true);
		}
	}
	else
	{
		ob_start();
		var_dump($var);
		$output = ob_get_clean();
		if(!extension_loaded('xdebug'))
		{
			$output = preg_replace("/\]\=\>\n(\s+)/m", "] => ", $output);
			$output = "\n<pre>\n".$label.htmlspecialchars($output, ENT_QUOTES)."</pre>\n";
		}
	}
	if($echo)
	{
		echo($output);
		return null;
	}
	return $output;
}

/** 格式化显示变量内容 */
function P()
{
	$args=func_get_args(); /* 获取多个参数 */
	if(count($args) < 1)
	{
		echo "<font color='red'>P() must have at least one arg!</font>";
		return;
	}
	echo "<div><pre>\n";
	foreach($args as $arg)
	{
		if(is_array($arg))
		{
			print_r($arg);
		}
		elseif(is_string($arg))
		{
			echo $arg."<br />\n";
		}
		else
		{
			var_dump($arg);
		}
	}
	echo "</pre></div>\n\n";
}

/** 数组转为字符串 $level:解析深度 */
function array_to_string($array, $glue = ', ', $level = 1)
{
	if(!is_array($array) || empty($array))
	{
		return '';
	}
	$string = '';
	foreach($array as $k => $v)
	{
		if(0 != $level)
		{
			if(is_array($v))
			{
				$string .= 'array(';
				$string .= array_to_string($v, $glue, $level - 1).$glue;
				$string = rtrim($string, $glue).')'.$glue;
			}
			else
			{
				$string .= $v.$glue;
			}
		}
	}
	$string = rtrim($string, $glue);
	return $string;
}

/** 错误终止输出 */
function halt($error)
{
	if(IS_CLI)
	{
		exit($error);
	}
	if(C('APP_DEBUG'))
	{
		if(!is_array($error))
		{
			$e = array();
			$traceInfo = '';
			$trace = debug_backtrace();
			$e['message'] = $error;
			$e['file'] = $trace[0]['file'];
			$e['class'] = isset($trace[0]['class']) ? $trace[0]['class'] : '';
			$e['function'] = isset($trace[0]['function']) ? $trace[0]['function'] : '';
			$e['line'] = $trace[0]['line'];
			$time = date('c');
			foreach ($trace as $t)
			{
				$traceInfo .= '['.$time.'] '.$t['file'].' ('.$t['line'].') ';
				$traceInfo .= isset($t['class']) ? $t['class'] : '';
				$traceInfo .= isset($t['type']) ? $t['type'] : '';
				$traceInfo .= $t['function'].'('.array_to_string($t['args']);
				$traceInfo .=")<br/>";
			}
			$e['trace'] = $traceInfo;
		}
		else
		{
			$e = $error;
		}

		if(ob_get_length())
		{
			ob_clean();
		}
		include C('TPL_DEBUG_ERR');
		exit;
	}
	else
	{
		if(file_exists(C('TPL_ERR')))
		{
			if(ob_get_length())
			{
				ob_clean();
			}
			include C('TPL_ERR');
			exit;
		}
		else
		{
			exit($error);
		}
	}
}

/** URL重定向 */
function redirect($url, $time = 0, $msg = '')
{
	$url = str_replace(array("\n", "\r"), '', $url); /* 多行URL地址支持 */
	if(empty($msg))
	{
		$msg = "系统将在 {$time} 秒之后自动跳转到 {$url} !";
	}
	if(!headers_sent())
	{
		if(0 === $time)
		{
			header("Location: ".$url);
		}
		else
		{
			header("refresh: {$time}; url = {$url}");
			echo($msg);
		}
		exit();
	}
	else
	{
		$str = "<meta http-equiv='Refresh' content='{$time}; URL={$url}'>";
		if(0 != $time)
		{
			$str .= $msg;
		}
		exit($str);
	}
}

/** Cookie 设置 获取 清除
 * 1 设置: cookie('name', 'value') | cookie('name', 'value', 3600)
 * 2 获取: cookie('name')
 * 3 删除: cookie('name', null) | cookie(null) | cookie(null, 'pfa_')
 * 数组形式$options: cookie('name','value',array('expire'=>1,'prefix'=>'pfa_'))
 * query形式$options: cookie('name','value','prefix=pfa_&expire=10000')
 */
function cookie($name, $value = '', $options = null)
{
	$config = array(
		'prefix' => C('COOKIE_PREFIX'),
		'expire' => C('COOKIE_EXPIRE'),
		'path' => C('COOKIE_PATH'),
		'domain' => C('COOKIE_DOMAIN'),
	);
	/* 参数设置(会覆盖黙认设置) */
	if(!empty($options))
	{
		if(is_numeric($options))
		{
			$options = array('expire' => $options);
		}
		elseif(is_string($options))
		{
			parse_str($options, $options);
		}
		$config = array_merge($config, array_change_key_case($options));
	}
	/* 清除指定前缀的所有cookie */
	if(is_null($name))
	{
		if(empty($_COOKIE))
		{
			return;
		}
		$prefix = empty($value) ? $config['prefix'] : $value;
		if(!empty($prefix)) /* 前缀为空将不作处理 */
		{
			foreach ($_COOKIE as $key => $val)
			{
				if (0 === stripos($key, $prefix))
				{
					setcookie($key, '', time() - 3600, $config['path'], $config['domain']);
					unset($_COOKIE[$key]);
				}
			}
		}
		return;
	}
	$name = $config['prefix'] . $name;
	if ('' === $value)
	{
		return isset($_COOKIE[$name]) ? $_COOKIE[$name] : null; /* 获取指定Cookie */
	}
	else
	{
		if (is_null($value))
		{
			setcookie($name, '', time() - 3600, $config['path'], $config['domain']);
			unset($_COOKIE[$name]); /* 删除指定cookie */
		}
		else
		{
			/* 设置cookie */
			$expire = !empty($config['expire']) ? time() + intval($config['expire']) : 0;
			setcookie($name, $value, $expire, $config['path'], $config['domain']);
			$_COOKIE[$name] = $value;
		}
	}
}

/** 检查时间间隔 记录时间interval($name), 检查间隔interval($name, $inerval) */
function interval($name = '', $interval = '')
{
	if(!isset($_SESSION))
	{
		session_start();
	}
	$name = empty($name) ? C('INTERVAL_NAME') : $name;

	/* interval为空, 记录当前时间 */
	if(empty($interval))
	{
		return $_SESSION[$name] = time();
	}
	/* 检查时间间隔 */
	if(!isset($_SESSION[$name]))
	{
		$_SESSION[$name] = time();
	}
	elseif((time() - $_SESSION[$name]) < $interval)
	{
		return false;
	}
	return true;
}

/** 字节格式化为 B KB MB GB TB */
function byte_format($size, $dec=2)
{
	$a = array("B", "KB", "MB", "GB", "TB", "PB");
	$pos = 0;
	while ($size >= 1024)
	{
		$size /= 1024;
		$pos++;
	}
	return round($size, $dec)." ".$a[$pos];
}

/** 获取客户端IP地址 */
function get_ip()
{
	$ip=false;
	if(!empty($_SERVER['HTTP_CLIENT_IP']))
	{
		$ip = $_SERVER['HTTP_CLIENT_IP'];
	}
	if(!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
	{
		$ips = explode (',', $_SERVER['HTTP_X_FORWARDED_FOR']);
		if($ip)
		{
			array_unshift($ips, $ip);
			$ip = FALSE;
		}
		for($i = 0; $i < count($ips); $i++)
		{
			if(!preg_match("^(10|172\.16|192\.168)\.", $ips[$i]))
			{
				$ip = $ips[$i];
				break;
			}
		}
	}
	$ip = $ip ? $ip : $_SERVER['REMOTE_ADDR'];
	preg_match("/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/", $ip) or $ip = 'unknown';
	return $ip;
}

/** 发送http状态 */
function send_http_status($code)
{
	static $_status = array(
		200 => 'OK', /** Success 2xx */
		/* Redirection 3xx */
		301 => 'Moved Permanently',
		302 => 'Moved Temporarily ',  /* 1.1 */
		/* Client Error 4xx */
		400 => 'Bad Request',
		403 => 'Forbidden',
		404 => 'Not Found',
		/* Server Error 5xx */
		500 => 'Internal Server Error',
		503 => 'Service Unavailable',
	);
	if(isset($_status[$code]))
	{
		header('HTTP/1.1 '.$code.' '.$_status[$code]);
		header('Status:'.$code.' '.$_status[$code]); /* 确保FastCGI模式下正常 */
	}
}

/** 隐藏ip后两位 */
function hide_ip($ip)
{
	$pattern = "/^(\d{1,3})\.(\d{1,3})\.(\d{1,3})\.(\d{1,3})$/i";
	$replacement = "\$1.\$2.*.*";
	$ip = preg_replace($pattern, $replacement, $ip);
	return $ip;
}

/** human treat dateline */
function get_dateStr($dateline)
{
	$timeDif = intval(time() - $dateline);
	$now = getdate();
	$todayPassTime = $now['seconds'] + $now['minutes'] * 60 + $now['hours'] * 60 * 60;

	if ($timeDif < 0)
	{
		return L('IN_THE_FUTURE');
	}
	elseif ($timeDif < 60)
	{
		$timeDif = $timeDif == 0 ? 1 : $timeDif;
		return $timeDif.L('SECOND_AGO');
	}
	elseif ($timeDif < 3600)
	{
		$timeDif = intval($timeDif / 60);
		return $timeDif.L('MINUTE_AGO');
	}
	elseif ($timeDif < $todayPassTime)
	{
		$timeDif = intval($timeDif / 3600);
		return $timeDif.L('HOUR_AGO');
	}
	elseif ($timeDif < $todayPassTime + 3600 * 24)
	{
		return L('YESTERDAY').date(' H:i:s', $dateline);
	}
	elseif ($timeDif < 3600 * 24 * 7)
	{
		$timeDif = intval($timeDif / 3600 / 24);
		return $timeDif.L('DAY_AGO');
	}
	return date('Y-m-d H:i:s', $dateline);
}

function date_to_timestamp($date)
{
	//$date format 2011-11-11 11:11:11
	$Y = (int)substr($date, 0, 4);
	$m = (int)substr($date, 5, 2);
	$d = (int)substr($date, 8, 2);
	$H = (int)substr($date, 11, 2);
	$i = (int)substr($date, 14, 2);
	$s = (int)substr($date, 17, 2);
	return mktime($H, $i, $s, $m, $d, $Y);
}

/** 截取字符 */
function msubstr($str, $start = 0, $length, $charset = "utf-8", $suffix = false)
{
	if(function_exists("mb_substr"))
	{
		if($suffix && strlen($str) > $length)
		{
			return mb_substr($str, $start, $length, $charset)."...";
		}
		else
		{
			return mb_substr($str, $start, $length, $charset);
		}
	}
	elseif(function_exists('iconv_substr'))
	{
		if ($suffix && strlen($str) > $length)
		{
			return iconv_substr($str, $start, $length, $charset)."...";
		}
		else
		{
			return iconv_substr($str, $start, $length, $charset);
		}
	}
	$re['utf-8'] = "/[\x01-\x7f]|[\xc2-\xdf][\x80-\xbf]|[\xe0-\xef][\x80-\xbf]{2}|[\xf0-\xff][\x80-\xbf]{3}/";
	$re['gb2312'] = "/[\x01-\x7f]|[\xb0-\xf7][\xa0-\xfe]/";
	$re['gbk'] = "/[\x01-\x7f]|[\x81-\xfe][\x40-\xfe]/";
	$re['big5'] = "/[\x01-\x7f]|[\x81-\xfe]([\x40-\x7e]|\xa1-\xfe])/";
	preg_match_all($re[$charset], $str, $match);
	$slice = join("", array_slice($match[0], $start, $length));
	if($suffix)
	{
		return $slice."…";
	}
	return $slice;
}

/** 获取字符长度 */
function mstrlen($string, $charset = 'UTF-8')
{
	if(function_exists('mb_strlen'))
	{
		return mb_strlen($string, $charset);
	}
	elseif(function_exists('iconv_strlen'))
	{
		return iconv_strlen($string, $charset);
	}
	return 0;
}

/** 自动转换字符集 支持数组转换 */
function auto_charset($fContents, $from = 'gbk', $to = 'utf-8')
{
	$from = strtoupper($from) == 'UTF8' ? 'utf-8' : $from;
	$to = strtoupper($to) == 'UTF8' ? 'utf-8' : $to;
	if(strtoupper($from) === strtoupper($to) || empty($fContents) || (is_scalar($fContents) && !is_string($fContents)))
	{
		return $fContents; /* 如果编码相同或者非字符串标量则不转换 */
	}
	if (is_string($fContents))
	{
		if (function_exists('mb_convert_encoding'))
		{
			return mb_convert_encoding($fContents, $to, $from);
		}
		elseif (function_exists('iconv'))
		{
			return iconv($from, $to, $fContents);
		}
		else
		{
			return $fContents;
		}
	}
	elseif(is_array($fContents))
	{
		foreach($fContents as $key => $val)
		{
			$_key = auto_charset($key, $from, $to);
			$fContents[$_key] = auto_charset($val, $from, $to);
			if ($key != $_key)
			{
				unset($fContents[$key]);
			}
		}
		return $fContents;
	}
	else
	{
		return $fContents;
	}
}

?>