<?php
/**
 *--------------------------------------------------
 * runtime
 *--------------------------------------------------
 * @program     : PFA
 * @create      : 2012-2-29 15:54:26
 * @description :
 */

if(!defined('PFA_PATH')) exit();

/* 检查应用目录 */
if(!is_dir(RUNTIME_PATH))
{
	/* 部署应用目录 */
	build_app_dir();
}
else
{
	/* 检查缓存目录 */
	check_runtime_dir();
}

/** 部署应用目录 */
function build_app_dir()
{
	if(!is_dir(APP_PATH)) mk_dir(APP_PATH, 0777);
	if(!is_writeable(APP_PATH))
	{
		halt(L('_DIR_READONLY_').': '.APP_PATH);
	}
	$dirs = array(
		HTML_PATH,
		CFG_PATH,
		COMM_PATH,
		LIB_PATH,
		LIB_CTRLR_PATH,
		LIB_MODL_PATH,
		LANG_PATH,
		TPL_PATH,
		TPL_PATH.D_S.C('TE_TPL_THEME'),
		RUNTIME_PATH,
		CACHE_PATH,
		LOG_PATH,
		TEMP_PATH,
		DATA_PATH);
	mkdirs($dirs);

	/* 目录安全 */
	if(C('DIR_INDEX'))
	{
		$content = C('DIR_INDEX_CONTENT');
		foreach ($dirs as $dir)
		{
			file_put_contents($dir.C('DIR_INDEX_FILENAME'), $content);
		}
	}
	/* 创建默认公共配置 */
	if(!is_file(CFG_PATH.'/comm.php'))
	{
		copy(PFA_PATH.'/tpl/cfg/comm.php', CFG_PATH.'/comm.php');
	}
	/* 创建默认路由规则 */
	if(!is_file(CFG_PATH.'/routes.php'))
	{
		copy(PFA_PATH.'/tpl/cfg/routes.php', CFG_PATH.'/routes.php');
	}
	/* 创建默认静态规则 */
	if(!is_file(CFG_PATH.'/htmls.php'))
	{
		copy(PFA_PATH.'/tpl/cfg/htmls.php', CFG_PATH.'/htmls.php');
	}
	/* 创建默认控制器 */
	if(!is_file(LIB_CTRLR_PATH.D_S.C('DEFAULT_CTRLR').'.class.php'))
	{
		build_first_ctrlr();
	}
}

/** 检查缓存目录 */
function check_runtime_dir()
{
	if(!is_writeable(RUNTIME_PATH))
	{
		halt(L('_DIR_READONLY_').': '.RUNTIME_PATH);
	}
	if(!is_dir(CACHE_PATH)) mk_dir(CACHE_PATH);
	if(!is_dir(LOG_PATH)) mk_dir(LOG_PATH);
	if(!is_dir(TEMP_PATH)) mk_dir(TEMP_PATH);
	if(!is_dir(DATA_PATH)) mk_dir(DATA_PATH);
	return true;
}

/** 创建默认控制器 */
function build_first_ctrlr()
{
	$defaultCtrlr = ucwords(strtolower(C('DEFAULT_CTRLR')))."Ctrlr";
	$content = file_get_contents(PFA_PATH.'/tpl/IndexCtrlr.tpl.php');
	$content = str_replace('IndexCtrlr', $defaultCtrlr, $content);
	$content = str_replace('index', C('DEFAULT_ACTN'), $content);
	file_put_contents(LIB_CTRLR_PATH.D_S.$defaultCtrlr.'.class.php', $content);
	$content = file_get_contents(PFA_PATH.'/tpl/index_ctrlr.html');
	file_put_contents(TPL_PATH.D_S.C('DEFAULT_TPL').C('TE_TPL_THEME').'/index.php', $content);
}

/** 创建编译缓存 */
function build_runtime_cache($append = '')
{
	/* 读取框架核心文件列表 */
	$list = include PFA_PATH.'/comm/core.php';
	/* 加载框架函数库 */
	$list[] = PFA_PATH.'/comm/func.php';
	/* 生成编译文件 */
	$defs = get_defined_constants(TRUE);
	$content = array_define($defs['user']);
	foreach ($list as $file)
	{
		$content .= compile($file);
	}
	$content .= $append."\nC(".var_export(C(),true).');';
	$runtime = '~runtime.php';
	file_put_contents(RUNTIME_PATH.D_S.$runtime, strip_whitespace('<?php '.$content));
}

?>