<?php
/**
 *--------------------------------------------------
 * PFA 应用基类
 *--------------------------------------------------
 * @program     : PFA
 * @create      : 2012-3-18 22:16:38
 * @description :
 */

class App extends Pfa
{
	/** 开始运行 */
	public function run()
	{
		set_error_handler(array('App', 'app_error'));
		//[RUNTIME]
		App::build(); /* 预编译应用 */
		//[/RUNTIME]
		Disp::dispatch(); /* URL调度并定义CTRLR_NAME和ACTN_NAME等 */
		self::load_lang(); /* 加载应用语言 */
		self::check_theme(); /* 检测并定义模板变量 */
		if(C('HTML_CACHE'))
		{
			header('Content-Type:'.C('TE_TPL_CONTENT_TYPE').'; charset='.C('DEFAULT_CHARSET')); /* 指定字符集 */
			header('Cache-control: private'); /*支持页面回跳 */
			header('X-Powered-By: Pfa');
			HtmlCache::read_htmlCache(); /* 开启静态缓存 */
		}

		date_default_timezone_set(C('DEFAULT_TIMEZONE')); /* 设置时区 */

		G('initTime'); /* 记录初始化时间 */
		$instance = get_instance(CTRLR_NAME.'Ctrlr', '', ACTN_NAME); /* 创建控制器实例 */
		G('execTime'); /* 记录初始化时间 */
	}

	//[RUNTIME]
	/** 读取配置 编译应用 */
	private static function build()
	{
		/* 加载应用公共文件 */
		$common = '';
		if(is_file(COMM_PATH.'/func.comm.php'))
		{
			include COMM_PATH.'/func.comm.php'; /* 加载应用公共函数 */
			if(!C('APP_DEBUG'))
			{
				$common .= compile(COMM_PATH.'/func.comm.php'); /* 编译文件 */
			}
		}
		/* 加载应用常量定义 */
		require_cache(CFG_PATH.'/defines.php');
		/* 加载应用公共设置 */
		C(require_cache(CFG_PATH.'/comm.php'));
		/* 加载动态配置文件 */
		$configs = C('APP_CFG_LIST');
		if(is_string($configs))
		{
			//echo $configs;
			$configs = explode(',', $configs);
			foreach($configs as $config)
			{
				$file = CFG_PATH.D_S.$config.'.php';
				if(is_file($file))
				{
					C($config, array_change_key_case(include $file));
				}
			}
		}
		C('APP_CFG_LIST',''); /* 清除配置参数 */

		/* 编译应用 */
		if(!C('APP_DEBUG'))
		{
			build_runtime_cache($common);
		}
	}
	//[/RUNTIME]

	/** 语言文件加载 */
	private static function load_lang()
	{
		$langSet = C('DEFAULT_LANG');
		if(C('LANG_DETECT'))
		{
			if(isset($_GET[C('VAR_LANG')]))
			{
				$langSet = $_GET[C('VAR_LANG')];
				cookie('pfa_lang', strtolower($langSet), 3600);
			}
			elseif(cookie('pfa_lang'))
			{
				$langSet = cookie('pfa_lang');
			}
			elseif(isset($_SERVER['HTTP_ACCEPT_LANGUAGE']))
			{
				preg_match('/^([a-z\-]+)/i', $_SERVER['HTTP_ACCEPT_LANGUAGE'], $matches);
				$langSet = $matches[1];
				cookie('pfa_lang', strtolower($langSet), 3600);
			}
		}
		define('LANG_SET', strtolower($langSet));
		/* 加载框架默认语言 */
		if(is_file(PFA_PATH.'/lang/'.C('DEFAULT_LANG').'.lang.php'))
		{
			L(include PFA_PATH.'/lang/'.C('DEFAULT_LANG').'.lang.php');
		}
		/* 读取应用公共语言包 */
		if(is_file(LANG_PATH.D_S.LANG_SET.'/comm.lang.php'))
		{
			L(include LANG_PATH.D_S.LANG_SET.'/comm.lang.php');
		}
		elseif(is_file(LANG_PATH.D_S.C('DEFAULT_LANG').'/comm.lang.php'))
		{
			L(include LANG_PATH.D_S.C('DEFAULT_LANG').'/comm.lang.php');
		}
		/* 读取控制器语言包 */
		if(is_file(LANG_PATH.D_S.LANG_SET.D_S.strtolower(CTRLR_NAME).'.lang.php'))
		{
			L(include LANG_PATH.D_S.LANG_SET.D_S.strtolower(CTRLR_NAME).'.lang.php');
		}
		elseif(is_file(LANG_PATH.D_S.C('DEFAULT_LANG').D_S.strtolower(CTRLR_NAME).'.lang.php'))
		{
			L(include LANG_PATH.D_S.C('DEFAULT_LANG').D_S.strtolower(CTRLR_NAME).'.lang.php');
		}
	}

	/** 设置模板主题 */
	private static function check_theme()
	{
		$tplSet = C('TE_TPL_THEME');
		if(C('TE_DETECT_THEME')) /* 侦测模板主题 */
		{
			$t = C('VAR_TPL');
			if(isset($_GET[$t]))
			{
				$tplSet = $_GET[$t];
			}
			elseif(cookie('pfa_theme'))
			{
				$tplSet = cookie('pfa_theme');
			}
			if(!is_dir(TPL_PATH.D_S.$tplSet)) /* 主题不存在时使用默认主题 */
			{
				$tplSet = C('TE_TPL_THEME');
			}
			cookie('pfa_theme', $tplSet);
		}
		/* 模板相关目录常量 */
		C('TE_TPL_THEME', $tplSet); /* 当前主题名称 */
		define('THEME_NAME', $tplSet); /* 当前主题名称 */
		define('THEME_PATH', TPL_PATH.(THEME_NAME ? D_S.THEME_NAME : '')); /* 当前主题路径 */
		define('__THEME__', __APP__.'/'.TPL_DIR.'/'.(THEME_NAME ? THEME_NAME : '')); /* 当前应用模板主题 URL */
		if(APP_PATH != dirname(PFA_PATH))
		{
			define('__PUBLIC__', __ROOT__.'/'.PUBLIC_DIR); /* 网站公共文件URL */
		}
		else
		{
			define('__PUBLIC__', __APP__.'/'.PUBLIC_DIR); /* 实用应用公共文件URL */
		}
		C('TPL_FILE_NAME', THEME_PATH.D_S.CTRLR_NAME.D_S.ACTN_NAME.C('TE_TPL_SUFFIX'));
		return;
	}

	/** 自定义错误处理 */
	public static function app_error($errno, $errstr, $errfile, $errline)
	{
		$errno = $errno & error_reporting();
		if(!defined('E_STRICT')) define('E_STRICT', 2048);
		if(!defined('E_RECOVERABLE_ERROR')) define('E_RECOVERABLE_ERROR', 4096);
		switch($errno)
		{
			case E_ERROR:
			case E_WARNING:
			case E_PARSE:
			case E_NOTICE:
			case E_CORE_ERROR:
			case E_CORE_WARNING:
			case E_COMPILE_ERROR:
			case E_COMPILE_WARNING:
			case E_USER_ERROR:
				$errorStr = "[{$errno}]{$errstr} ".basename($errfile)."({$errline})";
				Log::record($errorStr);
				halt($errorStr);
				break;
			case E_USER_WARNING:
			case E_USER_NOTICE:
			case E_STRICT:
			case E_RECOVERABLE_ERROR:
			default:
				$errorStr = "[{$errno}]{$errstr} ".basename($errfile)."({$errline})";
				Log::record($errorStr);
				break;
		}
	}

	/** 保存日志 */
	public function __destruct()
	{
		if(C('LOG_RECORD'))
		{
			Log::save();
		}
	}

}

?>