<?php
/**
 *--------------------------------------------------
 * PFA URL解析 路由 调度
 *--------------------------------------------------
 * @program     : PFA
 * @create      : 2012-3-10 14:37:30
 * @description :
 */

class Disp extends Pfa
{
	/** URL映射到控制器 */
	public static function dispatch()
	{
		/* PHP_FILE 当前应用完整地址 */
		$urlType = C('URL_TYPE');
		if($urlType == URL_REWRITE)
		{
			$url = dirname(_PHP_FILE_);
			if($url == '/' || $url == '\\')
			{
				$url = '';
			}
			define('PHP_FILE', $url);
		}
		elseif($urlType == URL_COMPAT)
		{
			define('PHP_FILE', _PHP_FILE_.'?'.C('VAR_PATHINFO').'=');
		}
		else
		{
			define('PHP_FILE', _PHP_FILE_);
		}

		$depr = C('URL_PATHINFO_DEPR');

		self::get_pathInfo(); /* 分析PATHINFO信息 */
		if(!self::router_check())
		{
			self::router(); /* 默认URL调度 */
		}

		/* 定义常量 */
		define('CTRLR_NAME', self::get_ctrlr(C('VAR_CTRLR')));
		define('ACTN_NAME', self::get_actn(C('VAR_ACTN')));
		/* 当前应用主机名 */
		define('__HOST__', 'http://'.get_env('HTTP_HOST'));
		/* 网站根地址 */
		define('__ROOT__', __HOST__.ROOT);
		/* 当前应用入口地址 */
		define('__APP__', __HOST__.APP_ROOT);
		/* 当前控制器地址 */
		$ctrlr = defined('P_CTRLR_NAME') ? P_CTRLR_NAME : CTRLR_NAME;
		define('__CTRLR__', __APP__.'/'.$ctrlr);
		/* 当前操作地址 */
		define('__ACTN__', __CTRLR__.$depr.ACTN_NAME);
		$_REQUEST = array_merge($_POST, $_GET); /* 保证$_REQUEST正常取值 */
	}

	/** 获得服务器的PATH_INFO信息 */
	private static function get_pathInfo()
	{
		if(!empty($_GET[C('VAR_PATHINFO')]))
		{
			$path = $_GET[C('VAR_PATHINFO')]; /* 兼容 PATHINFO 参数 */
			unset($_GET[C('VAR_PATHINFO')]);
		}
		elseif(!empty($_SERVER['PATH_INFO']))
		{
			$pathInfo = $_SERVER['PATH_INFO'];
			if(0 === strpos($pathInfo, $_SERVER['SCRIPT_NAME']))
			{
				$path = substr($pathInfo, strlen($_SERVER['SCRIPT_NAME']));
			}
			else
			{
				$path = $pathInfo;
			}
		}
		elseif(!empty($_SERVER['ORIG_PATH_INFO']))
		{
			$pathInfo = $_SERVER['ORIG_PATH_INFO'];
			if(0 === strpos($pathInfo, $_SERVER['SCRIPT_NAME']))
			{
				$path = substr($pathInfo, strlen($_SERVER['SCRIPT_NAME']));
			}
			else
			{
				$path = $pathInfo;
			}
		}
		elseif (!empty($_SERVER['REDIRECT_PATH_INFO']))
		{
			$path = $_SERVER['REDIRECT_PATH_INFO'];
		}
		elseif(!empty($_SERVER["REDIRECT_URL"]))
		{
			$path = $_SERVER["REDIRECT_URL"];
			if(empty($_SERVER['QUERY_STRING']) || $_SERVER['QUERY_STRING'] == $_SERVER["REDIRECT_QUERY_STRING"])
			{
				$parsedUrl = parse_url($_SERVER["REQUEST_URI"]);
				if(!empty($parsedUrl['query']))
				{
					$_SERVER['QUERY_STRING'] = $parsedUrl['query'];
					parse_str($parsedUrl['query'], $GET);
					$_GET = array_merge($_GET, $GET);
					reset($_GET);
				}
				else
				{
					unset($_SERVER['QUERY_STRING']);
				}
				reset($_SERVER);
			}
		}
		if(C('URL_HTML_SUFFIX') && !empty($path))
		{
			$path = preg_replace('/\.'.trim(C('URL_HTML_SUFFIX'), '.').'$/', '', $path);
		}
		$_SERVER['PATH_INFO'] = empty($path) ? '/' : $path;
	}

	/** 解析特殊URL调度检查 */
	private static function router_check()
	{
		$regx = trim($_SERVER['PATH_INFO'], '/');
		if(empty($regx))
		{
			return true; /* path_info为空则不处理 */
		}
		if(!C('URL_ROUTER'))
		{
			return false; /* 是否开启路由使用 */
		}
		/* 路由文件(routes.php)优先于cfg中的配置定义 */
		$routes = C('URL_ROUTE_RULES');
		if(is_array(C('routes')))
		{
			$routes = C('routes');
		}
		/* 路由处理 */
		if(!empty($routes))
		{
			$depr = C('URL_PATHINFO_DEPR');
			foreach($routes as $key => $route)
			{
				if(0 === stripos($regx.$depr, $route[0].$depr))
				{
					/* 简单: array('路由定义','控制器/操作名', '路由对应变量', '额外参数') */
					$var = self::parse_ca($route[1]);
					/* 获取当前路由参数对应的变量 */
					$paths = explode($depr, trim(str_ireplace($route[0].$depr, $depr, $regx), $depr));
					$vars = explode(',', $route[2]);
					for($i=0;$i<count($vars);$i++)
					{
						$var[$vars[$i]] = array_shift($paths);
					}
					/* 解析剩余URL参数 */
					$res = preg_replace('@(\w+)\/([^,\/]+)@e', '$var[\'\\1\']=\'\\2\';', implode('/', $paths));
					$_GET = array_merge($var, $_GET);
					if(isset($route[3]))
					{
						parse_str($route[3], $params);
						$_GET = array_merge($_GET, $params);
					}
					return true;
				}
				elseif(1 < substr_count($route[0], '/') && preg_match($route[0], $regx, $matches))
				{
					/* 正则: array('正则定义', '控制器/操作名', '路由对应变量', '额外参数') */
					$var = self::parse_ca($route[1]);
					/* 获取当前路由参数对应的变量 */
					$vars = explode(',', $route[2]);
					for($i = 0; $i < count($vars); $i++)
					{
						$var[$vars[$i]] = $matches[$i+1];
					}
					/* 解析剩余URL参数 */
					$res = preg_replace('@(\w+)\/([^,\/]+)@e', '$var[\'\\1\']=\'\\2\';', str_replace($matches[0], '', $regx));
					$_GET = array_merge($var, $_GET);
					if(isset($route[3]))
					{
						parse_str($route[3],$params);
						$_GET = array_merge($_GET,$params);
					}
					return true;
				}
			}
		}
		return false;
	}

	/** 默认URL调度 */
	private static function router()
	{
		$depr = C('URL_PATHINFO_DEPR');
		$paths = explode($depr, trim($_SERVER['PATH_INFO'],'/'));
		$var = array();
		if(!isset($_GET[C('VAR_CTRLR')])) /* 还没有定义模块名称 */
		{
			$var[C('VAR_CTRLR')] = array_shift($paths);
		}
		$var[C('VAR_ACTN')] = array_shift($paths);
		/* 解析剩余的URL参数 */
		$res = preg_replace('@(\w+)'.$depr.'([^'.$depr.'\/]+)@e', '$var[\'\\1\']=\'\\2\';', implode($depr, $paths));
		$_GET = array_merge($var, $_GET);
		return;
	}

	/** 获取控制器和操作名 */
	private static function parse_ca($route)
	{
		$array = explode('/', $route);
		$var = array();
		$var[C('VAR_ACTN')] = array_pop($array);
		$var[C('VAR_CTRLR')] = array_pop($array);
		return $var;
	}

	/** 获得控制器名称 */
	private static function get_ctrlr($var)
	{
		$ctrlr = (!empty($_GET[$var]) ? $_GET[$var] : C('DEFAULT_CTRLR'));
		unset($_GET[$var]);
		if(C('URL_CASE_IGNORE'))
		{
			/* index.php/aaa_bbb/index/ 识别到 AaaBbbCtrlr控制器 */
			define('P_CTRLR_NAME', strtolower($ctrlr));
			$ctrlr = ucfirst(parse_name(P_CTRLR_NAME, 1));
		}
		return strip_tags($ctrlr);
	}

	/** 获得操作名称 */
	private static function get_actn($var)
	{
		$actn = !empty($_POST[$var]) ?
			$_POST[$var] :
			(!empty($_GET[$var]) ? $_GET[$var] : C('DEFAULT_ACTN'));
		unset($_POST[$var], $_GET[$var]);
		if(C('URL_CASE_IGNORE'))
		{
			$actn = strtolower($actn);
		}
		return strip_tags($actn);
	}

	/** 私有化构造函数 */
	private function __construct(){}
}
?>