<?php
/**
 *--------------------------------------------------
 * PFA 缓存管理
 *--------------------------------------------------
 * @program     : PFA
 * @create      : 2012-3-11 13:55:39
 * @description :
 */

class Cache extends Pfa
{
	protected $handler; /* 操作句柄 */
	protected $connected; /* 是否连接 */
	protected $options = array(); /* 缓存连接参数 */

	/** 连接缓存 $type:缓存类型, $options:配置数组 */
	public static function connect($options = array())
	{
		if(!isset($options['cacheType']))
		{
			$options['cacheType'] = C('DATA_CACHE_TYPE');
		}
		$cacheClass = 'Cache'.ucwords(strtolower($options['cacheType']));
		import('lib.ext.cache.'.$cacheClass, PFA_PATH);
		$cache = get_instance($cacheClass, $options);
		return $cache;
	}

	public function __get($name)
	{
		return $this->get($name);
	}

	public function __set($name, $value)
	{
		return $this->set($name, $value);
	}

	public function __unset($name)
	{
		return $this->del($name);
	}

	public function set_option($name, $value)
	{
		$this->options[$name] = $value;
	}

	public function get_option($name)
	{
		return $this->options[$name];
	}
}
?>