<?php
/**
 *--------------------------------------------------
 * PFA 静态缓存
 *--------------------------------------------------
 * @program     : PFA
 * @create      : 2012-3-17 21:25:48
 * @description :
 */

class HtmlCache extends Pfa
{
	private static $cacheTime = null; /* 缓存有效期 */
	private static $requireCache = false; /* 是否需要缓存 */

	/* 判断是否需要静态缓存,并定义HTML_FILE_NAME */
	private static function require_htmlCache()
	{
		$htmls = C('htmls'); /* 读取静态规则 */
		if(!empty($htmls))
		{
			// 静态规则文件定义格式 actionName=>array('静态规则','缓存时间','附加规则')
			// 'read'=>array('{id},{name}',60,'md5') 必须保证静态规则的唯一性 和 可判断性
			// 检测静态规则
			$ctrlrName = strtolower(CTRLR_NAME);
			if(isset($htmls[$ctrlrName.':'.ACTN_NAME]))
			{
				$html = $htmls[$ctrlrName.':'.ACTN_NAME]; /* 某个控制器的操作的静态规则 */
			}
			elseif(isset($htmls[$ctrlrName.':']))
			{
				$html = $htmls[$ctrlrName.':']; /*某个控制器的静态规则 */
			}
			elseif(isset($htmls[ACTN_NAME]))
			{
				$html = $htmls[ACTN_NAME]; /* 所有操作的静态规则 */
			}
			elseif(isset($htmls['*']))
			{
				$html = $htmls['*']; /* 全局静态规则 */
			}
			if(!empty($html))
			{
				self::$requireCache = true; /* 需要缓存 */
				/* 解读静态规则 */
				$rule = $html[0];
				/* 以$_开头的系统变量 */
				$rule = preg_replace('/{\$(_\w+)\.(\w+)\|(\w+)}/e', "\\3(\$\\1['\\2'])", $rule);
				$rule = preg_replace('/{\$(_\w+)\.(\w+)}/e', "\$\\1['\\2']", $rule);
				/* {ID|FUN} GET变量的简写 */
				$rule = preg_replace('/{(\w+)\|(\w+)}/e', "\\2(\$_GET['\\1'])", $rule);
				$rule = preg_replace('/{(\w+)}/e', "\$_GET['\\1']", $rule);
				/* 特殊系统变量 */
				$rule = str_ireplace(
					array('{:app}', '{:ctrlr}', '{:actn}'),
					array(APP_NAME, CTRLR_NAME, ACTN_NAME),
					$rule);
				/* {|FUN} 单独使用函数 */
				$rule = preg_replace('/{\|(\w+)}/e', "\\1()", $rule);
				if(!empty($html[2]))
				{
					$rule = $html[2]($rule); /* 应用附加函数 */
				}
				self::$cacheTime = isset($html[1]) ? $html[1] : C('HTML_CACHE_TIME'); /* 设置缓存有效期 */
				define('HTML_FILE_NAME', HTML_PATH.D_S.$rule.C('HTML_FILE_SUFFIX')); /* 当前缓存文件 */
				return true;
			}
		}
		return false; /* 无需缓存 */
	}

	/** 读取静态缓存 */
	public static function read_htmlCache()
	{
		if(self::require_htmlCache() && self::check_htmlCache(HTML_FILE_NAME, self::$cacheTime))
		{ /* 需要读取且静态页面有效 */
			if(1 == C('HTML_READ_TYPE'))
			{
				/* 重定向到静态页面 */
				redirect(str_replace(
					array(realpath($_SERVER["DOCUMENT_ROOT"]), "\\"),
					array('',"/"),
					realpath(HTML_FILE_NAME)
					)
				);
			}
			else
			{
				/* 读取静态页面输出 */
				readfile(HTML_FILE_NAME);
				exit();
			}
		}
		return;
	}

	/** 写入静态缓存 */
	public static function write_htmlCache($content)
	{
		if(self::$requireCache)
		{
			if(!is_dir(dirname(HTML_FILE_NAME)))
			{
				mk_dir(dirname(HTML_FILE_NAME));
			}
			if(false === file_put_contents(HTML_FILE_NAME, $content))
			{
				halt(L('_CACHE_WRITE_ERROR_').':'.HTML_FILE_NAME);
			}
		}
		return;
	}

	/** 删除静态缓存 */
	public static function delete_htmlCache()
	{
		return @unlink(HTML_FILE_NAME);
	}

	/** 检查静态HTML文件是否有效 */
	public static function check_htmlCache($cacheFile = '', $cacheTime = '')
	{
		if(!is_file($cacheFile))
		{
			return false;
		}
		elseif(is_file(C('TPL_FILE_NAME')) && filemtime(C('TPL_FILE_NAME')) > filemtime($cacheFile))
		{
			return false; /* 检查模板文件是否更改 */
		}
		elseif($cacheTime != -1 && time() > filemtime($cacheFile) + $cacheTime)
		{
			return false; /* 文件是否在有效期 */
		}
		return true; /* 静态文件有效 */
	}
}
?>