<?php
/**
 *--------------------------------------------------
 * PFA 缓存到数据库
 *--------------------------------------------------
 * @program     : PFA
 * @create      : 2012-3-11 15:47:17
 * @description :
 */

/* 缓存表的结构
CREATE TABLE pfa_cache (
	cachekey varchar(255) NOT NULL,
	expire int(11) NOT NULL,
	data blob,
	datacrc int(32),
	UNIQUE KEY `cachekey` (`cachekey`)
);
*/

class CacheDb extends Cache
{
	private $db; /* 缓存数据库对象 */

	/** 构造函数 */
	function __construct($options = array())
	{
		$this->options = array (
			'db' => C('DB_NAME'),
			'table' => C('DATA_CACHE_TABLE'),
			'expire' => C('DATA_CACHE_TIME'),
			'length' => 0,
		);
		if(!empty($options))
		{
			$this->options = array_merge($this->options, $options);
		}
		$this->db = get_instance('Db');
		$this->connected = is_resource($this->db);
	}

	/** 是否连接 */
	private function is_connected()
	{
		return $this->connected;
	}

	/** 读取缓存 */
	public function get($name)
	{
		$name = addslashes($name);
		N('cache_read',1);
		$result = $this->db->query('SELECT `data`, `datacrc` FROM `'.$this->options['table'].'` WHERE `cachekey`=\''.$name.'\' AND (`expire` = 0 OR `expire` > '.time().') LIMIT 0, 1');
		if(false !== $result )
		{
			$result = $result[0];
			if(C('DATA_CACHE_CHECK')) /* 开启数据校验 */
			{
				if($result['datacrc'] != md5($result['data'])) /* 校验失败 */
				{
					return false;
				}
			}
			$content = $result['data'];
			if(C('DATA_CACHE_COMPRESS') && function_exists('gzcompress')) /* 解压数据 */
			{
				$content = gzuncompress($content);
			}
			$content = unserialize($content);
			return $content;
		}
		return false;
	}

	/** 写入缓存 */
	public function set($name, $value, $expire = null)
	{
		$data = serialize($value);
		$name = addslashes($name);
		N('cache_write',1);
		if( C('DATA_CACHE_COMPRESS') && function_exists('gzcompress')) /* 压缩数据 */
		{
			$data = gzcompress($data,3);
		}
		$crc = ''; /* 数据校验 */
		if(C('DATA_CACHE_CHECK'))
		{
			$crc = md5($data);
		}
		$expire = !empty($expire) ? $expire : $this->options['expire'];
		$expire = ($expire == 0) ? 0 : (time()+$expire);
		$result = $this->db->query('select `cachekey` from `'.$this->options['table'].'` where `cachekey`=\''.$name.'\' limit 0,1');
		if(!empty($result)) /* 更新记录 */
		{
			$result = $this->db->execute('UPDATE '.$this->options['table'].' SET `data` = \''.$data.'\', `datacrc` = \''.$crc.'\', `expire` = '.$expire.' WHERE `cachekey`=\''.$name.'\'');
		}
		else /* 新增记录 */
		{
			 $result = $this->db->execute('INSERT INTO '.$this->options['table'].' (`cachekey`, `data`, `datacrc`, `expire`) VALUES (\''.$name.'\',\''.$data.'\',\''.$crc.'\','.$expire.')');
		}
		if($result)
		{
			return true;
		}
		return false;
	}

	/** 删除缓存 */
	public function del($name)
	{
		$name = addslashes($name);
		return $this->db->execute('DELETE FROM `'.$this->options['table'].'` WHERE `cachekey`=\''.$name.'\'');
	}

	/** 清除缓存 */
	public function clear()
	{
		return $this->db->execute('TRUNCATE TABLE `'.$this->options['table'].'`');
	}
}
?>