<?php
/**
 *--------------------------------------------------
 * 框架公共文件
 *--------------------------------------------------
 * @program     : PFA
 * @create      : 2012-2-28 10:59:29
 * @description :
 */

G('beginTime');

define('MEMORY_ANALYSE', function_exists('memory_get_usage'));
if(MEMORY_ANALYSE)
{
	$GLOBALS['_startUseMems'] = memory_get_usage(); /* 记录内存初始使用 */
}

/* PHP版本检查 */
if(version_compare(PHP_VERSION, '5.2.0', '<')) die('require: PHP > 5.2!');

/* 定义路径 */
if(!defined('APP_NAME')) define('APP_NAME', basename(dirname($_SERVER['SCRIPT_FILENAME']))); /* 应用名称 */
if(!defined('APP_PATH')) define('APP_PATH', dirname($_SERVER['SCRIPT_FILENAME'])); /* 应用路径 */
if(!defined('PFA_PATH')) define('PFA_PATH', dirname(__FILE__)); /* PFA框架路径 */
if(!defined('RUNTIME_PATH')) define('RUNTIME_PATH',APP_PATH.DIRECTORY_SEPARATOR.'runtime'); /* runtime目录*/
$runtime = '~runtime.php';
if(is_file(RUNTIME_PATH.DIRECTORY_SEPARATOR.$runtime))
{
	require RUNTIME_PATH.DIRECTORY_SEPARATOR.$runtime;
	G('loadTime');
}
else
{
	/* 加载常量定义文件 */
	require PFA_PATH.'/comm/define.php';
	/* 加载框架函数库 */
	require	PFA_PATH.'/comm/func.php';
	/* 加载框架默认选项 */
	C(require PFA_PATH.'/comm/options.php');
	/* 检查部署 */
	require PFA_PATH."/comm/runtime.php";
	/* 读取框架核心文件列表 */
	$list = include PFA_PATH.'/comm/core.php';
	/* 加载框架核心文件 */
	foreach($list as $key => $file)
	{
		require_cache($file);
	}
	G('loadTime');
}
/* 创建控制器实例 */
$app = new App();
$app->run();

/* 调试页面跟踪信息 */
if(C('SHOW_RUN_TIME'))
{
	Debug::show_time();
}
if(C('SHOW_PAGE_TRACE'))
{
	Debug::show_trace();
}

G('endTime');

/* 记录和统计时间 */
function G($start, $end = '', $dec = 6)
{
	static $_info = array();
	if(!empty($end))
	{
		if(!isset($_info[$end]))
		{
			$_info[$end] = microtime(true);
		}
		return number_format(($_info[$end]-$_info[$start]),$dec);
	}
	else
	{
		$_info[$start] = microtime(true);
	}
}
?>