<?php
defined('SW_') or die('Access Error');

switch(SW::request('act','get')){
	
	//安装程序
	case 'install':

		//初始化安装类
		$objInstall=new SWInstall();
		$strErr='';

		//首先判断config目录是否可写
		if(!is_writable(SW::dirPath(''))) $strErr=LANG('Setup_Error_Writable');

		//如果没有出错
		if(!$strErr){
			
			//验证注册信息
			$objInstall->title=SWFunc::closeHtml(SW::request('title','post'));
			if(!$objInstall->title) $strErr=LANG('Invalid Option_Title');

			$objInstall->description=SWFunc::closeHtml(SW::request('description','post'));
			
			//获取程序地址
			$objInstall->url=SWFunc::checkUrl(SW::request('url','post'),true);
			if(!$objInstall->url) $strErr=LANG('Invalid Option_Url');

			$objInstall->author=SWFunc::closeHtml(SW::request('author','post'));
			if(!$objInstall->author) $strErr=LANG('Invalid Option_Author');
			
			$objInstall->email=SWFunc::checkString(SW::request('email','post'));
			if(!SWFunc::checkEmail($objInstall->email)) $strErr=LANG('Invalid Option_Email');
			
			$objInstall->account=SWFunc::checkString(SW::request('account','post'));
			if(!SWFunc::checkCharacter($objInstall->account,3)) $strErr=LANG('Invalid Account');

			//判断两次输入是否一样，同时进行认证
			$objInstall->password=SWFunc::checkString(SW::request('password','post'));
			if(!$objInstall->password || $objInstall->password!=SW::request('repassword','post') || !SWFunc::checkCharacter($objInstall->password,2,4,16)) $strErr=LANG('Invalid Password');
			
			$objInstall->language=SWFunc::checkString(SW::request('language','post'));
			if(!$objInstall->language) $strErr=LANG('Invalid Option_Language');
			
			$objInstall->timezone=SWFunc::checkString(SW::request('timezone','post'));
			if(!$objInstall->timezone) $strErr=LANG('Invalid Option_Timezone');

			$objInstall->dbprefix=SWFunc::checkString(SW::request('dbprefix','post'));
			if($objInstall->dbprefix && !SWFunc::checkCharacter($objInstall->dbprefix,3)) $strErr=LANG('Invalid Setup_DB_Prefix');
			
			//如果以上都没有错误，获取数据库设置
			if(!$strErr){
				$objInstall->dbhost=SWFunc::checkString(SW::request('dbhost','post'));
				$objInstall->dbname=SWFunc::checkString(SW::request('dbname','post'));
				$objInstall->dbuser=SWFunc::checkString(SW::request('dbuser','post'));
				$objInstall->dbpass=SWFunc::checkString(SW::request('dbpass','post'));
				if(!$objInstall->checkDatabase()) $strErr=LANG('Setup_Error_Mysql');
			}
			
		}

		//如果以上都没有错误
		if(!$strErr){
			
			//生成config文件
			$objInstall->createConfig();

			//把数据导入数据库，完成安装
			$objInstall->importData();

			//重新载入设置信息
			SW::getOption()->load();
			
			SWAdmin::postJson(LANG('Install Succeed'),0);

		}else{

			SWAdmin::postJson($strErr,1);

		}

	break;

}

?>
