<?php

defined('SW_') or die('Access Error');

class SWAttachment{

	//允许的最大上传文件大小
	var $uploadMaxSize=1000000;
		
	//允许上传的文件类型
	var $uploadFileExt=array('gif','jpg','jpeg','png','bmp','swf','flv','zip');

	//支持的图片类型
	var $imageType=array('gif', 'jpg', 'jpeg', 'png', 'bmp');
		
	/*=====================================================================
	* 列出目录下所有文件和文件夹
	======================================================================*/
	function getList($path){

		$file_list = array();
		
		//目录必须存在
		if (is_dir($path)) {

			//遍历目录取得文件信息
			if ($handle = opendir($path)) {
				$i = 0;
				while (false !== ($filename = readdir($handle))) {
					if ($filename{0} == '.') continue;
					$file = $path . $filename;
					if (is_dir($file)) {
						$file_list[$i]['is_dir'] = true; //是否文件夹
						$file_list[$i]['has_file'] = (count(scandir($file)) > 2); //文件夹是否包含文件
						$file_list[$i]['filesize'] = 0; //文件大小
						$file_list[$i]['is_photo'] = false; //是否图片
						$file_list[$i]['filetype'] = ''; //文件类别，用扩展名判断
					} else {
						$file_list[$i]['is_dir'] = false;
						$file_list[$i]['has_file'] = false;
						$file_list[$i]['filesize'] = filesize($file);
						$file_list[$i]['dir_path'] = '';
						$file_ext = strtolower(array_pop(explode('.', trim($file))));
						$file_list[$i]['is_photo'] = in_array($file_ext, $this->imageType);
						$file_list[$i]['filetype'] = $file_ext;
					}
					$file_list[$i]['filename'] = $filename; //文件名，包含扩展名
					$file_list[$i]['datetime'] = date('Y-m-d H:i:s', filemtime($file)); //文件最后修改时间
					$i++;
				}
				closedir($handle);
			}

		}

		usort($file_list, array('SWAttachment','cmp_func'));
		return $file_list;
		
	}

	/*=====================================================================
	* 对列出的文件进行排序
	======================================================================*/
	function cmp_func($a, $b) {
		$order='name';
		if ($a['is_dir'] && !$b['is_dir']) {
			return -1;
		} else if (!$a['is_dir'] && $b['is_dir']) {
			return 1;
		} else {
			if ($order == 'size') {
				if ($a['filesize'] > $b['filesize']) {
					return 1;
				} else if ($a['filesize'] < $b['filesize']) {
					return -1;
				} else {
					return 0;
				}
			} else if ($order == 'type') {
				return strcmp($a['filetype'], $b['filetype']);
			} else {
				return strcmp($a['filename'], $b['filename']);
			}
		}
	}
	
	/*=====================================================================
	* 获取上传文件夹，如果不存在则创建
	* 返回数组包含文件夹路径和url路径
	======================================================================*/
	function getUploadFolder(){
	
		//自动生成年份->月份目录
		$year=date('Y',time());
		$month=date('m',time());
		
		//创建年份目录
		if(!is_dir(SW::dirPath('attached.'.$year))){
			
			if(!$this->createFolder(SW::dirPath('attached'),$year)) return false;
			
		}
		
		//创建月份目录
		if(!is_dir(SW::dirPath('attached.'.$year.'.'.$month))){
			
			if(!$this->createFolder(SW::dirPath('attached.'.$year),$month)) return false;
			
		}
		
		//获取保存路径
		$requestPath = $year.'.'.$month;

		//文件保存目录路径
		$save_path = SW::dirPath('attached.'.$requestPath);

		//文件保存目录URL(包含域名的绝对网址)
		$save_url = SW::getOption('url').'attached/'.str_replace('.','/',$requestPath).'/';

		//文件保存目录URL(/开头的绝对路径)
		$save_urlPath = SW::urlPath('attached.'.$requestPath,true);

		return array('path'=>$save_path,'url'=>$save_url,'urlPath'=>$save_urlPath,'requestPath'=>$requestPath);

	}
	
	/*=====================================================================
	* 创建文件夹
	======================================================================*/
	function createFolder($path,$folderName){
				
		//目录必须存在
		if (is_dir($path)) {

			//遍历目录取得文件信息
			if ($handle = opendir($path)) {
				$i = 0;
				$folder = $path . $folderName;
				while (false !== ($filename = readdir($handle))) {
					if ($filename{0} == '.') continue;
					if (is_dir($folder) && $filename==$folderName) return; //文件夹是否存在
				}
				
				if(mkdir($folder)) return true;
				
			}
			
		}
		
		return false;
		
	}
	
	/*=====================================================================
	* 保存base64编码的图片
	* 可能出现在截图软件、浏览器粘贴或直接复制本地图片上
	======================================================================*/
	function saveImage($sUrl){

		$reExt='('.implode('|',$this->imageType).')';
		
		//base64编码的图片，可能出现在firefox粘贴，或者某些网站上，例如google图片
		if(substr($sUrl,0,10)=='data:image'){
			if(!preg_match('/^data:image\/'.$reExt.'/i',$sUrl,$sExt))return false;
			$sExt=$sExt[1];
			$imgContent=base64_decode(substr($sUrl,strpos($sUrl,'base64,')+7));
		}

		if(strlen($imgContent)>$this->uploadMaxSize)return false;//文件体积超过最大限制

		//获取上传文件夹
		$arrFolder = $this->getUploadFolder();

		//检查目录
		if (@is_dir($arrFolder['path']) === false) return false;
		
		//检查目录写权限
		if (@is_writable($arrFolder['path']) === false) return false;

		//新文件名
		$new_file_name = 'editor_' . date("YmdHis") . '_' . rand(10000, 99999) . '.' . $sExt;
		
		//文件路径
		$sLocalFile=$arrFolder['path'].$new_file_name;
		
		//保存文件
		file_put_contents($sLocalFile,$imgContent);

		//检查mime是否为图片，需要php.ini中开启gd2扩展
		$fileinfo= @getimagesize($sLocalFile);
		if(!$fileinfo||!preg_match("/image\/".$reExt."/i",$fileinfo['mime'])){
			@unlink($sLocalFile);
			return false;
		}

		return $arrFolder['urlPath'].$new_file_name;

	}
	
	/*=====================================================================
	* 上传文件方法
	* 上传失败返回false
	* 返回一个上传文件信息数组
	======================================================================*/
	function upload(){
		
		//获取文件请求信息
		if (empty($_FILES) === false) {
			
			//原文件名
			$file_name = $_FILES['file']['name'];
			//服务器上临时文件名
			$tmp_name = $_FILES['file']['tmp_name'];
			//文件大小
			$file_size = $_FILES['file']['size'];
			
		}else{
			
			return false;
		
		}
		
		//获取上传文件夹
		$arrFolder = $this->getUploadFolder();
			
		//检查文件名
		if (!$file_name) return false;
		
		//检查目录
		if (@is_dir($arrFolder['path']) === false) return false;
		
		//检查目录写权限
		if (@is_writable($arrFolder['path']) === false) return false;
		
		//检查是否已上传
		if (@is_uploaded_file($tmp_name) === false) return false;
		
		//检查文件大小
		if ($file_size > $this->uploadMaxSize) return false;
		
		//获得文件扩展名
		$temp_arr = explode(".", $file_name);
		$file_ext = array_pop($temp_arr);
		$file_ext = trim($file_ext);
		$file_ext = strtolower($file_ext);
		
		//检查扩展名
		if (in_array($file_ext, $this->uploadFileExt) === false) return false;
		
		//新文件名
		$new_file_name = date("YmdHis") . '_' . rand(10000, 99999) . '.' . $file_ext;
		
		//移动文件
		$file_path = $arrFolder['path'] . $new_file_name;
		if (move_uploaded_file($tmp_name, $file_path) === false) return false;
		@chmod($file_path, 0644);
		$file_url = $arrFolder['url'] . $new_file_name;
		
		//如果成功，返回一个数组
		$arrReturn=array(
			'name'=>$new_file_name,
			'path'=>$arrFolder['requestPath'],
			'url'=>$file_url,
			'size'=>$file_size
		);
		return $arrReturn;
		
	}
	
}

?>
