<?php

defined('SW_') or die('Access Error');

class SWInstall{

	var $title='';
	var $description='';
	var $url='';
	var $language='';
	var $timezone='';
	var $author='';
	var $email='';
	var $account='';
	var $password='';

	function __construct(){
		
		//获取option默认值
		$arrOption=$this->optionDate();

		$this->title=$arrOption['title']['default'];
		$this->description=$arrOption['description']['default'];
		$this->url=$arrOption['url']['default'];
		$this->language=$arrOption['language']['default'];
		$this->timezone=$arrOption['timezone']['default'];
		$this->author=$arrOption['author']['default'];
		$this->email=$arrOption['email']['default'];
		$this->account=$arrOption['account']['default'];
		$this->password=$arrOption['password']['default'];
		
		$this->dbhost='localhost';
		$this->dbname='swan';
		$this->dbuser='root';
		$this->dbpass='';
		$this->dbprefix='sw_';

	}

	/*=====================================================================
	* 获取http访问的程序根路径
	======================================================================*/
	function getRootUrl(){
		
		return 'http://'.$_SERVER['HTTP_HOST'].SW::urlPath('',true);
		
	}
	
	/*=====================================================================
	* 验证数据库设置是否正确
	======================================================================*/
	function checkDatabase(){
		
		$db=@mysql_connect($this->dbhost,$this->dbuser,$this->dbpass);
		
		if(!$db || !@mysql_select_db($this->dbname,$db)) return false;
		
		return true;
		
	}
	
	/*=====================================================================
	* 生成config文件
	* 路径：/config.php
	======================================================================*/
	function createConfig(){
		
		$path=SW::path('config');
		
		//创建文件
		$f=@fopen($path,'wb');
		$res=@fwrite($f,$this->getConfig());
		@fclose($f);
		
		return $res?true:false;
		
	}
	
	/*=====================================================================
	* 获取config文件字符串
	* 如果$eval为true，则直接执行其中的define
	* 如果是false，那么返回config文件的内容字符串
	======================================================================*/
	function getConfig($eval=false){

		$strConfig="
		define('SW_HASH','".(defined('SW_HASH')?SW_HASH:SWFunc::randomString(16))."');
		define('SW_CREATE','".(defined('SW_CREATE')?SW_CREATE:time())."');
		define('SW_HOST','".$this->dbhost."');
		define('SW_DB','".$this->dbname."');
		define('SW_USER','".$this->dbuser."');
		define('SW_PASS','".$this->dbpass."');
		define('SW_PREFIX','".$this->dbprefix."');
		";

		if($eval){
			
			//注意：这里是直接执行这个字符串
			eval($strConfig);

		}else{

			$str="<?php
			defined('SW_') or die('Access Error');".$strConfig."?>";
			
			return trim(str_replace("\t",'',$str));

		}
		
	}
	
	/*=====================================================================
	* option的数组，用于添加option值
	======================================================================*/
	function optionDate(){
		
		$arrOption = array(
			'title' => array('name'=>'title', 'type'=>'string', 'value'=>$this->title, 'default'=>'My Swan Blog'),
			'description' => array('name'=>'description', 'type'=>'string', 'value'=>$this->description, 'default'=>'Another swan blog'),
			'url' => array('name'=>'url', 'type'=>'string', 'value'=>$this->url, 'default'=>$this->getRootUrl()),
			'author' => array('name'=>'author', 'type'=>'string', 'value'=>$this->author, 'default'=>'User'),
			'email' => array('name'=>'email', 'type'=>'string', 'value'=>$this->email, 'default'=>'youremail@youremail.com'),
			'account' => array('name'=>'account', 'type'=>'string', 'value'=>$this->account, 'default'=>'admin'),
			'password' => array('name'=>'password', 'type'=>'string', 'value'=>md5($this->password), 'default'=>''),
			'pingback' => array('name'=>'pingback', 'type'=>'bool', 'value'=>0, 'default'=>0),
			'language' => array('name'=>'language', 'type'=>'string', 'value'=>$this->language, 'default'=>'zh_cn'),
			'timezone' => array('name'=>'timezone', 'type'=>'string', 'value'=>$this->timezone, 'default'=>'Asia/Shanghai'),
			'checkcomment' => array('name'=>'checkcomment', 'type'=>'bool', 'value'=>0, 'default'=>0),
			'receivepingback' => array('name'=>'receivepingback', 'type'=>'bool', 'value'=>1, 'default'=>1),
			'receivetrackback' => array('name'=>'receivetrackback', 'type'=>'bool', 'value'=>1, 'default'=>1),
			'akismet_key' => array('name'=>'akismet_key', 'type'=>'string', 'value'=>'', 'default'=>''),
			'feedcount' => array('name'=>'feedcount', 'type'=>'int', 'value'=>10, 'default'=>10),
			'version' => array('name'=>'version', 'type'=>'string', 'value'=>SW_VERSION, 'default'=>SW_VERSION),
			'template' => array('name'=>'template', 'type'=>'string', 'value'=>'default', 'default'=>'default'),
			'rewrite' => array('name'=>'rewrite', 'type'=>'bool', 'value'=>0, 'default'=>0),
			'template_option' => array('name'=>'template_option', 'type'=>'json', 'value'=>'', 'default'=>''),
			'mail_type' => array('name'=>'mail_type', 'type'=>'string', 'value'=>'', 'default'=>''),
			'mail_address' => array('name'=>'mail_address', 'type'=>'string', 'value'=>'', 'default'=>''),
			'mail_server' => array('name'=>'mail_server', 'type'=>'string', 'value'=>'', 'default'=>''),
			'mail_port' => array('name'=>'mail_port', 'type'=>'int', 'value'=>25, 'default'=>25),
			'mail_account' => array('name'=>'mail_account', 'type'=>'string', 'value'=>'', 'default'=>''),
			'mail_password' => array('name'=>'mail_password', 'type'=>'string', 'value'=>'', 'default'=>'')
		);

		return $arrOption;

	}
	
	/*=====================================================================
	* 导入数据库（生成config文件之后才能执行）
	======================================================================*/
	function importData(){
		
		$db=SW::getDb($this->dbhost,$this->dbname,$this->dbuser,$this->dbpass);
		
		//创建表
		foreach($this->getImportSql() as $sql){
			$db->execute($sql);
		}

		//导入option设置
		$arrOption=$this->optionDate();
		$arrSql=array();
		foreach($arrOption as $option){
			$arrSql[]="('".$option['name']."', '".$option['type']."', '".$option['value']."', '".$option['default']."')";
		}

		//生成sql
		$sql="
		INSERT INTO `".$this->dbprefix."option` (`name`, `type`, `value`, `default`) VALUES
		" . implode(",\n",$arrSql) . ';';
				
		$db->execute($sql);
		
	}
	
	/*=====================================================================
	* 生成导入的SQL语句
	======================================================================*/
	function getImportSql(){
		
		//导入的SQL语句
		$arrSql=array();
		
		$arrSql[]="CREATE TABLE IF NOT EXISTS `".$this->dbprefix."comment` (
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `parentid` int(11) NOT NULL,
		  `postid` int(11) NOT NULL,
		  `content` text NOT NULL,
		  `author` varchar(255) NOT NULL,
		  `email` varchar(255) NOT NULL,
		  `url` varchar(255) NOT NULL,
		  `ip` varchar(255) NOT NULL,
		  `posttime` int(11) NOT NULL,
		  `state` tinyint(4) NOT NULL,
		  `type` tinyint(4) NOT NULL,
		  PRIMARY KEY (`id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
		
		$arrSql[]="CREATE TABLE IF NOT EXISTS `".$this->dbprefix."option` (
		  `name` varchar(255) NOT NULL,
		  `type` varchar(255) NOT NULL,
		  `value` text NOT NULL,
		  `default` text NOT NULL,
		  PRIMARY KEY  (`name`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8 ;";

		$arrSql[]="CREATE TABLE IF NOT EXISTS `".$this->dbprefix."page` (
		  `id` int(11) NOT NULL auto_increment,
		  `parentid` int(11) NOT NULL,
		  `parentmap` varchar(255) NOT NULL,
		  `title` varchar(255) NOT NULL,
		  `content` text NOT NULL,
		  `alias` varchar(255) NOT NULL,
		  `posttime` int(11) NOT NULL,
		  `edittime` int(11) NOT NULL,
		  `state` tinyint(4) NOT NULL,
		  `flag` tinyint(4) NOT NULL,
		  `ordernum` int(11) NOT NULL,
		  `onmenu` tinyint(4) NOT NULL,
		  PRIMARY KEY  (`id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
		
		$arrSql[]="CREATE TABLE IF NOT EXISTS `".$this->dbprefix."post` (
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `title` varchar(255) NOT NULL,
		  `content` text NOT NULL,
		  `state` tinyint(4) NOT NULL,
		  `allowcomment` tinyint(4) NOT NULL,
		  `posttime` int(11) NOT NULL,
		  `edittime` int(11) NOT NULL,
		  `alias` varchar(255) NOT NULL,
		  `flag` tinyint(4) NOT NULL,
		  `log_pingback` text NOT NULL,
		  PRIMARY KEY (`id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
		
		$arrSql[]="CREATE TABLE IF NOT EXISTS `".$this->dbprefix."tag` (
		  `id` int(11) NOT NULL AUTO_INCREMENT,
		  `postid` int(11) NOT NULL,
		  `name` varchar(255) NOT NULL,
		  PRIMARY KEY (`id`)
		) ENGINE=MyISAM  DEFAULT CHARSET=utf8 AUTO_INCREMENT=1 ;";
		
		return $arrSql;

	}
	
}

?>
