DROP TABLE IF EXISTS `jishigou_api_oauth2_code`;
CREATE TABLE `jishigou_api_oauth2_code` (
`id` bigint(20) NOT NULL AUTO_INCREMENT,
`client_id` varchar(32) NOT NULL,
`uid` mediumint(8) unsigned NOT NULL,
`code` varchar(40) NOT NULL COMMENT 'ʱCodeڽAccessCode',
`redirect_uri` varchar(200) NOT NULL,
`expires` int(11) NOT NULL COMMENT 'CodeĹʱ',
`scope` varchar(255) DEFAULT NULL,
PRIMARY KEY (`id`),
KEY `code` (`code`),
KEY `expires` (`expires`),
KEY `uid-client_id` (`uid`,`client_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_api_oauth2_token`;
CREATE TABLE `jishigou_api_oauth2_token` (
`id` bigint(20) NOT NULL AUTO_INCREMENT,
`client_id` varchar(32) NOT NULL COMMENT 'ApiClientId',
`uid` mediumint(8) NOT NULL COMMENT 'ûUid',
`access_token` varchar(40) NOT NULL COMMENT 'AccessCodeAPIOauth2ʽ',
`refresh_token` varchar(40) NOT NULL,
`expires` int(11) NOT NULL COMMENT 'ʱ',
`scope` varchar(255) DEFAULT NULL,
PRIMARY KEY (`id`),
KEY `access_token` (`access_token`),
KEY `expires` (`expires`),
KEY `uid-client_id` (`uid`,`client_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_app`;
CREATE TABLE `jishigou_app` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`username` char(15) NOT NULL DEFAULT '',
`app_name` char(100) NOT NULL DEFAULT '' COMMENT 'App',
`source_url` char(255) NOT NULL DEFAULT '' COMMENT 'ԴURL',
`show_from` tinyint(1) NOT NULL DEFAULT '0' COMMENT '΢ǷʾAppԴϢ',
`app_desc` text NOT NULL,
`app_key` char(32) NOT NULL COMMENT 'AppKeyOauth2ʹõClientId',
`app_secret` char(32) NOT NULL DEFAULT '' COMMENT 'AppSecretOauth2ʹõClientSecret',
`allows_ip` text NOT NULL,
`status` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'App״̬Ϊ0ʱʾδãͣʹõģ',
`request_times` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT 'ͳ',
`request_times_day` int(10) unsigned NOT NULL DEFAULT '0',
`request_times_last_day` int(10) unsigned NOT NULL DEFAULT '0',
`request_times_week` int(10) unsigned NOT NULL DEFAULT '0',
`request_times_last_week` int(10) unsigned NOT NULL DEFAULT '0',
`request_times_month` int(10) unsigned NOT NULL DEFAULT '0',
`request_times_last_month` int(10) unsigned NOT NULL DEFAULT '0',
`request_times_year` bigint(20) unsigned NOT NULL DEFAULT '0',
`request_times_last_year` bigint(20) unsigned NOT NULL DEFAULT '0',
`last_request_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`redirect_uri` char(255) NOT NULL,
`create_time` int(11) unsigned NOT NULL COMMENT 'ʱ',
PRIMARY KEY (`id`),
UNIQUE KEY `app_key_secret` (`app_key`,`app_secret`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_blacklist`;
CREATE TABLE `jishigou_blacklist` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`uid` int(11) NOT NULL DEFAULT '0',
`touid` int(11) NOT NULL DEFAULT '0' COMMENT 'ûUid',
PRIMARY KEY (`id`),
KEY `uid_touid` (`uid`,`touid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_buddys`;
CREATE TABLE `jishigou_buddys` (
`id` int(10) NOT NULL AUTO_INCREMENT,
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`buddyid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'Uid',
`grade` tinyint(1) unsigned NOT NULL DEFAULT '1',
`remark` char(30) NOT NULL DEFAULT '' COMMENT 'ѱע',
`dateline` int(10) unsigned NOT NULL DEFAULT '0',
`description` char(255) NOT NULL DEFAULT '',
`buddy_lastuptime` int(10) unsigned NOT NULL COMMENT 'ʱ',
PRIMARY KEY (`id`),
UNIQUE KEY `uid_buddyid` (`uid`,`buddyid`),
KEY `buddyid` (`buddyid`),
KEY `dateline` (`dateline`),
KEY `buddy_lastuptime` (`buddy_lastuptime`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache`;
CREATE TABLE `jishigou_cache` (
`key` char(255) NOT NULL COMMENT 'Key',
`val` longblob NOT NULL COMMENT '',
`dateline` int(10) unsigned NOT NULL COMMENT 'ʱ',
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_1`;
CREATE TABLE `jishigou_cache_1` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_10`;
CREATE TABLE `jishigou_cache_10` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_11`;
CREATE TABLE `jishigou_cache_11` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_12`;
CREATE TABLE `jishigou_cache_12` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_13`;
CREATE TABLE `jishigou_cache_13` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_14`;
CREATE TABLE `jishigou_cache_14` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_15`;
CREATE TABLE `jishigou_cache_15` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_2`;
CREATE TABLE `jishigou_cache_2` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_3`;
CREATE TABLE `jishigou_cache_3` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_4`;
CREATE TABLE `jishigou_cache_4` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_5`;
CREATE TABLE `jishigou_cache_5` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_6`;
CREATE TABLE `jishigou_cache_6` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_7`;
CREATE TABLE `jishigou_cache_7` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_8`;
CREATE TABLE `jishigou_cache_8` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cache_9`;
CREATE TABLE `jishigou_cache_9` (
`key` char(255) NOT NULL,
`val` longblob NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_common_district`;
CREATE TABLE `jishigou_common_district` (
`id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
`name` char(255) NOT NULL,
`level` tinyint(4) unsigned NOT NULL DEFAULT '0' COMMENT '',
`upid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '',
`list` smallint(6) NOT NULL DEFAULT '0' COMMENT '',
PRIMARY KEY (`id`),
KEY `upid` (`upid`,`list`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_credits_log`;
CREATE TABLE `jishigou_credits_log` (
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`operation` char(3) NOT NULL DEFAULT '' COMMENT '',
`relatedid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Id',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`extcredits1` int(10) NOT NULL DEFAULT '0',
`extcredits2` int(10) NOT NULL DEFAULT '0',
`extcredits3` int(10) NOT NULL DEFAULT '0',
`extcredits4` int(10) NOT NULL DEFAULT '0',
`extcredits5` int(10) NOT NULL DEFAULT '0',
`extcredits6` int(10) NOT NULL DEFAULT '0',
`extcredits7` int(10) NOT NULL DEFAULT '0',
`extcredits8` int(10) NOT NULL DEFAULT '0',
KEY `uid` (`uid`),
KEY `operation` (`operation`),
KEY `relatedid` (`relatedid`),
KEY `dateline` (`dateline`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_credits_rule`;
CREATE TABLE `jishigou_credits_rule` (
`rid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
`rulename` varchar(20) NOT NULL DEFAULT '' COMMENT 'ֹ',
`action` varchar(20) NOT NULL DEFAULT '' COMMENT 'ֹ',
`cycletype` tinyint(1) NOT NULL DEFAULT '0' COMMENT '',
`cycletime` int(10) NOT NULL DEFAULT '0',
`rewardnum` tinyint(2) NOT NULL DEFAULT '1' COMMENT 'ִд',
`norepeat` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿѭ',
`extcredits1` int(10) NOT NULL DEFAULT '0',
`extcredits2` int(10) NOT NULL DEFAULT '0',
`extcredits3` int(10) NOT NULL DEFAULT '0',
`extcredits4` int(10) NOT NULL DEFAULT '0',
`extcredits5` int(10) NOT NULL DEFAULT '0',
`extcredits6` int(10) NOT NULL DEFAULT '0',
`extcredits7` int(10) NOT NULL DEFAULT '0',
`extcredits8` int(10) NOT NULL DEFAULT '0',
`related` char(20) NOT NULL DEFAULT '' COMMENT 'أû⣩',
PRIMARY KEY (`rid`),
UNIQUE KEY `action` (`action`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_credits_rule_log`;
CREATE TABLE `jishigou_credits_rule_log` (
`clid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`rid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'Id',
`total` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ִܹеĴ',
`cyclenum` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ѭ',
`extcredits1` int(10) NOT NULL DEFAULT '0',
`extcredits2` int(10) NOT NULL DEFAULT '0',
`extcredits3` int(10) NOT NULL DEFAULT '0',
`extcredits4` int(10) NOT NULL DEFAULT '0',
`extcredits5` int(10) NOT NULL DEFAULT '0',
`extcredits6` int(10) NOT NULL DEFAULT '0',
`extcredits7` int(10) NOT NULL DEFAULT '0',
`extcredits8` int(10) NOT NULL DEFAULT '0',
`starttime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`dateline` int(10) unsigned NOT NULL DEFAULT '0',
`relatedid` int(10) NOT NULL DEFAULT '0' COMMENT 'أû⣩Id',
PRIMARY KEY (`clid`),
KEY `uid` (`uid`,`rid`),
KEY `dateline` (`dateline`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_cron`;
CREATE TABLE `jishigou_cron` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`touid` int(11) NOT NULL DEFAULT '0' COMMENT 'ûUid',
`toemail` char(40) NOT NULL DEFAULT '' COMMENT 'û',
`at_content` text NOT NULL COMMENT 'At',
`pm_content` text NOT NULL COMMENT '˽',
`reply_content` text NOT NULL COMMENT 'ظ',
`sendtime` int(11) NOT NULL DEFAULT '0' COMMENT 'ִʱ',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_event`;
CREATE TABLE `jishigou_event` (
`id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
`type_id` mediumint(10) NOT NULL,
`title` char(100) NOT NULL COMMENT '',
`fromt` int(10) NOT NULL COMMENT 'ʼʱ',
`tot` int(10) NOT NULL COMMENT 'ʱ',
`content` text NOT NULL COMMENT '',
`image` char(255) NOT NULL COMMENT '',
`province_id` mediumint(7) NOT NULL COMMENT 'ʡ',
`area_id` mediumint(7) NOT NULL COMMENT '',
`city_id` mediumint(7) NOT NULL COMMENT '',
`address` char(255) NOT NULL COMMENT 'ַ',
`money` int(10) NOT NULL DEFAULT '0' COMMENT '',
`app_num` int(10) NOT NULL DEFAULT '0' COMMENT '',
`play_num` int(10) NOT NULL DEFAULT '0' COMMENT '',
`postman` int(7) NOT NULL COMMENT '',
`posttime` int(10) NOT NULL COMMENT 'ʱ',
`lasttime` int(10) NOT NULL COMMENT 'ʱ',
`qualification` text NOT NULL COMMENT 'ʸ',
`need_app_info` text NOT NULL COMMENT 'ʱдϢ',
`recd` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƽ',
`verify` tinyint(1) NOT NULL DEFAULT '1' COMMENT '',
`postip` char(15) NOT NULL DEFAULT '',
`item` char(15) NOT NULL DEFAULT '',
`item_id` int(10) NOT NULL DEFAULT '0',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_event_favorite`;
CREATE TABLE `jishigou_event_favorite` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`type_id` mediumint(10) NOT NULL DEFAULT '0' COMMENT 'Id',
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`dateline` int(10) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`id`),
KEY `type_id` (`type_id`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_event_info`;
CREATE TABLE `jishigou_event_info` (
`id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
`need_info` text NOT NULL COMMENT 'ϸϢ',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_event_member`;
CREATE TABLE `jishigou_event_member` (
`oid` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
`id` mediumint(10) NOT NULL,
`title` char(100) NOT NULL COMMENT '',
`fid` mediumint(8) NOT NULL COMMENT 'ûID',
`app` mediumint(1) NOT NULL DEFAULT '0' COMMENT 'ǷǱ',
`play` mediumint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿǲ',
`app_info` text NOT NULL COMMENT 'ʱд',
`store` mediumint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿղ',
`app_time` int(10) NOT NULL COMMENT 'ʱ',
`play_time` int(10) NOT NULL COMMENT 'ʱ',
`store_time` int(10) NOT NULL COMMENT 'ղʱ',
PRIMARY KEY (`oid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_event_needinfo`;
CREATE TABLE `jishigou_event_needinfo` (
`id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
`name` char(100) NOT NULL COMMENT '',
`form_type` char(10) NOT NULL COMMENT '',
`form_set` mediumtext NOT NULL COMMENT 'Ĭֵ',
`ename` char(20) NOT NULL COMMENT '',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_event_sort`;
CREATE TABLE `jishigou_event_sort` (
`id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
`type` char(50) NOT NULL COMMENT '',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_failedlogins`;
CREATE TABLE `jishigou_failedlogins` (
`ip` char(15) NOT NULL DEFAULT '' COMMENT 'Ipַ',
`count` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '',
`lastupdate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '¼ʱ',
PRIMARY KEY (`ip`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_force_out`;
CREATE TABLE `jishigou_force_out` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`uid` int(10) unsigned NOT NULL DEFAULT '0',
`role_id` tinyint(4) NOT NULL,
`douid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
`cause` char(100) NOT NULL DEFAULT '' COMMENT 'ɱûԭ',
`dateline` int(10) NOT NULL DEFAULT '0',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_group`;
CREATE TABLE `jishigou_group` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`uid` int(11) NOT NULL DEFAULT '0',
`group_name` char(15) NOT NULL DEFAULT '' COMMENT 'ѵķ',
`group_count` int(11) NOT NULL DEFAULT '0',
PRIMARY KEY (`id`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_groupfields`;
CREATE TABLE `jishigou_groupfields` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`gid` int(11) NOT NULL DEFAULT '0' COMMENT 'ѷId',
`uid` int(11) NOT NULL DEFAULT '0',
`touid` int(11) NOT NULL DEFAULT '0',
`g_name` char(15) NOT NULL DEFAULT '' COMMENT '',
`display` tinyint(4) NOT NULL DEFAULT '0',
PRIMARY KEY (`id`),
KEY `gid_uid` (`gid`,`uid`),
KEY `uid_touid` (`uid`,`touid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_imjiqiren_client_user`;
CREATE TABLE `jishigou_imjiqiren_client_user` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`username` char(30) NOT NULL DEFAULT '',
`user_im` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'QQ',
`try_bind_times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '󶨴',
`last_try_bind_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '԰󶨵ʱ',
`send_times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʹ',
`last_send_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ϣʱ',
`last_send_message_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϢId',
`stop_receive` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'ֹͣգ',
`receive_times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'մ',
`last_receive_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ϣʱ',
`last_receive_message_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ϢId',
`stop_sign_update` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'ֹͣǩ£',
`sign_update_times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ǩ´',
`last_sign_update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ǩµʱ',
`last_sign_update_message_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'µǩId',
`reset_password_times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ĵ',
`last_reset_password_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'ǷЧ',
`t_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '@ҵѹܣ',
`p_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT 'ѹܣ ',
`m_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '˽ѹܣ',
`f_enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '·˿ѹܣ',
`share_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
PRIMARY KEY (`id`),
KEY `uid` (`uid`),
KEY `user_im` (`user_im`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_imjiqiren_failedlogins`;
CREATE TABLE `jishigou_imjiqiren_failedlogins` (
`ip` char(15) NOT NULL DEFAULT '',
`count` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '',
`lastupdate` int(10) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`ip`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_imjiqiren_send_queue`;
CREATE TABLE `jishigou_imjiqiren_send_queue` (
`to` int(10) unsigned NOT NULL DEFAULT '0',
`message` text NOT NULL COMMENT 'еϢ',
`salt` char(10) NOT NULL DEFAULT '',
`dateline` int(10) unsigned NOT NULL DEFAULT '0',
UNIQUE KEY `to` (`to`),
KEY `dateline` (`dateline`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_invite`;
CREATE TABLE `jishigou_invite` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'Uid',
`code` char(16) NOT NULL DEFAULT '' COMMENT '',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`fuid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '붼Uidעɹ',
`fusername` char(15) NOT NULL DEFAULT '',
`femail` char(50) NOT NULL DEFAULT '' COMMENT 'ߵEmail',
PRIMARY KEY (`id`),
KEY `uidcode` (`uid`,`code`),
KEY `femail` (`femail`),
KEY `fuid` (`fuid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_ip_banned`;
CREATE TABLE `jishigou_ip_banned` (
`id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
`ip_start` int(10) unsigned NOT NULL DEFAULT '0',
`ip_end` int(10) unsigned NOT NULL DEFAULT '0',
`reason` char(255) NOT NULL DEFAULT '',
`dateline` int(10) unsigned NOT NULL DEFAULT '0',
`expire` int(10) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`id`),
UNIQUE KEY `ip_start` (`ip_start`,`ip_end`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_item_sms`;
CREATE TABLE `jishigou_item_sms` (
`sid` int(11) NOT NULL AUTO_INCREMENT,
`item` varchar(10) NOT NULL,
`itemid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Id',
`uid` int(10) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`sid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_item_user`;
CREATE TABLE `jishigou_item_user` (
`iid` int(11) NOT NULL AUTO_INCREMENT,
`item` varchar(10) NOT NULL,
`itemid` int(10) unsigned NOT NULL DEFAULT '0',
`type` varchar(10) NOT NULL DEFAULT '',
`uid` int(11) unsigned NOT NULL DEFAULT '0',
`description` varchar(254) NOT NULL COMMENT '',
PRIMARY KEY (`iid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_kaixin_bind_info`;
CREATE TABLE `jishigou_kaixin_bind_info` (
`uid` int(10) unsigned NOT NULL,
`kaixin_uid` char(32) NOT NULL default '' COMMENT 'Uid',
`kaixin_name` char(32) NOT NULL default '',
`kaixin_gender` char(64) NOT NULL default '' COMMENT 'Ա',
`kaixin_logo50` char(32) NOT NULL default '' COMMENT 'ͷ',
`token` char(128) NOT NULL default '',
`token_time` int(10) NOT NULL,
`token_expire` int(10) NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY  (`uid`),
UNIQUE KEY `renren_uid` (`kaixin_uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_kaixin_bind_topic`;
CREATE TABLE `jishigou_kaixin_bind_topic` (
`tid` int(10) unsigned NOT NULL,
`kaixin_id` bigint(20) unsigned NOT NULL,
KEY `tid` (`tid`),
KEY `kaixin_id` (`kaixin_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_live`;
CREATE TABLE `jishigou_live` (
`lid` int(11) NOT NULL AUTO_INCREMENT,
`livename` varchar(60) NOT NULL COMMENT '',
`description` text NOT NULL COMMENT '',
`starttime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʼʱ',
`endtime` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`image` varchar(100) NOT NULL COMMENT 'ͼƬ',
PRIMARY KEY (`lid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_log`;
CREATE TABLE `jishigou_log` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Uid',
`username` char(15) NOT NULL,
`nickname` char(15) NOT NULL,
`role_action_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Id',
`role_action_name` char(15) NOT NULL COMMENT '',
`mod` char(50) NOT NULL COMMENT 'Mod',
`code` char(255) NOT NULL DEFAULT '' COMMENT 'Code',
`ip` char(15) NOT NULL DEFAULT '' COMMENT 'IP',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`request_method` enum('POST','GET') NOT NULL DEFAULT 'GET' COMMENT '󷽷Post Get',
`data_length` int(10) unsigned NOT NULL COMMENT 'Log¼ĳ',
`uri` char(255) NOT NULL COMMENT 'Uri',
PRIMARY KEY (`id`),
KEY `role_action_id` (`role_action_id`),
KEY `mod_code` (`mod`,`code`),
KEY `uid` (`uid`),
KEY `ip` (`ip`),
KEY `dateline` (`dateline`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_log_data`;
CREATE TABLE `jishigou_log_data` (
`log_id` int(10) NOT NULL COMMENT 'Log¼Id',
`user_agent` char(255) NOT NULL COMMENT 'UserAgent',
`log_data` longblob NOT NULL COMMENT '¼飨PostGetֵ',
`dateline` int(10) unsigned NOT NULL COMMENT 'ʱ',
PRIMARY KEY (`log_id`),
KEY `dateline` (`dateline`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_manage_detail`;
CREATE TABLE `jishigou_manage_detail` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '΢Tid',
`type` char(8) NOT NULL DEFAULT '' COMMENT '΢״̬ʾˡɾȣ',
`tuid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`tusername` char(15) NOT NULL DEFAULT '',
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`username` char(15) NOT NULL DEFAULT '',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`postip` char(15) NOT NULL DEFAULT '' COMMENT 'IP',
PRIMARY KEY (`id`),
KEY `uid` (`uid`),
KEY `dateline` (`dateline`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_medal`;
CREATE TABLE `jishigou_medal` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`medal_img` char(255) NOT NULL COMMENT 'ͼƬ1',
`medal_img2` char(200) NOT NULL COMMENT 'ͼƬ2',
`medal_name` char(30) NOT NULL COMMENT '',
`medal_depict` char(50) NOT NULL COMMENT '',
`medal_count` int(11) NOT NULL DEFAULT '0',
`is_open` tinyint(4) NOT NULL DEFAULT '1' COMMENT 'Ƿ',
`conditions` varchar(250) NOT NULL COMMENT '',
`dateline` int(11) NOT NULL DEFAULT '0' COMMENT 'ʱ',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_medal_apply`;
CREATE TABLE `jishigou_medal_apply` (
`apply_id` int(10) NOT NULL AUTO_INCREMENT,
`uid` int(10) NOT NULL DEFAULT '0' COMMENT 'Uid',
`nickname` char(25) NOT NULL DEFAULT '',
`medal_id` smallint(6) NOT NULL DEFAULT '0' COMMENT 'ѫId',
`dateline` int(10) NOT NULL DEFAULT '0' COMMENT 'ѫµʱ',
PRIMARY KEY (`apply_id`),
KEY `uid` (`uid`),
KEY `medal_id` (`medal_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_media`;
CREATE TABLE `jishigou_media` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`media_name` char(20) NOT NULL DEFAULT '' COMMENT '',
`media_count` smallint(6) NOT NULL DEFAULT '0' COMMENT '',
`order` int(11) NOT NULL DEFAULT '0' COMMENT '',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_member_validate`;
CREATE TABLE `jishigou_member_validate` (
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`email` char(50) NOT NULL DEFAULT '' COMMENT 'ַ',
`role_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT 'ûId',
`key` char(16) NOT NULL DEFAULT '' COMMENT 'УKey',
`status` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '״̬',
`verify_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '֤ʱ',
`regdate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'עʱ',
`type` enum('email','admin') NOT NULL DEFAULT 'email' COMMENT '',
UNIQUE KEY `key` (`key`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_memberfields`;
CREATE TABLE `jishigou_memberfields` (
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`site` varchar(75) NOT NULL DEFAULT '',
`location` varchar(30) NOT NULL DEFAULT '',
`authstr` varchar(20) NOT NULL DEFAULT '' COMMENT 'һʱУ',
`question` varchar(255) NOT NULL DEFAULT '',
`answer` varchar(255) NOT NULL DEFAULT '',
`address` varchar(40) NOT NULL DEFAULT '' COMMENT 'ַ',
`validate_true_name` varchar(50) NOT NULL DEFAULT '' COMMENT '֤û',
`validate_card_type` varchar(10) NOT NULL DEFAULT '' COMMENT '֤',
`validate_card_id` varchar(50) NOT NULL DEFAULT '' COMMENT '֤',
`validate_remark` varchar(100) NOT NULL DEFAULT '' COMMENT '֤ע',
`validate_card_pic` char(100) NOT NULL COMMENT '֤ͼƬ',
`validate_extra` char(200) NOT NULL COMMENT '֤ûȨ-ר',
`account_bind_info` text NOT NULL COMMENT 'û󶨵ݣ棩',
PRIMARY KEY (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_members`;
CREATE TABLE `jishigou_members` (
`uid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ûUid',
`username` char(15) NOT NULL DEFAULT '' COMMENT 'ԵַĬϵͬUid',
`nickname` char(15) NOT NULL DEFAULT '' COMMENT 'ûǳƣ@ʾ',
`password` char(32) NOT NULL DEFAULT '' COMMENT '루洢MD5ֵ',
`medal_id` char(20) NOT NULL DEFAULT '' COMMENT 'ѫId',
`media_id` int(11) NOT NULL DEFAULT '0' COMMENT 'ýId',
`gender` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ա',
`regip` char(15) NOT NULL DEFAULT '' COMMENT 'עIP',
`regdate` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'עʱ',
`lastip` char(15) NOT NULL DEFAULT '' COMMENT 'IP',
`lastactivity` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`lastpost` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '΢ʱ',
`credits` int(10) NOT NULL DEFAULT '0' COMMENT 'ܻ',
`extcredits1` int(10) NOT NULL DEFAULT '0' COMMENT 'չֶ1',
`extcredits2` int(10) NOT NULL DEFAULT '0',
`extcredits3` int(10) NOT NULL DEFAULT '0',
`extcredits4` int(10) NOT NULL DEFAULT '0',
`extcredits5` int(10) NOT NULL DEFAULT '0',
`extcredits6` int(10) NOT NULL DEFAULT '0',
`extcredits7` int(10) NOT NULL DEFAULT '0',
`extcredits8` int(10) NOT NULL DEFAULT '0',
`email` char(50) NOT NULL DEFAULT '' COMMENT 'Emailַ',
`bday` date NOT NULL DEFAULT '0000-00-00' COMMENT 'û',
`newpm` tinyint(1) NOT NULL DEFAULT '0' COMMENT '˽',
`face_url` char(60) NOT NULL DEFAULT '' COMMENT 'ͷ洢ĵַ',
`face` char(60) NOT NULL DEFAULT '' COMMENT 'ûͷ',
`tag_count` mediumint(6) NOT NULL DEFAULT '0' COMMENT 'ǩ',
`role_id` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ûId',
`role_type` enum('admin','normal') NOT NULL DEFAULT 'normal' COMMENT 'ûͣadmin,normal',
`tag` char(255) NOT NULL DEFAULT '' COMMENT 'ûǩ',
`phone` char(15) NOT NULL DEFAULT '' COMMENT 'ֻ',
`use_tag_count` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ûǩ',
`create_tag_count` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT 'Ҵıǩ',
`image_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͼƬ',
`ucuid` mediumint(8) NOT NULL DEFAULT '0' COMMENT 'صUcUid',
`invite_uid` mediumint(8) unsigned NOT NULL COMMENT 'Uid',
`invite_count` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '',
`invitecode` char(16) NOT NULL DEFAULT '0' COMMENT 'ʱʹõУ',
`topic_count` mediumint(6) unsigned NOT NULL DEFAULT '0' COMMENT '΢',
`at_count` mediumint(6) unsigned NOT NULL DEFAULT '0' COMMENT '@',
`follow_count` mediumint(6) unsigned NOT NULL DEFAULT '0' COMMENT 'ע',
`fans_count` mediumint(6) unsigned NOT NULL DEFAULT '0' COMMENT '˿',
`email2` char(50) NOT NULL DEFAULT '' COMMENT 'Emailַ2',
`qq` char(10) NOT NULL DEFAULT '' COMMENT 'QQ',
`msn` char(50) NOT NULL DEFAULT '' COMMENT 'Msn',
`aboutme` char(255) NOT NULL DEFAULT '' COMMENT '',
`aboutmetime` int(10) NOT NULL DEFAULT '0' COMMENT 'ʱ',
`signature` char(30) NOT NULL DEFAULT '' COMMENT 'ǩ',
`signtime` int(10) NOT NULL DEFAULT '0' COMMENT 'ǩʱ',
`at_new` smallint(4) NOT NULL DEFAULT '0' COMMENT '@ҵ',
`comment_new` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT 'ҵ',
`event_new` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '',
`fans_new` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '·˿',
`vote_new` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱ',
`qun_new` smallint(4) NOT NULL DEFAULT '0' COMMENT 'ȺϢ',
`topic_new` smallint(4) NOT NULL DEFAULT '0' COMMENT '΢',
`topic_favorite_count` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '΢ղ',
`tag_favorite_count` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT 'ǩղ',
`disallow_beiguanzhu` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ע',
`validate` tinyint(1) NOT NULL DEFAULT '0' COMMENT '֤',
`validate_category` tinyint(1) NOT NULL DEFAULT '0' COMMENT '֤Id',
`favoritemy_new` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT 'ղ΢',
`notice_at` tinyint(2) NOT NULL DEFAULT '0' COMMENT '@ҵ',
`notice_pm` tinyint(2) NOT NULL DEFAULT '0' COMMENT '˽',
`notice_reply` tinyint(2) NOT NULL DEFAULT '0' COMMENT 'ظ',
`user_notice_time` int(10) NOT NULL DEFAULT '0' COMMENT 'ʱ',
`last_notice_time` int(10) NOT NULL DEFAULT '0',
`companyid` int(6) NOT NULL default '0',
`company` char(50) NOT NULL default '',
`departmentid` int(6) NOT NULL default '0',
`department` char(50) NOT NULL default '',
`theme_id` char(6) NOT NULL DEFAULT '' COMMENT 'ƤId',
`theme_bg_image` char(60) NOT NULL DEFAULT '' COMMENT 'Ƥ',
`theme_bg_color` char(7) NOT NULL DEFAULT '' COMMENT 'Ƥʽ',
`theme_text_color` char(7) NOT NULL DEFAULT '',
`theme_link_color` char(7) NOT NULL DEFAULT '',
`theme_bg_image_type` enum('repeat','center','left','right','bottom') NOT NULL DEFAULT 'repeat',
`theme_bg_repeat` tinyint(1) NOT NULL,
`theme_bg_fixed` tinyint(1) NOT NULL,
`last_topic_content_id` int(10) NOT NULL DEFAULT '0' COMMENT 'һη΢Id',
`level` int(10) NOT NULL COMMENT 'ȼ',
`style_three_tol` tinyint(3) NOT NULL DEFAULT '0',
`province` char(16) NOT NULL DEFAULT '' COMMENT 'ʡ',
`city` char(16) NOT NULL DEFAULT '' COMMENT '',
`area` char(16) NOT NULL DEFAULT '' COMMENT '',
`street` char(16) NOT NULL DEFAULT '' COMMENT 'ֵ',
`qmd_url` char(60) NOT NULL DEFAULT '' COMMENT 'ǩַ',
`event_post_new` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '»',
`fenlei_post_new` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '·',
`qmd_img` char(30) NOT NULL COMMENT 'ǩͼƬַ',
`open_extra` tinyint(1) NOT NULL DEFAULT '0' COMMENT '֤ûר״̬',
PRIMARY KEY (`uid`),
UNIQUE KEY `username` (`username`),
KEY `nickname` (`nickname`),
KEY `email` (`email`),
KEY `role_id` (`role_id`),
KEY `ucuid` (`ucuid`),
KEY `companytid` (`companyid`),
KEY `departmentid` (`departmentid`),
KEY `phone` (`phone`),
KEY `lastactivity` (`lastactivity`),
KEY `invite_uid` (`invite_uid`),
KEY `province_city` (`province`,`city`),
KEY `credits` (`credits`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_members_verify`;
CREATE TABLE `jishigou_members_verify` (
`id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
`uid` mediumint(8) unsigned NOT NULL,
`nickname` char(15) NOT NULL DEFAULT '' COMMENT 'ûǳ',
`face_url` char(60) NOT NULL DEFAULT '',
`face` char(60) NOT NULL DEFAULT '' COMMENT 'ûͷ',
`signature` char(30) NOT NULL DEFAULT '' COMMENT 'ǩ',
`is_sign` tinyint(1) NOT NULL DEFAULT '0',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_my_tag`;
CREATE TABLE `jishigou_my_tag` (
`user_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
`tag_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ǩId',
`total_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
`topic_count` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT '΢',
PRIMARY KEY (`user_id`,`tag_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_my_topic_tag`;
CREATE TABLE `jishigou_my_topic_tag` (
`user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`item_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
`tag_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
`count` smallint(4) unsigned NOT NULL DEFAULT '1' COMMENT 'ͳ',
PRIMARY KEY (`user_id`,`item_id`,`tag_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_notice`;
CREATE TABLE `jishigou_notice` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`title` char(200) NOT NULL DEFAULT '' COMMENT '',
`content` text NOT NULL COMMENT '',
`dateline` int(10) NOT NULL DEFAULT '0' COMMENT 'ʱ',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_output`;
CREATE TABLE `jishigou_output` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'վ۵Id',
`name` char(100) NOT NULL COMMENT 'վ۵',
`hash` char(32) NOT NULL COMMENT 'hash',
`lock_host` text NOT NULL COMMENT '',
`per_page_num` int(10) unsigned NOT NULL DEFAULT '20' COMMENT 'ÿҳʾ΢',
`content_default` char(100) NOT NULL COMMENT '΢Ĭʾ',
`type_first` tinyint(1) NOT NULL COMMENT 'ͬ΢ѡĬֵ',
`open_times` int(10) unsigned NOT NULL COMMENT 'ô',
`uid` mediumint(8) unsigned NOT NULL COMMENT 'ûUid',
`dateline` int(10) unsigned NOT NULL COMMENT 'ʱ',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_plugin`;
CREATE TABLE `jishigou_plugin` (
`pluginid` smallint(6) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
`available` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿ',
`adminid` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Աid',
`name` varchar(40) NOT NULL DEFAULT '' COMMENT '',
`identifier` varchar(40) NOT NULL DEFAULT '' COMMENT 'Ψһʶ',
`description` varchar(255) NOT NULL DEFAULT '' COMMENT '˵',
`datatables` varchar(255) NOT NULL DEFAULT '' COMMENT 'ݱ',
`directory` varchar(100) NOT NULL DEFAULT '' COMMENT 'Ŀ¼',
`copyright` varchar(100) NOT NULL DEFAULT '' COMMENT 'ȨϢ',
`modules` text NOT NULL COMMENT 'Ϣ',
`version` varchar(20) NOT NULL DEFAULT '' COMMENT '汾',
PRIMARY KEY (`pluginid`),
UNIQUE KEY `identifier` (`identifier`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_plugin_company`;
CREATE TABLE `jishigou_plugin_company` (
`cid` int(10) unsigned NOT NULL AUTO_INCREMENT,
`uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`uccid` int(10) unsigned NOT NULL DEFAULT '0',
`username` varchar(50) NOT NULL DEFAULT '',
`companyname` varchar(200) NOT NULL DEFAULT '' COMMENT 'ҵ',
`companyid` varchar(80) NOT NULL DEFAULT '',
`ceoname` varchar(20) NOT NULL DEFAULT '',
`userid` varchar(30) NOT NULL DEFAULT '',
`address` varchar(250) NOT NULL DEFAULT '' COMMENT 'ַ',
`tel` varchar(30) NOT NULL DEFAULT '' COMMENT '绰',
`ptime` int(10) NOT NULL DEFAULT '0',
`ison` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ͼ',
`descripction` text COMMENT '',
PRIMARY KEY (`cid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_pluginvar`;
CREATE TABLE `jishigou_pluginvar` (
`pluginvarid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
`pluginid` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT 'id',
`displayorder` tinyint(3) NOT NULL DEFAULT '0' COMMENT 'ʾ˳',
`title` varchar(100) NOT NULL DEFAULT '' COMMENT '',
`description` varchar(255) NOT NULL DEFAULT '' COMMENT '˵',
`variable` varchar(40) NOT NULL DEFAULT '' COMMENT '',
`type` varchar(20) NOT NULL DEFAULT 'text' COMMENT '',
`value` text NOT NULL COMMENT 'ֵ',
`extra` text NOT NULL COMMENT '',
PRIMARY KEY (`pluginvarid`),
KEY `pluginid` (`pluginid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_pms`;
CREATE TABLE `jishigou_pms` (
`pmid` int(10) unsigned NOT NULL AUTO_INCREMENT,
`msgfrom` char(15) NOT NULL DEFAULT '' COMMENT '˽',
`msgnickname` char(15) NOT NULL DEFAULT '',
`msgfromid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`msgto` char(15) NOT NULL DEFAULT '' COMMENT '˽ŷ͸',
`tonickname` char(15) NOT NULL DEFAULT '',
`msgtoid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`folder` enum('inbox','outbox') NOT NULL DEFAULT 'inbox',
`new` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ǷѶ',
`subject` varchar(75) NOT NULL DEFAULT '',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`message` text NOT NULL COMMENT '',
`delstatus` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'ɾ״̬',
`is_hi` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿǻظ',
`topmid` int(11) NOT NULL DEFAULT '0',
`plid` mediumint(8) NOT NULL DEFAULT '0' COMMENT 'ID',
PRIMARY KEY (`pmid`),
KEY `msgtoid` (`msgtoid`,`folder`,`dateline`),
KEY `msgfromid` (`msgfromid`,`folder`,`dateline`),
KEY `uids` (`plid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_pms_index`;
CREATE TABLE `jishigou_pms_index` (
`plid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
`uids` char(17) NOT NULL,
PRIMARY KEY (`plid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_pms_list`;
CREATE TABLE `jishigou_pms_list` (
`plid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`pmnum` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '˽',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`lastmessage` text NOT NULL COMMENT '˽Ϣ',
`is_new` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ǷѶ',
PRIMARY KEY (`plid`,`uid`),
KEY `dateline` (`dateline`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_qqwb_bind_info`;
CREATE TABLE `jishigou_qqwb_bind_info` (
`uid` int(10) unsigned NOT NULL,
`qqwb_username` char(20) NOT NULL DEFAULT '' COMMENT 'QQ΢û',
`token` char(32) NOT NULL COMMENT 'QQ΢Token',
`tsecret` char(32) NOT NULL COMMENT 'QQ΢Tsecret',
`dateline` int(10) unsigned NOT NULL COMMENT 'ʱ',
`synctoqq` tinyint(1) NOT NULL,
PRIMARY KEY (`uid`),
UNIQUE KEY `qqwb_username` (`qqwb_username`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_qqwb_bind_topic`;
CREATE TABLE `jishigou_qqwb_bind_topic` (
`tid` int(10) unsigned NOT NULL COMMENT '΢Id',
`qqwb_id` bigint(20) unsigned NOT NULL COMMENT 'QQ΢Id',
KEY `tid` (`tid`),
KEY `qqwb_id` (`qqwb_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_qun`;
CREATE TABLE `jishigou_qun` (
`qid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ȺId',
`cat_id` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT 'ȺId',
`name` char(50) NOT NULL COMMENT 'Ⱥ',
`icon` char(60) NOT NULL COMMENT 'Ⱥͼ',
`desc` char(200) NOT NULL COMMENT 'Ⱥ',
`founderuid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'Uid',
`foundername` char(15) NOT NULL,
`level` smallint(6) unsigned NOT NULL DEFAULT '0',
`credits` int(10) unsigned NOT NULL DEFAULT '0',
`province` char(16) NOT NULL,
`city` char(16) NOT NULL,
`recd` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƽ',
`join_type` tinyint(1) unsigned NOT NULL DEFAULT '0',
`gview_perm` tinyint(1) unsigned NOT NULL DEFAULT '0',
`member_num` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'Ա',
`topic_num` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '΢',
`thread_num` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`closed` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ⱥ״̬',
`qun_theme_id` char(6) NOT NULL DEFAULT '' COMMENT 'Ⱥʽ',
`postip` char(15) NOT NULL DEFAULT '0' COMMENT 'IPַ',
`lastactivity` int(10) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`qid`),
KEY `cat_id` (`cat_id`),
KEY `founderuid` (`founderuid`),
KEY `lastactivity` (`lastactivity`),
KEY `dateline` (`dateline`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_qun_announcement`;
CREATE TABLE `jishigou_qun_announcement` (
`id` int(10) NOT NULL AUTO_INCREMENT,
`author` char(15) NOT NULL,
`qid` int(10) unsigned NOT NULL DEFAULT '0',
`author_id` mediumint(9) unsigned NOT NULL DEFAULT '0',
`message` text NOT NULL,
`dateline` int(10) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_qun_apply`;
CREATE TABLE `jishigou_qun_apply` (
`qid` int(10) unsigned NOT NULL,
`uid` mediumint(8) unsigned NOT NULL,
`username` varchar(15) NOT NULL,
`message` varchar(255) NOT NULL,
`apply_time` int(10) unsigned NOT NULL,
PRIMARY KEY (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_qun_category`;
CREATE TABLE `jishigou_qun_category` (
`cat_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
`cat_name` char(15) NOT NULL,
`qun_num` int(10) unsigned NOT NULL DEFAULT '0',
`parent_id` smallint(6) unsigned NOT NULL DEFAULT '0',
`display_order` smallint(6) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_qun_event`;
CREATE TABLE `jishigou_qun_event` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`qid` int(10) unsigned NOT NULL DEFAULT '0',
`eid` int(10) NOT NULL DEFAULT '0',
`recd` tinyint(1) NOT NULL DEFAULT '0',
PRIMARY KEY (`id`),
KEY `q_e_id` (`qid`,`eid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_qun_level`;
CREATE TABLE `jishigou_qun_level` (
`level_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
`level_name` char(20) NOT NULL,
`credits_higher` int(10) NOT NULL DEFAULT '0',
`credits_lower` int(10) NOT NULL DEFAULT '0',
`member_num` int(10) unsigned NOT NULL DEFAULT '0',
`admin_num` smallint(6) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`level_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_qun_ploy`;
CREATE TABLE `jishigou_qun_ploy` (
`id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
`fans_num_min` int(10) unsigned NOT NULL DEFAULT '0',
`fans_num_max` int(10) unsigned NOT NULL DEFAULT '0',
`topics_higher` int(10) unsigned NOT NULL DEFAULT '0',
`topics_lower` int(10) unsigned NOT NULL DEFAULT '0',
`qun_num` int(10) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_qun_tag`;
CREATE TABLE `jishigou_qun_tag` (
`tag_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`tag_name` char(30) NOT NULL,
`count` mediumint(8) unsigned NOT NULL DEFAULT '0',
`dateline` int(10) NOT NULL DEFAULT '0',
PRIMARY KEY (`tag_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_qun_tag_fields`;
CREATE TABLE `jishigou_qun_tag_fields` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`tag_id` int(10) unsigned NOT NULL DEFAULT '0',
`qid` int(10) unsigned NOT NULL DEFAULT '0',
`tag_name` char(30) NOT NULL,
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_qun_user`;
CREATE TABLE `jishigou_qun_user` (
`qid` int(10) unsigned NOT NULL,
`uid` mediumint(8) unsigned NOT NULL,
`username` char(15) NOT NULL,
`level` tinyint(3) unsigned NOT NULL DEFAULT '0',
`join_time` int(10) unsigned NOT NULL DEFAULT '0',
`lastupdate` int(10) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`qid`,`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_qun_vote`;
CREATE TABLE `jishigou_qun_vote` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`qid` int(10) unsigned NOT NULL DEFAULT '0',
`vid` int(10) NOT NULL DEFAULT '0',
`recd` tinyint(1) NOT NULL DEFAULT '0',
PRIMARY KEY (`id`),
KEY `q_vid` (`qid`,`vid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_renren_bind_info`;
CREATE TABLE `jishigou_renren_bind_info` (
`uid` int(10) unsigned NOT NULL,
`renren_uid` char(32) NOT NULL default '',
`renren_name` char(32) NOT NULL default '',
`renren_sex` char(10) NOT NULL default '' COMMENT 'Ա',
`renren_star` char(10) NOT NULL default '',
`renren_headurl` char(64) NOT NULL default '' COMMENT 'ͷ',
`token` char(128) NOT NULL,
`token_time` int(10) NOT NULL,
`token_expire` int(10) NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY  (`uid`),
UNIQUE KEY `renren_uid` (`renren_uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_renren_bind_topic`;
CREATE TABLE `jishigou_renren_bind_topic` (
`tid` int(10) unsigned NOT NULL,
`renren_id` bigint(20) unsigned NOT NULL COMMENT 'Id',
KEY `tid` (`tid`),
KEY `renren_id` (`renren_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_report`;
CREATE TABLE `jishigou_report` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ݾٱId',
`uid` mediumint(8) NOT NULL DEFAULT '0' COMMENT 'ٱUid',
`username` char(15) NOT NULL DEFAULT '',
`ip` char(15) NOT NULL DEFAULT '' COMMENT 'ٱIPַ',
`type` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ٱ',
`reason` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ٱԭ',
`content` text NOT NULL COMMENT '',
`tid` int(10) NOT NULL DEFAULT '0' COMMENT '΢Id',
`dateline` int(10) NOT NULL DEFAULT '0' COMMENT 'ʱ',
`process_user` char(15) NOT NULL DEFAULT '' COMMENT '',
`process_time` int(10) NOT NULL DEFAULT '0' COMMENT 'ʱ',
`process_result` tinyint(1) NOT NULL DEFAULT '0' COMMENT '',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_robot`;
CREATE TABLE `jishigou_robot` (
`name` char(50) NOT NULL DEFAULT '' COMMENT '',
`times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʴ',
`first_visit` int(10) NOT NULL DEFAULT '0' COMMENT 'ηʱ',
`last_visit` int(10) NOT NULL DEFAULT '0' COMMENT 'ʱ',
`agent` char(255) NOT NULL DEFAULT '' COMMENT 'UserAgent',
`disallow` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿֹ',
PRIMARY KEY (`name`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_robot_ip`;
CREATE TABLE `jishigou_robot_ip` (
`ip` char(15) NOT NULL DEFAULT '' COMMENT 'IPַ',
`name` char(50) NOT NULL DEFAULT '' COMMENT '',
`times` int(10) unsigned NOT NULL DEFAULT '0',
`first_visit` int(10) NOT NULL DEFAULT '0',
`last_visit` int(10) NOT NULL DEFAULT '0',
PRIMARY KEY (`ip`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_robot_log`;
CREATE TABLE `jishigou_robot_log` (
`name` char(50) NOT NULL DEFAULT '' COMMENT '',
`date` date NOT NULL DEFAULT '0000-00-00' COMMENT 'ʱ',
`times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʴ',
`first_visit` int(10) unsigned NOT NULL DEFAULT '0',
`last_visit` int(10) unsigned NOT NULL DEFAULT '0',
UNIQUE KEY `name` (`name`,`date`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_role`;
CREATE TABLE `jishigou_role` (
`id` tinyint(1) unsigned NOT NULL AUTO_INCREMENT,
`name` varchar(50) NOT NULL DEFAULT '' COMMENT 'ûɫ',
`creditshigher` int(10) NOT NULL DEFAULT '0',
`creditslower` int(10) NOT NULL DEFAULT '0',
`privilege` mediumtext NOT NULL COMMENT 'ӵеȨ',
`type` enum('normal','admin') NOT NULL DEFAULT 'normal' COMMENT '',
`rank` tinyint(1) unsigned NOT NULL DEFAULT '0',
`icon` char(50) NOT NULL COMMENT 'ͼ',
`allow_sendpm_to` text NOT NULL COMMENT '˽Ȩ',
`allow_sendpm_from` text NOT NULL,
`allow_topic_forward_to` text NOT NULL COMMENT 'ת΢Ȩ',
`allow_topic_forward_from` text NOT NULL,
`allow_topic_reply_to` text NOT NULL COMMENT 'Ȩ',
`allow_topic_reply_from` text NOT NULL,
`allow_topic_at_to` text NOT NULL COMMENT '@Ȩ',
`allow_topic_at_from` text NOT NULL,
`allow_follow_to` text NOT NULL COMMENT 'עȨ',
`allow_follow_from` text NOT NULL,
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_role_action`;
CREATE TABLE `jishigou_role_action` (
`id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
`name` varchar(255) NOT NULL DEFAULT '' COMMENT '',
`module` varchar(50) NOT NULL DEFAULT 'index' COMMENT 'Modֵ',
`action` varchar(255) NOT NULL DEFAULT '' COMMENT 'Codeֵ',
`describe` varchar(255) NOT NULL DEFAULT '' COMMENT '',
`message` varchar(255) NOT NULL DEFAULT '' COMMENT 'ȨʱʾϢ',
`allow_all` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿ',
`credit_require` varchar(255) NOT NULL DEFAULT '',
`credit_update` varchar(255) NOT NULL DEFAULT '',
`log` tinyint(1) unsigned NOT NULL DEFAULT '0',
`is_admin` tinyint(1) unsigned DEFAULT '0' COMMENT 'ǷΪ̨Ȩ',
PRIMARY KEY (`id`),
UNIQUE KEY `action` (`module`,`name`,`is_admin`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_role_module`;
CREATE TABLE `jishigou_role_module` (
`module` varchar(50) NOT NULL DEFAULT '' COMMENT 'ģ',
`name` varchar(255) NOT NULL DEFAULT '' COMMENT 'ģ',
UNIQUE KEY `module` (`module`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_schedule`;
CREATE TABLE `jishigou_schedule` (
`id` bigint(20) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id',
`uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`type` char(255) NOT NULL DEFAULT '' COMMENT '',
`vars` text NOT NULL COMMENT 'ز',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_sessions`;
CREATE TABLE `jishigou_sessions` (
`sid` char(6) NOT NULL DEFAULT '' COMMENT 'Session Id',
`ip1` tinyint(1) unsigned NOT NULL DEFAULT '0',
`ip2` tinyint(1) unsigned NOT NULL DEFAULT '0',
`ip3` tinyint(1) unsigned NOT NULL DEFAULT '0',
`ip4` tinyint(1) unsigned NOT NULL DEFAULT '0',
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`action` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT 'زId',
`slastactivity` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
UNIQUE KEY `sid` (`sid`),
KEY `uid` (`uid`)
) ENGINE=HEAP;

DROP TABLE IF EXISTS `jishigou_setting`;
CREATE TABLE `jishigou_setting` (
`key` char(255) NOT NULL COMMENT 'վñKey',
`val` text NOT NULL COMMENT 'վñ',
PRIMARY KEY (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_share`;
CREATE TABLE `jishigou_share` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`name` char(50) NOT NULL COMMENT '',
`type` char(20) NOT NULL COMMENT '',
`topic_style` text NOT NULL COMMENT '΢ʽ',
`show_style` char(255) NOT NULL COMMENT 'ʾʽ',
`condition` text NOT NULL COMMENT '',
`nickname` char(255) NOT NULL COMMENT 'ûǳ',
`tag` char(255) NOT NULL COMMENT '',
`dateline` int(11) NOT NULL COMMENT 'ʱ',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_sign_tag`;
CREATE TABLE `jishigou_sign_tag` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ǩId',
`tag` text NOT NULL COMMENT 'ǩ',
`credits` char(20) NOT NULL DEFAULT '' COMMENT '',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_site`;
CREATE TABLE `jishigou_site` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'վId',
`host` char(50) NOT NULL,
`name` char(50) NOT NULL,
`description` char(255) NOT NULL COMMENT '',
`dateline` int(10) unsigned NOT NULL,
`url_count` int(10) unsigned NOT NULL COMMENT 'Url',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_sms_client_user`;
CREATE TABLE `jishigou_sms_client_user` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ֻû¼Id',
`uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`username` char(30) NOT NULL DEFAULT '',
`user_im` char(20) NOT NULL DEFAULT '' COMMENT 'ֻ',
`bind_key` char(10) NOT NULL DEFAULT '',
`bind_key_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`try_bind_times` int(10) unsigned NOT NULL DEFAULT '0',
`last_try_bind_time` int(10) unsigned NOT NULL DEFAULT '0',
`send_times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʹ',
`last_send_time` int(10) unsigned NOT NULL DEFAULT '0',
`last_send_message_id` int(10) unsigned NOT NULL DEFAULT '0',
`stop_receive` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'ֹͣգ',
`receive_times` int(10) unsigned NOT NULL DEFAULT '0',
`last_receive_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ϣʱ',
`last_receive_message_id` int(10) unsigned NOT NULL DEFAULT '0',
`reset_password_times` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ĵ',
`last_reset_password_time` int(10) unsigned NOT NULL DEFAULT '0',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`enable` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '',
`t_enable` tinyint(1) unsigned NOT NULL DEFAULT '0',
`p_enable` tinyint(1) unsigned NOT NULL DEFAULT '0',
`m_enable` tinyint(1) unsigned NOT NULL DEFAULT '0',
`f_enable` tinyint(1) unsigned NOT NULL DEFAULT '0',
`share_time` int(10) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`id`),
KEY `uid` (`uid`),
KEY `user_im` (`user_im`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_sms_failedlogins`;
CREATE TABLE `jishigou_sms_failedlogins` (
`ip` char(15) NOT NULL DEFAULT '',
`count` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '',
`lastupdate` int(10) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`ip`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_sms_receive_log`;
CREATE TABLE `jishigou_sms_receive_log` (
`id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ϢLog¼Id',
`uid` mediumint(8) unsigned NOT NULL,
`username` char(15) NOT NULL,
`dateline` int(10) unsigned NOT NULL,
`mobile` char(20) NOT NULL DEFAULT '' COMMENT '',
`message` text NOT NULL COMMENT 'Ϣ',
`msg_id` char(20) NOT NULL,
`status` tinyint(1) NOT NULL COMMENT '״̬',
`tid` int(10) unsigned NOT NULL COMMENT 'topic id',
PRIMARY KEY (`id`),
KEY `dateline` (`dateline`),
KEY `uid` (`uid`),
KEY `mobile` (`mobile`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_sms_send_log`;
CREATE TABLE `jishigou_sms_send_log` (
`id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ϢLog¼Id',
`uid` mediumint(8) unsigned NOT NULL,
`username` char(15) NOT NULL,
`dateline` int(10) unsigned NOT NULL,
`mobile` char(20) NOT NULL DEFAULT '' COMMENT '',
`message` text NOT NULL COMMENT '',
`msg_id` char(20) NOT NULL,
`status` tinyint(1) NOT NULL COMMENT '״̬',
PRIMARY KEY (`id`),
KEY `dateline` (`dateline`),
KEY `uid` (`uid`),
KEY `mobile` (`mobile`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_sms_send_queue`;
CREATE TABLE `jishigou_sms_send_queue` (
`to` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
`message` text NOT NULL COMMENT '',
`salt` char(10) NOT NULL DEFAULT '',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ϣʱ',
UNIQUE KEY `to` (`to`),
KEY `dateline` (`dateline`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_tag`;
CREATE TABLE `jishigou_tag` (
`id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT 'Id',
`name` char(30) NOT NULL DEFAULT '',
`user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`username` char(15) NOT NULL DEFAULT '',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`last_post` int(10) unsigned NOT NULL DEFAULT '0',
`total_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͳ',
`user_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
`topic_count` mediumint(8) unsigned NOT NULL DEFAULT '0',
`tag_count` mediumint(8) NOT NULL DEFAULT '0',
`status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '״̬',
`extra` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿչ',
PRIMARY KEY (`id`),
UNIQUE KEY `name` (`name`),
KEY `total_count` (`total_count`),
KEY `last_post` (`last_post`),
KEY `user_id` (`user_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_tag_extra`;
CREATE TABLE `jishigou_tag_extra` (
`id` int(10) unsigned NOT NULL COMMENT 'չId',
`name` char(50) NOT NULL,
`data` longtext NOT NULL COMMENT 'ʱ',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_tag_favorite`;
CREATE TABLE `jishigou_tag_favorite` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ղId',
`tag` char(64) NOT NULL DEFAULT '' COMMENT '',
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
PRIMARY KEY (`id`),
KEY `tag` (`tag`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_tag_recommend`;
CREATE TABLE `jishigou_tag_recommend` (
`id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'ƼId',
`name` char(50) NOT NULL COMMENT '',
`desc` text NOT NULL COMMENT '',
`uid` mediumint(8) NOT NULL COMMENT 'ûUid',
`username` char(30) NOT NULL,
`dateline` int(10) NOT NULL COMMENT 'ʱ',
`last_update` int(10) NOT NULL COMMENT 'ʱ',
`order` int(10) NOT NULL COMMENT '',
`enable` tinyint(1) NOT NULL DEFAULT '1' COMMENT 'Ƿã',
PRIMARY KEY (`id`),
KEY `order` (`order`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_talk`;
CREATE TABLE `jishigou_talk` (
`lid` int(11) NOT NULL AUTO_INCREMENT,
`cat_id` int(11) unsigned NOT NULL,
`talkname` varchar(60) NOT NULL,
`description` text NOT NULL,
`starttime` int(10) unsigned NOT NULL DEFAULT '0',
`endtime` int(10) unsigned NOT NULL DEFAULT '0',
`image` varchar(100) NOT NULL,
PRIMARY KEY (`lid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_talk_category`;
CREATE TABLE `jishigou_talk_category` (
`cat_id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
`cat_name` char(15) NOT NULL,
`talk_num` int(10) unsigned NOT NULL DEFAULT '0',
`parent_id` smallint(6) unsigned NOT NULL DEFAULT '0',
`display_order` smallint(6) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`cat_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_task`;
CREATE TABLE `jishigou_task` (
`id` smallint(4) unsigned NOT NULL AUTO_INCREMENT,
`available` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ǷЧ',
`type` enum('user','system') NOT NULL DEFAULT 'user' COMMENT '',
`name` char(50) NOT NULL DEFAULT '' COMMENT '',
`filename` char(50) NOT NULL DEFAULT '',
`lastrun` int(10) unsigned NOT NULL DEFAULT '0',
`nextrun` int(10) unsigned NOT NULL DEFAULT '0',
`weekday` tinyint(1) NOT NULL DEFAULT '0',
`day` tinyint(1) NOT NULL DEFAULT '0',
`hour` tinyint(1) NOT NULL DEFAULT '0',
`minute` char(36) NOT NULL DEFAULT '',
PRIMARY KEY (`id`),
KEY `nextrun` (`available`,`nextrun`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_task_log`;
CREATE TABLE `jishigou_task_log` (
`id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'Log¼Id',
`task_id` int(10) unsigned NOT NULL DEFAULT '0',
`exec_time` float unsigned NOT NULL DEFAULT '0' COMMENT 'ִʱ',
`message` text NOT NULL COMMENT 'Ϣ',
`error` int(10) NOT NULL DEFAULT '0' COMMENT '',
`dateline` int(10) NOT NULL DEFAULT '0' COMMENT 'ʱ',
`ip` varchar(16) NOT NULL DEFAULT '0' COMMENT 'IP',
`username` varchar(15) NOT NULL DEFAULT '',
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`agent` varchar(255) NOT NULL DEFAULT '',
PRIMARY KEY (`id`),
KEY `uid` (`uid`),
KEY `task_id` (`task_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic`;
CREATE TABLE `jishigou_topic` (
`tid` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '΢Tid',
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`username` char(15) NOT NULL DEFAULT '',
`content` char(255) NOT NULL DEFAULT '' COMMENT '΢',
`content2` char(255) NOT NULL DEFAULT '',
`imageid` char(100) NOT NULL DEFAULT '' COMMENT 'ͼƬ',
`videoid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƶ',
`musicid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '',
`longtextid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƿ',
`attachid` char(100) NOT NULL DEFAULT '' COMMENT 'ظ',
`roottid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ԭʼ΢Tid',
`replys` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT 'ظ',
`forwards` smallint(6) NOT NULL DEFAULT '0' COMMENT 'ת',
`totid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ظ/ת΢Tid',
`touid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ظ/תûUid',
`tousername` char(15) NOT NULL DEFAULT '',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`lastupdate` int(10) unsigned NOT NULL DEFAULT '0',
`from` enum('web','wap','mobile','qq','msn','api','sina','qqwb','vote','qun','event','android','iphone','ipad','sms','androidpad','fenlei','reward') NOT NULL DEFAULT 'web' COMMENT '΢',
`type` char(15) NOT NULL DEFAULT '' COMMENT '΢',
`item_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'صItemId',
`item` char(15) NOT NULL DEFAULT '',
`postip` char(15) NOT NULL DEFAULT '' COMMENT 'IPַ',
`managetype` tinyint(1) NOT NULL DEFAULT '0',
PRIMARY KEY (`tid`),
KEY `uid_type` (`uid`,`type`),
KEY `dateline` (`dateline`),
KEY `managetype` (`managetype`),
KEY `item_id_item` (`item_id`,`item`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_api`;
CREATE TABLE `jishigou_topic_api` (
`tid` int(10) unsigned NOT NULL DEFAULT '0',
`item_id` int(10) unsigned NOT NULL DEFAULT '0',
`uid` mediumint(8) unsigned NOT NULL,
PRIMARY KEY (`tid`,`item_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_attach`;
CREATE TABLE `jishigou_topic_attach` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`tid` int(10) NOT NULL DEFAULT '0' COMMENT '΢Tid',
`site_url` char(255) NOT NULL DEFAULT '',
`file` char(255) NOT NULL DEFAULT '',
`name` char(255) NOT NULL DEFAULT '',
`description` char(255) NOT NULL DEFAULT '',
`filesize` int(10) unsigned NOT NULL DEFAULT '0',
`filetype` varchar(10) NOT NULL DEFAULT '',
`uid` mediumint(8) unsigned DEFAULT '0',
`username` char(15) NOT NULL DEFAULT '',
`dateline` int(10) unsigned NOT NULL DEFAULT '0',
`file_url` char(255) NOT NULL DEFAULT '',
`item` char(100) NOT NULL DEFAULT '',
`itemid` int(10) unsigned NOT NULL DEFAULT '0',
`download` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ش',
`score` int(10) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`id`),
KEY `tid` (`tid`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_event`;
CREATE TABLE `jishigou_topic_event` (
`tid` int(10) unsigned NOT NULL DEFAULT '0',
`item_id` int(10) unsigned NOT NULL DEFAULT '0',
`uid` mediumint(8) unsigned NOT NULL,
PRIMARY KEY (`tid`,`item_id`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_favorite`;
CREATE TABLE `jishigou_topic_favorite` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '΢ղId',
`tid` int(10) unsigned NOT NULL DEFAULT '0',
`tuid` mediumint(10) unsigned NOT NULL DEFAULT '0',
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '΢ղصʱ',
PRIMARY KEY (`id`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_image`;
CREATE TABLE `jishigou_topic_image` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '΢ͼƬId',
`tid` int(10) NOT NULL DEFAULT '0' COMMENT '΢Tid',
`site_url` char(255) NOT NULL DEFAULT '',
`photo` char(255) NOT NULL DEFAULT '' COMMENT 'ͼƬַ',
`name` char(255) NOT NULL DEFAULT '' COMMENT '',
`description` char(255) NOT NULL DEFAULT '' COMMENT '',
`filesize` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'С',
`width` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '',
`height` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '',
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`username` char(15) NOT NULL DEFAULT '',
`item` char(100) NOT NULL DEFAULT '',
`itemid` int(10) unsigned NOT NULL DEFAULT '0',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`image_url` char(255) NOT NULL COMMENT 'ԶͼƬַ',
PRIMARY KEY (`id`),
KEY `tid` (`tid`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_live`;
CREATE TABLE `jishigou_topic_live` (
`tid` int(10) unsigned NOT NULL DEFAULT '0',
`item_id` int(10) unsigned NOT NULL DEFAULT '0',
`uid` mediumint(8) unsigned NOT NULL,
PRIMARY KEY (`tid`,`item_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_longtext`;
CREATE TABLE `jishigou_topic_longtext` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '΢ԭId',
`tid` int(10) unsigned NOT NULL COMMENT '΢ID',
`uid` int(10) unsigned NOT NULL COMMENT 'ûUid',
`username` char(15) NOT NULL DEFAULT '',
`longtext` longtext NOT NULL COMMENT 'ı',
`dateline` int(10) unsigned NOT NULL,
`last_modify` int(10) unsigned NOT NULL COMMENT '༭ʱ',
`modify_times` int(10) unsigned NOT NULL COMMENT '༭',
`views` int(10) unsigned NOT NULL COMMENT '鿴',
PRIMARY KEY (`id`),
KEY `tid` (`tid`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_mention`;
CREATE TABLE `jishigou_topic_mention` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '΢@Id',
`tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '΢Tid',
`tuid` mediumint(8) unsigned NOT NULL default '0' COMMENT '΢ûuid',
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ûUid',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
PRIMARY KEY (`id`),
KEY `tuid` (`tuid`),
KEY `uid` (`uid`),
KEY `tid` (`tid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_more`;
CREATE TABLE `jishigou_topic_more` (
`tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '΢Id',
`parents` text NOT NULL COMMENT 'ظ/ת΢Id',
`replyids` longtext NOT NULL COMMENT 'Id',
`replyidscount` smallint(4) unsigned NOT NULL DEFAULT '0' COMMENT '',
PRIMARY KEY (`tid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_music`;
CREATE TABLE `jishigou_topic_music` (
`id` int(11) NOT NULL AUTO_INCREMENT COMMENT '΢Id',
`uid` int(11) NOT NULL DEFAULT '0',
`tid` int(11) NOT NULL DEFAULT '0',
`username` varchar(50) NOT NULL DEFAULT '',
`music_url` varchar(255) NOT NULL DEFAULT '' COMMENT 'ֵַ',
`dateline` int(11) NOT NULL DEFAULT '0',
`xiami_id` int(20) NOT NULL DEFAULT '0' COMMENT 'xiamiId',
PRIMARY KEY (`id`),
KEY `uid` (`uid`),
KEY `tid` (`tid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_qun`;
CREATE TABLE `jishigou_topic_qun` (
`tid` int(10) unsigned NOT NULL,
`item_id` int(10) unsigned NOT NULL,
`uid` mediumint(8) unsigned NOT NULL,
PRIMARY KEY (`tid`,`item_id`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_recommend`;
CREATE TABLE `jishigou_topic_recommend` (
`tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƽ΢Tid',
`item` char(15) NOT NULL,
`item_id` int(10) unsigned NOT NULL DEFAULT '0',
`recd` tinyint(1) unsigned NOT NULL,
`display_order` smallint(6) unsigned NOT NULL DEFAULT '0' COMMENT 'д',
`expiration` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƽʱ',
PRIMARY KEY (`tid`),
KEY `expiration` (`expiration`),
KEY `recd` (`recd`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_reply`;
CREATE TABLE `jishigou_topic_reply` (
`tid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '΢Tid',
`replyid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '΢Tid',
KEY `tid` (`tid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_show`;
CREATE TABLE `jishigou_topic_show` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`uid` int(11) NOT NULL DEFAULT '0',
`stylevalue` text NOT NULL,
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_tag`;
CREATE TABLE `jishigou_topic_tag` (
`item_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
`tag_id` mediumint(8) unsigned NOT NULL DEFAULT '0',
`dateline` int(10) unsigned NOT NULL DEFAULT '0',
`count` mediumint(6) NOT NULL DEFAULT '0',
PRIMARY KEY (`item_id`,`tag_id`),
KEY `tag_id` (`tag_id`),
KEY `dateline` (`dateline`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_talk`;
CREATE TABLE `jishigou_topic_talk` (
`tid` int(10) unsigned NOT NULL DEFAULT '0',
`item_id` int(10) unsigned NOT NULL DEFAULT '0',
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`touid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`totid` int(10) unsigned NOT NULL DEFAULT '0',
`istop` tinyint(1) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`tid`,`item_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_url`;
CREATE TABLE `jishigou_topic_url` (
`tid` int(10) unsigned NOT NULL,
`item_id` int(10) unsigned NOT NULL,
`uid` mediumint(8) unsigned NOT NULL,
PRIMARY KEY (`tid`,`item_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_verify`;
CREATE TABLE `jishigou_topic_verify` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '΢Id',
`tid` int(10) unsigned NOT NULL,
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`username` char(15) NOT NULL DEFAULT '',
`content` char(255) NOT NULL DEFAULT '',
`content2` char(255) NOT NULL DEFAULT '',
`imageid` char(100) NOT NULL DEFAULT '',
`attachid` char(100) NOT NULL DEFAULT '',
`videoid` int(10) unsigned NOT NULL DEFAULT '0',
`musicid` int(10) unsigned NOT NULL DEFAULT '0',
`longtextid` int(10) unsigned NOT NULL DEFAULT '0',
`roottid` int(10) unsigned NOT NULL DEFAULT '0',
`replys` smallint(4) unsigned NOT NULL DEFAULT '0',
`forwards` smallint(6) NOT NULL DEFAULT '0',
`totid` int(10) unsigned NOT NULL DEFAULT '0',
`touid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`tousername` char(15) NOT NULL DEFAULT '',
`dateline` int(10) unsigned NOT NULL DEFAULT '0',
`lastupdate` int(10) unsigned NOT NULL DEFAULT '0',
`from` enum('web','wap','mobile','qq','msn','api','sina','qqwb','vote','qun','event','android','iphone','ipad','sms','androidpad') NOT NULL DEFAULT 'web',
`type` char(15) NOT NULL DEFAULT '',
`item_id` int(10) unsigned NOT NULL DEFAULT '0',
`item` char(15) NOT NULL DEFAULT '',
`postip` char(15) NOT NULL DEFAULT '',
`managetype` tinyint(1) NOT NULL DEFAULT '0',
PRIMARY KEY (`id`),
KEY `uid_type` (`uid`,`type`),
KEY `dateline` (`dateline`),
KEY `managetype` (`managetype`),
KEY `item_id_item` (`item_id`,`item`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_video`;
CREATE TABLE `jishigou_topic_video` (
`id` int(11) NOT NULL AUTO_INCREMENT COMMENT '΢ƵId',
`uid` int(11) NOT NULL DEFAULT '0' COMMENT 'ûUid',
`tid` int(11) NOT NULL DEFAULT '0' COMMENT '΢Tid',
`username` varchar(50) NOT NULL DEFAULT '',
`video_hosts` varchar(255) NOT NULL DEFAULT '',
`video_link` varchar(255) NOT NULL DEFAULT '' COMMENT 'Ƶַ',
`video_url` varchar(255) NOT NULL DEFAULT '',
`video_img_url` varchar(255) NOT NULL DEFAULT '' COMMENT 'ƵͼƬַ',
`video_img` varchar(255) NOT NULL DEFAULT '',
`dateline` int(11) NOT NULL DEFAULT '0' COMMENT 'ʱ',
PRIMARY KEY (`id`),
KEY `tid` (`tid`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_vote`;
CREATE TABLE `jishigou_topic_vote` (
`tid` int(10) unsigned NOT NULL DEFAULT '0',
`item_id` int(10) unsigned NOT NULL DEFAULT '0',
`uid` mediumint(8) unsigned NOT NULL,
PRIMARY KEY (`tid`,`item_id`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_url`;
CREATE TABLE `jishigou_url` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'UrlַId',
`key` varchar(10) CHARACTER SET gbk COLLATE gbk_bin NOT NULL DEFAULT '' COMMENT 'Key',
`url` text NOT NULL COMMENT 'ַ',
`dateline` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ʱ',
`open_times` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '򿪴',
`url_hash` char(32) NOT NULL DEFAULT '' COMMENT 'ַHash',
`title` varchar(100) NOT NULL,
`description` varchar(255) NOT NULL,
`site_id` int(10) unsigned NOT NULL COMMENT 'վId',
PRIMARY KEY (`id`),
UNIQUE KEY `url_hash` (`url_hash`),
UNIQUE KEY `key` (`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_user_medal`;
CREATE TABLE `jishigou_user_medal` (
`id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ûѫId',
`uid` int(11) NOT NULL COMMENT 'ûUid',
`nickname` char(50) NOT NULL,
`medalid` int(11) NOT NULL COMMENT 'ѫId',
`is_index` tinyint(4) NOT NULL DEFAULT '1',
`dateline` int(11) NOT NULL COMMENT 'ʱ',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_user_tag`;
CREATE TABLE `jishigou_user_tag` (
`id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ûǩId',
`name` char(30) NOT NULL DEFAULT '' COMMENT 'ǩ',
`count` int(11) NOT NULL DEFAULT '0' COMMENT '',
`type` char(20) NOT NULL DEFAULT '',
`dateline` int(11) NOT NULL DEFAULT '0' COMMENT 'ʱ',
PRIMARY KEY (`id`),
KEY `name` (`name`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_user_tag_fields`;
CREATE TABLE `jishigou_user_tag_fields` (
`id` int(11) NOT NULL AUTO_INCREMENT,
`tag_id` int(11) NOT NULL DEFAULT '0',
`uid` int(11) NOT NULL DEFAULT '0',
`tag_name` char(50) NOT NULL DEFAULT '',
PRIMARY KEY (`id`),
KEY `uid` (`uid`),
KEY `tag_id` (`tag_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_validate`;
CREATE TABLE `jishigou_validate` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT,
`item` varchar(20) NOT NULL DEFAULT '',
`item_id` int(10) unsigned NOT NULL DEFAULT '0',
`item_table` varchar(30) NOT NULL DEFAULT '',
`item_table_operation` enum('insert','update') NOT NULL DEFAULT 'update',
`item_sql` text NOT NULL,
`request_uid` int(10) unsigned NOT NULL DEFAULT '0',
`request_username` varchar(15) NOT NULL DEFAULT '',
`request_reason` text NOT NULL,
`request_time` int(10) unsigned NOT NULL DEFAULT '0',
`validate_result` tinyint(1) unsigned NOT NULL DEFAULT '0',
`validate_result_describe` text NOT NULL,
`validate_uid` int(10) unsigned NOT NULL DEFAULT '0',
`validate_username` varchar(15) NOT NULL DEFAULT '',
`validate_time` int(10) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`id`),
KEY `item` (`item_id`,`item_table`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_validate_category`;
CREATE TABLE `jishigou_validate_category` (
`id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
`category_id` int(10) NOT NULL DEFAULT '0' COMMENT 'ID',
`category_name` char(20) NOT NULL COMMENT '',
`category_pic` char(200) NOT NULL COMMENT 'ͼ',
`num` tinyint(4) NOT NULL DEFAULT '0',
`dateline` int(11) NOT NULL DEFAULT '0' COMMENT 'ʱ',
PRIMARY KEY (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_validate_category_fields`;
CREATE TABLE `jishigou_validate_category_fields` (
`id` int(10) NOT NULL AUTO_INCREMENT,
`uid` int(10) NOT NULL,
`category_fid` int(10) NOT NULL COMMENT '֤ID',
`category_id` int(10) NOT NULL COMMENT '֤ID',
`province` char(20) NOT NULL,
`city` char(20) NOT NULL,
`validate_info` char(200) NOT NULL COMMENT 'û֤',
`is_audit` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'Ƿ',
`audit_info` char(200) NOT NULL COMMENT '˱ע',
`order` int(10) NOT NULL COMMENT '',
`is_push` tinyint(1) NOT NULL DEFAULT '0' COMMENT 'ǷƼ',
`dateline` int(10) NOT NULL,
PRIMARY KEY (`id`),
KEY `uid` (`uid`),
KEY `category_fid` (`category_fid`),
KEY `category_id` (`category_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_validate_extra`;
CREATE TABLE `jishigou_validate_extra` (
`id` int(10) NOT NULL,
`data` longtext NOT NULL
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_vote`;
CREATE TABLE `jishigou_vote` (
`vid` int(10) unsigned NOT NULL AUTO_INCREMENT,
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`username` char(15) NOT NULL COMMENT 'û',
`subject` char(80) NOT NULL COMMENT 'ͶƱ˵',
`voter_num` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '',
`reply_num` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT 'ظ',
`maxchoice` tinyint(3) unsigned NOT NULL DEFAULT '0',
`multiple` tinyint(1) unsigned NOT NULL DEFAULT '0',
`is_view` tinyint(1) unsigned NOT NULL DEFAULT '1',
`recd` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT 'Ƽ',
`expiration` int(10) unsigned NOT NULL DEFAULT '0',
`lastvote` int(10) unsigned NOT NULL DEFAULT '0' COMMENT 'ͶƱʱ',
`dateline` int(10) unsigned NOT NULL DEFAULT '0',
`postip` char(15) NOT NULL DEFAULT '' COMMENT 'IP',
`item` char(15) NOT NULL DEFAULT '' COMMENT 'Ӧ',
`item_id` int(10) NOT NULL DEFAULT '0' COMMENT 'ӦID',
`verify` tinyint(1) NOT NULL DEFAULT '1' COMMENT '',
PRIMARY KEY (`vid`),
KEY `uid` (`uid`),
KEY `dateline` (`dateline`),
KEY `lastvote` (`lastvote`),
KEY `voter_num` (`voter_num`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_vote_field`;
CREATE TABLE `jishigou_vote_field` (
`vid` int(10) unsigned NOT NULL,
`message` text NOT NULL,
`option` text NOT NULL,
PRIMARY KEY (`vid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_vote_option`;
CREATE TABLE `jishigou_vote_option` (
`oid` int(10) unsigned NOT NULL AUTO_INCREMENT,
`vid` int(10) unsigned NOT NULL DEFAULT '0',
`vote_num` mediumint(8) unsigned NOT NULL DEFAULT '0',
`option` varchar(100) NOT NULL,
PRIMARY KEY (`oid`),
KEY `vid` (`vid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_vote_user`;
CREATE TABLE `jishigou_vote_user` (
`uid` mediumint(8) unsigned NOT NULL,
`username` varchar(15) NOT NULL,
`vid` int(10) unsigned NOT NULL,
`option` text NOT NULL,
`dateline` int(10) unsigned NOT NULL DEFAULT '0',
PRIMARY KEY (`uid`,`vid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_wall`;
CREATE TABLE `jishigou_wall` (
`id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '΢ǽId',
`uid` mediumint(8) unsigned NOT NULL COMMENT 'ûUid',
`status` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '״̬',
`show_mod` tinyint(1) NOT NULL COMMENT 'ʾģʽ',
`wall_reload_time` tinyint(1) unsigned NOT NULL DEFAULT '5' COMMENT 'Զǽʱ',
`last_load_time` int(10) unsigned NOT NULL COMMENT 'ʱ',
`last_load_tid` int(10) unsigned NOT NULL COMMENT '΢',
`auto_wall_tid` int(10) unsigned NOT NULL COMMENT 'ԶǽTid',
`auto_wall_tag` char(255) NOT NULL COMMENT 'Զǽ',
`screen_ad_top` text NOT NULL COMMENT 'Ļ',
`screen_ad_left` text NOT NULL COMMENT 'Ļ',
`screen_ad_right` text NOT NULL COMMENT 'ĻҲ',
PRIMARY KEY (`id`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_wall_draft`;
CREATE TABLE `jishigou_wall_draft` (
`wall_id` int(10) unsigned NOT NULL,
`tid` int(10) unsigned NOT NULL COMMENT 'ݸ΢Tid',
`mark` tinyint(1) unsigned NOT NULL,
PRIMARY KEY (`wall_id`,`tid`,`mark`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_wall_material`;
CREATE TABLE `jishigou_wall_material` (
`wall_id` int(10) unsigned NOT NULL,
`type` tinyint(1) unsigned NOT NULL,
`key` char(255) NOT NULL COMMENT 'ղصĹؼ',
PRIMARY KEY (`wall_id`,`type`,`key`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_wall_playlist`;
CREATE TABLE `jishigou_wall_playlist` (
`wall_id` int(10) unsigned NOT NULL COMMENT '΢ǽId',
`tid` int(10) unsigned NOT NULL COMMENT '΢Tid',
`order` int(10) unsigned NOT NULL COMMENT '΢ǽб',
PRIMARY KEY (`wall_id`,`tid`),
KEY `order` (`order`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_xwb_bind_info`;
CREATE TABLE `jishigou_xwb_bind_info` (
`uid` mediumint(8) unsigned NOT NULL DEFAULT '0',
`sina_uid` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '΢Uid',
`token` char(32) NOT NULL DEFAULT '',
`tsecret` char(32) NOT NULL DEFAULT '',
`profile` text NOT NULL,
`share_time` int(10) NOT NULL DEFAULT '0',
`last_read_time` int(10) unsigned NOT NULL DEFAULT '0',
`last_read_id` bigint(20) unsigned NOT NULL DEFAULT '0',
`name` char(100) NOT NULL,
`screen_name` char(100) NOT NULL,
`domain` char(100) NOT NULL,
`avatar_large` char(100) NOT NULL,
`access_token` char(32) NOT NULL,
`expires_in` int(10) unsigned NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY (`uid`),
UNIQUE KEY `sina_uid` (`sina_uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_xwb_bind_topic`;
CREATE TABLE `jishigou_xwb_bind_topic` (
`tid` bigint(20) unsigned NOT NULL DEFAULT '0',
`mid` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '΢Id',
`last_read_time` int(10) unsigned NOT NULL DEFAULT '0',
KEY `tid` (`tid`),
KEY `mid` (`mid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_yy_bind_info`;
CREATE TABLE `jishigou_yy_bind_info` (
`uid` int(10) unsigned NOT NULL,
`yy_uid` char(32) NOT NULL default '' COMMENT 'YYUid',
`yy_no` char(32) NOT NULL,
`yy_nick` char(64) NOT NULL,
`yy_email` char(64) NOT NULL,
`yy_real_id` char(32) NOT NULL,
`yy_real_name` char(64) NOT NULL,
`token` char(32) NOT NULL,
`token_time` int(10) NOT NULL,
`token_expire` int(10) NOT NULL,
`dateline` int(10) unsigned NOT NULL,
PRIMARY KEY  (`uid`),
UNIQUE KEY `yy_uid` (`yy_uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_reward`;
CREATE TABLE `jishigou_reward` (
`id` int(10) unsigned NOT NULL auto_increment,
`tid` int(10) unsigned NOT NULL default '0',
`uid` int(10) unsigned NOT NULL default '0',
`title` char(50) NOT NULL default '',
`fromt` int(10) unsigned NOT NULL default '0',
`tot` int(10) unsigned NOT NULL default '0',
`content` text NOT NULL,
`prize` text NOT NULL,
`rules` text NOT NULL,
`image` int(10) NOT NULL default '0',
`posttime` int(10) unsigned NOT NULL default '0',
`postip` int(10) unsigned NOT NULL default '0',
`recd` tinyint(1) NOT NULL default '0',
`verify` tinyint(1) NOT NULL default '1',
`f_num` int(10) unsigned NOT NULL default '0',
`a_num` int(10) unsigned NOT NULL default '0',
PRIMARY KEY  (`id`),
KEY `uid` (`uid`,`posttime`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_reward`;
CREATE TABLE `jishigou_topic_reward` (
`tid` int(10) unsigned NOT NULL default '0',
`item_id` int(10) unsigned NOT NULL default '0',
`uid` mediumint(8) unsigned NOT NULL,
PRIMARY KEY  (`tid`,`item_id`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_reward_win_user`;
CREATE TABLE `jishigou_reward_win_user` (
`id` int(10) unsigned NOT NULL auto_increment,
`uid` mediumint(8) unsigned NOT NULL,
`rid` int(10) unsigned NOT NULL default '0',
`pid` int(3) unsigned NOT NULL,
`dateline` int(10) unsigned NOT NULL default '0',
PRIMARY KEY  (`id`),
KEY `uid` (`uid`),
KEY `rid` (`rid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_reward_image`;
CREATE TABLE `jishigou_reward_image` (
`id` int(10) unsigned NOT NULL auto_increment,
`uid` int(10) unsigned NOT NULL default '0',
`rid` int(10) unsigned NOT NULL default '0',
`image` char(255) NOT NULL default '',
PRIMARY KEY  (`id`),
KEY `rid` (`rid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_reward_user`;
CREATE TABLE `jishigou_reward_user` (
`id` int(10) unsigned NOT NULL auto_increment,
`uid` mediumint(8) unsigned NOT NULL,
`tid` int(10) unsigned NOT NULL default '0',
`on` tinyint(1) NOT NULL default '0',
`dateline` int(10) unsigned NOT NULL default '0',
PRIMARY KEY  (`id`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_fenlei_content`;
CREATE TABLE `jishigou_fenlei_content` (
`id` int(10) NOT NULL auto_increment,
`title` char(100) NOT NULL default '',
`mid` smallint(4) NOT NULL default '0',
`fid` mediumint(7) NOT NULL default '0',
`fname` char(100) NOT NULL,
`posttime` int(10) NOT NULL default '0',
`edittime` int(10) NOT NULL default '0',
`province` mediumint(7) NOT NULL default '0',
`city` mediumint(7) NOT NULL default '0',
`area` mediumint(7) NOT NULL default '0',
`street` mediumint(7) NOT NULL default '0',
`showday` mediumint(4) NOT NULL default '0',
`telephone` char(30) NOT NULL default '',
`linkman` char(20) NOT NULL default '',
`postman` mediumint(7) NOT NULL,
PRIMARY KEY  (`id`),
KEY `fid` (`fid`),
KEY `province` (`province`),
KEY `city` (`city`),
KEY `area` (`area`),
KEY `street` (`street`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_fenlei_favorite`;
CREATE TABLE `jishigou_fenlei_favorite` (
`id` int(10) unsigned NOT NULL auto_increment,
`fid` mediumint(10) NOT NULL default '0',
`uid` mediumint(8) unsigned NOT NULL default '0',
`dateline` int(10) unsigned NOT NULL default '0',
PRIMARY KEY  (`id`),
KEY `fid` (`fid`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_fenlei_image`;
CREATE TABLE `jishigou_fenlei_image` (
`iid` int(10) NOT NULL auto_increment PRIMARY KEY,
`id` int(10) NOT NULL,
`picurl` char(255) NOT NULL,
KEY `id` (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_fenlei_module`;
CREATE TABLE `jishigou_fenlei_module` (
`id` smallint(4) NOT NULL auto_increment,
`sort_id` smallint(4) NOT NULL default '0',
`name` char(100) NOT NULL,
`list` smallint(4) NOT NULL default '0',
`config` text NOT NULL,
PRIMARY KEY  (`id`),
KEY `list` (`list`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_fenlei_sort`;
CREATE TABLE `jishigou_fenlei_sort` (
`fid` mediumint(7) unsigned NOT NULL auto_increment PRIMARY KEY,
`fup` mediumint(7) unsigned NOT NULL default '0',
`name` char(100) NOT NULL,
`mid` smallint(4) NOT NULL default '0',
`list` int(10) NOT NULL default '0',
`style` varchar(50) NOT NULL,
`mcount` int(10) unsigned NOT NULL default '0'
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_fenlei_ziduan`;
CREATE TABLE `jishigou_fenlei_ziduan` (
`id` mediumint(10) unsigned NOT NULL auto_increment,
`name` char(100) NOT NULL,
`field_name` char(100) NOT NULL,
`field_type` char(12) NOT NULL,
`field_leng` int(2) NOT NULL default '10',
`form_type` char(12) NOT NULL,
`field_inputleng` int(6) NOT NULL default '10',
`form_set` mediumtext NOT NULL,
`form_units` char(10) NOT NULL,
`mustfill` int(2) NOT NULL default '0',
`show` int(2) NOT NULL default '0',
`search` int(2) NOT NULL default '0',
`usedcount` mediumint(10) NOT NULL default '0',
PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_company`;
CREATE TABLE `jishigou_company` (
`id` int(10) NOT NULL auto_increment,
`parentid` int(10) unsigned NOT NULL default '0' COMMENT 'ϼλID',
`upid` char(250) NOT NULL default '' COMMENT 'λIDб',
`name` char(50) NOT NULL default '',
`managerid` int(10) unsigned NOT NULL default '0',
`managername` char(50) NOT NULL default '' COMMENT '',
`leaderid` int(10) unsigned NOT NULL default '0',
`leadername` char(50) NOT NULL default '' COMMENT 'ֹ쵼',
`usercount` int(10) unsigned NOT NULL default '0' COMMENT 'λԱ',
`userscount` int(10) unsigned NOT NULL default '0' COMMENT 'λԱ',
`topiccount` int(11) unsigned NOT NULL default '0' COMMENT 'λ΢',
`topicscount` int(11) unsigned NOT NULL default '0' COMMENT 'λ΢',
`image` char(200) NOT NULL default '' COMMENT 'ͼ',
`nickname` char(100) NOT NULL default '' COMMENT '',
`description` char(250) NOT NULL default '' COMMENT '',
`info` char(250) NOT NULL default '' COMMENT 'ע',
PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_department`;
CREATE TABLE `jishigou_department` (
`id` int(10) NOT NULL auto_increment,
`cid` int(10) unsigned NOT NULL default '0' COMMENT 'λID',
`parentid` int(10) unsigned NOT NULL default '0' COMMENT 'ϼID',
`upid` char(250) NOT NULL default '' COMMENT 'λIDб',
`name` char(50) NOT NULL default '',
`usercount` int(10) unsigned NOT NULL default '0' COMMENT 'Ա',
`topiccount` int(10) unsigned NOT NULL default '0' COMMENT '΢',
`managerid` int(10) unsigned NOT NULL default '0',
`managername` char(50) NOT NULL default '' COMMENT '',
`leaderid` int(10) unsigned NOT NULL default '0',
`leadername` char(50) NOT NULL default '' COMMENT 'ֹ쵼',
`image` char(200) NOT NULL default '' COMMENT 'ͼ',
`nickname` char(100) NOT NULL default '' COMMENT '',
`description` char(250) NOT NULL default '' COMMENT '',
`info` char(250) NOT NULL default '' COMMENT 'ע',
PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_buddy_department`;
CREATE TABLE `jishigou_buddy_department` (
`id` int(10) NOT NULL auto_increment,
`uid` int(10) unsigned NOT NULL,
`did` int(10) unsigned NOT NULL,
PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_bulletin`;
CREATE TABLE `jishigou_bulletin` (
`id` int(10) unsigned NOT NULL auto_increment,
`type` tinyint(3) NOT NULL default '0',
`cpid` int(10) unsigned NOT NULL default '0',
`uid` int(10) unsigned NOT NULL default '0',
`username` char(100) NOT NULL default '',
`message` text character set gbk NOT NULL,
`dateline` int(10) unsigned NOT NULL default '0',
PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_channel`;
CREATE TABLE `jishigou_channel` (
`ch_id` smallint(6) unsigned NOT NULL auto_increment,
`ch_name` char(15) NOT NULL default '',
`topic_num` int(10) unsigned NOT NULL default '0',
`parent_id` smallint(6) unsigned NOT NULL default '0',
`display_order` smallint(6) unsigned NOT NULL default '0',
PRIMARY KEY  (`ch_id`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_topic_channel`;
CREATE TABLE `jishigou_topic_channel` (
`tid` int(10) unsigned NOT NULL default '0',
`item_id` int(10) unsigned NOT NULL default '0',
`uid` mediumint(8) unsigned NOT NULL,
PRIMARY KEY  (`tid`,`item_id`),
KEY `uid` (`uid`)
) ENGINE=MyISAM;

DROP TABLE IF EXISTS `jishigou_buddy_channel`;
CREATE TABLE `jishigou_buddy_channel` (
`id` int(10) NOT NULL auto_increment,
`uid` int(10) unsigned NOT NULL,
`ch_id` int(10) unsigned NOT NULL,
PRIMARY KEY  (`id`)
) ENGINE=MyISAM;

REPLACE INTO `jishigou_credits_rule` (`rid`,`rulename`,`action`,`cycletype`,`cycletime`,`rewardnum`,`norepeat`,`extcredits1`,`extcredits2`,`extcredits3`,`extcredits4`,`extcredits5`,`extcredits6`,`extcredits7`,`extcredits8`,`related`) values (1,'ԭ΢','topic',1,0,10,0,0,2,0,0,0,0,0,0,''),(7,'ͶϢ','pm',1,0,1,0,0,1,0,0,0,0,0,0,''),(3,'ע','buddy',1,0,10,0,0,1,0,0,0,0,0,0,''),(8,'ͷ','face',0,0,1,0,0,10,0,0,0,0,0,0,''),(9,'VIP֤','vip',0,0,1,0,0,20,0,0,0,0,0,0,''),(6,'ÿ¼','login',1,0,1,0,0,2,0,0,0,0,0,0,''),(2,'ۻת΢','reply',1,0,10,0,0,1,0,0,0,0,0,0,''),(4,'ע','register',1,0,10,0,0,10,0,0,0,0,0,0,''),(10,'ָ','_T84202031',1,0,2,0,0,5,0,0,0,0,0,0,'˱'),(11,'עָû','_U-2012344970',0,0,1,0,0,5,0,0,0,0,0,0,'admin'),(12,'ɾ΢','topic_del',4,0,0,0,0,-5,0,0,0,0,0,0,''),(13,'ȡע','buddy_del',4,0,0,0,0,-5,0,0,0,0,0,0,''),(15,'ָ','_T',1,0,1,0,0,0,0,0,0,0,0,0,''),(16,'עָû','_U',1,0,1,0,0,0,0,0,0,0,0,0,''),(17,'ͶƱ','vote_add',1,0,10,0,0,2,0,0,0,0,0,0,''),(18,'ɾͶƱ','vote_del',4,0,0,0,0,-5,0,0,0,0,0,0,'');
REPLACE INTO `jishigou_event_info` (`id`, `need_info`) VALUES (1, 'a:6:{i:2;a:5:{s:2:"id";s:1:"2";s:4:"name";s:8:"ʵ";s:9:"form_type";s:4:"text";s:8:"form_set";s:0:"";s:5:"ename";s:8:"realname";}i:3;a:5:{s:2:"id";s:1:"3";s:4:"name";s:4:"Ա";s:9:"form_type";s:6:"select";s:8:"form_set";s:6:"\r\nŮ";s:5:"ename";s:4:"sexy";}i:4;a:5:{s:2:"id";s:1:"4";s:4:"name";s:8:"ֻ";s:9:"form_type";s:4:"text";s:8:"form_set";s:0:"";s:5:"ename";s:8:"telphone";}i:24;a:5:{s:2:"id";s:2:"24";s:4:"name";s:2:"QQ";s:9:"form_type";s:4:"text";s:8:"form_set";s:0:"";s:5:"ename";s:2:"qq";}i:27;a:5:{s:2:"id";s:2:"27";s:4:"name";s:8:"ҽ";s:9:"form_type";s:4:"text";s:8:"form_set";s:0:"";s:5:"ename";s:4:"show";}i:29;a:5:{s:2:"id";s:2:"29";s:4:"name";s:8:"ϵַ";s:9:"form_type";s:4:"text";s:8:"form_set";s:0:"";s:5:"ename";s:7:"linkadd";}}');
REPLACE INTO `jishigou_event_needinfo` (`id`, `name`, `form_type`, `form_set`, `ename`) VALUES (2, 'ʵ', 'text', '', 'realname'), (3, 'Ա', 'select', '\r\nŮ', 'sexy'), (4, 'ֻ', 'text', '', 'telphone'), (5, '', 'text', '', 'birthday'), (6, '֤', 'text', '', 'card_id'), (7, 'ʼĵַ', 'text', '', 'address'), (8, 'ʱ', 'text', '', 'number'), (9, '', 'text', '', 'nation'), (10, '', 'text', '', 'birthadd'), (11, 'ס', 'text', '', 'liveadd'), (12, 'ҵѧУ', 'text', '', 'school'), (13, 'ѧ', 'text', '', 'record'), (14, '˾', 'text', '', 'company'), (15, 'ְҵ', 'text', '', 'job'), (16, 'ְλ', 'text', '', 'position'), (17, '', 'text', '', 'money'), (18, '״̬', 'text', '', 'status'), (19, 'Ŀ', 'text', '', 'goal'), (20, 'Ѫ', 'select', 'A\r\nB\r\nAB\r\nO\r\n', 'blood'), (21, '', 'text', '', 'height'), (22, '', 'text', '', 'weight'), (23, '֧', 'text', '', 'taobao'), (24, 'QQ', 'text', '', 'qq'), (25, 'MSN', 'text', '', 'msn'), (26, 'ҳ', 'text', '', 'url'), (27, 'ҽ', 'text', '', 'show'), (28, 'Ȥ', 'text', '', 'like'), (1, 'ϵַ', 'text', '', 'linkadd');
REPLACE INTO `jishigou_event_sort` (`id`, `type`) VALUES (1, 'ݳ/Ӱ'), (2, '/ۻ'), (3, '/'), (4, 'չ/ɳ'), (5, '/'), (6, '/'), (7, 'ɶ/ҹ'), (8, 'Ʒ'), (9, 'м/԰'), (10, '/'), (11, '');
REPLACE INTO `jishigou_medal` (`id`, `medal_img`, `medal_img2`, `medal_name`, `medal_depict`, `medal_count`, `is_open`, `conditions`, `dateline`) VALUES (1, './images/medal/1301651267/1_o.jpg', './images/medal/1301651267/1_s.jpg', '΢', '3췢ԭ΢ܻ΢ѫ', 0, 1, 'a:4:{s:4:"type";s:5:"topic";s:3:"day";s:1:"3";s:6:"endday";s:0:"";s:7:"tagname";N;}', 1301651267), (2, './images/medal/1301651359/2_o.jpg', './images/medal/1301651359/2_s.jpg', 'ר', '3΢ۣܻáרҡѫ', 0, 1, 'a:4:{s:4:"type";s:5:"reply";s:3:"day";s:1:"3";s:6:"endday";N;s:7:"tagname";N;}', 1301651359);
REPLACE INTO `jishigou_qun_category` VALUES (1, 'ҵ', 0, 0, 0), (2, 'IT', 0, 1, 0), (3, 'ҵƾ', 0, 1, 0), (4, 'ý', 0, 1, 0), (5, 'Ȥ', 0, 0, 0), (6, '', 0, 5, 0), (7, 'Ϸ', 0, 5, 0), (8, '', 0, 5, 0), (9, '', 0, 5, 0), (10, 'Ӱ', 0, 5, 0), (11, '', 0, 5, 0), (12, '', 0, 5, 0), (13, 'Ӱ', 0, 5, 0);
REPLACE INTO `jishigou_qun_level` VALUES (1, 'Ⱥ', -999999999, 999999999, 100, 3);
REPLACE INTO `jishigou_qun_ploy` VALUES (1, 10, 999999999, 999999999, 10, 3);
REPLACE INTO `jishigou_role` (`id`,`name`,`creditshigher`,`creditslower`,`privilege`,`type`,`rank`,`icon`,`allow_sendpm_to`,`allow_sendpm_from`,`allow_topic_forward_to`,`allow_topic_forward_from`,`allow_topic_reply_to`,`allow_topic_reply_from`,`allow_topic_at_to`,`allow_topic_at_from`,`allow_follow_to`,`allow_follow_from`) values (1,'ο',0,0,'273,274,275,281,282,283,284,285,286,288,289,290,291,292,293,295,297,299,300,303,448','normal',0,'','','','','','','','','','',''),(2,'Ա',0,0,'7,8,9,11,13,84,88,90,91,92,93,101,102,106,107,108,111,115,123,125,126,132,133,134,135,136,137,138,139,154,158,159,169,172,176,182,183,184,186,187,188,189,190,191,192,193,194,195,196,197,198,200,201,202,204,205,206,208,210,211,212,213,215,216,217,218,219,220,221,222,223,224,225,226,227,228,229,230,231,232,233,234,235,236,237,238,239,240,241,242,243,244,245,246,247,248,249,250,251,252,253,254,255,256,257,258,259,260,261,262,263,264,265,267,268,269,270,271,273,274,275,276,281,282,283,284,285,286,288,289,290,291,292,293,294,295,296,297,298,299,300,302,303,304,305,306,307,308,311,315,317,318,319,320,321,323,324,325,327,328,329,330,340,361,363,374,375,376,377,378,379,380,381,382,383,384,385,386,387,388,389,390,391,392,393,394,395,396,400,401,403,404,405,406,407,408,409,410,411,412,413,415,416,417,418,419,420,421,422,424,425,426,427,428,429,430,431,432,435,443,445,446,447,448,449,450,451,452','admin',0,'','0','','0','','0','','0','','0',''),(3,'ͨԱ',0,20,'7,176,193,194,195,196,197,198,273,274,275,276,281,282,283,284,285,286,288,289,290,291,292,293,294,295,296,297,298,299,300,302,303,378,448','normal',0,'','0','','0','','0','','0','','0',''),(4,'',0,0,'','normal',0,'','0','','0','','0','','0','','0',''),(5,'֤Ա',0,0,'273,274,275,281,282,283,284,285,288,289,290,291,292,293,294,295,297,299,300,303,448','normal',0,'','0','','0','','0','','0','','0',''),(7,'̨鿴',0,0,'7,8,11,13,88,92,125,126,133,135,137,139,158,176,193,194,195,196,197,198,200,202,205,211,213,215,216,217,218,219,220,221,222,223,226,228,230,235,236,238,241,246,250,251,252,253,254,255,264,273,274,275,276,281,282,283,284,285,286,288,289,290,291,292,293,294,295,296,297,298,299,300,302,303,304,305,306,311,315,319,323,330,340,361,374,377,378,379,380,381,382,383,384,386,387,388,391,392,393,394,395,401,403,404,405,406,407,410,411,413,418,421,424,425,429,435,443,446,447,448,449,450','admin',0,'','0','','0','','0','','0','','0',''),(118,'',0,0,'','normal',0,'','','','','','','','','','',''),(108,'LV1Ա',20,300,'7,176,193,194,195,196,197,198,273,274,275,276,281,282,283,284,285,286,288,289,290,291,292,293,294,295,296,297,298,299,300,302,303,378,448','normal',1,'','0','','0','','0','','0','','0',''),(109,'LV2Ա',300,1000,'7,176,193,194,195,196,197,198,273,274,275,276,281,282,283,284,285,286,288,289,290,291,292,293,294,295,296,297,298,299,300,302,303,330,340,377,378,448','normal',2,'','0','','0','','0','','0','','0',''),(110,'LV3Ա',1000,3000,'7,176,193,194,195,196,197,198,273,274,275,276,281,282,283,284,285,286,288,289,290,291,292,293,294,295,296,297,298,299,300,302,303,330,340,377,378,447,448','normal',3,'','','','','','','','','','',''),(111,'LV4Ա',3000,6000,'7,176,193,194,195,196,197,198,273,274,275,276,281,282,283,284,285,286,288,289,290,291,292,293,294,295,296,297,298,299,300,302,303,330,340,377,378,447,448','normal',4,'','','','','','','','','','',''),(112,'LV5Ա',6000,12000,'7,176,193,194,195,196,197,198,273,274,275,276,281,282,283,284,285,286,288,289,290,291,292,293,294,295,296,297,298,299,300,302,303,330,340,377,378,447,448','normal',5,'','','','','','','','','','',''),(113,'LV6Ա',12000,20000,'7,176,193,194,195,196,197,198,273,274,275,276,281,282,283,284,285,286,288,289,290,291,292,293,294,295,296,297,298,299,300,302,303,330,340,377,378,447,448','normal',6,'','','','','','','','','','',''),(114,'LV7Ա',20000,30000,'7,176,193,194,195,196,197,198,273,274,275,276,281,282,283,284,285,286,288,289,290,291,292,293,294,295,296,297,298,299,300,302,303,330,340,377,378,447,448','normal',7,'','','','','','','','','','',''),(115,'LV8Ա',30000,45000,'7,176,193,194,195,196,197,198,273,274,275,276,281,282,283,284,285,286,288,289,290,291,292,293,294,295,296,297,298,299,300,302,303,330,340,377,378,447,448','normal',8,'','','','','','','','','','',''),(116,'LV9Ա',45000,60000,'7,176,193,194,195,196,197,198,273,274,275,276,281,282,283,284,285,286,288,289,290,291,292,293,294,295,296,297,298,299,300,302,303,330,340,377,378,447,448','normal',9,'','','','','','','','','','',''),(117,'LV10Ա',60000,0,'7,176,193,194,195,196,197,198,273,274,275,276,281,282,283,284,285,286,288,289,290,291,292,293,294,295,296,297,298,299,300,302,303,330,340,377,378,447,448','normal',10,'','','','','','','','','','','');
REPLACE INTO `jishigou_role_action` (`id`,`name`,`module`,`action`,`describe`,`message`,`allow_all`,`credit_require`,`credit_update`,`log`,`is_admin`) values (88,'̨','index','*','','',0,'','',0,1),(92,'鿴URLַ','setting','modify_rewrite','','',0,'','',0,1),(7,'΢','topic','add|do_add','','',0,'','',0,0),(8,'鿴ɫб','role','list','','',0,'','',0,1),(9,'޸ĽɫȨ','role','domodify','','',0,'','',0,1),(11,'жб','role_action','list','','',0,'','',0,1),(13,'鿴','setting','modify_normal','','',0,'','',0,1),(435,'鿴ʾ','show','show','','',0,'','',0,1),(186,'ִɾ','tag','delete','','',0,'','',0,1),(182,'ִб༭΢','topic','domodify','','',0,'','',0,1),(183,'ִɾ΢','topic','delete','','',0,'','',0,1),(176,'˽','pm','send|dosend','','',0,'','',0,0),(187,'ִû','member','doadd','','',0,'','',0,1),(188,'ûҳ','member','search','','',0,'','',0,1),(138,'ģ鶯б','role_action','list_action','','',0,'','',0,1),(84,'޸','link','domodify','','',0,'','',0,1),(400,'ӶȨ','role_action','add','','',0,'','',0,1),(90,'ύݿⱸ','db','doexport','','',0,'','',0,1),(91,'޸ĺ','setting','domodify_normal','','',0,'','',0,1),(93,'޸URLַ','setting','domodify_rewrite','','',0,'','',0,1),(101,'޸Ķ','role_action','domodify','','',0,'','',0,1),(102,'ɾ','role_action','delete','','',0,'','',0,1),(184,'ɾ˽','pm','delete','','',0,'','',0,1),(189,'޸Ĺ','income','domodify','','',0,'','',0,1),(106,'޸Ľʾ','show','domodify','','',0,'','',0,1),(107,'ѹݱݰ','db','importzip','','',0,'','',0,1),(108,'֩ͳ','robot','domodify','','',0,'','',0,1),(111,'޸ݹ','setting','domodify_filter','','',0,'','',0,1),(115,'޸IPʿ','setting','domodify_access','','',0,'','',0,1),(123,'ִݿŻ','db','dooptimize','','',0,'','',0,1),(125,'鿴ݹ','setting','modify_filter','','',0,'','',0,1),(126,'鿴IPʿ','setting','modify_access','','',0,'','',0,1),(132,'ݻָ','db','doimport','','',0,'','',0,1),(133,'鿴ݻָҳ','db','import','','',0,'','',0,1),(134,'ɾݿⱸ','db','dodelete','','',0,'','',0,1),(135,'鿴UC','ucenter','ucenter','','',0,'','',0,1),(136,'޸UC','ucenter','do_setting','','',0,'','',0,1),(137,'鿴ɫȨ','role','modify','','',0,'','',0,1),(139,'','role_action','modify|domodify','','',0,'','',0,1),(154,'޸ʼ','setting','do_modify_smtp','','',0,'','',0,1),(158,'ջ','cache','*','','',0,'','',0,1),(159,'ϵͳ̨','upgrade','*','','',0,'','',0,1),(172,'ִоٱ','report','batch_process','','',0,'','',0,1),(169,'ֹ','robot','disallow0|disallow1','','',0,'','',0,1),(190,'ӹ','notice','add','','',0,'','',0,1),(191,'ִб༭','notice','domodify','','',0,'','',0,1),(192,'ӽɫ','role','add|doadd','','',0,'','',0,1),(193,'ȡ΢','xwb','__synctopic','','',0,'','',0,0),(194,'ȡ΢','xwb','__syncreply','','',0,'','',0,0),(195,'µͶƱ','vote','create','','',0,'','',0,0),(196,'ͶƱ','vote','vote','','',0,'','',0,0),(197,'ת΢','topic','forward','','',0,'','',0,0),(198,'΢','topic','reply','','',0,'','',0,0),(200,'鿴','setting','modify_credits','','',0,'','',0,1),(201,'޸Ļ','setting','do_modify_credits','','',0,'','',0,1),(202,'鿴ֹб','setting','list_credits_rule','','',0,'','',0,1),(204,'޸Ļֹ','setting','do_modify_credits_rule','','',0,'','',0,1),(205,'鿴ĳֹ','setting','modify_credits_rule','','',0,'','',0,1),(206,'ɾվ','share','delete','','',0,'','',0,1),(208,'վ','share','add|do_add','','',0,'','',0,1),(210,'༭վ','share','modify|domodify','','',0,'','',0,1),(211,'鿴QQ΢','setting','modify_qqwb','','',0,'','',0,1),(212,'޸QQ΢','setting','do_modify_qqwb','','',0,'','',0,1),(213,'鿴΢','setting','modify_sina','','',0,'','',0,1),(215,'鿴ʼ','setting','modify_smtp','','',0,'','',0,1),(216,'鿴Զ̸','setting','modify_ftp','','',0,'','',0,1),(217,'鿴Ƽ','setting','modify_hot_tag_recommend','','',0,'','',0,1),(218,'鿴ҳõƹ','setting','modify_slide_index','','',0,'','',0,1),(219,'鿴ҳõƹ','setting','modify_slide','','',0,'','',0,1),(220,'༭ûҳ','member','modify','','',0,'','',0,1),(221,'ûҳ','member','add','','',0,'','',0,1),(222,'鿴ݱҳ','db','export','','',0,'','',0,1),(223,'鿴ݱŻҳ','db','optimize','','',0,'','',0,1),(224,'޸΢','setting','do_modify_sina','','',0,'','',0,1),(225,'޸QQ','imjiqiren','do_modify_setting','','',0,'','',0,1),(226,'鿴ŷͼ¼','sms','send_log','','',0,'','',0,1),(227,'޸ֻ','sms','do_modify_setting','','',0,'','',0,1),(228,'鿴Žռ¼','sms','receive_log','','',0,'','',0,1),(229,'ɾշ¼','sms','delete_log','','',0,'','',0,1),(230,'鿴΢б','topic','modifylist','','',0,'','',0,1),(231,'޸Ƽ','setting','do_modify_hot_tag_recommend','','',0,'','',0,1),(232,'޸ҳõ','setting','do_modify_slide_index','','',0,'','',0,1),(233,'޸ҳõ','setting','do_modify_slide','','',0,'','',0,1),(234,'޸Ķƻ','task','dobatchmodify','','',0,'','',0,1),(235,'鿴ƻ','task','list','','',0,'','',0,1),(236,'鿴ƻ','task','modify','','',0,'','',0,1),(237,'޸ĵƻ','task','domodify','','',0,'','',0,1),(238,'鿴ƻ¼','task','log_list','','',0,'','',0,1),(239,'ɾƻ','task','log_delete','','',0,'','',0,1),(240,'޸Զ̸','setting','do_modify_ftp','','',0,'','',0,1),(241,'鿴ͶƱ','vote','edit','','',0,'','',0,1),(242,'޸ͶƱ','vote','doedit','','',0,'','',0,1),(243,'ɾͶƱ','vote','delete','','',0,'','',0,1),(244,'Ӹ˱ǩ','user_tag','add','','',0,'','',0,1),(245,'ɾ˱ǩ','user_tag','delete','','',0,'','',0,1),(246,'鿴˱ǩ','user_tag','modify','','',0,'','',0,1),(247,'޸ĸ˱ǩ','user_tag','domodify','','',0,'','',0,1),(248,'޸Ĺ','web_info','domodify','','',0,'','',0,1),(249,'ִɾ','notice','delete','','',0,'','',0,1),(250,'鿴༭ҳ','notice','modify','','',0,'','',0,1),(251,'鿴΢Ⱥ','qun','category','','',0,'','',0,1),(252,'鿴΢Ⱥȼ','qun','level','','',0,'','',0,1),(253,'鿴΢Ⱥ','qun','ploy','','',0,'','',0,1),(254,'鿴΢Ⱥ','qun','manage','','',0,'','',0,1),(255,'鿴΢Ⱥ','qun','setting','','',0,'','',0,1),(256,'޸΢Ⱥ','qun','dosetting','','',0,'','',0,1),(257,'޸΢Ⱥ','qun','docategory','','',0,'','',0,1),(258,'޸΢ȼ','qun','dolevel','','',0,'','',0,1),(259,'޸΢Ⱥ','qun','doploy','','',0,'','',0,1),(260,'ִ΢Ⱥ','qun','domanage','','',0,'','',0,1),(261,'û','member','dosearch','','',0,'','',0,1),(262,'޸ûϢ','member','domodify','','',0,'','',0,1),(263,'ִɾû','member','delete','','',0,'','',0,1),(264,'鿴û','sessions','search','','',0,'','',0,1),(265,'ѫ','medal','add','','',0,'','',0,1),(267,'޸ѫ','medal','modify|domodify','','',0,'','',0,1),(268,'ɾѫ','medal','delete','','',0,'','',0,1),(269,'V֤','vipintro','add','','',0,'','',0,1),(270,'ȡV֤','vipintro','open_validate','','',0,'','',0,1),(271,'޸V֤','vipintro','modify','','',0,'','',0,1),(273,'鿴ҵҳ','topic','myhome','','',0,'','',0,0),(274,'鿴TAעû','topic','follow','','',0,'','',0,0),(275,'鿴עTAû','topic','fans','','',0,'','',0,0),(276,'ҵģ壨ʽ','skin','do_modify','','',0,'','',0,0),(281,'鿴ǳҳ','search','user','','',0,'','',0,0),(282,'鿴ǩҳ','search','usertag','','',0,'','',0,0),(283,'鿴ؼ΢ҳ','search','topic','','',0,'','',0,0),(284,'鿴΢ҳ','search','tag','','',0,'','',0,0),(285,'鿴ؼͶƱҳ','search','vote','','',0,'','',0,0),(286,'΢','show','show','','',0,'','',0,0),(288,'鿴ýҳ','other','media','','',0,'','',0,0),(289,'鿴˰ҳ','topic','top','','',0,'','',0,0),(290,'鿴·΢','topic','new','','',0,'','',0,0),(291,'鿴۵΢','topic','newreply','','',0,'','',0,0),(292,'鿴ҵѫҳ','settings','user_medal','','',0,'','',0,0),(293,'鿴ҵҳ','settings','base','','',0,'','',0,0),(294,'ִ޸ĸϲ','settings','do_modify_profile','','',0,'','',0,0),(295,'鿴޸ͷҳ','settings','face','','',0,'','',0,0),(296,'ִͷ޸Ĳ','settings','do_modify_face','','',0,'','',0,0),(297,'鿴޸ҳ','settings','secret','','',0,'','',0,0),(298,'ִ޸','settings','do_modify_password','','',0,'','',0,0),(299,'鿴ҵĻ','settings','extcredits','','',0,'','',0,0),(300,'鿴˽б','pm','list','','',0,'','',0,0),(302,'˽Ϊδ','pm','markunread','','',0,'','',0,0),(303,'鿴ͶƱ','vote','view','','',0,'','',0,0),(304,'鿴չ','tag','extra','','',0,'','',0,1),(305,'鿴ƽ','tag','recommend','','',0,'','',0,1),(306,'鿴б','tag','list','','',0,'','',0,1),(307,'༭ƽ','tag','do_recommend','','',0,'','',0,1),(308,'༭չ','tag','add_extra','','',0,'','',0,1),(311,'鿴','setting','navigation','','',0,'','',0,1),(315,'鿴','event','manage','','',0,'','',0,1),(317,'޸ĵ','setting','do_navigation','','',0,'','',0,1),(318,'ĬϹעƽ','setting','do_regfollow','','',0,'','',0,1),(319,'鿴û','sms','list','','',0,'','',0,1),(320,'û','sms','export_to_excel','','',0,'','',0,1),(321,'ɾ','event','delete','','',0,'','',0,1),(323,'鿴б','plugin','main','','',0,'','',0,1),(324,'װ','plugin','add','','',0,'','',0,1),(325,'Ʋ','plugin','design|adddesign','','',0,'','',0,1),(327,'ò','plugin','action','','',0,'','',0,1),(328,'жز','plugin','uninstall','','',0,'','',0,1),(329,'û','member','export_all_user','','',0,'','',0,1),(330,'ʹ΢ǽ','wall','control','','',0,'','',0,0),(340,'΢Ⱥ','qun','create|docreate','','',0,'','',0,0),(361,'鿴','fenlei','manage','','',0,'','',0,1),(363,'޸API','api','do_modify_setting','','',0,'','',0,1),(374,'鿴б','verify','edit|doedit','','',0,'','',0,1),(375,'ûϢ','verify','doverify','','',0,'','',0,1),(376,'΢','topic','doverify','','',0,'','',0,1),(377,'ϴ','uploadattach','attach','','',0,'','',0,0),(378,'','uploadattach','down','','',0,'','',0,0),(379,'鿴עѡ','setting','modify_register','','',0,'','',0,1),(380,'鿴Զע','setting','regfollow','','',0,'','',0,1),(381,'鿴Discuz̳','dzbbs','discuz_setting','','',0,'','',0,1),(382,'鿴Ƥ','show','modify_theme','','',0,'','',0,1),(383,'鿴','vipintro','people_setting','','',0,'','',0,1),(384,'鿴΢۵б','output','output_setting','','',0,'','',0,1),(385,'΢б','topic','topic_manage','','',0,'','',0,1),(386,'鿴΢','topic','verify','','',0,'','',0,1),(387,'鿴΢վ','topic','del','','',0,'','',0,1),(388,'鿴΢˹','topic','manage','','',0,'','',0,1),(389,'ûǩ','topic','signature','','',0,'','',0,1),(390,'ҽܹ','topic','aboutme','','',0,'','',0,1),(391,'鿴ûб','member','newm','','',0,'','',0,1),(392,'鿴û','member','force_out','','',0,'','',0,1),(393,'鿴ϱ쵼','member','leaderlist','','',0,'','',0,1),(394,'鿴ͶƱб','vote','index','','',0,'','',0,1),(395,'鿴','event','index','','',0,'','',0,1),(396,'ֱ','live','index','','',0,'','',0,1),(401,'鿴֤','setting','modify_seccode','','',0,'','',0,1),(420,'̨¼','logs','*','','',0,'','',0,1),(403,'鿴ĬϹע','setting','follow','','',0,'','',0,1),(404,'鿴ͼƬϴ','setting','modify_image','','',0,'','',0,1),(405,'鿴Դ','setting','modify_topic_from','','',0,'','',0,1),(406,'鿴ͼƬǩ','setting','modify_qmd','','',0,'','',0,1),(407,'鿴˵','setting','invite','','',0,'','',0,1),(408,'޸ݷԴ','setting','do_modify_topic_from','','',0,'','',0,1),(409,'ֱ','live','add','','',0,'','',0,1),(410,'鿴ֱ','live','config','','',0,'','',0,1),(411,'鿴΢۵','output','modify','','',0,'','',0,1),(412,'΢۵','output','add','','',0,'','',0,1),(413,'鿴Ϣ','fenlei','setting','','',0,'','',0,1),(419,'ûV֤','vipintro','tuijian','','',0,'','',0,1),(415,'˽Ⱥб','pm','pmsend','','',0,'','',0,1),(416,'ִ˽Ⱥ','pm','dopmsend','','',0,'','',0,1),(417,'ɾȺ˽','pm','delmsg','','',0,'','',0,1),(418,'鿴˽б','pm','pm_manage','','',0,'','',0,1),(421,'鿴ģ','show','modify_template','','',0,'','',0,1),(422,'վLOGO','show','editlogo','','',0,'','',0,1),(424,'鿴DeDeCMS','dedecms','dedecms_setting','','',0,'','',0,1),(425,'鿴PHPWind','phpwind','phpwind_setting','','',0,'','',0,1),(426,'༭վ','output','do_modify','','',0,'','',0,1),(427,'ɾ΢۵','output','delete','','',0,'','',0,1),(428,'޸Ƥ','show','domodifytheme','','',0,'','',0,1),(429,'鿴վб','share','share_setting','','',0,'','',0,1),(430,'޸DeDeCMS','dedecms','dedecms_save','','',0,'','',0,1),(431,'޸PHPWind','phpwind','phpwind_save','','',0,'','',0,1),(432,'޸Discuz̳','dzbbs','dzbbs_save','','',0,'','',0,1),(443,'̨','search','*','','',0,'','',0,1),(445,'̨ŷ','sms','do_send','','',0,'','',0,1),(446,'鿴֤û','member','waitvalidate','','',0,'','',0,1),(447,'»','event','create','','',0,'','',0,0),(448,'鿴','event','detail','','',0,'','',0,0),(449,'鿴ֻӦ','setting','modify_mobile','','',0,'','',0,1),(450,'鿴V֤','vipintro','categorylist','','',0,'','',0,1),(451,'༭V֤','vipintro','domodify','','',0,'','',0,1),(452,'ɾV֤','vipintro','delcategory','','',0,'','',0,1);
REPLACE INTO `jishigou_role_module` (`module`,`name`) values ('role_action','Ȩ޹'),('role','ɫ'),('login','¼˳'),('index','̨'),('pm','˽Ź'),('setting','ϵͳ'),('link',''),('role_module','ģ'),('db','ݿ'),('show','ʾ'),('robot','֩м¼'),('tag',''),('report','ٱ'),('topic','΢'),('ucenter','Ucenter'),('cache',''),('upgrade','ϵͳ'),('profile',''),('member','û'),('income',''),('notice','վ'),('xwb','΢'),('vote','ͶƱ'),('share','վ'),('imjiqiren','QQ'),('sms','ֻ'),('task','ƻ'),('user_tag','˱ǩ'),('web_info',''),('qun','΢Ⱥ'),('sessions','û'),('medal','ѫ(û)'),('vipintro','ûV֤'),('skin','ǰ̨'),('search',''),('tools',''),('other',''),('settings',''),('event',''),('plugin','ģ'),('wall','΢ǽ'),('fenlei','Ϣ'),('api','APIӦ'),('verify','ͷǩ'),('uploadattach',''),('dzbbs','Discuz̳'),('output','΢վ'),('live','΢ֱ'),('module','module'),('logs','̨¼'),('dedecms','DeDeCMS'),('phpwind','PHPWind');
REPLACE INTO `jishigou_validate_category` (`id`, `category_id`, `category_name`, `category_pic`, `num`, `dateline`) VALUES (1, 0, '', '', 0, 1322040871), (2, 1, 'վ', '', 0, 1322040878), (3, 1, '', '', 0, 1324547052), (4, 0, 'ҵ', '', 0, 1324547052), (5, 4, 'IT', '', 0, 1324547052), (6, 4, '', '', 0, 1324547052);
