/******************************************************************************
 * Author: michal
 * Last modified: 2010-12-14 12:10
 * Filename: cityall.js
 * Description: 世界城市地区数据
 * Comment:数据格式如下
[{value:"?",text:"?",data:[
              {value:"1",text:"中国",data:[
                             {value:"11",text:"北京",data:[
                                              {value:"1",text:"东城",data:[]},
                                              {value:"2",text:"西城",data:[]},
                                              {value:"3",text:"崇文",data:[]}
                                             ]},
                             {value:"12",text:"天津",data:[
												{value:"1",text:"和平",data:[]},
												{value:"2",text:"和东",data:[]},
												{value:"3",text:"和西",data:[]},
												{value:"4",text:"南开",data:[]},
												{value:"5",text:"河北",data:[]},
												{value:"6",text:"红桥",data:[]},
												{value:"7",text:"塘沽",data:[]},
                                             ]},
                             ]},
              {value:"ALB",text:"阿尔巴尼亚",data:[
                             {value:"?",text:"?",data:[
												{value:"EL",text:"爱尔巴桑",data:[]},
												{value:"DI",text:"迪勃拉",data:[]}
                             				   ]},
                             ]},
              {value:"EGY",text:"埃及",data:[
                             {value:"?",text:"?",data:[
                                               {value:"ASW",text:"阿斯旺",data:[]},
                                               {value:"CAI",text:"开罗",data:[]}
                                              ]},
                             ]},

			  {value:"GLP",text:"瓜德罗普",data:[
			  				{value:"??",text:"??",data:[
			  					]}
			  				]},
			  ]}];
*/
cityall = [{value:"?",text:"?",data:[{value:"1",text:"中国",data:[{value:"11",text:"北京",data:[{value:"1",text:"东城",data:[]},{value:"2",text:"西城",data:[]},{value:"3",text:"崇文",data:[]},{value:"4",text:"宣武",data:[]},{value:"5",text:"朝阳",data:[]},{value:"6",text:"丰台",data:[]},{value:"7",text:"石景山",data:[]},{value:"8",text:"海淀",data:[]},{value:"9",text:"门头沟",data:[]},{value:"11",text:"房山",data:[]},{value:"12",text:"通州",data:[]},{value:"13",text:"顺义",data:[]},{value:"21",text:"昌平",data:[]},{value:"24",text:"大兴",data:[]},{value:"26",text:"平谷",data:[]},{value:"27",text:"怀柔",data:[]},{value:"28",text:"密云",data:[]},{value:"29",text:"延庆",data:[]},]},{value:"12",text:"天津",data:[{value:"1",text:"和平",data:[]},{value:"2",text:"河东",data:[]},{value:"3",text:"河西",data:[]},{value:"4",text:"南开",data:[]},{value:"5",text:"河北",data:[]},{value:"6",text:"红桥",data:[]},{value:"7",text:"塘沽",data:[]},{value:"8",text:"汉沽",data:[]},{value:"9",text:"大港",data:[]},{value:"10",text:"东丽",data:[]},{value:"11",text:"西青",data:[]},{value:"12",text:"津南",data:[]},{value:"13",text:"北辰",data:[]},{value:"21",text:"宁河",data:[]},{value:"22",text:"武清",data:[]},{value:"23",text:"静海",data:[]},{value:"24",text:"宝坻",data:[]},{value:"25",text:"蓟县",data:[]},]},{value:"13",text:"河北",data:[{value:"1",text:"石家庄",data:[]},{value:"2",text:"唐山",data:[]},{value:"3",text:"秦皇岛",data:[]},{value:"4",text:"邯郸",data:[]},{value:"5",text:"邢台",data:[]},{value:"6",text:"保定",data:[]},{value:"7",text:"张家口",data:[]},{value:"8",text:"承德",data:[]},{value:"9",text:"沧州",data:[]},{value:"10",text:"廊坊",data:[]},{value:"11",text:"衡水",data:[]},]},{value:"14",text:"山西",data:[{value:"1",text:"太原",data:[]},{value:"2",text:"大同",data:[]},{value:"3",text:"阳泉",data:[]},{value:"4",text:"长治",data:[]},{value:"5",text:"晋城",data:[]},{value:"6",text:"朔州",data:[]},{value:"7",text:"晋中",data:[]},{value:"8",text:"运城",data:[]},{value:"9",text:"忻州",data:[]},{value:"10",text:"临汾",data:[]},{value:"11",text:"吕梁",data:[]},]},{value:"15",text:"内蒙古",data:[{value:"1",text:"呼和浩特",data:[]},{value:"2",text:"包头",data:[]},{value:"3",text:"乌海",data:[]},{value:"4",text:"赤峰",data:[]},{value:"5",text:"通辽",data:[]},{value:"6",text:"鄂尔多斯",data:[]},{value:"7",text:"呼伦贝尔",data:[]},{value:"8",text:"巴彦淖尔",data:[]},{value:"9",text:"乌兰察布",data:[]},{value:"22",text:"兴安",data:[]},{value:"25",text:"锡林郭勒",data:[]},{value:"29",text:"阿拉善",data:[]},]},{value:"21",text:"辽宁",data:[{value:"1",text:"沈阳",data:[]},{value:"2",text:"大连",data:[]},{value:"3",text:"鞍山",data:[]},{value:"4",text:"抚顺",data:[]},{value:"5",text:"本溪",data:[]},{value:"6",text:"丹东",data:[]},{value:"7",text:"锦州",data:[]},{value:"8",text:"营口",data:[]},{value:"9",text:"阜新",data:[]},{value:"10",text:"辽阳",data:[]},{value:"11",text:"盘锦",data:[]},{value:"12",text:"铁岭",data:[]},{value:"13",text:"朝阳",data:[]},{value:"14",text:"葫芦岛",data:[]},]},{value:"22",text:"吉林",data:[{value:"1",text:"长春",data:[]},{value:"2",text:"吉林",data:[]},{value:"3",text:"四平",data:[]},{value:"4",text:"辽源",data:[]},{value:"5",text:"通化",data:[]},{value:"6",text:"白山",data:[]},{value:"7",text:"松原",data:[]},{value:"8",text:"白城",data:[]},{value:"24",text:"延边",data:[]},]},{value:"23",text:"黑龙江",data:[{value:"1",text:"哈尔滨",data:[]},{value:"2",text:"齐齐哈尔",data:[]},{value:"3",text:"鸡西",data:[]},{value:"4",text:"鹤岗",data:[]},{value:"5",text:"双鸭山",data:[]},{value:"6",text:"大庆",data:[]},{value:"7",text:"伊春",data:[]},{value:"8",text:"佳木斯",data:[]},{value:"9",text:"七台河",data:[]},{value:"10",text:"牡丹江",data:[]},{value:"11",text:"黑河",data:[]},{value:"12",text:"绥化",data:[]},{value:"27",text:"大兴安岭",data:[]},]},{value:"31",text:"上海",data:[{value:"1",text:"黄浦",data:[]},{value:"3",text:"卢湾",data:[]},{value:"4",text:"徐汇",data:[]},{value:"5",text:"长宁",data:[]},{value:"6",text:"静安",data:[]},{value:"7",text:"普陀",data:[]},{value:"8",text:"闸北",data:[]},{value:"9",text:"虹口",data:[]},{value:"11",text:"杨浦",data:[]},{value:"12",text:"闵行",data:[]},{value:"13",text:"宝山",data:[]},{value:"14",text:"嘉定",data:[]},{value:"15",text:"浦东新",data:[]},{value:"16",text:"金山",data:[]},{value:"17",text:"松江",data:[]},{value:"25",text:"南汇",data:[]},{value:"26",text:"奉贤",data:[]},{value:"29",text:"青浦",data:[]},{value:"30",text:"崇明",data:[]},]},{value:"32",text:"江苏",data:[{value:"1",text:"南京",data:[]},{value:"2",text:"无锡",data:[]},{value:"3",text:"徐州",data:[]},{value:"4",text:"常州",data:[]},{value:"5",text:"苏州",data:[]},{value:"6",text:"南通",data:[]},{value:"7",text:"连云港",data:[]},{value:"8",text:"淮安",data:[]},{value:"9",text:"盐城",data:[]},{value:"10",text:"扬州",data:[]},{value:"11",text:"镇江",data:[]},{value:"12",text:"泰州",data:[]},{value:"13",text:"宿迁",data:[]},]},{value:"33",text:"浙江",data:[{value:"1",text:"杭州",data:[]},{value:"2",text:"宁波",data:[]},{value:"3",text:"温州",data:[]},{value:"4",text:"嘉兴",data:[]},{value:"5",text:"湖州",data:[]},{value:"6",text:"绍兴",data:[]},{value:"7",text:"金华",data:[]},{value:"8",text:"衢州",data:[]},{value:"9",text:"舟山",data:[]},{value:"10",text:"台州",data:[]},{value:"11",text:"丽水",data:[]},]},{value:"34",text:"安徽",data:[{value:"1",text:"合肥",data:[]},{value:"2",text:"芜湖",data:[]},{value:"3",text:"蚌埠",data:[]},{value:"4",text:"淮南",data:[]},{value:"5",text:"马鞍山",data:[]},{value:"6",text:"淮北",data:[]},{value:"7",text:"铜陵",data:[]},{value:"8",text:"安庆",data:[]},{value:"10",text:"黄山",data:[]},{value:"11",text:"滁州",data:[]},{value:"12",text:"阜阳",data:[]},{value:"13",text:"宿州",data:[]},{value:"14",text:"巢湖",data:[]},{value:"15",text:"六安",data:[]},{value:"16",text:"亳州",data:[]},{value:"17",text:"池州",data:[]},{value:"18",text:"宣城",data:[]},]},{value:"35",text:"福建",data:[{value:"1",text:"福州",data:[]},{value:"2",text:"厦门",data:[]},{value:"3",text:"莆田",data:[]},{value:"4",text:"三明",data:[]},{value:"5",text:"泉州",data:[]},{value:"6",text:"漳州",data:[]},{value:"7",text:"南平",data:[]},{value:"8",text:"龙岩",data:[]},{value:"9",text:"宁德",data:[]},]},{value:"36",text:"江西",data:[{value:"1",text:"南昌",data:[]},{value:"2",text:"景德镇",data:[]},{value:"3",text:"萍乡",data:[]},{value:"4",text:"九江",data:[]},{value:"5",text:"新余",data:[]},{value:"6",text:"鹰潭",data:[]},{value:"7",text:"赣州",data:[]},{value:"8",text:"吉安",data:[]},{value:"9",text:"宜春",data:[]},{value:"10",text:"抚州",data:[]},{value:"11",text:"上饶",data:[]},]},{value:"37",text:"山东",data:[{value:"1",text:"济南",data:[]},{value:"2",text:"青岛",data:[]},{value:"3",text:"淄博",data:[]},{value:"4",text:"枣庄",data:[]},{value:"5",text:"东营",data:[]},{value:"6",text:"烟台",data:[]},{value:"7",text:"潍坊",data:[]},{value:"8",text:"济宁",data:[]},{value:"9",text:"泰安",data:[]},{value:"10",text:"威海",data:[]},{value:"11",text:"日照",data:[]},{value:"12",text:"莱芜",data:[]},{value:"13",text:"临沂",data:[]},{value:"14",text:"德州",data:[]},{value:"15",text:"聊城",data:[]},{value:"16",text:"滨州",data:[]},{value:"17",text:"菏泽",data:[]},]},{value:"41",text:"河南",data:[{value:"1",text:"郑州",data:[]},{value:"2",text:"开封",data:[]},{value:"3",text:"洛阳",data:[]},{value:"4",text:"平顶山",data:[]},{value:"5",text:"安阳",data:[]},{value:"6",text:"鹤壁",data:[]},{value:"7",text:"新乡",data:[]},{value:"8",text:"焦作",data:[]},{value:"9",text:"濮阳",data:[]},{value:"10",text:"许昌",data:[]},{value:"11",text:"漯河",data:[]},{value:"12",text:"三门峡",data:[]},{value:"13",text:"南阳",data:[]},{value:"14",text:"商丘",data:[]},{value:"15",text:"信阳",data:[]},{value:"16",text:"周口",data:[]},{value:"17",text:"驻马店",data:[]},{value:"18",text:"济源",data:[]},]},{value:"42",text:"湖北",data:[{value:"1",text:"武汉",data:[]},{value:"2",text:"黄石",data:[]},{value:"3",text:"十堰",data:[]},{value:"5",text:"宜昌",data:[]},{value:"6",text:"襄樊",data:[]},{value:"7",text:"鄂州",data:[]},{value:"8",text:"荆门",data:[]},{value:"9",text:"孝感",data:[]},{value:"10",text:"荆州",data:[]},{value:"11",text:"黄冈",data:[]},{value:"12",text:"咸宁",data:[]},{value:"13",text:"随州",data:[]},{value:"28",text:"恩施",data:[]},{value:"94",text:"仙桃",data:[]},{value:"95",text:"潜江",data:[]},{value:"96",text:"天门",data:[]},{value:"A21",text:"神农架",data:[]},]},{value:"43",text:"湖南",data:[{value:"1",text:"长沙",data:[]},{value:"2",text:"株洲",data:[]},{value:"3",text:"湘潭",data:[]},{value:"4",text:"衡阳",data:[]},{value:"5",text:"邵阳",data:[]},{value:"6",text:"岳阳",data:[]},{value:"7",text:"常德",data:[]},{value:"8",text:"张家界",data:[]},{value:"9",text:"益阳",data:[]},{value:"10",text:"郴州",data:[]},{value:"11",text:"永州",data:[]},{value:"12",text:"怀化",data:[]},{value:"13",text:"娄底",data:[]},{value:"31",text:"湘西",data:[]},]},{value:"44",text:"广东",data:[{value:"1",text:"广州",data:[]},{value:"2",text:"韶关",data:[]},{value:"3",text:"深圳",data:[]},{value:"4",text:"珠海",data:[]},{value:"5",text:"汕头",data:[]},{value:"6",text:"佛山",data:[]},{value:"7",text:"江门",data:[]},{value:"8",text:"湛江",data:[]},{value:"9",text:"茂名",data:[]},{value:"12",text:"肇庆",data:[]},{value:"13",text:"惠州",data:[]},{value:"14",text:"梅州",data:[]},{value:"15",text:"汕尾",data:[]},{value:"16",text:"河源",data:[]},{value:"17",text:"阳江",data:[]},{value:"18",text:"清远",data:[]},{value:"19",text:"东莞",data:[]},{value:"20",text:"中山",data:[]},{value:"51",text:"潮州",data:[]},{value:"52",text:"揭阳",data:[]},{value:"53",text:"云浮",data:[]},]},{value:"45",text:"广西",data:[{value:"1",text:"南宁",data:[]},{value:"2",text:"柳州",data:[]},{value:"3",text:"桂林",data:[]},{value:"4",text:"梧州",data:[]},{value:"5",text:"北海",data:[]},{value:"6",text:"防城港",data:[]},{value:"7",text:"钦州",data:[]},{value:"8",text:"贵港",data:[]},{value:"9",text:"玉林",data:[]},{value:"10",text:"百色",data:[]},{value:"11",text:"贺州",data:[]},{value:"12",text:"河池",data:[]},{value:"13",text:"来宾",data:[]},{value:"14",text:"崇左",data:[]},]},{value:"46",text:"海南",data:[{value:"1",text:"海口",data:[]},{value:"2",text:"三亚",data:[]},{value:"91",text:"五指山",data:[]},{value:"92",text:"琼海",data:[]},{value:"93",text:"儋州",data:[]},{value:"95",text:"文昌",data:[]},{value:"96",text:"万宁",data:[]},{value:"97",text:"东方",data:[]},{value:"A25",text:"定安",data:[]},{value:"A26",text:"屯昌",data:[]},{value:"A27",text:"澄迈",data:[]},{value:"A28",text:"临高",data:[]},{value:"A30",text:"白沙",data:[]},{value:"A31",text:"昌江",data:[]},{value:"A33",text:"乐东",data:[]},{value:"A34",text:"陵水",data:[]},{value:"A35",text:"保亭",data:[]},{value:"A36",text:"琼中",data:[]},{value:"A37",text:"西沙",data:[]},{value:"A38",text:"南沙",data:[]},{value:"A39",text:"中沙",data:[]},]},{value:"50",text:"重庆",data:[{value:"1",text:"万州",data:[]},{value:"2",text:"涪陵",data:[]},{value:"3",text:"渝中",data:[]},{value:"4",text:"大渡口",data:[]},{value:"5",text:"江北",data:[]},{value:"6",text:"沙坪坝",data:[]},{value:"7",text:"九龙坡",data:[]},{value:"8",text:"南岸",data:[]},{value:"9",text:"北碚",data:[]},{value:"10",text:"万盛",data:[]},{value:"11",text:"双桥",data:[]},{value:"12",text:"渝北",data:[]},{value:"13",text:"巴南",data:[]},{value:"21",text:"长寿",data:[]},{value:"22",text:"綦江",data:[]},{value:"23",text:"潼南",data:[]},{value:"24",text:"铜梁",data:[]},{value:"25",text:"大足",data:[]},{value:"26",text:"荣昌",data:[]},{value:"27",text:"璧山",data:[]},{value:"28",text:"梁平",data:[]},{value:"29",text:"城口",data:[]},{value:"30",text:"丰都",data:[]},{value:"31",text:"垫江",data:[]},{value:"32",text:"武隆",data:[]},{value:"33",text:"忠县",data:[]},{value:"34",text:"开县",data:[]},{value:"35",text:"云阳",data:[]},{value:"36",text:"奉节",data:[]},{value:"37",text:"巫山",data:[]},{value:"38",text:"巫溪",data:[]},{value:"39",text:"黔江",data:[]},{value:"40",text:"石柱",data:[]},{value:"41",text:"秀山",data:[]},{value:"42",text:"酉阳",data:[]},{value:"43",text:"彭水",data:[]},{value:"81",text:"江津",data:[]},{value:"82",text:"合川",data:[]},{value:"83",text:"永川",data:[]},{value:"84",text:"南川",data:[]},]},{value:"51",text:"四川",data:[{value:"1",text:"成都",data:[]},{value:"3",text:"自贡",data:[]},{value:"4",text:"攀枝花",data:[]},{value:"5",text:"泸州",data:[]},{value:"6",text:"德阳",data:[]},{value:"7",text:"绵阳",data:[]},{value:"8",text:"广元",data:[]},{value:"9",text:"遂宁",data:[]},{value:"10",text:"内江",data:[]},{value:"11",text:"乐山",data:[]},{value:"13",text:"南充",data:[]},{value:"14",text:"眉山",data:[]},{value:"15",text:"宜宾",data:[]},{value:"16",text:"广安",data:[]},{value:"17",text:"达州",data:[]},{value:"18",text:"雅安",data:[]},{value:"19",text:"巴中",data:[]},{value:"20",text:"资阳",data:[]},{value:"32",text:"阿坝",data:[]},{value:"33",text:"甘孜",data:[]},{value:"34",text:"凉山",data:[]},]},{value:"52",text:"贵州",data:[{value:"1",text:"贵阳",data:[]},{value:"2",text:"六盘水",data:[]},{value:"3",text:"遵义",data:[]},{value:"4",text:"安顺",data:[]},{value:"22",text:"铜仁",data:[]},{value:"23",text:"黔西南",data:[]},{value:"24",text:"毕节",data:[]},{value:"26",text:"黔东南",data:[]},{value:"27",text:"黔南",data:[]},]},{value:"53",text:"云南",data:[{value:"1",text:"昆明",data:[]},{value:"3",text:"曲靖",data:[]},{value:"4",text:"玉溪",data:[]},{value:"5",text:"保山",data:[]},{value:"6",text:"昭通",data:[]},{value:"7",text:"丽江",data:[]},{value:"8",text:"普洱",data:[]},{value:"9",text:"临沧",data:[]},{value:"23",text:"楚雄",data:[]},{value:"25",text:"红河",data:[]},{value:"26",text:"文山",data:[]},{value:"28",text:"西双版纳",data:[]},{value:"29",text:"大理",data:[]},{value:"31",text:"德宏",data:[]},{value:"33",text:"怒江",data:[]},{value:"34",text:"迪庆",data:[]},]},{value:"54",text:"西藏",data:[{value:"1",text:"拉萨",data:[]},{value:"21",text:"昌都",data:[]},{value:"22",text:"山南",data:[]},{value:"23",text:"日喀则",data:[]},{value:"24",text:"那曲",data:[]},{value:"25",text:"阿里",data:[]},{value:"26",text:"林芝",data:[]},]},{value:"61",text:"陕西",data:[{value:"1",text:"西安",data:[]},{value:"2",text:"铜川",data:[]},{value:"3",text:"宝鸡",data:[]},{value:"4",text:"咸阳",data:[]},{value:"5",text:"渭南",data:[]},{value:"6",text:"延安",data:[]},{value:"7",text:"汉中",data:[]},{value:"8",text:"榆林",data:[]},{value:"9",text:"安康",data:[]},{value:"10",text:"商洛",data:[]},]},{value:"62",text:"甘肃",data:[{value:"1",text:"兰州市",data:[]},{value:"2",text:"嘉峪关",data:[]},{value:"3",text:"金昌",data:[]},{value:"4",text:"白银",data:[]},{value:"5",text:"天水",data:[]},{value:"6",text:"武威",data:[]},{value:"7",text:"张掖",data:[]},{value:"8",text:"平凉",data:[]},{value:"9",text:"酒泉",data:[]},{value:"10",text:"庆阳",data:[]},{value:"11",text:"定西",data:[]},{value:"12",text:"陇南",data:[]},{value:"29",text:"临夏",data:[]},{value:"30",text:"甘南",data:[]},]},{value:"63",text:"青海",data:[{value:"1",text:"西宁",data:[]},{value:"21",text:"海东",data:[]},{value:"22",text:"海北",data:[]},{value:"23",text:"黄南",data:[]},{value:"25",text:"海南",data:[]},{value:"26",text:"果洛",data:[]},{value:"27",text:"玉树",data:[]},{value:"28",text:"海西",data:[]},]},{value:"64",text:"宁夏",data:[{value:"1",text:"银川",data:[]},{value:"2",text:"石嘴山",data:[]},{value:"3",text:"吴忠",data:[]},{value:"4",text:"固原",data:[]},{value:"5",text:"中卫",data:[]},]},{value:"65",text:"新疆",data:[{value:"1",text:"乌鲁木齐",data:[]},{value:"2",text:"克拉玛依",data:[]},{value:"21",text:"吐鲁番",data:[]},{value:"22",text:"哈密",data:[]},{value:"23",text:"昌吉",data:[]},{value:"27",text:"博尔塔拉",data:[]},{value:"28",text:"巴音郭楞",data:[]},{value:"29",text:"阿克苏",data:[]},{value:"30",text:"克孜勒苏",data:[]},{value:"31",text:"喀什",data:[]},{value:"32",text:"和田",data:[]},{value:"40",text:"伊犁",data:[]},{value:"42",text:"塔城",data:[]},{value:"43",text:"阿勒泰",data:[]},{value:"91",text:"石河子",data:[]},{value:"92",text:"阿拉尔",data:[]},{value:"93",text:"图木舒克",data:[]},{value:"94",text:"五家渠",data:[]},]},{value:"71",text:"台湾",data:[{value:"1",text:"台北市",data:[]},{value:"2",text:"高雄市",data:[]},{value:"3",text:"基隆市",data:[]},{value:"4",text:"台中市",data:[]},{value:"5",text:"台南市",data:[]},{value:"6",text:"新竹市",data:[]},{value:"7",text:"嘉义市",data:[]},{value:"8",text:"台北县",data:[]},{value:"9",text:"宜兰县",data:[]},{value:"10",text:"桃园县",data:[]},{value:"11",text:"新竹县",data:[]},{value:"12",text:"苗栗县",data:[]},{value:"13",text:"台中县",data:[]},{value:"14",text:"彰化县",data:[]},{value:"15",text:"南投县",data:[]},{value:"16",text:"云林县",data:[]},{value:"17",text:"嘉义县",data:[]},{value:"18",text:"台南县",data:[]},{value:"19",text:"高雄县",data:[]},{value:"20",text:"屏东县",data:[]},{value:"22",text:"台东县",data:[]},{value:"23",text:"花莲县",data:[]},{value:"21",text:"澎湖县",data:[]},]},{value:"81",text:"香港",data:[{value:"HCW",text:"中西区",data:[]},{value:"HEA",text:"东区",data:[]},{value:"KKC",text:"九龙城区",data:[]},{value:"KKT",text:"观塘区",data:[]},{value:"HSO",text:"南区",data:[]},{value:"KSS",text:"深水埗区",data:[]},{value:"KWT",text:"黄大仙区",data:[]},{value:"HWC",text:"湾仔区",data:[]},{value:"KYT",text:"油尖旺区",data:[]},{value:"NIS",text:"离岛区",data:[]},{value:"NKT",text:"葵青区",data:[]},{value:"NNO",text:"北区",data:[]},{value:"NSK",text:"西贡区",data:[]},{value:"NST",text:"沙田区",data:[]},{value:"NTM",text:"屯门区",data:[]},{value:"NTP",text:"大埔区",data:[]},{value:"NTW",text:"荃湾区",data:[]},{value:"NYL",text:"元朗区",data:[]},]},{value:"82",text:"澳门",data:[{value:"OLF",text:"花地玛堂区",data:[]},{value:"ANT",text:"圣安多尼堂区",data:[]},{value:"CAT",text:"大堂区",data:[]},{value:"LAW",text:"望德堂区",data:[]},{value:"LAZ",text:"风顺堂区",data:[]},{value:"TPA",text:"氹仔",data:[]},{value:"CLN",text:"路环",data:[]},]},]},{value:"ALB",text:"阿尔巴尼亚",data:[{value:"?",text:"?",data:[{value:"EL",text:"爱尔巴桑",data:[]},{value:"DI",text:"迪勃拉",data:[]},{value:"TR",text:"地拉那",data:[]},{value:"DR",text:"都拉斯",data:[]},{value:"VL",text:"发罗拉",data:[]},{value:"FR",text:"费里",data:[]},{value:"GJ",text:"吉诺卡斯特",data:[]},{value:"KO",text:"科尔察",data:[]},{value:"KU",text:"库克斯",data:[]},{value:"LE",text:"莱什",data:[]},{value:"BR",text:"培拉特",data:[]},{value:"SH",text:"斯库台",data:[]},]},]},{value:"DZA",text:"阿尔及利亚",data:[{value:"?",text:"?",data:[{value:"ADR",text:"阿德拉尔",data:[]},{value:"ALG",text:"阿尔及尔",data:[]},{value:"ADE",text:"艾因·德夫拉",data:[]},{value:"ATE",text:"艾因·蒂姆尚特",data:[]},{value:"AAE",text:"安纳巴",data:[]},{value:"ORA",text:"奥兰",data:[]},{value:"BAT",text:"巴特纳",data:[]},{value:"BJA ",text:"贝贾亚",data:[]},{value:"BEC",text:"贝沙尔",data:[]},{value:"EBA",text:"贝伊德",data:[]},{value:"BIS",text:"比斯克拉",data:[]},{value:"BOR",text:"布尔吉·布阿雷里吉",data:[]},{value:"BLI",text:"布利达",data:[]},{value:"BOU",text:"布迈德斯",data:[]},{value:"BOA",text:"布依拉 　",data:[]},{value:"TIP",text:"蒂巴扎",data:[]},{value:"TIS",text:"蒂斯姆西勒特",data:[]},{value:"GHA",text:"盖尔达耶",data:[]},{value:"GUE",text:"盖尔马",data:[]},{value:"KHE",text:"罕西拉",data:[]},{value:"REL",text:"赫利赞",data:[]},{value:"JIJ",text:"吉杰尔",data:[]},{value:"DJE",text:"杰勒法",data:[]},{value:"CZL",text:"君士坦丁",data:[]},{value:"LAG",text:"拉格瓦特",data:[]},{value:"MUA",text:"马斯卡拉",data:[]},{value:"MED",text:"麦迪亚",data:[]},{value:"MIL",text:"密拉",data:[]},{value:"MOS",text:"莫斯塔加纳姆",data:[]},{value:"MSI",text:"姆西拉",data:[]},{value:"NAA",text:"纳阿马",data:[]},{value:"SET",text:"塞蒂夫",data:[]},{value:"SAI",text:"赛伊达",data:[]},{value:"SKI",text:"斯基克达",data:[]},{value:"SAH",text:"苏克·阿赫拉斯",data:[]},{value:"ETA",text:"塔里夫",data:[]},{value:"TAM",text:"塔曼拉塞特",data:[]},{value:"TEB",text:"特贝萨",data:[]},{value:"TLE",text:"特莱姆森",data:[]},{value:"IOU",text:"提济乌祖",data:[]},{value:"TIA",text:"提亚雷特",data:[]},{value:"TIN",text:"廷杜夫",data:[]},{value:"EOU",text:"瓦德",data:[]},{value:"OUA",text:"瓦尔格拉",data:[]},{value:"OEB",text:"乌姆布阿基",data:[]},{value:"SBA",text:"西迪贝勒阿贝斯",data:[]},{value:"CHL",text:"谢里夫",data:[]},{value:"ILL",text:"伊利齐",data:[]},]},]},{value:"AFG",text:"阿富汗",data:[{value:"?",text:"?",data:[{value:"HEA",text:"赫拉特",data:[]},{value:"KBL",text:"喀布尔",data:[]},{value:"KDH",text:"坎大哈",data:[]},{value:"MZR",text:"马扎里沙里夫",data:[]},]},]},{value:"ARG",text:"阿根廷",data:[{value:"?",text:"?",data:[{value:"PRA",text:"巴拉那　",data:[]},{value:"VDM",text:"别德马",data:[]},{value:"PSS",text:"波萨达斯",data:[]},{value:"BHI",text:"布兰卡港",data:[]},{value:"BUE",text:"布宜诺斯艾利斯",data:[]},{value:"FMA",text:"福莫萨",data:[]},{value:"JUJ",text:"胡胡伊",data:[]},{value:"CTC",text:"卡塔马卡",data:[]},{value:"COR",text:"科尔多瓦",data:[]},{value:"CNQ",text:"科连特斯",data:[]},{value:"VLK",text:"克劳斯城",data:[]},{value:"COC",text:"肯考迪娅",data:[]},{value:"IRJ",text:"拉里奥哈",data:[]},{value:"LPG",text:"拉普拉塔",data:[]},{value:"RES",text:"雷西斯滕匹亚",data:[]},{value:"RGL",text:"里奥加耶戈斯",data:[]},{value:"RCU",text:"里奥夸尔托",data:[]},{value:"CRD",text:"里瓦达维亚海军准将城",data:[]},{value:"ROS",text:"罗萨里奥",data:[]},{value:"RWO",text:"罗森",data:[]},{value:"MDQ",text:"马德普拉塔",data:[]},{value:"MDZ",text:"门多萨",data:[]},{value:"NQN",text:"内乌肯",data:[]},{value:"SLA",text:"萨尔塔",data:[]},{value:"SDE",text:"圣地亚哥-德尔埃斯特罗",data:[]},{value:"SFN",text:"圣菲　",data:[]},{value:"UAQ",text:"圣胡安　",data:[]},{value:"AFA",text:"圣拉斐尔",data:[]},{value:"LUQ",text:"圣路易斯",data:[]},{value:"RSA",text:"圣罗莎",data:[]},{value:"SMC",text:"圣米格尔-德图库曼",data:[]},{value:"SNS",text:"圣尼古拉斯",data:[]},{value:"REL",text:"特雷利乌",data:[]},{value:"USH",text:"乌斯怀亚",data:[]},]},]},{value:"ARE",text:"阿拉伯联合酋长国",data:[{value:"?",text:"?",data:[{value:"AZ",text:"阿布扎比",data:[]},{value:"AL",text:"艾因",data:[]},{value:"DU",text:"迪拜",data:[]},{value:"SH",text:"沙迦",data:[]},]},]},{value:"ABW",text:"阿鲁巴",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"OMN",text:"阿曼",data:[{value:"?",text:"?",data:[{value:"BA",text:"巴提奈地区",data:[]},{value:"ZA",text:"达希莱地区",data:[]},{value:"SH",text:"东部地区",data:[]},{value:"MA",text:"马斯喀特省",data:[]},{value:"MU",text:"穆桑达姆省 ",data:[]},{value:"DA",text:"内地地区",data:[]},{value:"WU",text:"中部地区",data:[]},{value:"ZU",text:"佐法尔省",data:[]},]},]},{value:"AZE",text:"阿塞拜疆",data:[{value:"?",text:"?",data:[{value:"ABS",text:"阿布歇隆",data:[]},{value:"XAC",text:"哈奇马斯",data:[]},{value:"KAL",text:"卡尔巴卡尔",data:[]},{value:"QAZ",text:"卡扎赫",data:[]},{value:"LAN",text:"连科兰",data:[]},{value:"MQA",text:"密尔-卡拉巴赫",data:[]},{value:"MSA",text:"穆甘-萨连",data:[]},{value:"NQA",text:"纳戈尔诺－卡拉巴赫",data:[]},{value:"NX",text:"纳希切万",data:[]},{value:"PRI",text:"普利亚拉克斯",data:[]},{value:"SA",text:"舍基",data:[]},{value:"SMC",text:"苏姆盖特",data:[]},{value:"SIR",text:"锡尔万",data:[]},{value:"GA",text:"占贾",data:[]},]},]},{value:"ASC",text:"阿森松岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"EGY",text:"埃及",data:[{value:"?",text:"?",data:[{value:"ASW",text:"阿斯旺",data:[]},{value:"GBY",text:"古尔代盖",data:[]},{value:"CAI",text:"开罗",data:[]},{value:"SKH",text:"苏布拉开马",data:[]},{value:"ALY",text:"亚历山大",data:[]},]},]},{value:"ETH",text:"埃塞俄比亚",data:[{value:"?",text:"?",data:[{value:"AF",text:"阿法尔",data:[]},{value:"AH",text:"阿姆哈拉",data:[]},{value:"OR",text:"奥罗米亚",data:[]},{value:"BG",text:"宾香古尔",data:[]},{value:"DD",text:"德雷达瓦",data:[]},{value:"GB",text:"甘贝拉各族",data:[]},{value:"HR",text:"哈勒里民族",data:[]},{value:"SN",text:"南方各族",data:[]},{value:"SM",text:"索马里",data:[]},{value:"TG",text:"提格雷",data:[]},{value:"AA",text:"亚的斯亚贝巴",data:[]},]},]},{value:"IRL",text:"爱尔兰",data:[{value:"?",text:"?",data:[{value:"OF",text:"奥法利",data:[]},{value:"TP",text:"蒂珀雷里",data:[]},{value:"DB",text:"都柏林",data:[]},{value:"DG",text:"多内加尔",data:[]},{value:"GW",text:"戈尔韦",data:[]},{value:"KD",text:"基尔代尔",data:[]},{value:"KK",text:"基尔肯尼",data:[]},{value:"CV",text:"卡范",data:[]},{value:"CW",text:"卡洛",data:[]},{value:"KR",text:"凯里",data:[]},{value:"CK",text:"科克",data:[]},{value:"CL",text:"克莱尔",data:[]},{value:"LF",text:"朗福德",data:[]},{value:"LT",text:"劳斯",data:[]},{value:"LA",text:"崂斯",data:[]},{value:"LM",text:"利默里克",data:[]},{value:"LR",text:"利特里姆",data:[]},{value:"RC",text:"罗斯康芒 ",data:[]},{value:"MY",text:"梅奥",data:[]},{value:"MT",text:"米斯",data:[]},{value:"MG",text:"莫内根",data:[]},{value:"SL",text:"斯莱戈",data:[]},{value:"WK",text:"威克洛",data:[]},{value:"WX",text:"韦克斯福德 ",data:[]},{value:"WF",text:"沃特福德　 ",data:[]},{value:"WM",text:"西米斯",data:[]},]},]},{value:"EST",text:"爱沙尼亚",data:[{value:"?",text:"?",data:[{value:"65",text:"贝尔瓦",data:[]},{value:"37",text:"哈留",data:[]},{value:"70",text:"拉普拉",data:[]},{value:"57",text:"里亚内",data:[]},{value:"67",text:"帕尔努",data:[]},{value:"74",text:"萨雷",data:[]},{value:"78",text:"塔尔图",data:[]},{value:"82",text:"瓦尔加",data:[]},{value:"84",text:"维良地",data:[]},{value:"59",text:"维鲁",data:[]},{value:"86",text:"沃鲁",data:[]},{value:"39",text:"希尤",data:[]},{value:"51",text:"耶尔韦",data:[]},{value:"49",text:"耶盖瓦",data:[]},{value:"44",text:"依达－维鲁",data:[]},]},]},{value:"AND",text:"安道尔",data:[{value:"?",text:"?",data:[{value:"7",text:"安道尔城",data:[]},{value:"5",text:"奥尔迪诺",data:[]},{value:"3",text:"恩坎普",data:[]},{value:"2",text:"卡尼略",data:[]},{value:"8",text:"莱塞斯卡尔德－恩戈尔达",data:[]},{value:"4",text:"马萨纳",data:[]},{value:"6",text:"圣胡利娅－德洛里亚",data:[]},]},]},{value:"AGO",text:"安哥拉",data:[{value:"?",text:"?",data:[{value:"CNO",text:"北宽扎",data:[]},{value:"LNO",text:"北隆达",data:[]},{value:"BGO",text:"本戈",data:[]},{value:"BGU",text:"本格拉",data:[]},{value:"BIE",text:"比耶",data:[]},{value:"CAB",text:"卡宾达",data:[]},{value:"CNN",text:"库内内",data:[]},{value:"CCU",text:"宽多库邦戈",data:[]},{value:"LUA",text:"罗安达",data:[]},{value:"MAL",text:"马兰热",data:[]},{value:"MOX",text:"莫希科",data:[]},{value:"NAM",text:"纳米贝",data:[]},{value:"CUS",text:"南宽扎",data:[]},{value:"LSU",text:"南隆达",data:[]},{value:"HUA",text:"万博",data:[]},{value:"HUI",text:"威拉",data:[]},{value:"UIG",text:"威热",data:[]},{value:"ZAI",text:"扎伊尔",data:[]},]},]},{value:"AIA",text:"安圭拉",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"ATG",text:"安提瓜岛和巴布达",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"AUS",text:"澳大利亚",data:[{value:"NT",text:"北部地区",data:[{value:"PAL",text:"北帕默斯顿",data:[]},{value:"DRW",text:"达尔文",data:[]},]},{value:"ACT",text:"堪培拉",data:[{value:"CBR",text:"堪培拉",data:[]},]},{value:"QLD",text:"昆士兰",data:[{value:"BNE",text:"布里斯班",data:[]},{value:"OOL",text:"黄金海岸",data:[]},{value:"CNS",text:"凯恩斯",data:[]},{value:"CUD",text:"日光海岸",data:[]},{value:"TSV",text:"汤斯维尔",data:[]},{value:"TWB",text:"图文巴",data:[]},]},{value:"SA",text:"南澳大利亚",data:[{value:"ADL",text:"阿德莱德",data:[]},{value:"PUG",text:"奥古斯塔港",data:[]},{value:"MGB",text:"甘比亚山",data:[]},{value:"WAY",text:"怀阿拉",data:[]},{value:"PLO",text:"林肯港",data:[]},{value:"MYB",text:"默里布里奇",data:[]},{value:"PPI",text:"皮里港",data:[]},{value:"VHA",text:"维克托港",data:[]},]},{value:"TAS",text:"塔斯马尼亚",data:[{value:"BWT",text:"伯尼港",data:[]},{value:"DPO",text:"德文波特",data:[]},{value:"HBA",text:"霍巴特",data:[]},{value:"LST",text:"朗塞斯顿",data:[]},]},{value:"VIC",text:"维多利亚",data:[{value:"GEX",text:"吉朗",data:[]},{value:"MEL",text:"墨尔本",data:[]},]},{value:"WA",text:"西澳大利亚",data:[{value:"ALH",text:"奥尔巴尼",data:[]},{value:"BUY",text:"班伯里",data:[]},{value:"FRE",text:"弗里曼特尔港",data:[]},{value:"GET",text:"杰拉尔顿",data:[]},{value:"KGI",text:"卡尔古利",data:[]},{value:"MDU",text:"曼哲拉",data:[]},{value:"PER",text:"珀斯",data:[]},]},{value:"NSW",text:"新南威尔士",data:[{value:"NTL",text:"纽卡斯尔",data:[]},{value:"WOL",text:"伍伦贡",data:[]},{value:"HBS",text:"悉尼",data:[]},]},]},{value:"AUT",text:"奥地利",data:[{value:"?",text:"?",data:[{value:"BUR",text:"布尔根兰",data:[]},{value:"TYR",text:"蒂罗尔",data:[]},{value:"VOR",text:"福拉尔贝格",data:[]},{value:"CAT",text:"克恩顿",data:[]},{value:"SZG",text:"萨尔茨堡",data:[]},{value:"UAU",text:"上奥地利",data:[]},{value:"STY",text:"施蒂利亚",data:[]},{value:"VDD",text:"维也纳",data:[]},{value:"LAU",text:"下奥地利",data:[]},]},]},{value:"ALA",text:"奥兰群岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"BRB",text:"巴巴多斯岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"PNG",text:"巴布亚新几内亚",data:[{value:"?",text:"?",data:[{value:"NO",text:"北部",data:[]},{value:"BV",text:"布干维尔",data:[]},{value:"EH",text:"东部高地",data:[]},{value:"ES",text:"东塞皮克",data:[]},{value:"EB",text:"东新不列颠",data:[]},{value:"EN",text:"恩加",data:[]},{value:"GU",text:"海湾",data:[]},{value:"MD",text:"马当",data:[]},{value:"MN",text:"马努斯",data:[]},{value:"MB",text:"米尔恩湾",data:[]},{value:"NC",text:"莫尔兹比港",data:[]},{value:"MR",text:"莫罗贝",data:[]},{value:"SH",text:"南部高地",data:[]},{value:"SI",text:"钦布",data:[]},{value:"SA",text:"桑道恩",data:[]},{value:"WE",text:"西部",data:[]},{value:"WH",text:"西部高地",data:[]},{value:"WB",text:"西新不列颠",data:[]},{value:"NI",text:"新爱尔兰",data:[]},]},]},{value:"BHS",text:"巴哈马",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"PAK",text:"巴基斯坦",data:[{value:"?",text:"?",data:[{value:"PEW",text:"白沙瓦",data:[]},{value:"LYP",text:"费萨拉巴德",data:[]},{value:"GUJ",text:"故吉软瓦拉",data:[]},{value:"HDD",text:"海德拉巴",data:[]},{value:"KCT",text:"卡拉奇",data:[]},{value:"LHE",text:"拉合尔",data:[]},{value:"RWP",text:"拉瓦尔品第",data:[]},{value:"MUX",text:"木尔坦",data:[]},{value:"ISB",text:"伊斯兰堡",data:[]},]},]},{value:"PRY",text:"巴拉圭",data:[{value:"?",text:"?",data:[{value:"AM",text:"阿曼拜",data:[]},{value:"PH",text:"阿耶斯总统省",data:[]},{value:"PA",text:"巴拉瓜里",data:[]},{value:"BO",text:"博克龙",data:[]},{value:"GU",text:"瓜伊拉",data:[]},{value:"CG",text:"卡瓜苏",data:[]},{value:"CN",text:"卡嫩迪尤",data:[]},{value:"CZ",text:"卡萨帕",data:[]},{value:"CC",text:"康塞普西翁",data:[]},{value:"CD",text:"科迪勒拉",data:[]},{value:"MI",text:"米西奥内斯",data:[]},{value:"NE",text:"涅恩布库",data:[]},{value:"AG",text:"上巴拉圭",data:[]},{value:"AN",text:"上巴拉那",data:[]},{value:"SP",text:"圣佩德罗",data:[]},{value:"AS",text:"亚松森特别区",data:[]},{value:"IT",text:"伊塔普亚",data:[]},{value:"CE",text:"中央",data:[]},]},]},{value:"PSE",text:"巴勒斯坦",data:[{value:"?",text:"?",data:[{value:"GZ",text:"加沙地带",data:[]},{value:"WE",text:"西岸",data:[]},]},]},{value:"BHR",text:"巴林",data:[{value:"?",text:"?",data:[{value:"5",text:"北部",data:[]},{value:"1",text:"哈德",data:[]},{value:"12",text:"哈马德",data:[]},{value:"9",text:"里法",data:[]},{value:"3",text:"麦纳麦　 ",data:[]},{value:"2",text:"穆哈拉格",data:[]},{value:"10",text:"西部 ",data:[]},{value:"8",text:"伊萨城",data:[]},{value:"7",text:"中部 ",data:[]},]},]},{value:"PAN",text:"巴拿马",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"BRA",text:"巴西",data:[{value:"?",text:"?",data:[{value:"AC",text:"阿克里",data:[]},{value:"AL",text:"阿拉戈斯",data:[]},{value:"AP",text:"阿马帕",data:[]},{value:"PR",text:"巴拉那",data:[]},{value:"BSB",text:"巴西利亚",data:[]},{value:"BA",text:"巴伊亚",data:[]},{value:"RN",text:"北里奥格兰德",data:[]},{value:"PE",text:"伯南布哥",data:[]},{value:"GO",text:"戈亚斯",data:[]},{value:"RO",text:"朗多尼亚",data:[]},{value:"RJ",text:"里约热内卢",data:[]},{value:"RR",text:"罗赖马",data:[]},{value:"MA",text:"马拉尼昂",data:[]},{value:"MT",text:"马托格罗索",data:[]},{value:"MG",text:"米纳斯吉拉斯",data:[]},{value:"RS",text:"南里奥格兰德",data:[]},{value:"MS",text:"南马托格罗索",data:[]},{value:"PA",text:"帕拉",data:[]},{value:"PB",text:"帕拉伊巴",data:[]},{value:"PI",text:"皮奥伊",data:[]},{value:"CE",text:"塞阿拉",data:[]},{value:"SE",text:"塞尔希培",data:[]},{value:"ES",text:"圣埃斯皮里图",data:[]},{value:"SP",text:"圣保罗",data:[]},{value:"SC",text:"圣卡塔琳娜",data:[]},{value:"TO",text:"托坎廷斯",data:[]},{value:"AM",text:"亚马孙",data:[]},]},]},{value:"BLR",text:"白俄罗斯",data:[{value:"?",text:"?",data:[{value:"BR",text:"布列斯特",data:[]},{value:"HO",text:"戈梅利",data:[]},{value:"HR",text:"格罗德诺",data:[]},{value:"MI",text:"明斯克市",data:[]},{value:"MA",text:"莫吉廖夫",data:[]},{value:"VI",text:"维捷布斯克",data:[]},]},]},{value:"BMU",text:"百慕大",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"BGR",text:"保加利亚",data:[{value:"?",text:"?",data:[{value:"BOJ",text:"布尔加斯",data:[]},{value:"KHO",text:"卡斯科伏",data:[]},{value:"ROU",text:"鲁塞",data:[]},{value:"LVP",text:"洛维奇",data:[]},{value:"OZA",text:"蒙塔纳",data:[]},{value:"PDV",text:"普罗夫迪夫",data:[]},{value:"SOF",text:"索非亚",data:[]},{value:"GSO",text:"索非亚市",data:[]},{value:"VAR",text:"瓦尔纳",data:[]},]},]},{value:"MNP",text:"北马里亚纳群岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"BEN",text:"贝宁",data:[{value:"?",text:"?",data:[{value:"AL",text:"阿黎博里",data:[]},{value:"AK",text:"阿塔科拉",data:[]},{value:"LI",text:"滨海",data:[]},{value:"BOH",text:"波希康市",data:[]},{value:"BO",text:"博尔古",data:[]},{value:"AQ",text:"大西洋",data:[]},{value:"PL",text:"高原",data:[]},{value:"KO",text:"库福",data:[]},{value:"MO",text:"莫诺",data:[]},{value:"CO",text:"丘陵",data:[]},{value:"OU",text:"韦梅",data:[]},{value:"DO",text:"峡谷",data:[]},{value:"ZO",text:"祖",data:[]},]},]},{value:"BEL",text:"比利时",data:[{value:"?",text:"?",data:[{value:"WHT",text:"埃诺",data:[]},{value:"VAN",text:"安特卫普",data:[]},{value:"WBR",text:"布拉班特-瓦隆",data:[]},{value:"BRU",text:"布鲁塞尔",data:[]},{value:"VOV",text:"东佛兰德",data:[]},{value:"VBR",text:"佛兰芒-布拉班特",data:[]},{value:"WLG",text:"列日",data:[]},{value:"VLI",text:"林堡",data:[]},{value:"WLX",text:"卢森堡",data:[]},{value:"WNA",text:"那慕尔",data:[]},{value:"VWV",text:"西佛兰德",data:[]},]},]},{value:"ISL",text:"冰岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"PRI",text:"波多黎各",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"POL",text:"波兰",data:[{value:"?",text:"?",data:[{value:"ELB",text:"埃尔布隆格",data:[]},{value:"OLS",text:"奥尔什丁",data:[]},{value:"OSS",text:"奥斯特罗文卡",data:[]},{value:"BZG",text:"比得哥什",data:[]},{value:"PIO",text:"彼得库夫",data:[]},{value:"BYT",text:"比托姆",data:[]},{value:"BAP",text:"比亚瓦波德拉斯卡",data:[]},{value:"BIA",text:"比亚维斯托克",data:[]},{value:"OPO",text:"波莱",data:[]},{value:"POZ",text:"波兹南",data:[]},{value:"DAB",text:"达布罗瓦戈尼察",data:[]},{value:"GOW",text:"大波兰地区戈茹夫",data:[]},{value:"WRO",text:"弗罗茨瓦夫",data:[]},{value:"WLO",text:"弗沃茨瓦韦克",data:[]},{value:"GDN",text:"格但斯克",data:[]},{value:"GDY",text:"格丁尼亚",data:[]},{value:"GWC",text:"格利维采",data:[]},{value:"GRU",text:"格鲁琼兹",data:[]},{value:"CHO",text:"海乌姆",data:[]},{value:"WAW",text:"华沙",data:[]},{value:"CHZ",text:"霍茹夫",data:[]},{value:"KAL",text:"卡利什",data:[]},{value:"KTW",text:"卡托维兹",data:[]},{value:"KLC",text:"凯尔采",data:[]},{value:"KON",text:"科宁",data:[]},{value:"OSZ",text:"科沙林",data:[]},{value:"KRK",text:"克拉科夫",data:[]},{value:"KRO",text:"克罗斯诺",data:[]},{value:"RDM",text:"拉多姆",data:[]},{value:"LEG",text:"莱格尼察",data:[]},{value:"LEZ",text:"莱什诺",data:[]},{value:"LUL",text:"卢布林",data:[]},{value:"RDS",text:"鲁达",data:[]},{value:"LOD",text:"罗兹",data:[]},{value:"IEG",text:"绿山城",data:[]},{value:"MYL",text:"米什洛维采",data:[]},{value:"PIL",text:"皮瓦",data:[]},{value:"PRZ",text:"普热梅希尔",data:[]},{value:"PLO",text:"普沃茨克",data:[]},{value:"CIE",text:"切哈努夫",data:[]},{value:"RZE",text:"热舒夫",data:[]},{value:"SZZ",text:"什切青",data:[]},{value:"SKI",text:"斯凯尔涅维采",data:[]},{value:"SLP",text:"斯武普斯克",data:[]},{value:"SWL",text:"苏瓦乌基",data:[]},{value:"SOP",text:"索波特",data:[]},{value:"SWC",text:"索斯诺维茨",data:[]},{value:"TAR",text:"塔尔努夫",data:[]},{value:"QEP",text:"塔尔诺布热格",data:[]},{value:"TYY",text:"特切",data:[]},{value:"TOR",text:"托伦",data:[]},{value:"WZH",text:"瓦乌布日赫",data:[]},{value:"QOY",text:"沃姆扎",data:[]},{value:"SOW",text:"希米亚诺维采",data:[]},{value:"SWI",text:"希维诺乌伊希切",data:[]},{value:"SWT",text:"希维托赫洛维采",data:[]},{value:"SDC",text:"谢德尔采",data:[]},{value:"SIR",text:"谢拉兹",data:[]},{value:"NOW",text:"新松奇",data:[]},{value:"JAW",text:"雅沃兹诺",data:[]},{value:"JEG",text:"耶莱尼亚古拉",data:[]},{value:"ZAB",text:"扎布热",data:[]},{value:"ZAM",text:"扎莫希奇",data:[]},]},]},{value:"BOL",text:"玻利维亚",data:[{value:"?",text:"?",data:[{value:"ALT",text:"奥尔托",data:[]},{value:"ORU",text:"奥鲁罗",data:[]},{value:"BEN",text:"贝尼",data:[]},{value:"POI",text:"波多西",data:[]},{value:"QUI",text:"基拉科洛",data:[]},{value:"CBB",text:"科恰班巴",data:[]},{value:"LPB",text:"拉巴斯",data:[]},{value:"PAN",text:"潘多",data:[]},{value:"CHU",text:"丘基萨卡",data:[]},{value:"SAC",text:"萨卡巴",data:[]},{value:"SRZ",text:"圣克鲁斯",data:[]},{value:"TJA",text:"塔里哈",data:[]},]},]},{value:"BIH",text:"波斯尼亚和黑塞哥维那",data:[{value:"?",text:"?",data:[{value:"FPO",text:"波萨维纳",data:[]},{value:"FBP",text:"波斯尼亚－波德里涅",data:[]},{value:"FTO",text:"多米斯拉夫格勒",data:[]},{value:"FHN",text:"黑塞哥维那－涅雷特瓦",data:[]},{value:"FSA",text:"萨拉热窝",data:[]},{value:"FTU",text:"图兹拉－波德里涅",data:[]},{value:"FUS",text:"乌纳－萨纳",data:[]},{value:"FHB",text:"西波斯尼亚",data:[]},{value:"FZH",text:"西黑塞哥维那",data:[]},{value:"FZE",text:"泽尼察－多博伊",data:[]},{value:"FSB",text:"中波斯尼亚",data:[]},]},]},{value:"BWA",text:"博茨瓦纳",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"BLZ",text:"伯利兹",data:[{value:"?",text:"?",data:[{value:"BZ",text:"伯利兹",data:[]},{value:"OW",text:"橘园",data:[]},{value:"CY",text:"卡约",data:[]},{value:"CR",text:"科罗萨尔",data:[]},{value:"SC",text:"斯坦港",data:[]},{value:"TO",text:"托莱多",data:[]},]},]},{value:"BTN",text:"不丹",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"BFA",text:"布基纳法索",data:[{value:"?",text:"?",data:[{value:"BAL",text:"巴雷",data:[]},{value:"BAM",text:"巴姆",data:[]},{value:"BAN",text:"巴瓦 ",data:[]},{value:"BAZ",text:"巴泽加",data:[]},{value:"PON",text:"波尼",data:[]},{value:"BLG",text:"布尔古",data:[]},{value:"BOK",text:"布尔基恩德",data:[]},{value:"BOR",text:"布古里巴",data:[]},{value:"GAN",text:"冈祖尔古",data:[]},{value:"GOU",text:"古尔马",data:[]},{value:"ZIR",text:"济罗",data:[]},{value:"KAD",text:"卡焦戈",data:[]},{value:"KEN",text:"凯内杜古",data:[]},{value:"KOO",text:"科蒙加里",data:[]},{value:"COM",text:"科莫埃",data:[]},{value:"KOP",text:"孔皮恩加",data:[]},{value:"KOS",text:"孔西",data:[]},{value:"KOL",text:"库尔佩罗戈",data:[]},{value:"KOW",text:"库尔维奥戈",data:[]},{value:"KOT",text:"库里滕加",data:[]},{value:"LER",text:"雷拉巴",data:[]},{value:"LOR",text:"罗卢姆",data:[]},{value:"MOU",text:"穆翁",data:[]},{value:"NAM",text:"纳门滕加",data:[]},{value:"NAH",text:"纳乌里",data:[]},{value:"NAY",text:"纳亚拉",data:[]},{value:"GNA",text:"尼亚尼亚",data:[]},{value:"NOU",text:"努姆比埃尔",data:[]},{value:"PAS",text:"帕索雷",data:[]},{value:"SEN",text:"塞诺",data:[]},{value:"SAG",text:"桑吉",data:[]},{value:"SAM",text:"桑马滕加",data:[]},{value:"SOR",text:"苏鲁",data:[]},{value:"SOM",text:"苏姆",data:[]},{value:"TAP",text:"塔波阿",data:[]},{value:"TUY",text:"图伊",data:[]},{value:"HOU",text:"乌埃",data:[]},{value:"OUB",text:"乌布里滕加",data:[]},{value:"OUD",text:"乌达兰",data:[]},{value:"SIS",text:"锡西里",data:[]},{value:"YAG",text:"亚加",data:[]},{value:"YAT",text:"亚滕加",data:[]},{value:"IOA",text:"伊奥巴",data:[]},{value:"ZOW",text:"宗德韦奥戈",data:[]},{value:"ZOD",text:"宗多马",data:[]},]},]},{value:"BDI",text:"布隆迪",data:[{value:"?",text:"?",data:[{value:"BB",text:"布班扎",data:[]},{value:"BR",text:"布鲁里",data:[]},{value:"BM",text:"布琼布拉城市",data:[]},{value:"BU",text:"布琼布拉乡村",data:[]},{value:"NG",text:"恩戈齐",data:[]},{value:"KI",text:"基龙多",data:[]},{value:"GI",text:"基特加",data:[]},{value:"KR",text:"卡鲁济",data:[]},{value:"KY",text:"卡扬扎　 ",data:[]},{value:"CA",text:"坎库佐",data:[]},{value:"RT",text:"鲁塔纳 ",data:[]},{value:"RY",text:"鲁伊吉",data:[]},{value:"MA",text:"马坎巴",data:[]},{value:"MU",text:"穆拉姆维亚",data:[]},{value:"MW",text:"穆瓦洛",data:[]},{value:"MY",text:"穆因加",data:[]},{value:"CI",text:"锡比托凯",data:[]},]},]},{value:"BVT",text:"布韦岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"PRK",text:"朝鲜",data:[{value:"?",text:"?",data:[{value:"HAE",text:"海州",data:[]},{value:"HYE",text:"惠山",data:[]},{value:"KAN",text:"江界",data:[]},{value:"KSN",text:"开城",data:[]},{value:"NAS",text:"罗先",data:[]},{value:"NAM",text:"南浦",data:[]},{value:"FNJ",text:"平壤",data:[]},{value:"CHO",text:"清津",data:[]},{value:"SAR",text:"沙里院",data:[]},{value:"HAM",text:"咸兴",data:[]},{value:"SII",text:"新义州",data:[]},{value:"WON",text:"元山",data:[]},]},]},{value:"DNK",text:"丹麦",data:[{value:"?",text:"?",data:[{value:"AR",text:"奥胡斯",data:[]},{value:"VSV",text:"北日德兰",data:[]},{value:"BO",text:"博恩霍尔姆",data:[]},{value:"FRE",text:"菲特烈堡",data:[]},{value:"FY",text:"菲茵",data:[]},{value:"CPH",text:"哥本哈根",data:[]},{value:"RIB",text:"里伯",data:[]},{value:"RKG",text:"灵克宾",data:[]},{value:"RKE",text:"罗斯基勒",data:[]},{value:"VBI",text:"南日德兰",data:[]},{value:"ST",text:"斯多斯特姆",data:[]},{value:"VIB",text:"维堡",data:[]},{value:"VEJ",text:"维厄勒",data:[]},{value:"VS",text:"西希兰",data:[]},]},]},{value:"DEU",text:"德国",data:[{value:"?",text:"?",data:[{value:"ARN",text:"阿恩斯贝格",data:[]},{value:"ERF",text:"爱尔福特",data:[]},{value:"ANS",text:"安斯巴格",data:[]},{value:"AGB",text:"奥格斯堡",data:[]},{value:"BE",text:"柏林",data:[]},{value:"BYU",text:"拜伊罗特",data:[]},{value:"BFE",text:"比勒费尔德",data:[]},{value:"POT",text:"波茨坦",data:[]},{value:"BOM",text:"波鸿",data:[]},{value:"HB",text:"不来梅",data:[]},{value:"BRW",text:"不伦瑞克",data:[]},{value:"DAR",text:"达姆施塔特",data:[]},{value:"DET",text:"代特莫尔特",data:[]},{value:"DRS",text:"德累斯顿",data:[]},{value:"DES",text:"德绍",data:[]},{value:"DUS",text:"杜塞尔多夫",data:[]},{value:"FFO",text:"法兰克福",data:[]},{value:"FBG",text:"弗赖堡",data:[]},{value:"HAE",text:"哈雷",data:[]},{value:"HH",text:"汉堡",data:[]},{value:"HAJ",text:"汉诺威",data:[]},{value:"KEL",text:"基尔",data:[]},{value:"GBN",text:"吉森",data:[]},{value:"KAE",text:"卡尔斯鲁厄",data:[]},{value:"KAS",text:"卡塞尔",data:[]},{value:"CHE",text:"开姆尼斯",data:[]},{value:"KOB",text:"科布伦次",data:[]},{value:"CGN",text:"科隆",data:[]},{value:"LEJ",text:"莱比锡",data:[]},{value:"LDH",text:"兰茨胡特",data:[]},{value:"LBG",text:"吕讷堡",data:[]},{value:"MAG",text:"马格德堡",data:[]},{value:"MHG",text:"曼海姆",data:[]},{value:"MAI",text:"美因兹",data:[]},{value:"MUN",text:"明斯特",data:[]},{value:"MUC",text:"慕尼黑",data:[]},{value:"NUE",text:"纽伦堡",data:[]},{value:"SWH",text:"什未林",data:[]},{value:"STR",text:"斯图加特",data:[]},{value:"TRI",text:"特里尔",data:[]},{value:"WIB",text:"威斯巴登",data:[]},{value:"WUG",text:"维尔茨堡",data:[]},]},]},{value:"TLS",text:"东帝汶",data:[{value:"?",text:"?",data:[{value:"AL",text:"阿伊莱乌",data:[]},{value:"AN",text:"阿伊纳罗",data:[]},{value:"ER",text:"埃尔梅拉",data:[]},{value:"AM",text:"安贝诺",data:[]},{value:"BA",text:"包考",data:[]},{value:"BO",text:"博博纳罗",data:[]},{value:"DI",text:"帝力",data:[]},{value:"KO",text:"科瓦利马",data:[]},{value:"LA",text:"劳滕",data:[]},{value:"LI",text:"利基卡",data:[]},{value:"MT",text:"马纳图托",data:[]},{value:"MF",text:"马努法伊",data:[]},{value:"VI",text:"维克克",data:[]},]},]},{value:"TGO",text:"多哥",data:[{value:"?",text:"?",data:[{value:"M",text:"滨海区",data:[]},{value:"S",text:"草原区",data:[]},{value:"P",text:"高原区",data:[]},{value:"K",text:"卡拉区",data:[]},{value:"C",text:"中部区",data:[]},]},]},{value:"DMA",text:"多米尼加",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"DOM",text:"多米尼加共和国",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"RUS",text:"俄罗斯",data:[{value:"?",text:"?",data:[{value:"ABA",text:"阿巴坎",data:[]},{value:"ARK",text:"阿尔汉格尔斯克",data:[]},{value:"AGI",text:"阿金斯科耶",data:[]},{value:"DYR",text:"阿纳德尔",data:[]},{value:"AST",text:"阿斯特拉罕",data:[]},{value:"ESL",text:"埃利斯塔",data:[]},{value:"ORL",text:"奥廖尔",data:[]},{value:"ORE",text:"奥伦堡",data:[]},{value:"BAX",text:"巴尔瑙尔",data:[]},{value:"PNZ",text:"奔萨",data:[]},{value:"PKC",text:"彼得罗巴甫洛夫斯克",data:[]},{value:"PES",text:"彼得罗扎沃茨克",data:[]},{value:"PER",text:"彼尔姆",data:[]},{value:"BBZ",text:"比罗比詹",data:[]},{value:"BEL",text:"别尔哥罗德",data:[]},{value:"COK",text:"伯力",data:[]},{value:"BQS",text:"布拉戈维申斯克",data:[]},{value:"BRY",text:"布良斯克",data:[]},{value:"CHE",text:"车里雅宾斯克",data:[]},{value:"CHI",text:"赤塔",data:[]},{value:"ROS",text:"顿河畔罗斯托夫",data:[]},{value:"OMS",text:"鄂木斯克",data:[]},{value:"VOG",text:"伏尔加格勒",data:[]},{value:"VMR",text:"弗拉基米尔",data:[]},{value:"VLA",text:"弗拉季高加索",data:[]},{value:"GOA",text:"戈尔诺－阿尔泰斯克",data:[]},{value:"GRV",text:"格罗兹尼",data:[]},{value:"VVO",text:"海参崴",data:[]},{value:"KHM",text:"汉特－曼西斯克",data:[]},{value:"KIR",text:"基洛夫",data:[]},{value:"KGD",text:"加里宁格勒",data:[]},{value:"KZN",text:"喀山",data:[]},{value:"KLF",text:"卡卢加",data:[]},{value:"KOS",text:"科斯特罗马",data:[]},{value:"KRR",text:"克拉斯诺达尔",data:[]},{value:"KYA",text:"克拉斯诺亚尔斯克",data:[]},{value:"KEM",text:"克麦罗沃",data:[]},{value:"KYZ",text:"克孜勒",data:[]},{value:"KUD",text:"库德姆卡尔",data:[]},{value:"KRO",text:"库尔干",data:[]},{value:"URS",text:"库尔斯克",data:[]},{value:"LIP",text:"利佩茨克",data:[]},{value:"RYA",text:"梁赞",data:[]},{value:"MCX",text:"马哈奇卡拉",data:[]},{value:"MAG",text:"马加丹",data:[]},{value:"IN",text:"马加斯",data:[]},{value:"MAY",text:"迈科普",data:[]},{value:"MMK",text:"摩尔曼斯克",data:[]},{value:"MOW",text:"莫斯科",data:[]},{value:"NAL",text:"纳尔奇克",data:[]},{value:"NNM",text:"纳里扬马尔",data:[]},{value:"JSA",text:"南萨哈林斯克",data:[]},{value:"VUS",text:"诺夫哥罗德",data:[]},{value:"PAL",text:"帕拉纳",data:[]},{value:"PSK",text:"普斯科夫",data:[]},{value:"CSY",text:"切博克萨雷",data:[]},{value:"CKS",text:"切尔克斯克",data:[]},{value:"TYU",text:"秋明",data:[]},{value:"SAR",text:"萨拉托夫",data:[]},{value:"SKX",text:"萨兰斯克",data:[]},{value:"SLY",text:"萨列哈尔德",data:[]},{value:"SAM",text:"萨马拉",data:[]},{value:"SCW",text:"瑟克特夫卡尔",data:[]},{value:"SPE",text:"圣彼得堡",data:[]},{value:"LNX",text:"斯摩棱斯克",data:[]},{value:"STA",text:"斯塔夫罗波尔",data:[]},{value:"TAM",text:"坦波夫",data:[]},{value:"TVE",text:"特维尔",data:[]},{value:"TUL",text:"图拉",data:[]},{value:"TOM",text:"托木斯克",data:[]},{value:"VOR",text:"沃罗涅什",data:[]},{value:"VLG",text:"沃洛格达",data:[]},{value:"UFA",text:"乌法",data:[]},{value:"UUD",text:"乌兰乌德",data:[]},{value:"ULY",text:"乌里扬诺夫斯克",data:[]},{value:"UOB",text:"乌斯季奥尔登斯基",data:[]},{value:"GOJ",text:"下诺夫哥罗德",data:[]},{value:"NVS",text:"新西伯利亚",data:[]},{value:"JAK",text:"雅库茨克",data:[]},{value:"JAR",text:"雅罗斯拉夫尔",data:[]},{value:"JEK",text:"叶卡捷林堡",data:[]},{value:"IKT",text:"伊尔库茨克",data:[]},{value:"IJK",text:"伊热夫斯克",data:[]},{value:"IVO",text:"伊万诺沃",data:[]},{value:"YOL",text:"约什卡尔奥拉",data:[]},]},]},{value:"ECU",text:"厄瓜多尔",data:[{value:"?",text:"?",data:[{value:"A",text:"阿苏艾",data:[]},{value:"O",text:"埃尔奥罗",data:[]},{value:"E",text:"埃斯梅拉尔达斯",data:[]},{value:"B",text:"玻利瓦尔",data:[]},{value:"G",text:"瓜亚斯",data:[]},{value:"W",text:"加拉帕戈斯",data:[]},{value:"C",text:"卡尔奇",data:[]},{value:"F",text:"卡尼亚尔",data:[]},{value:"X",text:"科托帕希",data:[]},{value:"L",text:"洛哈",data:[]},{value:"R",text:"洛斯里奥斯",data:[]},{value:"M",text:"马纳比",data:[]},{value:"S",text:"莫罗纳－圣地亚哥",data:[]},{value:"D",text:"纳波，奥雷利亚纳",data:[]},{value:"Y",text:"帕斯塔萨",data:[]},{value:"P",text:"皮钦查",data:[]},{value:"H",text:"钦博拉索",data:[]},{value:"Z",text:"萨莫拉－钦奇佩",data:[]},{value:"U",text:"苏昆毕奥斯",data:[]},{value:"T",text:"通古拉瓦",data:[]},{value:"I",text:"因巴布拉",data:[]},]},]},{value:"ERI",text:"厄立特里亚",data:[{value:"?",text:"?",data:[{value:"KE",text:"安塞巴",data:[]},{value:"SK",text:"北红海",data:[]},{value:"BR",text:"加什·巴尔卡",data:[]},{value:"DE",text:"南部",data:[]},{value:"DK",text:"南红海",data:[]},{value:"MA",text:"中部",data:[]},]},]},{value:"FRA",text:"法国",data:[{value:"?",text:"?",data:[{value:"ARL",text:"阿尔勒",data:[]},{value:"AJA",text:"阿雅克修",data:[]},{value:"QXB",text:"艾克斯",data:[]},{value:"ORR",text:"奥尔良",data:[]},{value:"PAR",text:"巴黎",data:[]},{value:"BSN",text:"贝桑松",data:[]},{value:"DIJ",text:"第戎",data:[]},{value:"FRJ",text:"弗雷瑞斯",data:[]},{value:"CFR",text:"卡昂",data:[]},{value:"RNS",text:"雷恩",data:[]},{value:"LIO",text:"里昂",data:[]},{value:"LLE",text:"里尔",data:[]},{value:"LIG",text:"利摩日",data:[]},{value:"URO",text:"鲁昂",data:[]},{value:"MRS",text:"马赛",data:[]},{value:"MZM",text:"梅斯",data:[]},{value:"MPL",text:"蒙彼利埃",data:[]},{value:"NTE",text:"南特",data:[]},{value:"NCE",text:"尼斯",data:[]},{value:"CSM",text:"沙隆",data:[]},{value:"TLS",text:"图卢兹",data:[]},{value:"VAA",text:"瓦朗斯",data:[]},{value:"AMI",text:"亚眠",data:[]},]},]},{value:"FRO",text:"法罗群岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"PYF",text:"法属波利尼西亚",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"GUF",text:"法属圭亚那",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"ATF",text:"法属南部领地",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"VAT",text:"梵蒂冈",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"PHL",text:"菲律宾",data:[{value:"?",text:"?",data:[{value:"DOR",text:"达沃",data:[]},{value:"CAO",text:"卡卢坎",data:[]},{value:"MNL",text:"马尼拉",data:[]},{value:"CEB",text:"宿务",data:[]},]},]},{value:"FJI",text:"斐济",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"FIN",text:"芬兰",data:[{value:"?",text:"?",data:[{value:"ESP",text:"埃斯波",data:[]},{value:"OLU",text:"奥卢",data:[]},{value:"POR",text:"波里",data:[]},{value:"PRV",text:"博尔沃",data:[]},{value:"HMY",text:"海门林纳",data:[]},{value:"HEL",text:"赫尔辛基",data:[]},{value:"KAJ",text:"卡亚尼",data:[]},{value:"KOK",text:"科科拉",data:[]},{value:"KTK",text:"科特卡",data:[]},{value:"KUO",text:"库奥皮奥",data:[]},{value:"LHI",text:"拉赫蒂",data:[]},{value:"LPP",text:"拉彭兰塔",data:[]},{value:"RVN",text:"罗瓦涅米",data:[]},{value:"MHQ",text:"玛丽港",data:[]},{value:"MIK",text:"米凯利",data:[]},{value:"TMP",text:"坦佩雷",data:[]},{value:"TKU",text:"图尔库",data:[]},{value:"VAA",text:"瓦萨",data:[]},{value:"VAT",text:"万塔",data:[]},{value:"JOE",text:"约恩苏",data:[]},]},]},{value:"CPV",text:"佛得角",data:[{value:"?",text:"?",data:[{value:"PA",text:"保尔 ",data:[]},{value:"PN",text:"波多诺伏",data:[]},{value:"BV",text:"博阿维斯塔岛",data:[]},{value:"BR",text:"布拉瓦岛",data:[]},{value:"RG",text:"大里贝拉",data:[]},{value:"FO",text:"福古岛　 ",data:[]},{value:"MA",text:"马尤岛 ",data:[]},{value:"MO",text:"莫斯特罗",data:[]},{value:"PR",text:"普拉亚",data:[]},{value:"SL",text:"萨尔岛",data:[]},{value:"SA",text:"圣安唐岛 　 ",data:[]},{value:"IA",text:"圣地亚哥岛　 ",data:[]},{value:"SD",text:"圣多明戈",data:[]},{value:"SF",text:"圣菲利普",data:[]},{value:"CA",text:"圣卡塔琳娜",data:[]},{value:"CR",text:"圣克鲁斯",data:[]},{value:"SM",text:"圣米戈尔",data:[]},{value:"SN",text:"圣尼古拉岛",data:[]},{value:"SV",text:"圣维森特岛",data:[]},{value:"TA",text:"塔拉法尔",data:[]},]},]},{value:"FLK",text:"弗兰克群岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"GMB",text:"冈比亚",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"COG",text:"刚果",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"COD",text:"刚果民主共和国",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"COL",text:"哥伦比亚",data:[{value:"?",text:"?",data:[{value:"ARA",text:"阿劳卡",data:[]},{value:"ANT",text:"安提奥基亚",data:[]},{value:"NDS",text:"北桑坦德",data:[]},{value:"BDC",text:"波哥大首都区",data:[]},{value:"BOL",text:"博利瓦尔",data:[]},{value:"BOY",text:"博亚卡",data:[]},{value:"ATL",text:"大西洋",data:[]},{value:"GVR",text:"瓜维亚雷",data:[]},{value:"GJR",text:"瓜希拉",data:[]},{value:"GNA",text:"瓜伊尼亚",data:[]},{value:"QUI",text:"金迪奥",data:[]},{value:"CAL",text:"卡尔达斯",data:[]},{value:"CAQ",text:"卡克塔",data:[]},{value:"CAS",text:"卡萨纳雷",data:[]},{value:"CAU",text:"考卡",data:[]},{value:"VDC",text:"考卡山谷",data:[]},{value:"COR",text:"科尔多巴",data:[]},{value:"CAM",text:"昆迪纳马卡",data:[]},{value:"RIS",text:"利萨拉尔达",data:[]},{value:"MAG",text:"马格达雷那",data:[]},{value:"MET",text:"梅塔",data:[]},{value:"NAR",text:"纳里尼奥",data:[]},{value:"PUT",text:"普图马约",data:[]},{value:"CHO",text:"乔科",data:[]},{value:"CES",text:"塞萨尔",data:[]},{value:"SAN",text:"桑坦德",data:[]},{value:"SAP",text:"圣安德烈斯-普罗维登西亚",data:[]},{value:"SUC",text:"苏克雷",data:[]},{value:"TOL",text:"托利马",data:[]},{value:"VIC",text:"维查达",data:[]},{value:"VAU",text:"沃佩斯",data:[]},{value:"HUI",text:"乌伊拉",data:[]},{value:"AMZ",text:"亚马孙",data:[]},]},]},{value:"CRI",text:"哥斯达黎加",data:[{value:"?",text:"?",data:[{value:"A",text:"阿拉胡埃拉",data:[]},{value:"H",text:"埃雷迪亚",data:[]},{value:"G",text:"瓜纳卡斯特",data:[]},{value:"C",text:"卡塔戈",data:[]},{value:"L",text:"利蒙",data:[]},{value:"P",text:"蓬塔雷纳斯",data:[]},{value:"SJ",text:"圣何塞",data:[]},]},]},{value:"GGY",text:"格恩西岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"GRD",text:"格林纳达",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"GRL",text:"格陵兰",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"CUB",text:"古巴",data:[{value:"?",text:"?",data:[{value:"11",text:"奥尔金",data:[]},{value:"1",text:"比那尔德里奥",data:[]},{value:"5",text:"比亚克拉拉",data:[]},{value:"12",text:"格拉玛",data:[]},{value:"14",text:"关塔那摩",data:[]},{value:"2",text:"哈瓦那",data:[]},{value:"3",text:"哈瓦那城",data:[]},{value:"9",text:"卡马圭",data:[]},{value:"10",text:"拉斯图纳斯",data:[]},{value:"4",text:"马坦萨斯",data:[]},{value:"MAY",text:"马亚里",data:[]},{value:"MZO",text:"曼萨尼罗",data:[]},{value:"99",text:"青年岛特区",data:[]},{value:"13",text:"圣地亚哥",data:[]},{value:"7",text:"圣斯皮里图斯",data:[]},{value:"6",text:"西恩富戈斯",data:[]},{value:"8",text:"谢戈德阿维拉",data:[]},]},]},{value:"GLP",text:"瓜德罗普",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"GUM",text:"关岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"GUY",text:"圭亚那",data:[{value:"?",text:"?",data:[{value:"EW",text:"埃塞奎博群岛-西德梅拉拉",data:[]},{value:"BW",text:"巴里马-瓦伊尼",data:[]},{value:"PM",text:"波默伦-苏佩纳姆",data:[]},{value:"PI",text:"波塔罗-锡帕鲁尼",data:[]},{value:"DM",text:"德梅拉拉-马海卡",data:[]},{value:"EC",text:"东伯比斯-科兰太因",data:[]},{value:"CM",text:"库尤尼-马扎鲁尼",data:[]},{value:"MB",text:"马海卡-伯比斯",data:[]},{value:"UD",text:"上德梅拉拉-伯比斯",data:[]},{value:"UT",text:"上塔库图-上埃塞奎博",data:[]},]},]},{value:"KAZ",text:"哈萨克斯坦",data:[{value:"?",text:"?",data:[{value:"AYK",text:"阿尔卡累克",data:[]},{value:"AKM",text:"阿克莫拉",data:[]},{value:"AKS",text:"阿克苏",data:[]},{value:"AKT",text:"阿克托别",data:[]},{value:"ALA",text:"阿拉木图",data:[]},{value:"ARY",text:"阿雷斯",data:[]},{value:"AST",text:"阿斯塔纳市",data:[]},{value:"ATY",text:"阿特劳",data:[]},{value:"EKB",text:"埃基巴斯图兹",data:[]},{value:"BXH",text:"巴尔喀什",data:[]},{value:"PAV",text:"巴甫洛达尔",data:[]},{value:"SEV",text:"北哈萨克斯坦",data:[]},{value:"VOS",text:"东哈萨克斯坦",data:[]},{value:"ZYR",text:"济良诺夫斯克",data:[]},{value:"DMB",text:"江布尔",data:[]},{value:"DZH",text:"杰兹卡兹甘",data:[]},{value:"KAR",text:"卡拉干达",data:[]},{value:"KZO",text:"卡拉扎尔",data:[]},{value:"KAP",text:"卡普恰盖",data:[]},{value:"KST",text:"科斯塔奈",data:[]},{value:"KZY",text:"克孜勒奥尔达",data:[]},{value:"KEN",text:"肯套",data:[]},{value:"KUR",text:"库尔恰托夫",data:[]},{value:"LKK",text:"利萨科夫斯克",data:[]},{value:"LEN",text:"列宁诺戈尔斯克",data:[]},{value:"RUD",text:"鲁德内",data:[]},{value:"MAN",text:"曼格斯套",data:[]},{value:"KGT",text:"南哈萨克斯坦",data:[]},{value:"SAR",text:"萨兰",data:[]},{value:"SEM",text:"塞梅伊",data:[]},{value:"SAK",text:"沙赫京斯克",data:[]},{value:"STE",text:"斯捷普诺戈尔斯克",data:[]},{value:"TEK",text:"铁克利",data:[]},{value:"TEM",text:"铁米尔套",data:[]},{value:"TUR",text:"突厥斯坦",data:[]},{value:"ZAP",text:"西哈萨克斯坦",data:[]},{value:"ZHA",text:"扎纳奥津",data:[]},]},]},{value:"HTI",text:"海地",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"KOR",text:"韩国",data:[{value:"27",text:"大邱",data:[{value:"DSG",text:"达城郡",data:[]},{value:"TAE",text:"大邱",data:[]},{value:"SUS",text:"寿城区",data:[]},]},{value:"30",text:"大田",data:[]},{value:"26",text:"釜山",data:[]},{value:"29",text:"光州",data:[]},{value:"41",text:"济州特别自治道",data:[]},{value:"42",text:"江原道",data:[{value:"CHC",text:"春川市",data:[]},{value:"TGH",text:"东海市",data:[]},{value:"GSG",text:"高城郡",data:[]},{value:"HSG",text:"横城郡",data:[]},{value:"HCN",text:"洪川郡",data:[]},{value:"HCH",text:"华川郡",data:[]},{value:"KAG",text:"江陵市",data:[]},{value:"JSE",text:"旌善郡",data:[]},{value:"IJE",text:"麟蹄郡",data:[]},{value:"YWL",text:"宁越郡",data:[]},{value:"POG",text:"平昌郡",data:[]},{value:"SUK",text:"三陟市",data:[]},{value:"SHO",text:"束草市",data:[]},{value:"TBK",text:"太白市",data:[]},{value:"CWN",text:"铁原郡",data:[]},{value:"YNY",text:"襄阳郡",data:[]},{value:"YGU",text:"杨口郡",data:[]},{value:"WJU",text:"原州市",data:[]},]},{value:"49",text:"京畿道",data:[{value:"ASG",text:"安城市",data:[]},{value:"ASN",text:"安山市",data:[]},{value:"ANY",text:"安养市",data:[]},{value:"POC",text:"抱川市",data:[]},{value:"SEO",text:"城南市",data:[]},{value:"DDC",text:"东豆川市",data:[]},{value:"BCN",text:"富川市",data:[]},{value:"GYG",text:"高阳市",data:[]},{value:"GMG",text:"光明市",data:[]},{value:"KWU",text:"广州市",data:[]},{value:"GCN",text:"果川市",data:[]},{value:"HNM",text:"河南市",data:[]},{value:"HCH",text:"华城市",data:[]},{value:"GPG",text:"加平郡",data:[]},{value:"GMP",text:"金浦市",data:[]},{value:"GRI",text:"九里市",data:[]},{value:"GUN",text:"军浦市",data:[]},{value:"YJU",text:"骊州郡",data:[]},{value:"ICE",text:"利川市",data:[]},{value:"YCN",text:"涟川郡",data:[]},{value:"YNG",text:"龙仁市",data:[]},{value:"NYU",text:"南杨州市",data:[]},{value:"PTK",text:"平泽市",data:[]},{value:"PJU",text:"坡州市",data:[]},{value:"SHE",text:"始兴市",data:[]},{value:"SUO",text:"水原市",data:[]},{value:"OSN",text:"乌山市",data:[]},{value:"YPG",text:"扬平郡",data:[]},{value:"YYU",text:"杨州市",data:[]},{value:"UWN",text:"仪旺市",data:[]},{value:"UIJ",text:"议政府市",data:[]},]},{value:"43",text:"庆尚北道",data:[{value:"ADG",text:"安东市",data:[]},{value:"BHA",text:"奉化郡",data:[]},{value:"GRG",text:"高灵郡",data:[]},{value:"KUM",text:"龟尾市",data:[]},{value:"KMC",text:"金泉市",data:[]},{value:"GWI",text:"军威郡",data:[]},{value:"YEC",text:"醴泉郡",data:[]},{value:"KPO",text:"浦项市",data:[]},{value:"CGK",text:"漆谷郡",data:[]},{value:"CDO",text:"淸道郡",data:[]},{value:"CSG",text:"靑松郡",data:[]},{value:"GYS",text:"庆山市",data:[]},{value:"GJU",text:"庆州市",data:[]},{value:"YEJ",text:"荣州市",data:[]},{value:"SJU",text:"尙州市",data:[]},{value:"UJN",text:"蔚珍郡",data:[]},{value:"MGG",text:"闻庆市",data:[]},{value:"SEJ",text:"星州郡",data:[]},{value:"USG",text:"义城郡",data:[]},{value:"YYG",text:"英阳郡",data:[]},{value:"YDK",text:"盈德郡",data:[]},{value:"YCH",text:"永川市",data:[]},{value:"ULG",text:"郁陵郡",data:[]},]},{value:"44",text:"庆尚南道",data:[{value:"CNG",text:"昌宁郡",data:[]},{value:"CHW",text:"昌原市",data:[]},{value:"GSO",text:"固城郡",data:[]},{value:"HDG",text:"河东郡",data:[]},{value:"KMH",text:"金海市",data:[]},{value:"HIN",text:"晋州市",data:[]},{value:"GCH",text:"居昌郡",data:[]},{value:"KJE",text:"巨济市",data:[]},{value:"YSN",text:"梁山市",data:[]},{value:"MAS",text:"马山市",data:[]},{value:"MIR",text:"密阳市",data:[]},{value:"NHE",text:"南海郡",data:[]},{value:"SCH",text:"山淸郡",data:[]},{value:"SAH",text:"泗川市",data:[]},{value:"TYG",text:"统营市",data:[]},{value:"HCE",text:"陜川郡",data:[]},{value:"HAN",text:"咸安郡",data:[]},{value:"HYG",text:"咸阳郡",data:[]},{value:"URG",text:"宜宁郡",data:[]},{value:"CHF",text:"鎭海市",data:[]},]},{value:"47",text:"全罗北道",data:[{value:"SCG",text:"淳昌郡",data:[]},{value:"PUS",text:"扶安郡",data:[]},{value:"GCG",text:"高敞郡",data:[]},{value:"GJE",text:"金堤市",data:[]},{value:"JEO",text:"井邑市",data:[]},{value:"MJU",text:"茂朱郡",data:[]},{value:"NWN",text:"南原市",data:[]},{value:"JNJ",text:"全州市",data:[]},{value:"KUV",text:"群山市",data:[]},{value:"ISL",text:"任实郡",data:[]},{value:"WAJ",text:"完州郡",data:[]},{value:"IKS",text:"益山市",data:[]},{value:"JSU",text:"长水郡",data:[]},{value:"JAN",text:"鎭安郡",data:[]},]},{value:"48",text:"全罗南道",data:[{value:"BSG",text:"宝城郡",data:[]},{value:"GHG",text:"高兴郡",data:[]},{value:"GSE",text:"谷城郡",data:[]},{value:"WND",text:"莞岛郡",data:[]},{value:"KAN",text:"光阳市",data:[]},{value:"HAE",text:"海南郡",data:[]},{value:"HSN",text:"和顺郡",data:[]},{value:"GJN",text:"康津郡",data:[]},{value:"YOS",text:"丽水市",data:[]},{value:"YGG",text:"灵光郡",data:[]},{value:"YAM",text:"灵岩郡",data:[]},{value:"NJU",text:"罗州市",data:[]},{value:"MOK",text:"木浦市",data:[]},{value:"GRE",text:"求礼郡",data:[]},{value:"SYS",text:"顺天市",data:[]},{value:"DYA",text:"潭阳郡",data:[]},{value:"MAN",text:"务安郡",data:[]},{value:"HPG",text:"咸平郡",data:[]},{value:"SAN",text:"新安郡",data:[]},{value:"JSN",text:"长城郡",data:[]},{value:"JHG",text:"长兴郡",data:[]},{value:"JDO",text:"珍岛郡",data:[]},]},{value:"28",text:"仁川",data:[]},{value:"11",text:"首尔",data:[]},{value:"31",text:"蔚山",data:[]},{value:"45",text:"忠清北道",data:[{value:"BEN",text:"报恩郡",data:[]},{value:"JYG",text:"曾坪郡",data:[]},{value:"DYG",text:"丹阳郡",data:[]},{value:"JCH",text:"堤川市",data:[]},{value:"GSN",text:"槐山郡",data:[]},{value:"CWO",text:"淸原郡",data:[]},{value:"CJJ",text:"淸州市",data:[]},{value:"OCN",text:"沃川郡",data:[]},{value:"ESG",text:"阴城郡",data:[]},{value:"YDG",text:"永同郡",data:[]},{value:"JCN",text:"鎭川郡",data:[]},{value:"CHU",text:"忠州市",data:[]},]},{value:"46",text:"忠清南道",data:[{value:"BOR",text:"保宁市",data:[]},{value:"BYO",text:"扶余郡",data:[]},{value:"GOJ",text:"公州市",data:[]},{value:"HSE",text:"洪城郡",data:[]},{value:"GYE",text:"鸡龙市",data:[]},{value:"GSA",text:"锦山郡",data:[]},{value:"YOS",text:"礼山郡",data:[]},{value:"NSN",text:"论山市",data:[]},{value:"CYG",text:"青阳郡",data:[]},{value:"SSA",text:"瑞山市",data:[]},{value:"SCE",text:"舒川郡",data:[]},{value:"TAN",text:"泰安郡",data:[]},{value:"TJI",text:"唐津郡",data:[]},{value:"CHO",text:"天安市",data:[]},{value:"ASA",text:"牙山市",data:[]},{value:"YGI",text:"燕岐郡",data:[]},]},]},{value:"NLD",text:"荷兰",data:[{value:"?",text:"?",data:[{value:"AER",text:"阿尔梅勒",data:[]},{value:"AME",text:"阿默斯福特",data:[]},{value:"AMS",text:"阿姆斯特丹",data:[]},{value:"ARN",text:"阿纳姆",data:[]},{value:"APE",text:"阿珀尔多伦",data:[]},{value:"ASS",text:"阿森",data:[]},{value:"EDE",text:"埃德",data:[]},{value:"EMM",text:"埃门",data:[]},{value:"EIN",text:"埃因霍芬",data:[]},{value:"BRD",text:"布雷达",data:[]},{value:"TLB",text:"蒂尔堡",data:[]},{value:"DOR",text:"多德雷赫特",data:[]},{value:"ENS",text:"恩斯赫德",data:[]},{value:"GRQ",text:"格罗宁根",data:[]},{value:"HRA",text:"哈勒姆",data:[]},{value:"HAG",text:"海牙",data:[]},{value:"HFD",text:"霍夫多尔普",data:[]},{value:"LID",text:"莱顿",data:[]},{value:"LEY",text:"莱利斯塔德",data:[]},{value:"RTM",text:"鹿特丹",data:[]},{value:"LWR",text:"吕伐登",data:[]},{value:"MST",text:"马斯特里赫特",data:[]},{value:"MDL",text:"米德尔堡",data:[]},{value:"NIJ",text:"奈梅亨",data:[]},{value:"HTB",text:"斯海尔托亨博思",data:[]},{value:"UTC",text:"乌得勒支",data:[]},{value:"ZWO",text:"兹沃勒",data:[]},{value:"ZTM",text:"佐特尔梅",data:[]},]},]},{value:"ANT",text:"荷属安地列斯",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"HMD",text:"赫德和麦克唐纳群岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"HND",text:"洪都拉斯",data:[{value:"?",text:"?",data:[{value:"AT",text:"阿特兰蒂达",data:[]},{value:"PA",text:"埃尔帕拉伊索",data:[]},{value:"OC",text:"奥科特佩克",data:[]},{value:"OL",text:"奥兰乔",data:[]},{value:"FM",text:"弗朗西斯科-莫拉桑",data:[]},{value:"GD",text:"格拉西亚斯-阿迪奥斯",data:[]},{value:"IB",text:"海湾群岛",data:[]},{value:"CR",text:"科尔特斯",data:[]},{value:"CL",text:"科隆",data:[]},{value:"CM",text:"科马亚瓜",data:[]},{value:"CP",text:"科潘",data:[]},{value:"PZ",text:"拉巴斯",data:[]},{value:"LE",text:"伦皮拉",data:[]},{value:"CH",text:"乔卢特卡",data:[]},{value:"CHO",text:"乔罗马",data:[]},{value:"VA",text:"山谷",data:[]},{value:"SB",text:"圣巴巴拉",data:[]},{value:"IN",text:"因蒂布卡",data:[]},{value:"YO",text:"约罗",data:[]},]},]},{value:"KIR",text:"基里巴斯",data:[{value:"?",text:"?",data:[{value:"PHO",text:"菲尼克斯群岛",data:[]},{value:"GIL",text:"吉尔伯特群岛",data:[]},{value:"LIN",text:"莱恩群岛",data:[]},]},]},{value:"DJI",text:"吉布提",data:[{value:"?",text:"?",data:[{value:"S",text:"阿里萨比赫区",data:[]},{value:"O",text:"奥博克区",data:[]},{value:"K",text:"迪基勒区",data:[]},{value:"T",text:"塔朱拉区",data:[]},]},]},{value:"KGZ",text:"吉尔吉斯斯坦",data:[{value:"?",text:"?",data:[{value:"O",text:"奥什",data:[]},{value:"B",text:"巴特肯",data:[]},{value:"GB",text:"比什凯克市",data:[]},{value:"C",text:"楚河",data:[]},{value:"J",text:"贾拉拉巴德",data:[]},{value:"KBA",text:"卡拉巴尔塔",data:[]},{value:"KKO",text:"卡拉库尔",data:[]},{value:"KAN",text:"坎特",data:[]},{value:"KJ",text:"科克扬加克",data:[]},{value:"MS",text:"迈利赛",data:[]},{value:"N",text:"纳伦",data:[]},{value:"SU",text:"苏卢克图",data:[]},{value:"T",text:"塔拉斯",data:[]},{value:"TK",text:"塔什库梅尔",data:[]},{value:"UG",text:"乌兹根",data:[]},{value:"Y",text:"伊塞克湖",data:[]},]},]},{value:"GIN",text:"几内亚",data:[{value:"?",text:"?",data:[{value:"BOK",text:"博凯",data:[]},{value:"NZR",text:"恩泽雷科雷",data:[]},{value:"FRN",text:"法拉纳",data:[]},{value:"KND",text:"金迪亚",data:[]},{value:"KNK",text:"康康",data:[]},{value:"CNK",text:"科纳克里",data:[]},{value:"LAB",text:"拉贝",data:[]},{value:"MAM",text:"玛木",data:[]},]},]},{value:"GNB",text:"几内亚比绍",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"CAN",text:"加拿大",data:[{value:"?",text:"?",data:[{value:"ABB",text:"阿伯茨福",data:[]},{value:"EDM",text:"埃德蒙顿",data:[]},{value:"OSH",text:"奥沙瓦",data:[]},{value:"BAR",text:"巴里",data:[]},{value:"CBR",text:"布列塔尼角",data:[]},{value:"TOR",text:"多伦多",data:[]},{value:"FRE",text:"弗雷德里顿",data:[]},{value:"GLP",text:"圭尔夫",data:[]},{value:"HAL",text:"哈利法克斯",data:[]},{value:"HAM",text:"哈密尔顿",data:[]},{value:"YXY",text:"怀特霍斯",data:[]},{value:"KWL",text:"基劳纳",data:[]},{value:"BRP",text:"基奇纳",data:[]},{value:"KGN",text:"金斯敦",data:[]},{value:"CAL",text:"卡里加里",data:[]},{value:"QUE",text:"魁北克",data:[]},{value:"REG",text:"里贾纳",data:[]},{value:"LOD",text:"伦敦",data:[]},{value:"MTR",text:"蒙特利尔",data:[]},{value:"SUD",text:"萨德伯里",data:[]},{value:"SAK",text:"萨斯卡通",data:[]},{value:"TRR",text:"三河城",data:[]},{value:"THU",text:"桑德贝",data:[]},{value:"SBE",text:"舍布鲁克",data:[]},{value:"SCA",text:"圣卡塔琳娜",data:[]},{value:"SJB",text:"圣约翰斯",data:[]},{value:"VIC",text:"维多利亚",data:[]},{value:"VAN",text:"温哥华",data:[]},{value:"WNP",text:"温尼伯",data:[]},{value:"WDR",text:"温莎",data:[]},{value:"OTT",text:"渥太华",data:[]},{value:"CHA",text:"夏洛特敦",data:[]},{value:"YZF",text:"耶洛奈夫",data:[]},{value:"IQL",text:"伊魁特",data:[]},]},]},{value:"GHA",text:"加纳",data:[{value:"?",text:"?",data:[{value:"AS",text:"阿散蒂",data:[]},{value:"OBU",text:"奥布阿西",data:[]},{value:"NO",text:"北部",data:[]},{value:"BA",text:"布朗阿哈福",data:[]},{value:"GA",text:"大阿克拉",data:[]},{value:"EA",text:"东部",data:[]},{value:"UE",text:"上东部",data:[]},{value:"UW",text:"上西部",data:[]},{value:"VO",text:"沃尔特",data:[]},{value:"WE",text:"西部",data:[]},{value:"CE",text:"中部",data:[]},]},]},{value:"GAB",text:"加蓬",data:[{value:"?",text:"?",data:[{value:"OL",text:"奥果韦-洛洛",data:[]},{value:"OI",text:"奥果韦-伊温多",data:[]},{value:"OM",text:"滨海奥果韦",data:[]},{value:"NG",text:"恩古涅",data:[]},{value:"ES",text:"河口",data:[]},{value:"NY",text:"尼扬加",data:[]},{value:"HO",text:"上奥果韦",data:[]},{value:"WN",text:"沃勒-恩特姆",data:[]},{value:"MO",text:"中奥果韦",data:[]},]},]},{value:"KHM",text:"柬埔寨",data:[{value:"?",text:"?",data:[{value:"OC",text:"奥多棉吉",data:[]},{value:"KB",text:"白马市",data:[]},{value:"PR",text:"柏威夏",data:[]},{value:"PL",text:"拜林市",data:[]},{value:"BM",text:"班迭棉吉",data:[]},{value:"KZC",text:"磅清扬",data:[]},{value:"KO",text:"磅士卑",data:[]},{value:"KZK",text:"磅同",data:[]},{value:"KM",text:"磅湛",data:[]},{value:"PG",text:"波罗勉",data:[]},{value:"TK",text:"茶胶",data:[]},{value:"SVR",text:"柴桢",data:[]},{value:"KL",text:"干丹",data:[]},{value:"KKZ",text:"戈公",data:[]},{value:"KMT",text:"贡布",data:[]},{value:"PNH",text:"金边市",data:[]},{value:"KH",text:"桔井",data:[]},{value:"RBE",text:"腊塔纳基里",data:[]},{value:"BA",text:"马德望",data:[]},{value:"MWV",text:"蒙多基里",data:[]},{value:"PO",text:"菩萨",data:[]},{value:"TNX",text:"上丁",data:[]},{value:"KA",text:"西哈努克市",data:[]},{value:"REP",text:"暹粒",data:[]},]},]},{value:"CZE",text:"捷克共和国",data:[{value:"?",text:"?",data:[{value:"OL",text:"奥洛穆茨",data:[]},{value:"PL",text:"比尔森",data:[]},{value:"PR",text:"布拉格直辖市",data:[]},{value:"KR",text:"赫拉德茨-克拉洛韦",data:[]},{value:"KA",text:"卡罗维发利",data:[]},{value:"LI",text:"利贝雷克",data:[]},{value:"MO",text:"摩拉维亚-西里西亚 ",data:[]},{value:"JC",text:"南摩拉维亚  ",data:[]},{value:"PA",text:"帕尔杜比采",data:[]},{value:"VY",text:"维索基纳",data:[]},{value:"US",text:"乌斯季",data:[]},{value:"ST",text:"中捷克",data:[]},{value:"ZL",text:"兹林",data:[]},]},]},{value:"ZWE",text:"津巴布韦",data:[{value:"?",text:"?",data:[{value:"MN",text:"北马塔贝莱兰",data:[]},{value:"BU",text:"布拉瓦约",data:[]},{value:"ME",text:"东马绍纳兰",data:[]},{value:"HA",text:"哈拉雷",data:[]},{value:"ML",text:"马尼卡兰",data:[]},{value:"MV",text:"马斯温戈",data:[]},{value:"MS",text:"南马塔贝莱兰",data:[]},{value:"MW",text:"西马绍纳兰",data:[]},{value:"MD",text:"中部",data:[]},{value:"MC",text:"中马绍纳兰",data:[]},]},]},{value:"CMR",text:"喀麦隆",data:[{value:"?",text:"?",data:[{value:"ADA",text:"阿达马瓦",data:[]},{value:"NOR",text:"北部",data:[]},{value:"EXN",text:"北端",data:[]},{value:"LIT",text:"滨海",data:[]},{value:"EST",text:"东部",data:[]},{value:"SUD",text:"南部",data:[]},{value:"NOT",text:"西北",data:[]},{value:"OUE",text:"西部",data:[]},{value:"SOU",text:"西南",data:[]},{value:"CEN",text:"中央",data:[]},]},]},{value:"QAT",text:"卡塔尔",data:[{value:"?",text:"?",data:[{value:"MS",text:"北部",data:[]},{value:"DW",text:"多哈",data:[]},{value:"GW",text:"古韦里耶",data:[]},{value:"KR",text:"豪尔",data:[]},{value:"JB",text:"杰里扬拜特奈",data:[]},{value:"RN",text:"赖扬",data:[]},{value:"WK",text:"沃克拉",data:[]},{value:"UL",text:"乌姆锡拉勒",data:[]},{value:"JM",text:"朱迈利耶",data:[]},]},]},{value:"CYM",text:"开曼群岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"CCK",text:"科科斯群岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"COM",text:"科摩罗",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"CIV",text:"科特迪瓦",data:[{value:"?",text:"?",data:[{value:"AG",text:"阿涅比",data:[]},{value:"BF",text:"巴芬",data:[]},{value:"VB",text:"邦达马河谷",data:[]},{value:"DE",text:"登盖莱",data:[]},{value:"NC",text:"恩济－科莫埃",data:[]},{value:"FR",text:"弗罗马格尔",data:[]},{value:"LC",text:"湖泊",data:[]},{value:"MR",text:"马拉韦",data:[]},{value:"SB",text:"南邦达马",data:[]},{value:"SC",text:"南科莫埃",data:[]},{value:"HT",text:"萨桑德拉",data:[]},{value:"SV",text:"萨瓦纳",data:[]},{value:"DH",text:"山地",data:[]},{value:"WR",text:"沃罗杜古",data:[]},{value:"BS",text:"下萨桑德拉",data:[]},{value:"LG",text:"泻湖",data:[]},{value:"ZA",text:"赞赞",data:[]},{value:"MV",text:"中卡瓦利",data:[]},{value:"MC",text:"中科莫埃",data:[]},]},]},{value:"KWT",text:"科威特",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"HRV",text:"克罗地亚",data:[{value:"?",text:"?",data:[{value:"14",text:"奥西耶克-巴拉尼亚",data:[]},{value:"7",text:"别洛瓦尔-比洛戈拉",data:[]},{value:"8",text:"滨海和山区",data:[]},{value:"11",text:"波热加-斯拉沃尼亚",data:[]},{value:"12",text:"布罗德-波萨维纳",data:[]},{value:"19",text:"杜布罗夫斯克-内雷特瓦",data:[]},{value:"4",text:"卡尔洛瓦茨",data:[]},{value:"6",text:"科普里夫尼察-克里热夫齐",data:[]},{value:"2",text:"克拉皮纳-扎戈列",data:[]},{value:"9",text:"利卡-塞尼",data:[]},{value:"20",text:"梅吉穆列",data:[]},{value:"1",text:"萨格勒布",data:[]},{value:"21",text:"萨格勒布市",data:[]},{value:"17",text:"斯普利特-达尔马提亚",data:[]},{value:"5",text:"瓦拉日丁",data:[]},{value:"10",text:"维罗维蒂察-波德拉维纳",data:[]},{value:"16",text:"武科瓦尔-斯里耶姆",data:[]},{value:"15",text:"希贝尼克-克宁",data:[]},{value:"3",text:"锡萨克-莫斯拉维纳",data:[]},{value:"18",text:"伊斯特拉",data:[]},{value:"13",text:"扎达尔",data:[]},]},]},{value:"KEN",text:"肯尼亚",data:[{value:"?",text:"?",data:[{value:"EMA",text:"埃尔格约-马拉奎特",data:[]},{value:"BAR",text:"巴林戈",data:[]},{value:"BUN",text:"邦戈马",data:[]},{value:"BOM",text:"博美特",data:[]},{value:"BUS",text:"布希亚",data:[]},{value:"EMB",text:"恩布",data:[]},{value:"HOB",text:"霍马湾",data:[]},{value:"KIA",text:"基安布",data:[]},{value:"KIL",text:"基里菲",data:[]},{value:"KIR",text:"基里尼亚加",data:[]},{value:"KIS",text:"基苏木",data:[]},{value:"KIT",text:"基图伊",data:[]},{value:"KII",text:"基西",data:[]},{value:"GAS",text:"加里萨",data:[]},{value:"KAK",text:"卡卡梅加",data:[]},{value:"KAJ",text:"卡耶亚多",data:[]},{value:"KEY",text:"凯里乔",data:[]},{value:"KWA",text:"夸勒",data:[]},{value:"LAU",text:"拉木",data:[]},{value:"LAI",text:"莱基皮亚",data:[]},{value:"MAC",text:"马查科斯",data:[]},{value:"MAK",text:"马瓜尼",data:[]},{value:"RBT",text:"马萨布布",data:[]},{value:"MAN",text:"曼德拉",data:[]},{value:"MER",text:"梅鲁",data:[]},{value:"MOM",text:"蒙巴萨",data:[]},{value:"MIG",text:"米戈利",data:[]},{value:"MUR",text:"穆兰卡",data:[]},{value:"NUU",text:"纳库鲁",data:[]},{value:"NAR",text:"纳罗克",data:[]},{value:"NAN",text:"南迪",data:[]},{value:"NA",text:"内罗毕",data:[]},{value:"NIT",text:"尼蒂",data:[]},{value:"NYM",text:"尼亚米拉",data:[]},{value:"NYN",text:"年达鲁阿",data:[]},{value:"NYE",text:"涅里",data:[]},{value:"UAS",text:"桑布卢",data:[]},{value:"TRI",text:"塔纳河",data:[]},{value:"TTA",text:"泰塔塔维塔",data:[]},{value:"TNZ",text:"特兰斯-恩佐亚",data:[]},{value:"TUR",text:"图尔卡纳",data:[]},{value:"WJR",text:"瓦吉尔",data:[]},{value:"UGI",text:"瓦辛基苏",data:[]},{value:"VIH",text:"韦希加",data:[]},{value:"WPO",text:"西波克特",data:[]},{value:"SIA",text:"夏亚",data:[]},{value:"ISI",text:"伊希约洛",data:[]},{value:"CE",text:"中央",data:[]},]},]},{value:"COK",text:"库克群岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"LVA",text:"拉脱维亚",data:[{value:"?",text:"?",data:[{value:"ALU",text:"阿卢克斯内",data:[]},{value:"AIZ",text:"爱兹克劳克雷",data:[]},{value:"OGR",text:"奥格雷",data:[]},{value:"BAL",text:"巴尔维",data:[]},{value:"BAU",text:"包斯卡",data:[]},{value:"CES",text:"采西斯",data:[]},{value:"DOB",text:"多贝莱",data:[]},{value:"GUL",text:"古尔贝内",data:[]},{value:"JEK",text:"杰卡布皮尔斯",data:[]},{value:"KRA",text:"克拉斯拉瓦 ",data:[]},{value:"KUL",text:"库尔迪加",data:[]},{value:"RZR",text:"雷泽克内",data:[]},{value:"RGA",text:"里加",data:[]},{value:"LPK",text:"利耶帕亚",data:[]},{value:"LIM",text:"林巴济",data:[]},{value:"LUD",text:"卢扎",data:[]},{value:"MAD",text:"马多纳",data:[]},{value:"PRE",text:"普雷利",data:[]},{value:"SAL",text:"萨尔杜斯",data:[]},{value:"TAL",text:"塔尔西",data:[]},{value:"DGR",text:"陶格夫皮尔斯",data:[]},{value:"TUK",text:"图库马",data:[]},{value:"VLK",text:"瓦尔加",data:[]},{value:"VLM",text:"瓦尔米耶拉",data:[]},{value:"VSL",text:"文茨皮尔斯",data:[]},{value:"JGR",text:"叶尔加瓦",data:[]},]},]},{value:"LSO",text:"莱索托",data:[{value:"?",text:"?",data:[{value:"D",text:"伯里亚",data:[]},{value:"B",text:"布塔布泰",data:[]},{value:"G",text:"古廷",data:[]},{value:"H",text:"加查斯内克",data:[]},{value:"C",text:"莱里贝",data:[]},{value:"E",text:"马费滕",data:[]},{value:"A",text:"马塞卢",data:[]},{value:"F",text:"莫哈莱斯胡克",data:[]},{value:"J",text:"莫霍特隆",data:[]},{value:"K",text:"塔巴采卡",data:[]},]},]},{value:"LAO",text:"老挝",data:[{value:"?",text:"?",data:[{value:"AT",text:"阿速坡",data:[]},{value:"BL",text:"波里坎赛",data:[]},{value:"BK",text:"博乔",data:[]},{value:"XI",text:"川圹",data:[]},{value:"PH",text:"丰沙里",data:[]},{value:"KH",text:"甘蒙",data:[]},{value:"HO",text:"华潘",data:[]},{value:"LP",text:"琅勃拉邦",data:[]},{value:"LM",text:"琅南塔",data:[]},{value:"XN",text:"赛宋本行政特区",data:[]},{value:"XE",text:"色贡",data:[]},{value:"SL",text:"沙拉湾",data:[]},{value:"SV",text:"沙湾拿吉",data:[]},{value:"XA",text:"沙耶武里",data:[]},{value:"VI",text:"万象",data:[]},{value:"OU",text:"乌多姆赛",data:[]},{value:"CH",text:"占巴塞",data:[]},]},]},{value:"LBN",text:"黎巴嫩",data:[{value:"?",text:"?",data:[{value:"AS",text:"北部",data:[]},{value:"BI",text:"贝卡",data:[]},{value:"BA",text:"贝鲁特",data:[]},{value:"JL",text:"黎巴嫩山",data:[]},{value:"NA",text:"奈拜提耶市",data:[]},{value:"JA",text:"南部",data:[]},]},]},{value:"LBR",text:"利比里亚",data:[{value:"?",text:"?",data:[{value:"GBA",text:"巴波卢",data:[]},{value:"BG",text:"邦",data:[]},{value:"BOP",text:"博波卢",data:[]},{value:"BM",text:"博米",data:[]},{value:"GB",text:"大巴萨",data:[]},{value:"GG",text:"大吉德",data:[]},{value:"CM",text:"大角山",data:[]},{value:"GK",text:"大克鲁",data:[]},{value:"FT",text:"菲什敦",data:[]},{value:"RG",text:"吉河",data:[]},{value:"RI",text:"里弗塞斯",data:[]},{value:"LO",text:"洛法",data:[]},{value:"MG",text:"马吉比",data:[]},{value:"MY",text:"马里兰",data:[]},{value:"MO",text:"蒙特塞拉多",data:[]},{value:"NI",text:"宁巴",data:[]},{value:"SI",text:"锡诺",data:[]},]},]},{value:"LBY",text:"利比亚",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"LTU",text:"立陶宛",data:[{value:"?",text:"?",data:[{value:"AL",text:"阿利图斯",data:[]},{value:"KA",text:"考纳斯",data:[]},{value:"KL",text:"克莱佩达",data:[]},{value:"MA",text:"马里扬泊列",data:[]},{value:"PA",text:"帕涅韦日斯",data:[]},{value:"TA",text:"陶拉格",data:[]},{value:"TE",text:"特尔希艾",data:[]},{value:"VI",text:"维尔纽斯",data:[]},{value:"UT",text:"乌田纳",data:[]},{value:"SI",text:"希奥利艾",data:[]},{value:"AKM",text:"亚克曼",data:[]},]},]},{value:"LIE",text:"列支敦士登",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"REU",text:"留尼旺岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"LUX",text:"卢森堡",data:[{value:"?",text:"?",data:[{value:"DD",text:"迪基希",data:[]},{value:"GG",text:"格雷文马赫",data:[]},{value:"LL",text:"卢森堡",data:[]},]},]},{value:"RWA",text:"卢旺达",data:[{value:"?",text:"?",data:[{value:"BY",text:"比温巴",data:[]},{value:"BU",text:"布塔雷",data:[]},{value:"NY",text:"恩延扎",data:[]},{value:"KG",text:"基本古",data:[]},{value:"KY",text:"基布耶",data:[]},{value:"KR",text:"基加利-恩加利",data:[]},{value:"KV",text:"基加利市　 ",data:[]},{value:"GK",text:"吉孔戈罗",data:[]},{value:"GS",text:"吉塞尼",data:[]},{value:"GT",text:"吉塔拉马",data:[]},{value:"KA",text:"卡布加",data:[]},{value:"RW",text:"卢瓦马加纳",data:[]},{value:"RH",text:"鲁汉戈",data:[]},{value:"RU",text:"鲁亨盖里",data:[]},{value:"CY",text:"尚古古",data:[]},{value:"UM",text:"乌姆塔拉",data:[]},]},]},{value:"ROU",text:"罗马尼亚",data:[{value:"?",text:"?",data:[{value:"AL",text:"阿尔巴尤利亚",data:[]},{value:"AR",text:"阿拉德",data:[]},{value:"OR",text:"奥拉迪亚",data:[]},{value:"BA",text:"巴克乌",data:[]},{value:"BM",text:"巴亚马雷",data:[]},{value:"BN",text:"比斯特里察",data:[]},{value:"BO",text:"博托沙尼",data:[]},{value:"BC",text:"布加勒斯特",data:[]},{value:"BS",text:"布拉索夫",data:[]},{value:"BL",text:"布勒伊拉",data:[]},{value:"BZ",text:"布泽乌",data:[]},{value:"DT",text:"德罗贝塔-塞维林堡",data:[]},{value:"DE",text:"德瓦",data:[]},{value:"TI",text:"蒂米什瓦拉",data:[]},{value:"FO",text:"福克沙尼",data:[]},{value:"GL",text:"加拉茨",data:[]},{value:"GG",text:"久尔久",data:[]},{value:"CT",text:"康斯坦察",data:[]},{value:"DO",text:"克拉约瓦",data:[]},{value:"CR",text:"克勒拉希",data:[]},{value:"CN",text:"克卢日纳波卡",data:[]},{value:"VI",text:"勒姆尼库沃尔恰",data:[]},{value:"RE",text:"雷希察",data:[]},{value:"MC",text:"梅尔库里亚丘克",data:[]},{value:"PI",text:"皮特什蒂",data:[]},{value:"PN",text:"皮亚特拉尼亚姆茨",data:[]},{value:"PL",text:"普洛耶什蒂",data:[]},{value:"SM",text:"萨图·马雷",data:[]},{value:"SG",text:"圣格奥尔基",data:[]},{value:"ST",text:"斯拉蒂纳",data:[]},{value:"SB",text:"斯洛博齐亚",data:[]},{value:"SU",text:"苏恰瓦",data:[]},{value:"TA",text:"特尔戈维什泰",data:[]},{value:"TM",text:"特尔古穆列什",data:[]},{value:"TJ",text:"特尔古日乌",data:[]},{value:"TU",text:"图尔恰",data:[]},{value:"VA",text:"瓦斯卢伊",data:[]},{value:"SO",text:"锡比乌",data:[]},{value:"IS",text:"雅西",data:[]},{value:"AD",text:"亚厉山德里亚",data:[]},{value:"ZA",text:"扎勒乌",data:[]},]},]},{value:"MDG",text:"马达加斯加",data:[{value:"?",text:"?",data:[{value:"AS",text:"安齐拉纳纳 ",data:[]},{value:"FN",text:"菲亚纳兰楚阿 ",data:[]},{value:"MJ",text:"马哈赞加 ",data:[]},{value:"AN",text:"塔那那利佛 ",data:[]},{value:"TM",text:"图阿马西拉 ",data:[]},{value:"TL",text:"图利亚拉 ",data:[]},]},]},{value:"MDV",text:"马尔代夫",data:[{value:"?",text:"?",data:[{value:"ADD",text:"阿杜",data:[]},{value:"AAD",text:"北阿里",data:[]},{value:"THD",text:"北蒂拉杜马蒂",data:[]},{value:"MAD",text:"北马洛斯马杜卢",data:[]},{value:"MLD",text:"北米拉杜马杜卢",data:[]},{value:"NAD",text:"北尼兰杜",data:[]},{value:"HAD",text:"北苏瓦迪瓦",data:[]},{value:"FAA",text:"法迪福卢",data:[]},{value:"FEA",text:"费利杜",data:[]},{value:"FMU",text:"福阿穆拉库",data:[]},{value:"HDH",text:"哈杜马蒂",data:[]},{value:"KLH",text:"科卢马杜卢",data:[]},{value:"MAL",text:"马累",data:[]},{value:"MAA",text:"马累岛",data:[]},{value:"MUA",text:"穆拉库",data:[]},{value:"AAU",text:"南阿里",data:[]},{value:"THU",text:"南蒂拉杜马蒂",data:[]},{value:"MAU",text:"南马洛斯马杜卢",data:[]},{value:"MLU",text:"南米拉杜马杜卢",data:[]},{value:"NAU",text:"南尼兰杜",data:[]},{value:"HAU",text:"南苏瓦迪瓦",data:[]},]},]},{value:"MLT",text:"马耳他",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"MWI",text:"马拉维",data:[{value:"?",text:"?",data:[{value:"N",text:"北部区",data:[]},{value:"S",text:"南部区",data:[]},{value:"C",text:"中央区",data:[]},]},]},{value:"MYS",text:"马来西亚",data:[{value:"PH",text:"槟榔屿",data:[{value:"BWH",text:"北海",data:[]},{value:"PEN",text:"槟城",data:[]},{value:"BMJ",text:"大山脚",data:[]},{value:"NTE",text:"高渊",data:[]},]},{value:"PS",text:"玻璃市 　 　 ",data:[{value:"KGR",text:"加央",data:[]},]},{value:"TR",text:"丁加奴",data:[{value:"KEM",text:"甘马挽",data:[]},{value:"TGG",text:"瓜拉丁加奴",data:[]},{value:"DGN",text:"龙运",data:[]},{value:"MAR",text:"马江",data:[]},{value:"SET",text:"实兆",data:[]},{value:"HUL",text:"乌鲁",data:[]},{value:"BES",text:"勿述",data:[]},]},{value:"KD",text:"吉打",data:[{value:"PGT",text:"巴东得腊",data:[]},{value:"PEN",text:"笨筒",data:[]},{value:"LGK",text:"浮罗交怡",data:[]},{value:"KOR",text:"哥打士打",data:[]},{value:"KPA",text:"古邦巴素",data:[]},{value:"KMU",text:"瓜拉姆达",data:[]},{value:"BLZ",text:"华玲",data:[]},{value:"KLM",text:"居林",data:[]},{value:"BMA",text:"万拉峇鲁",data:[]},]},{value:"KN",text:"吉兰丹",data:[{value:"PPU",text:"巴西富地",data:[]},{value:"PMA",text:"巴西马",data:[]},{value:"TMR",text:"丹那美拉",data:[]},{value:"TUM",text:"道北",data:[]},{value:"BAC",text:"登卓",data:[]},{value:"KBR",text:"哥打巴鲁",data:[]},{value:"KUG",text:"瓜拉吉赖",data:[]},{value:"GMU",text:"话望生",data:[]},{value:"MAC",text:"马樟",data:[]},{value:"JEL",text:"日里",data:[]},]},{value:"KL",text:"吉隆坡",data:[{value:"KUL",text:"吉隆坡",data:[]},]},{value:"ML",text:"马六甲",data:[{value:"MEL",text:"马六甲市",data:[]},{value:"AOG",text:"亚罗牙也",data:[]},{value:"JAS",text:"野新",data:[]},]},{value:"LB",text:"纳闽",data:[{value:"LBU",text:"纳闽",data:[]},{value:"VIC",text:"维多利亚",data:[]},]},{value:"PG",text:"彭亨",data:[{value:"BER",text:"百乐",data:[]},{value:"PEK",text:"北根",data:[]},{value:"TEM",text:"淡马鲁",data:[]},{value:"JER",text:"而连突",data:[]},{value:"KUA",text:"关丹",data:[]},{value:"CAH",text:"金马仑高原",data:[]},{value:"RAU",text:"劳勿",data:[]},{value:"KUL",text:"立卑",data:[]},{value:"MAR",text:"马兰",data:[]},{value:"BEN",text:"文冬",data:[]},{value:"TOM",text:"云冰",data:[]},]},{value:"PK",text:"霹雳",data:[{value:"TAS",text:"安顺",data:[]},{value:"TAM",text:"丹绒马",data:[]},{value:"SSP",text:"和丰",data:[]},{value:"LUM",text:"紅土坎",data:[]},{value:"BGA",text:"华都牙也",data:[]},{value:"KAR",text:"江沙",data:[]},{value:"TPG",text:"太平",data:[]},{value:"IPH",text:"怡保",data:[]},]},{value:"JH",text:"柔佛",data:[{value:"POW",text:"笨珍",data:[]},{value:"MEP",text:"丰盛港",data:[]},{value:"KTI",text:"哥打丁宜",data:[]},{value:"KLA",text:"居銮",data:[]},{value:"BAT",text:"峇株巴辖",data:[]},{value:"MUA",text:"麻坡",data:[]},{value:"SGM",text:"昔加末",data:[]},{value:"JHB",text:"新山",data:[]},]},{value:"NS",text:"森美兰",data:[{value:"PDI",text:"波德申",data:[]},{value:"TAI",text:"淡边",data:[]},{value:"SRB",text:"芙蓉",data:[]},{value:"KPI",text:"瓜拉庇劳",data:[]},{value:"REM",text:"林茂",data:[]},{value:"JEP",text:"仁保",data:[]},{value:"JEL",text:"日叻务",data:[]},]},{value:"SB",text:"沙巴",data:[{value:"PAP",text:"吧巴",data:[]},{value:"BEF",text:"保佛",data:[]},{value:"BEL",text:"比鲁兰",data:[]},{value:"PIT",text:"必达士",data:[]},{value:"PMP",text:"兵南邦",data:[]},{value:"TAB",text:"担布南",data:[]},{value:"TEN",text:"丹南",data:[]},{value:"TAW",text:"斗湖",data:[]},{value:"TUR",text:"斗亚兰",data:[]},{value:"BKI",text:"哥打基纳巴鲁",data:[]},{value:"KMU",text:"哥打马鲁都",data:[]},{value:"KEG",text:"根地咬",data:[]},{value:"KUD",text:"古达",data:[]},{value:"KBD",text:"古打毛律",data:[]},{value:"KUN",text:"古纳",data:[]},{value:"KPU",text:"瓜拉班尤",data:[]},{value:"KBT",text:"京那巴登岸",data:[]},{value:"RNU",text:"兰脑",data:[]},{value:"LDU",text:"拿笃",data:[]},{value:"NAB",text:"纳巴湾",data:[]},{value:"SDK",text:"山打根",data:[]},{value:"SPT",text:"西比陶",data:[]},{value:"SMM",text:"仙本那",data:[]},]},{value:"SR",text:"沙捞越",data:[{value:"KCH",text:"古晋",data:[]},{value:"KPI",text:"加帛",data:[]},{value:"LMN",text:"林梦",data:[]},{value:"MYY",text:"美里",data:[]},{value:"BTU",text:"民都鲁",data:[]},{value:"MKM",text:"木胶",data:[]},{value:"BTG",text:"木中",data:[]},{value:"SMH",text:"三马拉汉",data:[]},{value:"SAM",text:"斯里阿曼",data:[]},{value:"SAR",text:"泗里街",data:[]},{value:"SBW",text:"泗务",data:[]},]},{value:"SL",text:"雪兰莪",data:[{value:"PJA",text:"八打灵",data:[]},{value:"GOM",text:"鹅麦",data:[]},{value:"KLG",text:"瓜拉冷岳",data:[]},{value:"KSL",text:"瓜拉雪兰莪",data:[]},{value:"SBM",text:"沙白安南",data:[]},{value:"HUL",text:"乌鲁冷岳",data:[]},{value:"HUS",text:"乌鲁雪兰莪",data:[]},{value:"SEP",text:"雪邦",data:[]},]},]},{value:"MLI",text:"马里",data:[{value:"?",text:"?",data:[{value:"CD",text:"巴马科首都区",data:[]},{value:"KD",text:"基达尔",data:[]},{value:"GA",text:"加奥",data:[]},{value:"KY",text:"卡伊",data:[]},{value:"KL",text:"库利科罗",data:[]},{value:"MP",text:"莫普提",data:[]},{value:"SG",text:"塞古",data:[]},{value:"TB",text:"通布图",data:[]},{value:"SK",text:"锡卡索",data:[]},]},]},{value:"MKD",text:"马其顿",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"MHL",text:"马绍尔群岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"MTQ",text:"马提尼克",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"MYT",text:"马约特岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"IMN",text:"曼岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"MUS",text:"毛里求斯",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"MRT",text:"毛里塔尼亚",data:[{value:"?",text:"?",data:[{value:"AD",text:"阿德拉尔",data:[]},{value:"AS",text:"阿萨巴",data:[]},{value:"BR",text:"卜拉克纳",data:[]},{value:"HG",text:"东胡德",data:[]},{value:"GO",text:"戈尔戈勒",data:[]},{value:"GM",text:"吉迪马卡",data:[]},{value:"DN",text:"努瓦迪布湾",data:[]},{value:"NO",text:"努瓦克肖特特区",data:[]},{value:"TA",text:"塔甘特",data:[]},{value:"TR",text:"特拉扎",data:[]},{value:"TZ",text:"提里斯-宰穆尔",data:[]},{value:"HC",text:"西胡德",data:[]},{value:"IN",text:"因希里",data:[]},]},]},{value:"USA",text:"美国",data:[{value:"AR",text:"阿肯色",data:[{value:"FYV",text:"费耶特维尔",data:[]},{value:"FSM",text:"史密斯堡",data:[]},{value:"LIT",text:"小石城",data:[]},]},{value:"AL",text:"阿拉巴马",data:[{value:"BHM",text:"伯明罕",data:[]},{value:"MGM",text:"蒙哥马利",data:[]},{value:"MOB",text:"莫比尔",data:[]},]},{value:"AK",text:"阿拉斯加",data:[{value:"ANC",text:"安克雷奇",data:[]},{value:"FAI",text:"费尔班克斯",data:[]},{value:"JNU",text:"朱诺",data:[]},]},{value:"ID",text:"爱达荷",data:[{value:"IDA",text:"爱达荷福尔斯",data:[]},{value:"PIH",text:"波卡特洛",data:[]},{value:"BOI",text:"博伊西",data:[]},{value:"BLK",text:"布莱克富特",data:[]},{value:"COE",text:"科达伦",data:[]},{value:"LWS",text:"刘易斯顿",data:[]},{value:"MJL",text:"莫斯科",data:[]},{value:"ZMU",text:"墨菲",data:[]},{value:"NPA",text:"楠帕",data:[]},{value:"QKM",text:"岂彻姆",data:[]},{value:"SVY",text:"森瓦利",data:[]},{value:"YAF",text:"亚美利加瀑布城",data:[]},]},{value:"IA",text:"爱荷华",data:[{value:"DVN",text:"达文波特",data:[]},{value:"DSM",text:"得梅因",data:[]},{value:"CID",text:"锡达拉皮兹",data:[]},]},{value:"ND",text:"北达科他",data:[{value:"BIS",text:"俾斯麦",data:[]},{value:"GFK",text:"大福克斯",data:[]},{value:"FAR",text:"法戈",data:[]},{value:"MOT",text:"迈诺特",data:[]},]},{value:"NC",text:"北卡罗来纳",data:[{value:"AEV",text:"艾许维尔",data:[]},{value:"DHH",text:"杜罕",data:[]},{value:"GBO",text:"格林斯伯勒",data:[]},{value:"CHE",text:"教堂山",data:[]},{value:"RAG",text:"罗利",data:[]},{value:"RDU",text:"洛利杜罕都会区",data:[]},{value:"CRQ",text:"夏洛特",data:[]},]},{value:"PA",text:"宾夕法尼亚",data:[{value:"AEW",text:"阿伦敦",data:[]},{value:"PHL",text:"费城",data:[]},{value:"PIT",text:"匹兹堡",data:[]},]},{value:"TX",text:"德克萨斯",data:[{value:"ELP",text:"埃尔帕索",data:[]},{value:"AUS",text:"奥斯汀",data:[]},{value:"DAL",text:"达拉斯",data:[]},{value:"CRP",text:"哥帕斯基斯蒂",data:[]},{value:"GLS",text:"交维斯顿",data:[]},{value:"LRD",text:"拉雷多",data:[]},{value:"TXC",text:"麦亚伦",data:[]},{value:"SAT",text:"圣安东尼奥",data:[]},{value:"HOU",text:"休斯敦",data:[]},]},{value:"OH",text:"俄亥俄",data:[{value:"DYT",text:"代顿",data:[]},{value:"CZX",text:"哥伦布",data:[]},{value:"CLE",text:"克利夫兰",data:[]},{value:"TOL",text:"托莱多",data:[]},{value:"CVG",text:"辛辛那提",data:[]},]},{value:"OK",text:"俄克拉荷马",data:[{value:"OKC",text:"俄克拉荷马城",data:[]},{value:"OUN",text:"诺曼",data:[]},{value:"TUL",text:"塔尔萨",data:[]},]},{value:"OR",text:"俄勒冈",data:[{value:"BZO",text:"本德",data:[]},{value:"PDX",text:"波特兰",data:[]},{value:"DLS",text:"达尔斯",data:[]},{value:"DAC",text:"达拉斯",data:[]},{value:"TLM",text:"蒂拉穆克",data:[]},{value:"XFX",text:"格兰茨帕斯",data:[]},{value:"HDX",text:"胡德里弗",data:[]},{value:"CTR",text:"火山口湖",data:[]},{value:"YCV",text:"科瓦利斯",data:[]},{value:"COB",text:"库斯贝",data:[]},{value:"MFR",text:"梅德福",data:[]},{value:"SLE",text:"塞勒姆",data:[]},{value:"STH",text:"圣海伦斯",data:[]},{value:"SPY",text:"斯普林菲尔德",data:[]},{value:"EUG",text:"尤金",data:[]},]},{value:"FL",text:"佛罗里达",data:[{value:"ORL",text:"奥兰多",data:[]},{value:"EYW",text:"基韦斯特",data:[]},{value:"JAX",text:"杰克逊维尔",data:[]},{value:"CPV",text:"卡纳维尔角",data:[]},{value:"FLL",text:"罗德岱堡",data:[]},{value:"MIA",text:"迈阿密",data:[]},{value:"PIE",text:"圣彼德斯堡市",data:[]},{value:"TLH",text:"塔拉哈西",data:[]},{value:"TPA",text:"坦帕",data:[]},]},{value:"VT",text:"佛蒙特",data:[{value:"BTV",text:"伯灵顿",data:[]},{value:"RUT",text:"拉特兰",data:[]},{value:"ZBR",text:"南伯灵顿",data:[]},]},{value:"DC",text:"哥伦比亚特区",data:[{value:"WAS",text:"华盛顿哥伦比亚特区",data:[]},]},{value:"WA",text:"华盛顿",data:[{value:"GEG",text:"斯波坎",data:[]},{value:"TTW",text:"塔科马",data:[]},{value:"SEA",text:"西雅图",data:[]},]},{value:"WY",text:"怀俄明",data:[{value:"EVD",text:"埃文斯顿",data:[]},{value:"CPR",text:"卡斯珀",data:[]},{value:"LAR",text:"拉勒米",data:[]},{value:"RKS",text:"罗克斯普林斯",data:[]},{value:"CYS",text:"夏延",data:[]},{value:"SHR",text:"谢里登",data:[]},]},{value:"CA",text:"加利福尼亚",data:[{value:"SFO",text:"旧金山",data:[]},{value:"LAX",text:"洛杉矶",data:[]},{value:"SAN",text:"圣迭戈",data:[]},{value:"SJC",text:"圣何塞",data:[]},]},{value:"KS",text:"堪萨斯",data:[{value:"ABZ",text:"阿比林",data:[]},{value:"OVL",text:"奥弗兰公园",data:[]},{value:"HCH",text:"哈钦森",data:[]},{value:"KCK",text:"堪萨斯城",data:[]},{value:"XIA",text:"莱文沃思",data:[]},{value:"LWC",text:"劳伦斯",data:[]},{value:"MHK",text:"曼哈顿",data:[]},{value:"TOP",text:"托皮卡",data:[]},{value:"ICT",text:"威奇托",data:[]},]},{value:"CT",text:"康涅狄格",data:[{value:"BDR",text:"布里奇波特",data:[]},{value:"DAQ",text:"达里恩",data:[]},{value:"GRH",text:"格林尼治",data:[]},{value:"HFD",text:"哈特福德",data:[]},{value:"XIN",text:"米德尔顿",data:[]},{value:"HVN",text:"纽黑文",data:[]},{value:"WPT",text:"韦斯特波特",data:[]},{value:"WAT",text:"沃特伯里",data:[]},{value:"NWT",text:"新不列颠",data:[]},]},{value:"CO",text:"科罗拉多",data:[{value:"ASE",text:"阿斯彭",data:[]},{value:"AUX",text:"奥罗拉",data:[]},{value:"WBU",text:"博尔德",data:[]},{value:"GJT",text:"大章克申",data:[]},{value:"DEN",text:"丹佛",data:[]},{value:"FNL",text:"柯林斯堡",data:[]},{value:"COS",text:"科罗拉多斯普林斯",data:[]},{value:"VAC",text:"韦尔",data:[]},]},{value:"KY",text:"肯塔基",data:[{value:"LEX",text:"列克星敦",data:[]},{value:"LUI",text:"路易斯维尔",data:[]},{value:"OWB",text:"欧文斯伯勒",data:[]},]},{value:"LA",text:"路易斯安那",data:[{value:"BTR",text:"巴吞鲁日",data:[]},{value:"SHV",text:"什里夫波特",data:[]},{value:"MSY",text:"新奥尔良",data:[]},]},{value:"RI",text:"罗德岛",data:[{value:"PAW",text:"波塔基特",data:[]},{value:"CQH",text:"克兰斯顿",data:[]},{value:"NPO",text:"纽波特",data:[]},{value:"PVD",text:"普罗维登斯",data:[]},{value:"WST",text:"韦斯特利",data:[]},{value:"SFN",text:"文索基特",data:[]},{value:"UZO",text:"沃威克",data:[]},]},{value:"MD",text:"马里兰",data:[{value:"BAL",text:"巴尔的摩",data:[]},{value:"GAI",text:"盖瑟斯堡",data:[]},{value:"RKV",text:"罗克维尔",data:[]},]},{value:"MA",text:"马萨诸塞",data:[{value:"BZD",text:"波士顿",data:[]},{value:"SFY",text:"斯普林菲尔德",data:[]},{value:"ORH",text:"伍斯特",data:[]},]},{value:"MT",text:"蒙大拿",data:[{value:"BGS",text:"比灵斯",data:[]},{value:"GTF",text:"大瀑布村",data:[]},{value:"MSO",text:"米苏拉",data:[]},]},{value:"MO",text:"密苏里",data:[{value:"COV",text:"哥伦比亚",data:[]},{value:"JEF",text:"杰佛逊市",data:[]},{value:"MKC",text:"堪萨斯城",data:[]},{value:"STL",text:"圣路易斯",data:[]},{value:"SGF",text:"斯普林菲尔德",data:[]},]},{value:"MS",text:"密西西比",data:[{value:"BIX",text:"比洛克西",data:[]},{value:"GPT",text:"格尔夫波特",data:[]},{value:"GLH",text:"格林维尔",data:[]},{value:"HBG",text:"哈蒂斯堡",data:[]},{value:"JAN",text:"杰克逊",data:[]},{value:"MEI",text:"默里迪恩",data:[]},{value:"VKS",text:"维克斯堡",data:[]},]},{value:"MI",text:"密歇根",data:[{value:"ARB",text:"安娜堡",data:[]},{value:"BTL",text:"巴特尔克里克",data:[]},{value:"BCY",text:"贝城",data:[]},{value:"GRR",text:"大急流城",data:[]},{value:"DEO",text:"迪尔伯恩",data:[]},{value:"DET",text:"底特律",data:[]},{value:"FNT",text:"弗林特",data:[]},{value:"WYD",text:"怀恩多特",data:[]},{value:"AZO",text:"卡拉马袓",data:[]},{value:"LAN",text:"兰辛",data:[]},{value:"MKG",text:"马斯基根",data:[]},{value:"PTK",text:"庞菷亚克",data:[]},{value:"SGM",text:"萨吉诺",data:[]},{value:"SSM",text:"苏圣玛丽",data:[]},{value:"WAM",text:"沃伦",data:[]},{value:"PHN",text:"休伦港",data:[]},]},{value:"ME",text:"缅因",data:[{value:"BNQ",text:"班戈",data:[]},{value:"POL",text:"波特兰",data:[]},{value:"QLW",text:"刘易斯顿",data:[]},]},{value:"MN",text:"明尼苏达",data:[{value:"RST",text:"罗切斯特",data:[]},{value:"MES",text:"明尼阿波利斯",data:[]},{value:"STP",text:"圣保罗",data:[]},]},{value:"SD",text:"南达科他",data:[{value:"ABK",text:"阿伯丁",data:[]},{value:"RAP",text:"拉皮德城",data:[]},{value:"FSD",text:"苏福尔斯",data:[]},]},{value:"SC",text:"南卡罗来纳",data:[{value:"NTS",text:"北查尔斯顿",data:[]},{value:"CHS",text:"查尔斯顿",data:[]},{value:"COV",text:"哥伦比亚",data:[]},]},{value:"NE",text:"内布拉斯加",data:[{value:"OMA",text:"奥马哈",data:[]},{value:"XDE",text:"贝尔维尤",data:[]},{value:"LNK",text:"林肯",data:[]},]},{value:"NV",text:"内华达",data:[{value:"EKO",text:"埃尔科",data:[]},{value:"NVS",text:"北拉斯维加斯",data:[]},{value:"VGI",text:"弗吉尼亚城",data:[]},{value:"HNZ",text:"亨德森",data:[]},{value:"CSN",text:"卡森城",data:[]},{value:"LAS",text:"拉斯维加斯",data:[]},{value:"RNO",text:"里诺",data:[]},{value:"SPK",text:"斯帕克斯",data:[]},]},{value:"NY",text:"纽约",data:[{value:"FFO",text:"布法罗",data:[]},{value:"ROC",text:"罗切斯特",data:[]},{value:"QEE",text:"纽约市",data:[]},]},{value:"DE",text:"特拉华",data:[{value:"DOR",text:"多佛",data:[]},{value:"NWK",text:"纽瓦克",data:[]},{value:"ILG",text:"威明顿",data:[]},]},{value:"TN",text:"田纳西",data:[{value:"BSJ",text:"布利斯托",data:[]},{value:"CHA",text:"查塔努加",data:[]},{value:"TRI",text:"金斯波特",data:[]},{value:"MEM",text:"孟菲斯",data:[]},{value:"BNA",text:"纳什维尔",data:[]},{value:"TYS",text:"诺克斯维尔",data:[]},{value:"YTC",text:"三城区",data:[]},{value:"MQY",text:"士麦那",data:[]},{value:"RGI",text:"斯普林希尔",data:[]},{value:"JCY",text:"约翰逊城",data:[]},]},{value:"WI",text:"威斯康星",data:[{value:"ATW",text:"阿普尓顿",data:[]},{value:"OSH",text:"奥什科什",data:[]},{value:"GBK",text:"格林贝",data:[]},{value:"ENW",text:"基诺沙",data:[]},{value:"LSE",text:"拉克罗斯",data:[]},{value:"RAC",text:"拉辛",data:[]},{value:"MTW",text:"马尼托沃克",data:[]},{value:"QMD",text:"迈迪逊",data:[]},{value:"MKE",text:"密尔沃基",data:[]},{value:"EAU",text:"欧克莱尓",data:[]},{value:"AUW",text:"沃索",data:[]},{value:"SBM",text:"希博伊根",data:[]},]},{value:"VA",text:"维吉尼亚",data:[{value:"VAB",text:"弗吉尼亚比奇",data:[]},{value:"ORF",text:"诺福克",data:[]},{value:"HTW",text:"切萨皮克",data:[]},]},{value:"WV",text:"西佛吉尼亚",data:[{value:"CRW",text:"查尔斯顿",data:[]},{value:"HNU",text:"亨廷顿",data:[]},{value:"PKB",text:"帕克斯堡",data:[]},]},{value:"HI",text:"夏威夷",data:[{value:"KHH",text:"凯卢阿",data:[]},{value:"HNL",text:"檀香山",data:[]},{value:"ITO",text:"希洛",data:[]},]},{value:"NH",text:"新罕布什尔",data:[{value:"CON",text:"康科德",data:[]},{value:"MHT",text:"曼彻斯特",data:[]},{value:"ASH",text:"纳舒厄",data:[]},]},{value:"NM",text:"新墨西哥",data:[{value:"ABQ",text:"阿尔伯克基",data:[]},{value:"LRU",text:"拉斯克鲁塞斯",data:[]},{value:"ROW",text:"罗斯韦尔",data:[]},{value:"SAF",text:"圣菲",data:[]},]},{value:"NJ",text:"新泽西",data:[{value:"NRK",text:"纽瓦克",data:[]},{value:"PAT",text:"帕特森",data:[]},{value:"JEC",text:"泽西城",data:[]},]},{value:"AZ",text:"亚利桑那",data:[{value:"PHX",text:"凤凰城",data:[]},{value:"GDA",text:"格兰代尔",data:[]},{value:"MQA",text:"梅萨",data:[]},{value:"STZ",text:"史卡兹代尔",data:[]},{value:"TPE",text:"坦普",data:[]},{value:"TUC",text:"图森",data:[]},{value:"YUM",text:"优玛",data:[]},]},{value:"IL",text:"伊利诺斯",data:[{value:"ALN",text:"奥尔顿",data:[]},{value:"AUZ",text:"奥罗拉",data:[]},{value:"BLO",text:"布卢明顿",data:[]},{value:"DVI",text:"丹维尓",data:[]},{value:"DEK",text:"迪卡尔布",data:[]},{value:"DEC",text:"迪凯持",data:[]},{value:"ESL",text:"东圣路易斯",data:[]},{value:"CMI",text:"厄巴纳-香槟",data:[]},{value:"GSU",text:"盖尔斯堡",data:[]},{value:"MDH",text:"卡本代尔",data:[]},{value:"RKI",text:"罗克艾兰",data:[]},{value:"RFD",text:"罗克福德",data:[]},{value:"NOM",text:"诺黙尔",data:[]},{value:"PLA",text:"皮奥里亚",data:[]},{value:"CRA",text:"森特勒利亚",data:[]},{value:"SPI",text:"斯普林菲尔德",data:[]},{value:"UGN",text:"沃其根",data:[]},{value:"CHI",text:"芝加哥",data:[]},]},{value:"IN",text:"印第安那",data:[{value:"EVV",text:"埃文斯维尔",data:[]},{value:"FWA",text:"韦恩堡",data:[]},{value:"IND",text:"印第安纳波利斯",data:[]},]},{value:"UT",text:"犹他",data:[{value:"OGD",text:"奥格登",data:[]},{value:"LTJ",text:"雷登",data:[]},{value:"OEU",text:"欧仁",data:[]},{value:"PAC",text:"帕克城",data:[]},{value:"PVU",text:"普罗沃",data:[]},{value:"SGU",text:"圣乔治",data:[]},{value:"WVC",text:"西瓦利城",data:[]},{value:"SLC",text:"盐湖城",data:[]},]},{value:"GA",text:"佐治亚",data:[{value:"AUT",text:"奥古斯塔",data:[]},{value:"CZX",text:"哥伦布",data:[]},{value:"MCN",text:"梅肯",data:[]},{value:"SAV",text:"沙瓦纳",data:[]},{value:"TAT",text:"亚特兰大",data:[]},]},]},{value:"ASM",text:"美属萨摩亚",data:[{value:"?",text:"?",data:[{value:"AAN",text:"阿纳",data:[]},{value:"ATU",text:"阿图阿",data:[]},{value:"AIT",text:"艾加伊勒泰",data:[]},{value:"FAA",text:"法塞莱莱阿加",data:[]},{value:"GFG",text:"加盖福毛加",data:[]},{value:"GMG",text:"加加埃毛加",data:[]},{value:"PAL",text:"帕劳利",data:[]},{value:"SAT",text:"萨图帕伊泰阿",data:[]},{value:"SAV",text:"萨瓦伊岛",data:[]},{value:"TUA",text:"图阿马萨加",data:[]},{value:"VAF",text:"瓦奥福诺蒂",data:[]},{value:"VAI",text:"韦西加诺",data:[]},{value:"UPO",text:"乌波卢岛",data:[]},]},]},{value:"UMI",text:"美属外岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"MNG",text:"蒙古",data:[{value:"?",text:"?",data:[{value:"69",text:"巴彦洪格尔",data:[]},{value:"71",text:"巴彦乌勒盖",data:[]},{value:"67",text:"布尔干",data:[]},{value:"37",text:"达尔汗乌勒",data:[]},{value:"61",text:"东方",data:[]},{value:"63",text:"东戈壁",data:[]},{value:"35",text:"鄂尔浑",data:[]},{value:"65",text:"戈壁阿尔泰",data:[]},{value:"64",text:"戈壁苏木贝尔",data:[]},{value:"73",text:"后杭爱",data:[]},{value:"43",text:"科布多",data:[]},{value:"39",text:"肯特",data:[]},{value:"41",text:"库苏古尔",data:[]},{value:"UMN",text:"南戈壁",data:[]},{value:"UVO",text:"前杭爱",data:[]},{value:"49",text:"色楞格",data:[]},{value:"51",text:"苏赫巴托尔",data:[]},{value:"46",text:"乌布苏",data:[]},{value:"1",text:"乌兰巴托市",data:[]},{value:"57",text:"扎布汗",data:[]},{value:"59",text:"中戈壁",data:[]},{value:"47",text:"中央",data:[]},]},]},{value:"MSR",text:"蒙特塞拉特",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"BGD",text:"孟加拉",data:[{value:"?",text:"?",data:[{value:"DAC",text:"达卡",data:[]},{value:"CGP",text:"吉大港",data:[]},{value:"KHL",text:"库尔纳",data:[]},]},]},{value:"FSM",text:"密克罗尼西亚",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"PER",text:"秘鲁",data:[{value:"?",text:"?",data:[{value:"AR",text:"阿雷基帕",data:[]},{value:"AP",text:"阿普里马克",data:[]},{value:"AY",text:"阿亚库乔",data:[]},{value:"AN",text:"安卡什",data:[]},{value:"JUL",text:"胡利亚卡",data:[]},{value:"JU",text:"胡宁",data:[]},{value:"CJ",text:"卡哈马卡",data:[]},{value:"CL",text:"卡亚俄",data:[]},{value:"CU",text:"库斯科",data:[]},{value:"LD",text:"拉利伯塔德",data:[]},{value:"LY",text:"兰巴耶克",data:[]},{value:"LI",text:"利马",data:[]},{value:"LO",text:"洛雷托",data:[]},{value:"MD",text:"马德雷德迪奥斯",data:[]},{value:"MO",text:"莫克瓜",data:[]},{value:"PA",text:"帕斯科",data:[]},{value:"PI",text:"皮乌拉",data:[]},{value:"PU",text:"普诺",data:[]},{value:"CHM",text:"钦博特",data:[]},{value:"CHI",text:"钦查阿尔塔",data:[]},{value:"SM",text:"圣马丁",data:[]},{value:"SUL",text:"苏拉纳",data:[]},{value:"TA",text:"塔克纳",data:[]},{value:"TU",text:"通贝斯",data:[]},{value:"HO",text:"瓦努科",data:[]},{value:"HV",text:"万卡维利卡",data:[]},{value:"UC",text:"乌卡亚利",data:[]},{value:"AM",text:"亚马孙",data:[]},{value:"IC",text:"伊卡",data:[]},]},]},{value:"MMR",text:"缅甸",data:[{value:"?",text:"?",data:[{value:"BG",text:"勃固省",data:[]},{value:"SH",text:"掸邦",data:[]},{value:"TN",text:"德林达依省",data:[]},{value:"KN",text:"克伦邦",data:[]},{value:"KC",text:"克钦邦",data:[]},{value:"KH",text:"克耶邦",data:[]},{value:"MG",text:"马圭省",data:[]},{value:"MD",text:"曼德勒省",data:[]},{value:"MN",text:"孟邦",data:[]},{value:"CH",text:"钦邦",data:[]},{value:"RK",text:"若开邦",data:[]},{value:"SG",text:"实皆省",data:[]},{value:"YG",text:"仰光省",data:[]},{value:"AY",text:"伊洛瓦底省",data:[]},]},]},{value:"MDA",text:"摩尔多瓦",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"MAR",text:"摩洛哥",data:[{value:"?",text:"?",data:[{value:"TGR",text:"丹吉尔",data:[]},{value:"TET",text:"得土安",data:[]},{value:"FES",text:"非斯",data:[]},{value:"CBL",text:"卡萨布兰卡",data:[]},{value:"RSA",text:"拉巴特",data:[]},{value:"MRK",text:"马拉喀什",data:[]},{value:"MKN",text:"梅克内斯",data:[]},{value:"OUJ",text:"乌季达",data:[]},{value:"WSH",text:"西撒哈拉",data:[]},]},]},{value:"MCO",text:"摩纳哥",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"MOZ",text:"莫桑比克",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"MEX",text:"墨西哥",data:[{value:"?",text:"?",data:[{value:"AGU",text:"阿瓜斯卡连斯特",data:[]},{value:"ACA",text:"阿卡普尔科",data:[]},{value:"HMO",text:"埃莫西约",data:[]},{value:"CAM",text:"埃佩切",data:[]},{value:"OBR",text:"奥夫雷贡城",data:[]},{value:"ORI",text:"奥里萨巴",data:[]},{value:"VHM",text:"巴利城",data:[]},{value:"PVR",text:"巴亚尔塔港",data:[]},{value:"VSA",text:"比利亚埃尔莫萨",data:[]},{value:"PRH",text:"波萨里卡",data:[]},{value:"TIJ",text:"蒂华纳",data:[]},{value:"DUR",text:"杜兰戈",data:[]},{value:"ESE",text:"恩塞纳达",data:[]},{value:"GDL",text:"瓜达拉哈拉",data:[]},{value:"GUA",text:"瓜纳华托",data:[]},{value:"JAL",text:"哈拉帕",data:[]},{value:"JUZ",text:"华雷斯",data:[]},{value:"BJU",text:"华雷斯港",data:[]},{value:"CAR",text:"卡门",data:[]},{value:"COL",text:"科利马",data:[]},{value:"QUE",text:"克雷塔罗",data:[]},{value:"CVC",text:"库埃纳瓦卡",data:[]},{value:"CUL",text:"库利阿坎",data:[]},{value:"COA",text:"夸察夸拉克斯",data:[]},{value:"LAP",text:"拉巴斯",data:[]},{value:"LEN",text:"莱昂",data:[]},{value:"REX",text:"雷诺萨",data:[]},{value:"LMM",text:"洛斯莫奇斯",data:[]},{value:"MZT",text:"马萨特兰",data:[]},{value:"MAM",text:"马塔莫罗斯",data:[]},{value:"MID",text:"梅里达",data:[]},{value:"LOV",text:"蒙克洛瓦",data:[]},{value:"MTY",text:"蒙特雷",data:[]},{value:"MLM",text:"莫雷利亚",data:[]},{value:"MEX",text:"墨西哥城",data:[]},{value:"MXL",text:"墨西卡利",data:[]},{value:"NOG",text:"诺加莱斯",data:[]},{value:"PAC",text:"帕丘卡",data:[]},{value:"PUE",text:"普埃布拉",data:[]},{value:"CHI",text:"奇尔潘辛戈",data:[]},{value:"CHH",text:"奇瓦瓦",data:[]},{value:"CTM",text:"切图马尔",data:[]},{value:"SLW",text:"萨尔蒂约",data:[]},{value:"ZAC",text:"萨卡特卡斯",data:[]},{value:"CLY",text:"塞拉亚",data:[]},{value:"SLP",text:"圣路易斯波托亚",data:[]},{value:"TAP",text:"塔帕丘拉",data:[]},{value:"TAM",text:"坦皮科",data:[]},{value:"TLA",text:"特拉斯卡拉",data:[]},{value:"TPQ",text:"特皮克",data:[]},{value:"TCN",text:"特瓦坎",data:[]},{value:"TGZ",text:"图斯特拉-古铁雷斯",data:[]},{value:"TRC",text:"托雷翁",data:[]},{value:"TLC",text:"托卢卡",data:[]},{value:"OAX",text:"瓦哈卡",data:[]},{value:"VIC",text:"维多利亚城",data:[]},{value:"VER",text:"韦拉克鲁斯",data:[]},{value:"UPN",text:"乌鲁阿潘",data:[]},{value:"NLE",text:"新拉雷多",data:[]},{value:"IRP",text:"伊拉普阿托",data:[]},]},]},{value:"NAM",text:"纳米比亚",data:[{value:"?",text:"?",data:[{value:"ER",text:"埃龙戈",data:[]},{value:"OW",text:"奥汉圭纳",data:[]},{value:"KV",text:"奥卡万戈",data:[]},{value:"OK",text:"奥马赫科",data:[]},{value:"OT",text:"奥姆沙蒂",data:[]},{value:"OJ",text:"奥乔宗蒂约巴",data:[]},{value:"ON",text:"奥沙纳",data:[]},{value:"OO",text:"奥希科托",data:[]},{value:"HA",text:"哈达普",data:[]},{value:"KH",text:"霍马斯",data:[]},{value:"KR",text:"卡拉斯",data:[]},{value:"CA",text:"卡普里维",data:[]},{value:"KU",text:"库内内",data:[]},]},]},{value:"ZAF",text:"南非",data:[{value:"?",text:"?",data:[{value:"UTN",text:"阿平顿",data:[]},{value:"MAY",text:"艾利弗山",data:[]},{value:"PZB",text:"彼德马里茨堡",data:[]},{value:"PTG",text:"彼德斯堡",data:[]},{value:"PRY",text:"比勒陀利亚",data:[]},{value:"BIY",text:"比索",data:[]},{value:"BDD",text:"布雷达斯多普",data:[]},{value:"BFN",text:"布隆方丹",data:[]},{value:"BHT",text:"布隆克斯特斯普利特",data:[]},{value:"DAA",text:"德阿尔",data:[]},{value:"DUR",text:"德班",data:[]},{value:"DUN",text:"邓迪",data:[]},{value:"BAE",text:"东巴克利",data:[]},{value:"ELS",text:"东伦敦",data:[]},{value:"VRU",text:"弗雷堡",data:[]},{value:"VGG",text:"弗里尼欣",data:[]},{value:"GBD",text:"格罗布莱斯达尔",data:[]},{value:"GIY",text:"基雅尼",data:[]},{value:"KIM",text:"金伯利",data:[]},{value:"CPT",text:"开普敦",data:[]},{value:"KXE",text:"克莱克斯多普",data:[]},{value:"KMH",text:"库鲁曼",data:[]},{value:"UTW",text:"昆士敦",data:[]},{value:"LAY",text:"莱迪史密斯",data:[]},{value:"RFT",text:"兰德方丹",data:[]},{value:"RCB",text:"理查兹湾",data:[]},{value:"RSB",text:"利斯滕堡",data:[]},{value:"MDB",text:"米德尔堡",data:[]},{value:"MZQ",text:"姆库泽",data:[]},{value:"MOO",text:"穆里斯堡",data:[]},{value:"NLP",text:"内尔斯普雷特",data:[]},{value:"NYL",text:"尼尔斯特隆",data:[]},{value:"NCS",text:"纽卡斯尔",data:[]},{value:"GRJ",text:"乔治",data:[]},{value:"SAS",text:"萨索尔堡",data:[]},{value:"ZEC",text:"瑟孔达",data:[]},{value:"IXO",text:"特克索波",data:[]},{value:"TPB",text:"特隆普斯堡",data:[]},{value:"SBU",text:"跳羚",data:[]},{value:"TLH",text:"图拉马哈谢",data:[]},{value:"THY",text:"托霍延杜",data:[]},{value:"WSH",text:"韦茨肖克",data:[]},{value:"WEL",text:"韦尔科姆",data:[]},{value:"ULD",text:"乌伦迪",data:[]},{value:"UTT",text:"乌姆塔塔",data:[]},{value:"WOR",text:"伍斯特",data:[]},{value:"BEW",text:"西博福特",data:[]},{value:"PSS",text:"谢普斯通港",data:[]},{value:"PLZ",text:"伊丽莎白港",data:[]},{value:"JNB",text:"约翰内斯堡",data:[]},]},]},{value:"ATA",text:"南极洲",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"SGS",text:"南乔治亚和南桑德威奇群岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"NRU",text:"瑙鲁",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"NPL",text:"尼泊尔",data:[{value:"?",text:"?",data:[{value:"BA",text:"巴格马蒂",data:[]},{value:"DH",text:"道拉吉里",data:[]},{value:"GA",text:"甘达基",data:[]},{value:"KO",text:"戈西",data:[]},{value:"KA",text:"格尔纳利",data:[]},{value:"JA",text:"贾纳克布尔",data:[]},{value:"RA",text:"拉布蒂",data:[]},{value:"LU",text:"蓝毗尼",data:[]},{value:"MA",text:"马哈卡利",data:[]},{value:"ME",text:"梅吉",data:[]},{value:"NA",text:"纳拉亚尼",data:[]},{value:"BH",text:"佩里",data:[]},{value:"SA",text:"萨加玛塔",data:[]},{value:"SE",text:"塞蒂",data:[]},]},]},{value:"NIC",text:"尼加拉瓜",data:[{value:"?",text:"?",data:[{value:"ES",text:"埃斯特利",data:[]},{value:"AN",text:"北大西洋",data:[]},{value:"BO",text:"博阿科",data:[]},{value:"GR",text:"格拉纳达",data:[]},{value:"CA",text:"卡拉索",data:[]},{value:"LE",text:"莱昂",data:[]},{value:"RV",text:"里瓦斯",data:[]},{value:"MD",text:"马德里斯",data:[]},{value:"MN",text:"马那瓜",data:[]},{value:"MS",text:"马萨亚",data:[]},{value:"MT",text:"马塔加尔帕",data:[]},{value:"AS",text:"南大西洋",data:[]},{value:"CD",text:"奇南德加",data:[]},{value:"CT",text:"琼塔莱斯",data:[]},{value:"SJ",text:"圣胡安河",data:[]},{value:"JI",text:"希诺特加",data:[]},{value:"NS",text:"新塞哥维亚",data:[]},]},]},{value:"NER",text:"尼日尔",data:[{value:"?",text:"?",data:[{value:"AJY",text:"阿加德兹",data:[]},{value:"DIF",text:"迪法",data:[]},{value:"TIL",text:"蒂拉贝里",data:[]},{value:"DSS",text:"多索",data:[]},{value:"ZND",text:"津德尔",data:[]},{value:"MFQ",text:"马拉迪",data:[]},{value:"NIM",text:"尼亚美市",data:[]},{value:"THZ",text:"塔瓦",data:[]},]},]},{value:"NGA",text:"尼日利亚",data:[{value:"?",text:"?",data:[{value:"ABV",text:"阿比亚",data:[]},{value:"OGB",text:"奥博莫绍",data:[]},{value:"KAN",text:"卡诺",data:[]},{value:"LOS",text:"拉各斯",data:[]},{value:"IBA",text:"伊巴丹",data:[]},]},]},{value:"NIU",text:"纽埃",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"NOR",text:"挪威",data:[{value:"?",text:"?",data:[{value:"2",text:"阿克什胡斯",data:[]},{value:"5",text:"奥普兰",data:[]},{value:"3",text:"奥斯陆市",data:[]},{value:"17",text:"北特伦德拉格",data:[]},{value:"6",text:"布斯克吕",data:[]},{value:"9",text:"东阿格德尔",data:[]},{value:"1",text:"东福尔",data:[]},{value:"20",text:"芬马克",data:[]},{value:"4",text:"海德马克",data:[]},{value:"12",text:"霍达兰",data:[]},{value:"11",text:"罗加兰",data:[]},{value:"15",text:"默勒－鲁姆斯达尔",data:[]},{value:"16",text:"南特伦德拉格",data:[]},{value:"18",text:"诺尔兰",data:[]},{value:"14",text:"松恩－菲尤拉讷",data:[]},{value:"8",text:"泰勒马克",data:[]},{value:"19",text:"特罗姆斯",data:[]},{value:"10",text:"西阿格德尔",data:[]},{value:"7",text:"西福尔",data:[]},]},]},{value:"NFK",text:"诺福克",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"PLW",text:"帕劳群岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"PCN",text:"皮特凯恩",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"PRT",text:"葡萄牙",data:[{value:"?",text:"?",data:[{value:"ALL",text:"滨海阿连特茹",data:[]},{value:"PLT",text:"滨海皮尼亚尔",data:[]},{value:"VDP",text:"波尔图",data:[]},{value:"MDR",text:"杜罗",data:[]},{value:"EDV",text:"恩特拉杜罗伏日 　 　",data:[]},{value:"FAO",text:"法鲁",data:[]},{value:"FUN",text:"丰沙尔",data:[]},{value:"CAV",text:"卡瓦多 　 　",data:[]},{value:"CLB",text:"科瓦贝拉 　 　 　",data:[]},{value:"LIS",text:"里斯本",data:[]},{value:"LTE",text:"利巴特茹",data:[]},{value:"MTE",text:"梅地奥特茹 　",data:[]},{value:"MLI",text:"米尼奥-利马 　",data:[]},{value:"BIN",text:"内贝拉北",data:[]},{value:"BIS",text:"内贝拉南 　",data:[]},{value:"PIN",text:"内皮尼亚尔北",data:[]},{value:"PIS",text:"内皮尼亚尔南 　",data:[]},{value:"PDL",text:"蓬塔德尔加达",data:[]},{value:"PSE",text:"塞图巴尔半岛",data:[]},{value:"SES",text:"山后",data:[]},{value:"AAT",text:"上阿连特茹",data:[]},{value:"ATM",text:"上特拉斯山 　 　",data:[]},{value:"TAM",text:"塔梅加",data:[]},{value:"AES",text:"万福",data:[]},{value:"OES",text:"西部",data:[]},{value:"BAL",text:"下阿连特茹",data:[]},{value:"BVO",text:"下伏日",data:[]},{value:"BMO",text:"下蒙德古",data:[]},{value:"ALC",text:"中阿连特茹",data:[]},]},]},{value:"GEO",text:"乔治亚",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"JPN",text:"日本",data:[{value:"?",text:"?",data:[{value:"38",text:"爱媛",data:[]},{value:"23",text:"爱知",data:[]},{value:"1",text:"北海道",data:[]},{value:"28",text:"兵库",data:[]},{value:"47",text:"冲绳",data:[]},{value:"8",text:"茨城",data:[]},{value:"27",text:"大阪",data:[]},{value:"44",text:"大分",data:[]},{value:"32",text:"岛根",data:[]},{value:"36",text:"徳岛",data:[]},{value:"13",text:"东京",data:[]},{value:"7",text:"福岛",data:[]},{value:"40",text:"福冈",data:[]},{value:"18",text:"福井",data:[]},{value:"16",text:"富山",data:[]},{value:"33",text:"冈山",data:[]},{value:"39",text:"高知",data:[]},{value:"4",text:"宮城",data:[]},{value:"45",text:"宫崎",data:[]},{value:"34",text:"广岛",data:[]},{value:"30",text:"和歌山",data:[]},{value:"26",text:"京都",data:[]},{value:"22",text:"静冈",data:[]},{value:"9",text:"枥木",data:[]},{value:"46",text:"鹿儿岛",data:[]},{value:"29",text:"奈良",data:[]},{value:"31",text:"鸟取",data:[]},{value:"21",text:"岐阜",data:[]},{value:"11",text:"埼玉",data:[]},{value:"12",text:"千叶",data:[]},{value:"2",text:"青森",data:[]},{value:"5",text:"秋田",data:[]},{value:"10",text:"群马",data:[]},{value:"24",text:"三重",data:[]},{value:"35",text:"山口",data:[]},{value:"19",text:"山梨",data:[]},{value:"6",text:"山形",data:[]},{value:"14",text:"神奈川",data:[]},{value:"17",text:"石川",data:[]},{value:"37",text:"香川",data:[]},{value:"15",text:"新潟",data:[]},{value:"43",text:"熊本",data:[]},{value:"3",text:"岩手",data:[]},{value:"42",text:"长崎",data:[]},{value:"20",text:"长野",data:[]},{value:"25",text:"滋贺",data:[]},{value:"41",text:"佐贺",data:[]},]},]},{value:"SWE",text:"瑞典",data:[{value:"?",text:"?",data:[{value:"BD",text:"北博滕",data:[]},{value:"K",text:"布莱金厄",data:[]},{value:"DLN",text:"达拉纳",data:[]},{value:"UGL",text:"东约特兰",data:[]},{value:"T",text:"厄勒布鲁",data:[]},{value:"I",text:"哥得兰",data:[]},{value:"N",text:"哈兰",data:[]},{value:"H",text:"卡尔马",data:[]},{value:"G",text:"克鲁努贝里",data:[]},{value:"D",text:"南曼兰",data:[]},{value:"AB",text:"斯德哥尔摩",data:[]},{value:"M",text:"斯科耐",data:[]},{value:"S",text:"韦姆兰",data:[]},{value:"C",text:"乌普萨拉",data:[]},{value:"AC",text:"西博滕",data:[]},{value:"U",text:"西曼兰",data:[]},{value:"Y",text:"西诺尔兰",data:[]},{value:"O",text:"西约特兰",data:[]},{value:"F",text:"延雪平",data:[]},{value:"X",text:"耶夫勒堡",data:[]},{value:"Z",text:"耶姆特兰",data:[]},]},]},{value:"CHE",text:"瑞士",data:[{value:"?",text:"?",data:[{value:"AG",text:"阿尔高",data:[]},{value:"BS",text:"巴塞尔城市",data:[]},{value:"BL",text:"巴塞尔乡村",data:[]},{value:"BE",text:"伯尔尼",data:[]},{value:"ZG",text:"楚格",data:[]},{value:"FR",text:"弗里堡",data:[]},{value:"GL",text:"格拉鲁斯",data:[]},{value:"GR",text:"格劳宾登",data:[]},{value:"LU",text:"卢塞恩",data:[]},{value:"LA",text:"洛桑",data:[]},{value:"NE",text:"纳沙泰尔",data:[]},{value:"AI",text:"内阿彭策尔",data:[]},{value:"GE",text:"日内瓦",data:[]},{value:"JU",text:"汝拉",data:[]},{value:"SH",text:"沙夫豪森",data:[]},{value:"OW",text:"上瓦尔登",data:[]},{value:"SG",text:"圣加仑",data:[]},{value:"SZ",text:"施维茨",data:[]},{value:"ZH",text:"苏黎世",data:[]},{value:"SO",text:"索洛图恩",data:[]},{value:"TI",text:"提契诺",data:[]},{value:"TG",text:"图尔高",data:[]},{value:"VS",text:"瓦莱",data:[]},{value:"AR",text:"外阿彭策尔",data:[]},{value:"VD",text:"沃",data:[]},{value:"UR",text:"乌里",data:[]},{value:"NW",text:"下瓦尔登",data:[]},]},]},{value:"SLV",text:"萨尔瓦多",data:[{value:"?",text:"?",data:[{value:"APO",text:"阿波帕",data:[]},{value:"AH",text:"阿瓦查潘",data:[]},{value:"LI",text:"滨海",data:[]},{value:"CH",text:"查拉特南戈",data:[]},{value:"DE",text:"德尔加多",data:[]},{value:"KN",text:"基埃-恩特姆",data:[]},{value:"CA",text:"卡瓦尼亚斯",data:[]},{value:"CU",text:"库斯卡特兰",data:[]},{value:"PZ",text:"拉巴斯",data:[]},{value:"LB",text:"拉利伯塔德",data:[]},{value:"UN",text:"拉乌尼翁",data:[]},{value:"MEJ",text:"梅基卡诺斯",data:[]},{value:"MO",text:"莫拉桑",data:[]},{value:"SA",text:"圣安娜",data:[]},{value:"SM",text:"圣米格尔",data:[]},{value:"SS",text:"圣萨尔瓦多",data:[]},{value:"SV",text:"圣维森特",data:[]},{value:"SO",text:"松索纳特",data:[]},{value:"SOY",text:"索亚潘戈",data:[]},{value:"WN",text:"韦莱-恩萨斯",data:[]},{value:"US",text:"乌苏卢坦",data:[]},{value:"IL",text:"伊洛潘戈",data:[]},{value:"CS",text:"中南",data:[]},]},]},{value:"WSM",text:"萨摩亚",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"SCG",text:"塞尔维亚,黑山",data:[{value:"?",text:"?",data:[{value:"BEG",text:"贝尔格莱德",data:[]},{value:"POD",text:"波德戈里察",data:[]},{value:"KGV",text:"克拉古涅瓦茨",data:[]},{value:"INI",text:"尼什",data:[]},{value:"NVS",text:"诺维萨德",data:[]},{value:"PRN",text:"普里什蒂纳",data:[]},{value:"SUB",text:"苏博蒂察",data:[]},{value:"ZEM",text:"泽蒙",data:[]},]},]},{value:"SLE",text:"塞拉利昂",data:[{value:"?",text:"?",data:[{value:"N",text:"北部",data:[]},{value:"E",text:"东部",data:[]},{value:"S",text:"南部",data:[]},{value:"W",text:"西部区",data:[]},]},]},{value:"SEN",text:"塞内加尔",data:[{value:"?",text:"?",data:[{value:"DA",text:"达喀尔",data:[]},{value:"FA",text:"法蒂克",data:[]},{value:"ZI",text:"济金绍尔",data:[]},{value:"TH",text:"捷斯",data:[]},{value:"DI",text:"久尔贝勒",data:[]},{value:"KA",text:"考拉克",data:[]},{value:"KO",text:"科尔达",data:[]},{value:"LO",text:"卢加",data:[]},{value:"MA",text:"马塔姆",data:[]},{value:"SL",text:"圣路易",data:[]},{value:"TA",text:"坦巴昆达",data:[]},]},]},{value:"CYP",text:"塞浦路斯",data:[{value:"?",text:"?",data:[{value:"4",text:"法马古斯塔",data:[]},{value:"6",text:"凯里尼亚",data:[]},{value:"3",text:"拉纳卡",data:[]},{value:"2",text:"利马索尔",data:[]},{value:"1",text:"尼科西亚",data:[]},{value:"5",text:"帕福斯",data:[]},]},]},{value:"SYC",text:"塞舌尔",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"SAU",text:"沙特阿拉伯",data:[{value:"?",text:"?",data:[{value:"ARA",text:"阿尔阿尔",data:[]},{value:"AHB",text:"艾卜哈",data:[]},{value:"BH",text:"巴哈",data:[]},{value:"BUR",text:"布赖代",data:[]},{value:"DAM",text:"达曼",data:[]},{value:"HBT",text:"哈费尔巴廷",data:[]},{value:"HL",text:"哈伊勒",data:[]},{value:"KMX",text:"海米斯穆谢特",data:[]},{value:"AKH",text:"海耶",data:[]},{value:"HFF",text:"胡富夫",data:[]},{value:"JED",text:"吉达",data:[]},{value:"JZ",text:"吉赞",data:[]},{value:"RD",text:"利雅得",data:[]},{value:"MED",text:"麦地那",data:[]},{value:"ML",text:"麦加",data:[]},{value:"MBR",text:"姆巴拉兹",data:[]},{value:"NR",text:"纳季兰",data:[]},{value:"SAK",text:"塞卡卡",data:[]},{value:"TB",text:"塔布克",data:[]},{value:"TAR",text:"塔伊夫",data:[]},{value:"YNB",text:"延布",data:[]},{value:"JBI",text:"朱拜勒",data:[]},]},]},{value:"CXR",text:"圣诞岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"STP",text:"圣多美和普林西比",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"SHN",text:"圣赫勒拿",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"KNA",text:"圣基茨和尼维斯",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"LCA",text:"圣卢西亚",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"SMR",text:"圣马力诺",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"SPM",text:"圣皮埃尔和米克隆群岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"VCT",text:"圣文森特和格林纳丁斯",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"LKA",text:"斯里兰卡",data:[{value:"?",text:"?",data:[{value:"ADP",text:"阿努拉德普勒",data:[]},{value:"AMP",text:"安帕赖",data:[]},{value:"BAD",text:"巴杜勒",data:[]},{value:"BTC",text:"拜蒂克洛",data:[]},{value:"POL",text:"波隆纳鲁沃",data:[]},{value:"HBA",text:"汉班托特",data:[]},{value:"KIL",text:"基里诺奇",data:[]},{value:"GAL",text:"加勒",data:[]},{value:"GAM",text:"加姆珀哈",data:[]},{value:"JAF",text:"贾夫纳",data:[]},{value:"KLT",text:"卡卢特勒",data:[]},{value:"KEG",text:"凯格勒",data:[]},{value:"KAN",text:"康提",data:[]},{value:"CMB",text:"科伦坡",data:[]},{value:"KUR",text:"库鲁内格勒",data:[]},{value:"RAT",text:"拉特纳普勒",data:[]},{value:"MAN",text:"马纳尔",data:[]},{value:"MAT",text:"马特莱",data:[]},{value:"MAA",text:"马特勒",data:[]},{value:"MON",text:"莫讷勒格勒",data:[]},{value:"MUL",text:"穆莱蒂武",data:[]},{value:"NUE",text:"努沃勒埃利耶",data:[]},{value:"PUT",text:"普塔勒姆",data:[]},{value:"TRR",text:"亭可马里",data:[]},{value:"VAV",text:"瓦武尼亚",data:[]},]},]},{value:"SVK",text:"斯洛伐克",data:[{value:"?",text:"?",data:[{value:"BBY",text:"班斯卡-比斯特里察",data:[]},{value:"BTS",text:"布拉迪斯拉发",data:[]},{value:"KOR",text:"科希策",data:[]},{value:"NRA",text:"尼特拉",data:[]},{value:"POV",text:"普雷绍夫",data:[]},{value:"RIL",text:"日利纳",data:[]},{value:"TNA",text:"特尔纳瓦",data:[]},{value:"TRE",text:"特伦钦",data:[]},]},]},{value:"SVN",text:"斯洛文尼亚",data:[{value:"?",text:"?",data:[{value:"OKR",text:"奥巴尔诺-克拉",data:[]},{value:"OSR",text:"奥斯雷德涅斯洛文",data:[]},{value:"POD",text:"波德拉夫",data:[]},{value:"POM",text:"波穆尔",data:[]},{value:"DLJ",text:"多雷尼",data:[]},{value:"GSZ",text:"戈雷尼",data:[]},{value:"GSK",text:"戈里",data:[]},{value:"KOR",text:"科洛",data:[]},{value:"NKR",text:"诺特拉尼",data:[]},{value:"SAV",text:"萨维尼",data:[]},{value:"SPO",text:"斯波德涅波萨夫",data:[]},{value:"ZAS",text:"扎萨夫",data:[]},]},]},{value:"SJM",text:"斯瓦尔巴和扬马廷",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"SWZ",text:"斯威士兰",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"SDN",text:"苏丹",data:[{value:"?",text:"?",data:[{value:"ASH",text:"北部",data:[]},{value:"SIS",text:"赤道",data:[]},{value:"SDA",text:"达尔富尔",data:[]},{value:"SHA",text:"东部",data:[]},{value:"SBG",text:"加扎勒河",data:[]},{value:"KRT",text:"喀土穆",data:[]},{value:"GKU",text:"科尔多凡",data:[]},{value:"ANB",text:"上尼罗",data:[]},{value:"WDH",text:"中部",data:[]},]},]},{value:"SUR",text:"苏里南",data:[{value:"?",text:"?",data:[{value:"BR",text:"布罗科蓬多",data:[]},{value:"CR",text:"科罗尼",data:[]},{value:"CM",text:"科默韦讷",data:[]},{value:"MA",text:"马罗韦讷",data:[]},{value:"NI",text:"尼克里",data:[]},{value:"PA",text:"帕拉",data:[]},{value:"PM",text:"帕拉马里博",data:[]},{value:"SA",text:"萨拉马卡",data:[]},{value:"WA",text:"瓦尼卡",data:[]},{value:"SI",text:"西帕里韦尼",data:[]},]},]},{value:"SLB",text:"所罗门群岛",data:[{value:"?",text:"?",data:[{value:"GC",text:"瓜达尔卡纳尔",data:[]},{value:"HO",text:"霍尼亚拉",data:[]},{value:"RB",text:"拉纳尔和贝罗纳",data:[]},{value:"MK",text:"马基拉",data:[]},{value:"ML",text:"马莱塔",data:[]},{value:"CH",text:"乔伊索",data:[]},{value:"TM",text:"泰莫图",data:[]},{value:"WE",text:"西部",data:[]},{value:"IS",text:"伊萨贝尔",data:[]},{value:"CE",text:"中部群岛",data:[]},]},]},{value:"SOM",text:"索马里",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"TJK",text:"塔吉克斯坦",data:[{value:"?",text:"?",data:[{value:"DYU",text:"杜尚别",data:[]},{value:"KHO",text:"霍罗格",data:[]},{value:"KAN",text:"卡尼巴达姆",data:[]},{value:"KOF",text:"科法尔尼洪",data:[]},{value:"KHU",text:"苦盏",data:[]},{value:"KTJ",text:"库尔干-秋别",data:[]},{value:"KLB",text:"库洛布",data:[]},{value:"RGU",text:"洛贡",data:[]},{value:"NUR",text:"努雷克",data:[]},{value:"PJK",text:"彭吉肯特",data:[]},{value:"SBA",text:"萨班特",data:[]},{value:"TBS",text:"塔博沙尔",data:[]},{value:"TSZ",text:"图尔孙扎德",data:[]},{value:"UTJ",text:"乌拉秋别",data:[]},{value:"ISF",text:"伊斯法拉",data:[]},]},]},{value:"THA",text:"泰国",data:[{value:"?",text:"?",data:[{value:"37",text:"安纳乍能",data:[]},{value:"77",text:"巴蜀",data:[]},{value:"13",text:"巴吞他尼",data:[]},{value:"25",text:"巴真",data:[]},{value:"71",text:"北碧",data:[]},{value:"19",text:"北标",data:[]},{value:"94",text:"北大年",data:[]},{value:"11",text:"北揽",data:[]},{value:"60",text:"北榄坡",data:[]},{value:"24",text:"北柳",data:[]},{value:"76",text:"碧差汶",data:[]},{value:"93",text:"博达伦",data:[]},{value:"18",text:"猜那",data:[]},{value:"36",text:"猜也奔",data:[]},{value:"53",text:"程逸",data:[]},{value:"86",text:"春蓬",data:[]},{value:"20",text:"春武里",data:[]},{value:"63",text:"达",data:[]},{value:"23",text:"达叻",data:[]},{value:"14",text:"大城",data:[]},{value:"92",text:"董里",data:[]},{value:"78",text:"佛丕",data:[]},{value:"73",text:"佛统",data:[]},{value:"62",text:"甘烹碧",data:[]},{value:"15",text:"红统",data:[]},{value:"16",text:"华富里",data:[]},{value:"46",text:"加拉信",data:[]},{value:"81",text:"甲米",data:[]},{value:"22",text:"尖竹汶",data:[]},{value:"40",text:"孔敬",data:[]},{value:"21",text:"拉农",data:[]},{value:"43",text:"廊开",data:[]},{value:"39",text:"廊莫那浦",data:[]},{value:"70",text:"叻丕",data:[]},{value:"42",text:"黎",data:[]},{value:"45",text:"黎逸",data:[]},{value:"74",text:"龙仔厝",data:[]},{value:"85",text:"罗勇",data:[]},{value:"80",text:"洛坤",data:[]},{value:"44",text:"玛哈沙拉堪",data:[]},{value:"10",text:"曼谷",data:[]},{value:"49",text:"莫达汉",data:[]},{value:"26",text:"那空那育",data:[]},{value:"48",text:"那空帕农",data:[]},{value:"55",text:"难",data:[]},{value:"51",text:"南奔",data:[]},{value:"12",text:"暖武里",data:[]},{value:"54",text:"帕",data:[]},{value:"56",text:"帕尧",data:[]},{value:"82",text:"攀牙",data:[]},{value:"65",text:"彭世洛",data:[]},{value:"66",text:"披集",data:[]},{value:"83",text:"普吉",data:[]},{value:"57",text:"清莱",data:[]},{value:"50",text:"清迈",data:[]},{value:"47",text:"色军",data:[]},{value:"91",text:"沙敦",data:[]},{value:"27",text:"沙缴",data:[]},{value:"33",text:"四色菊",data:[]},{value:"90",text:"宋卡",data:[]},{value:"64",text:"素可泰",data:[]},{value:"84",text:"素叻",data:[]},{value:"32",text:"素林",data:[]},{value:"72",text:"素攀武里",data:[]},{value:"96",text:"陶公",data:[]},{value:"41",text:"乌隆",data:[]},{value:"61",text:"乌泰他尼",data:[]},{value:"34",text:"乌汶",data:[]},{value:"31",text:"武里南",data:[]},{value:"17",text:"信武里",data:[]},{value:"35",text:"耶梭通",data:[]},{value:"95",text:"也拉",data:[]},{value:"58",text:"夜丰颂",data:[]},{value:"75",text:"夜功",data:[]},]},]},{value:"TZA",text:"坦桑尼亚",data:[{value:"?",text:"?",data:[{value:"AR",text:"阿鲁沙",data:[]},{value:"PN",text:"奔巴北",data:[]},{value:"PS",text:"奔巴南",data:[]},{value:"PW",text:"滨海",data:[]},{value:"DS",text:"达累斯萨拉姆",data:[]},{value:"DO",text:"多多马",data:[]},{value:"KI",text:"基戈马",data:[]},{value:"KA",text:"卡盖拉",data:[]},{value:"LN",text:"林迪",data:[]},{value:"RK",text:"鲁夸",data:[]},{value:"RV",text:"鲁伍马",data:[]},{value:"MR",text:"马腊",data:[]},{value:"MY",text:"曼亚拉",data:[]},{value:"MO",text:"莫洛戈罗",data:[]},{value:"MB",text:"姆贝亚",data:[]},{value:"MT",text:"姆特瓦拉",data:[]},{value:"MW",text:"姆万扎",data:[]},{value:"KJ",text:"乞力马扎罗",data:[]},{value:"ZN",text:"桑给巴尔",data:[]},{value:"UN",text:"桑给巴尔北",data:[]},{value:"US",text:"桑给巴尔南",data:[]},{value:"MM",text:"桑给巴尔市和西",data:[]},{value:"TB",text:"塔波拉",data:[]},{value:"TN",text:"坦噶",data:[]},{value:"SI",text:"辛吉达",data:[]},{value:"SH",text:"欣延加",data:[]},{value:"IR",text:"伊林加",data:[]},]},]},{value:"TON",text:"汤加",data:[{value:"?",text:"?",data:[{value:"E",text:"埃瓦",data:[]},{value:"H",text:"哈派",data:[]},{value:"N",text:"纽阿斯",data:[]},{value:"T",text:"汤加塔布",data:[]},{value:"V",text:"瓦瓦乌 ",data:[]},]},]},{value:"TCA",text:"特克斯和凯克特斯群岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"TAA",text:"特里斯坦达昆哈",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"TTO",text:"特立尼达和多巴哥",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"TUN",text:"突尼斯",data:[{value:"?",text:"?",data:[{value:"AR",text:"艾尔亚奈",data:[]},{value:"BJ",text:"巴杰",data:[]},{value:"BA",text:"本阿鲁斯",data:[]},{value:"BI",text:"比塞大",data:[]},{value:"KB",text:"吉比利",data:[]},{value:"GB",text:"加贝斯",data:[]},{value:"GF",text:"加夫萨",data:[]},{value:"JE",text:"坚杜拜",data:[]},{value:"LK",text:"卡夫",data:[]},{value:"KS",text:"卡塞林",data:[]},{value:"KR",text:"凯鲁万",data:[]},{value:"MH",text:"马赫迪耶",data:[]},{value:"MN",text:"马努巴",data:[]},{value:"ME",text:"梅德宁",data:[]},{value:"MO",text:"莫纳斯提尔",data:[]},{value:"NA",text:"纳布勒",data:[]},{value:"SF",text:"斯法克斯",data:[]},{value:"SO",text:"苏塞",data:[]},{value:"TA",text:"泰塔温　 ",data:[]},{value:"TU",text:"突尼斯",data:[]},{value:"TO",text:"托泽尔",data:[]},{value:"SD",text:"西迪布济德",data:[]},{value:"SL",text:"锡勒亚奈",data:[]},{value:"ZA",text:"宰格万",data:[]},]},]},{value:"TUV",text:"图瓦卢",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"TUR",text:"土耳其",data:[{value:"?",text:"?",data:[{value:"ADA",text:"阿达纳",data:[]},{value:"ADI",text:"阿德亚曼",data:[]},{value:"ARD",text:"阿尔达罕",data:[]},{value:"ART",text:"阿尔特温",data:[]},{value:"AFY",text:"阿菲永",data:[]},{value:"AKS",text:"阿克萨赖",data:[]},{value:"AGR",text:"阿勒",data:[]},{value:"AMA",text:"阿马西亚",data:[]},{value:"EDI",text:"埃迪尔内",data:[]},{value:"EZC",text:"埃尔津詹",data:[]},{value:"EZR",text:"埃尔祖鲁姆",data:[]},{value:"ELA",text:"埃拉泽",data:[]},{value:"ESK",text:"埃斯基谢希尔",data:[]},{value:"AYI",text:"艾登",data:[]},{value:"ANK",text:"安卡拉",data:[]},{value:"ANT",text:"安塔利亚",data:[]},{value:"ORD",text:"奥尔杜",data:[]},{value:"BAR",text:"巴尔腾",data:[]},{value:"BAL",text:"巴勒克埃西尔",data:[]},{value:"BAT",text:"巴特曼",data:[]},{value:"BAY",text:"巴伊布尔特",data:[]},{value:"BIL",text:"比莱吉克",data:[]},{value:"BIT",text:"比特利斯",data:[]},{value:"BIN",text:"宾格尔",data:[]},{value:"BOL",text:"博卢",data:[]},{value:"BRD",text:"布尔杜尔",data:[]},{value:"BRS",text:"布尔萨",data:[]},{value:"CKR",text:"昌克勒",data:[]},{value:"DEN",text:"代尼兹利",data:[]},{value:"DIY",text:"迪亚巴克尔",data:[]},{value:"VAN",text:"凡",data:[]},{value:"HKR",text:"哈卡里",data:[]},{value:"HTY",text:"哈塔伊",data:[]},{value:"KLS",text:"基利斯",data:[]},{value:"GIR",text:"吉雷松",data:[]},{value:"GAZ",text:"加济安泰普",data:[]},{value:"GMS",text:"居米什哈内",data:[]},{value:"KRS",text:"卡尔斯",data:[]},{value:"KAH",text:"卡赫拉曼马拉什",data:[]},{value:"KRB",text:"卡拉比克",data:[]},{value:"KRM",text:"卡拉曼",data:[]},{value:"KAS",text:"卡斯塔莫努",data:[]},{value:"KAY",text:"开塞利",data:[]},{value:"KOC",text:"科贾埃利",data:[]},{value:"KLR",text:"柯克拉雷利",data:[]},{value:"KON",text:"科尼亚",data:[]},{value:"KRH",text:"克尔谢希尔",data:[]},{value:"KRK",text:"克勒克卡莱",data:[]},{value:"URF",text:"拉飞",data:[]},{value:"RIZ",text:"里泽",data:[]},{value:"MAR",text:"马尔丁",data:[]},{value:"MAL",text:"马拉蒂亚",data:[]},{value:"MAN",text:"马尼萨",data:[]},{value:"MUG",text:"穆拉",data:[]},{value:"MUS",text:"穆什",data:[]},{value:"NEV",text:"内夫谢希尔",data:[]},{value:"NIG",text:"尼代",data:[]},{value:"CKL",text:"恰纳卡莱",data:[]},{value:"COR",text:"乔鲁姆",data:[]},{value:"KUT",text:"屈塔希亚",data:[]},{value:"SAK",text:"萨卡里亚",data:[]},{value:"SAM",text:"萨姆松",data:[]},{value:"TEL",text:"泰基尔达",data:[]},{value:"TRA",text:"特拉布宗",data:[]},{value:"TUN",text:"通杰利",data:[]},{value:"TOK",text:"托卡特",data:[]},{value:"USK",text:"乌萨克",data:[]},{value:"SIR",text:"锡尔纳克",data:[]},{value:"SII",text:"锡尔特",data:[]},{value:"SIN",text:"锡诺普",data:[]},{value:"SIV",text:"锡瓦斯",data:[]},{value:"IGD",text:"伊迪尔",data:[]},{value:"ICE",text:"伊切尔",data:[]},{value:"ISP",text:"伊斯帕尔塔",data:[]},{value:"IST",text:"伊斯坦布尔",data:[]},{value:"IZM",text:"伊兹密尔",data:[]},{value:"YOZ",text:"约兹加特",data:[]},{value:"ZON",text:"宗古尔达克",data:[]},]},]},{value:"TKM",text:"土库曼斯坦",data:[{value:"?",text:"?",data:[{value:"A",text:"阿哈尔",data:[]},{value:"ASB",text:"阿什哈巴德市",data:[]},{value:"B",text:"巴尔坎",data:[]},{value:"D",text:"达沙古兹",data:[]},{value:"L",text:"列巴普",data:[]},{value:"M",text:"马雷",data:[]},{value:"NEB",text:"涅比特达格",data:[]},]},]},{value:"TKL",text:"托克劳",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"WLF",text:"瓦利斯和福图纳",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"VUT",text:"瓦努阿图",data:[{value:"?",text:"?",data:[{value:"MA",text:"马朗帕",data:[]},{value:"PE",text:"彭纳马",data:[]},{value:"SA",text:"桑马",data:[]},{value:"TA",text:"塔菲阿",data:[]},{value:"TO",text:"托尔巴",data:[]},{value:"SH",text:"谢法",data:[]},]},]},{value:"GTM",text:"危地马拉",data:[{value:"?",text:"?",data:[{value:"PR",text:"埃尔普罗格雷索",data:[]},{value:"ES",text:"埃斯昆特拉",data:[]},{value:"JA",text:"哈拉帕",data:[]},{value:"JU",text:"胡蒂亚帕",data:[]},{value:"QC",text:"基切",data:[]},{value:"QZ",text:"克萨尔特南戈",data:[]},{value:"RE",text:"雷塔卢莱乌",data:[]},{value:"MIX",text:"米克斯科",data:[]},{value:"PE",text:"佩滕",data:[]},{value:"CQ",text:"奇基穆拉",data:[]},{value:"CM",text:"奇马尔特南戈",data:[]},{value:"ZA",text:"萨卡帕",data:[]},{value:"ST",text:"萨卡特佩克斯",data:[]},{value:"AV",text:"上韦拉帕斯",data:[]},{value:"SR",text:"圣罗莎",data:[]},{value:"SM",text:"圣马科斯",data:[]},{value:"SU",text:"苏奇特佩克斯",data:[]},{value:"SO",text:"索洛拉",data:[]},{value:"TO",text:"托托尼卡潘",data:[]},{value:"GU",text:"危地马拉",data:[]},{value:"HU",text:"韦韦特南戈",data:[]},{value:"BV",text:"下韦拉帕斯",data:[]},{value:"VIN",text:"新城",data:[]},{value:"IZ",text:"伊萨瓦尔",data:[]},]},]},{value:"VIR",text:"维尔京群岛，美属",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"VGB",text:"维尔京群岛，英属",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"VEN",text:"委内瑞拉",data:[{value:"?",text:"?",data:[{value:"D",text:"阿拉瓜",data:[]},{value:"Y",text:"阿马库罗三角洲",data:[]},{value:"C",text:"阿普雷",data:[]},{value:"B",text:"安索阿特吉",data:[]},{value:"E",text:"巴里纳斯",data:[]},{value:"F",text:"玻利瓦尔",data:[]},{value:"P",text:"波图格萨",data:[]},{value:"I",text:"法尔孔",data:[]},{value:"J",text:"瓜里科",data:[]},{value:"A",text:"加拉加斯",data:[]},{value:"G",text:"卡拉沃沃",data:[]},{value:"H",text:"科赫德斯",data:[]},{value:"K",text:"拉腊",data:[]},{value:"W",text:"联邦属地",data:[]},{value:"L",text:"梅里达",data:[]},{value:"M",text:"米兰达",data:[]},{value:"N",text:"莫纳加斯",data:[]},{value:"R",text:"苏克雷",data:[]},{value:"V",text:"苏利亚",data:[]},{value:"S",text:"塔奇拉",data:[]},{value:"T",text:"特鲁希略",data:[]},{value:"O",text:"新埃斯帕塔",data:[]},{value:"U",text:"亚拉奎",data:[]},{value:"Z",text:"亚马孙",data:[]},]},]},{value:"BRN",text:"文莱",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"UGA",text:"乌干达",data:[{value:"?",text:"?",data:[{value:"ARU",text:"阿鲁阿 ",data:[]},{value:"APC",text:"阿帕克 ",data:[]},{value:"ADJ",text:"阿朱马尼 ",data:[]},{value:"BUN",text:"本迪布焦 ",data:[]},{value:"BUG",text:"布吉里 ",data:[]},{value:"BUS",text:"布西亚 ",data:[]},{value:"BSH",text:"布谢尼 ",data:[]},{value:"NTU",text:"恩通加莫 ",data:[]},{value:"GUL",text:"古卢 ",data:[]},{value:"HOI",text:"霍伊马 ",data:[]},{value:"KBA",text:"基巴莱 ",data:[]},{value:"KIB",text:"基博加 ",data:[]},{value:"KYE",text:"基恩乔乔 ",data:[]},{value:"KIS",text:"基索罗 ",data:[]},{value:"KIT",text:"基特古姆 ",data:[]},{value:"JIN",text:"金贾 ",data:[]},{value:"KBL",text:"卡巴莱 ",data:[]},{value:"KAR",text:"卡巴罗莱 ",data:[]},{value:"KAB",text:"卡贝拉马伊多 ",data:[]},{value:"KAL",text:"卡兰加拉 ",data:[]},{value:"KAM",text:"卡姆文盖 ",data:[]},{value:"KML",text:"卡穆利 ",data:[]},{value:"KAN",text:"卡农古 ",data:[]},{value:"KPC",text:"卡普乔鲁瓦 ",data:[]},{value:"KAS",text:"卡塞塞 ",data:[]},{value:"KTK",text:"卡塔奎 ",data:[]},{value:"KAY",text:"卡永加 ",data:[]},{value:"KMP",text:"坎帕拉 ",data:[]},{value:"KOT",text:"科蒂多 ",data:[]},{value:"KUM",text:"库米 ",data:[]},{value:"RAK",text:"拉卡伊 ",data:[]},{value:"LIR",text:"利拉 ",data:[]},{value:"LUW",text:"卢韦罗 ",data:[]},{value:"RUK",text:"鲁昆吉里 ",data:[]},{value:"MAS",text:"马萨卡 ",data:[]},{value:"MSN",text:"马辛迪 ",data:[]},{value:"MAY",text:"马尤盖 ",data:[]},{value:"MRT",text:"莫罗托 ",data:[]},{value:"MOY",text:"莫约 ",data:[]},{value:"MBR",text:"姆巴拉拉 ",data:[]},{value:"MBA",text:"姆巴莱 ",data:[]},{value:"MPI",text:"姆皮吉 ",data:[]},{value:"MUB",text:"穆本德 ",data:[]},{value:"MUK",text:"穆科诺 ",data:[]},{value:"NAK",text:"纳卡皮里皮里特 ",data:[]},{value:"NKS",text:"纳卡松戈拉 ",data:[]},{value:"NEB",text:"内比 　 ",data:[]},{value:"PAD",text:"帕德尔 ",data:[]},{value:"PAL",text:"帕利萨 ",data:[]},{value:"SEM",text:"森巴布莱 ",data:[]},{value:"SOR",text:"索罗提 ",data:[]},{value:"TOR",text:"托罗罗 ",data:[]},{value:"WAK",text:"瓦基索 ",data:[]},{value:"SIR",text:"锡龙科 ",data:[]},{value:"IGA",text:"伊甘加 ",data:[]},{value:"YUM",text:"永贝 ",data:[]},]},]},{value:"UKR",text:"乌克兰",data:[{value:"?",text:"?",data:[{value:"51",text:"敖德萨",data:[]},{value:"53",text:"波尔塔瓦",data:[]},{value:"12",text:"第聂伯罗波得罗夫斯克",data:[]},{value:"14",text:"顿涅茨克",data:[]},{value:"63",text:"哈尔科夫",data:[]},{value:"65",text:"赫尔松州",data:[]},{value:"68",text:"赫梅利尼茨基",data:[]},{value:"30",text:"基辅",data:[]},{value:"35",text:"基洛夫格勒",data:[]},{value:"61",text:"捷尔诺波尔",data:[]},{value:"43",text:"克里米亚自治共和国",data:[]},{value:"46",text:"利沃夫",data:[]},{value:"9",text:"卢甘斯克",data:[]},{value:"56",text:"罗夫诺",data:[]},{value:"48",text:"尼古拉耶夫",data:[]},{value:"71",text:"切尔卡瑟",data:[]},{value:"74",text:"切尔尼戈夫",data:[]},{value:"77",text:"切尔诺夫策",data:[]},{value:"18",text:"日托米尔",data:[]},{value:"59",text:"苏梅",data:[]},{value:"21",text:"外喀尔巴阡",data:[]},{value:"5",text:"文尼察",data:[]},{value:"7",text:"沃伦",data:[]},{value:"26",text:"伊万－弗兰科夫州",data:[]},{value:"23",text:"扎波罗热",data:[]},]},]},{value:"URY",text:"乌拉圭",data:[{value:"?",text:"?",data:[{value:"AR",text:"阿蒂加斯",data:[]},{value:"DU",text:"杜拉斯诺",data:[]},{value:"FA",text:"佛罗里达",data:[]},{value:"FS",text:"弗洛雷斯",data:[]},{value:"CA",text:"卡内洛内斯",data:[]},{value:"CO",text:"科洛尼亚",data:[]},{value:"LA",text:"拉瓦耶哈",data:[]},{value:"RV",text:"里韦拉",data:[]},{value:"RO",text:"罗恰",data:[]},{value:"MA",text:"马尔多纳多",data:[]},{value:"MO",text:"蒙得维的亚",data:[]},{value:"RN",text:"内格罗河",data:[]},{value:"PA",text:"派桑杜",data:[]},{value:"SL",text:"萨尔托",data:[]},{value:"CL",text:"塞罗拉尔戈",data:[]},{value:"TT",text:"三十三人",data:[]},{value:"SJ",text:"圣何塞",data:[]},{value:"SO",text:"索里亚诺",data:[]},{value:"TAW",text:"塔夸伦博",data:[]},]},]},{value:"UZB",text:"乌兹别克斯坦",data:[{value:"?",text:"?",data:[{value:"AN",text:"安集延",data:[]},{value:"BU",text:"布哈拉",data:[]},{value:"FA",text:"费尔干纳",data:[]},{value:"XO",text:"花拉子模",data:[]},{value:"JI",text:"吉扎克",data:[]},{value:"QR",text:"卡拉卡尔帕克斯坦共和国",data:[]},{value:"QA",text:"卡什卡达里亚",data:[]},{value:"NG",text:"纳曼干",data:[]},{value:"NW",text:"纳沃伊",data:[]},{value:"SA",text:"撒马尔罕",data:[]},{value:"SU",text:"苏尔汉河",data:[]},{value:"TK",text:"塔什干",data:[]},{value:"TO",text:"塔什干市",data:[]},{value:"SI",text:"锡尔河",data:[]},]},]},{value:"ESP",text:"西班牙",data:[{value:"?",text:"?",data:[{value:"LEI",text:"阿尔梅里亚",data:[]},{value:"ALB",text:"阿尔瓦塞特",data:[]},{value:"ALA",text:"阿拉瓦",data:[]},{value:"ALC",text:"阿利坎特",data:[]},{value:"AST",text:"阿斯图利亚斯",data:[]},{value:"AVI",text:"阿维拉",data:[]},{value:"ORE",text:"奥伦塞",data:[]},{value:"BJZ",text:"巴达霍斯",data:[]},{value:"BLR",text:"巴利阿里",data:[]},{value:"VLL",text:"巴利亚多利德",data:[]},{value:"VLC",text:"巴伦西亚",data:[]},{value:"BCN",text:"巴塞罗那",data:[]},{value:"VSE",text:"比斯开",data:[]},{value:"BUR",text:"布尔戈斯",data:[]},{value:"GRX",text:"格拉纳达",data:[]},{value:"GUA",text:"瓜达拉哈拉",data:[]},{value:"JAE",text:"哈恩",data:[]},{value:"GRO",text:"赫罗纳",data:[]},{value:"GUI",text:"吉普斯夸",data:[]},{value:"CAD",text:"加的斯",data:[]},{value:"CCS",text:"卡塞雷斯",data:[]},{value:"CIR",text:"卡斯蒂利亚",data:[]},{value:"CAS",text:"卡斯特利翁",data:[]},{value:"ODB",text:"科尔多瓦",data:[]},{value:"CUE",text:"昆卡",data:[]},{value:"LCG",text:"拉科鲁尼亚",data:[]},{value:"ARL",text:"拉里奥哈",data:[]},{value:"LPA",text:"拉斯帕尔马斯",data:[]},{value:"LEN",text:"莱昂",data:[]},{value:"LLE",text:"莱里达",data:[]},{value:"LGO",text:"卢戈",data:[]},{value:"MAD",text:"马德里",data:[]},{value:"AGP",text:"马拉加",data:[]},{value:"MJV",text:"穆尔西亚",data:[]},{value:"NVV",text:"纳瓦拉",data:[]},{value:"PAC",text:"帕伦西亚",data:[]},{value:"PEV",text:"蓬特韦德拉",data:[]},{value:"ZAZ",text:"萨拉戈萨 ",data:[]},{value:"SLM",text:"萨拉曼卡",data:[]},{value:"ZMR",text:"萨莫拉",data:[]},{value:"SEG",text:"塞哥维亚",data:[]},{value:"SVQ",text:"塞维利亚",data:[]},{value:"SDR",text:"桑坦德",data:[]},{value:"SCT",text:"圣克鲁斯-德特内里费",data:[]},{value:"SOR",text:"索里亚",data:[]},{value:"TAR",text:"塔拉戈纳",data:[]},{value:"TER",text:"特鲁埃尔",data:[]},{value:"TOL",text:"托莱多",data:[]},{value:"HUV",text:"韦尔瓦",data:[]},{value:"HUC",text:"韦斯卡",data:[]},]},]},{value:"GRC",text:"希腊",data:[{value:"?",text:"?",data:[{value:"PRI",text:"比雷埃夫斯",data:[]},{value:"DO",text:"多德卡尼斯",data:[]},{value:"CHQ",text:"干尼亚",data:[]},{value:"CY",text:"基克拉迪",data:[]},{value:"LST",text:"拉西锡",data:[]},{value:"LES",text:"莱斯博斯",data:[]},{value:"RET",text:"雷西姆农",data:[]},{value:"SMI",text:"萨摩斯",data:[]},{value:"ATH",text:"雅典",data:[]},{value:"HER",text:"伊拉克里翁",data:[]},]},]},{value:"SGP",text:"新加坡",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"NCL",text:"新喀里多尼亚",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"NZL",text:"新西兰",data:[{value:"?",text:"?",data:[{value:"AUK",text:"奥克兰",data:[]},{value:"NSH",text:"北岸",data:[]},{value:"PMR",text:"北帕默斯顿",data:[]},{value:"FNR",text:"北远",data:[]},{value:"BHE",text:"布莱尼姆",data:[]},{value:"DUD",text:"达尼丁",data:[]},{value:"GMN",text:"格雷茅斯",data:[]},{value:"HLZ",text:"哈密尔顿",data:[]},{value:"HAS",text:"黑斯廷斯",data:[]},{value:"WAE",text:"怀塔科拉",data:[]},{value:"GIS",text:"吉斯伯恩",data:[]},{value:"KAI",text:"凯帕拉",data:[]},{value:"CHC",text:"克赖斯特彻奇",data:[]},{value:"RMD",text:"里士满",data:[]},{value:"MNK",text:"马努考",data:[]},{value:"NSN",text:"纳尔逊",data:[]},{value:"NPE",text:"内皮尔",data:[]},{value:"STR",text:"斯特拉特福德",data:[]},{value:"TAU",text:"陶马鲁努伊",data:[]},{value:"WHK",text:"瓦卡塔尼",data:[]},{value:"WRE",text:"旺阿雷",data:[]},{value:"WAG",text:"旺格努伊",data:[]},{value:"NPL",text:"新普利茅斯",data:[]},{value:"IVC",text:"因弗卡吉尔",data:[]},]},]},{value:"HUN",text:"匈牙利",data:[{value:"?",text:"?",data:[{value:"BA",text:"巴兰尼亚",data:[]},{value:"BK",text:"巴奇-基什孔",data:[]},{value:"BZ",text:"包尔绍德-奥包乌伊-曾普伦",data:[]},{value:"BE",text:"贝凯什",data:[]},{value:"BU",text:"布达佩斯",data:[]},{value:"FE",text:"费耶尔",data:[]},{value:"HB",text:"豪伊杜-比豪尔",data:[]},{value:"HE",text:"赫维什",data:[]},{value:"JN",text:"加兹-纳杰孔-索尔诺克",data:[]},{value:"GS",text:"杰尔-莫松-肖普朗",data:[]},{value:"KE",text:"科马罗姆",data:[]},{value:"NO",text:"诺格拉德",data:[]},{value:"PE",text:"佩斯",data:[]},{value:"CS",text:"琼格拉德",data:[]},{value:"SO",text:"绍莫吉",data:[]},{value:"SZ",text:"索博尔奇-索特马尔-贝拉格",data:[]},{value:"TO",text:"托尔瑙",data:[]},{value:"VE",text:"维斯普雷姆",data:[]},{value:"VA",text:"沃什",data:[]},{value:"ZA",text:"佐洛",data:[]},]},]},{value:"SYR",text:"叙利亚",data:[{value:"?",text:"?",data:[{value:"HL",text:"阿勒颇",data:[]},{value:"RD",text:"大马士革",data:[]},{value:"DI",text:"大马士革市",data:[]},{value:"DZ",text:"代尔祖尔",data:[]},{value:"DA",text:"德拉",data:[]},{value:"HM",text:"哈马",data:[]},{value:"HA",text:"哈塞克",data:[]},{value:"HI",text:"霍姆斯",data:[]},{value:"GH",text:"加布",data:[]},{value:"QA",text:"卡米什利",data:[]},{value:"QU",text:"库奈特拉",data:[]},{value:"RQ",text:"拉卡",data:[]},{value:"LA",text:"拉塔基亚",data:[]},{value:"SU",text:"苏韦达",data:[]},{value:"TA",text:"塔尔图斯",data:[]},{value:"ID",text:"伊德利卜",data:[]},]},]},{value:"JAM",text:"牙买加",data:[{value:"?",text:"?",data:[{value:"POR",text:"波特兰",data:[]},{value:"HAN",text:"汉诺威",data:[]},{value:"KIN",text:"金斯敦",data:[]},{value:"CLA",text:"克拉伦登",data:[]},{value:"MAN",text:"曼彻斯特",data:[]},{value:"AND",text:"圣安德鲁斯",data:[]},{value:"ANN",text:"圣安娜",data:[]},{value:"CAT",text:"圣凯瑟琳",data:[]},{value:"MAR",text:"圣玛丽",data:[]},{value:"THO",text:"圣托马斯",data:[]},{value:"ELI",text:"圣伊丽莎白",data:[]},{value:"JAM",text:"圣詹姆斯",data:[]},{value:"TRL",text:"特里洛尼",data:[]},{value:"WML",text:"西摩兰",data:[]},]},]},{value:"ARM",text:"亚美尼亚",data:[{value:"?",text:"?",data:[{value:"ARM",text:"阿尔马维尔",data:[]},{value:"AGT",text:"阿拉加措特恩",data:[]},{value:"ARA",text:"阿拉拉特",data:[]},{value:"EVN",text:"埃里温市",data:[]},{value:"GEG",text:"格加尔库尼克",data:[]},{value:"KOT",text:"科泰克",data:[]},{value:"LOR",text:"洛里",data:[]},{value:"TAV",text:"塔武什",data:[]},{value:"VAY",text:"瓦约茨·佐尔",data:[]},{value:"SHI",text:"希拉克",data:[]},{value:"SYU",text:"休尼克",data:[]},]},]},{value:"YEM",text:"也门",data:[{value:"?",text:"?",data:[{value:"AB",text:"阿比扬",data:[]},{value:"AM",text:"阿姆兰",data:[]},{value:"BA",text:"贝达",data:[]},{value:"DA",text:"达利",data:[]},{value:"HD",text:"哈德拉毛",data:[]},{value:"HJ",text:"哈杰",data:[]},{value:"HU",text:"荷台达",data:[]},{value:"JA",text:"焦夫",data:[]},{value:"LA",text:"拉赫季",data:[]},{value:"MA",text:"马里卜",data:[]},{value:"MR",text:"迈赫拉",data:[]},{value:"MW",text:"迈赫维特",data:[]},{value:"SD",text:"萨达",data:[]},{value:"SN",text:"萨那",data:[]},{value:"GXF",text:"赛文",data:[]},{value:"SH",text:"舍卜沃",data:[]},{value:"TA",text:"塔伊兹",data:[]},{value:"ASR",text:"希赫尔",data:[]},{value:"AD",text:"亚丁",data:[]},{value:"IB",text:"伊卜",data:[]},{value:"DH",text:"扎玛尔",data:[]},]},]},{value:"IRQ",text:"伊拉克",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"IRN",text:"伊朗",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"ISR",text:"以色列",data:[{value:"?",text:"?",data:[{value:"ASH",text:"阿什杜德",data:[]},{value:"BEV",text:"贝尔谢巴",data:[]},{value:"BAT",text:"贝特雁",data:[]},{value:"HFA",text:"海法",data:[]},{value:"HOL",text:"霍隆",data:[]},{value:"NAT",text:"内坦亚",data:[]},{value:"TLV",text:"特拉维夫",data:[]},{value:"J",text:"耶路撒冷",data:[]},]},]},{value:"ITA",text:"意大利",data:[{value:"?",text:"?",data:[{value:"AST",text:"阿斯蒂",data:[]},{value:"ASP",text:"阿斯科利皮切诺",data:[]},{value:"AOI",text:"安科纳",data:[]},{value:"OLB",text:"奥尔比亚",data:[]},{value:"QOS",text:"奥里斯塔诺",data:[]},{value:"AOT",text:"奥斯塔",data:[]},{value:"PMO",text:"巴勒莫",data:[]},{value:"BRI",text:"巴里",data:[]},{value:"BGO",text:"贝加莫",data:[]},{value:"BEN",text:"贝内文托",data:[]},{value:"PSA",text:"比萨",data:[]},{value:"PRD",text:"波代诺内",data:[]},{value:"QPO",text:"波坦察",data:[]},{value:"BLQ",text:"博洛尼亚",data:[]},{value:"BIE",text:"布拉",data:[]},{value:"BRC",text:"布雷西亚",data:[]},{value:"BDS",text:"布林迪西",data:[]},{value:"TRS",text:"的里雅斯特",data:[]},{value:"TRN",text:"都灵",data:[]},{value:"FRR",text:"费拉拉",data:[]},{value:"FLR",text:"佛罗伦萨",data:[]},{value:"FOG",text:"福贾",data:[]},{value:"CAG",text:"卡利亚里",data:[]},{value:"CST",text:"卡塞塔",data:[]},{value:"CTA",text:"卡塔尼亚",data:[]},{value:"QCZ",text:"卡坦扎罗",data:[]},{value:"COB",text:"坎波巴索",data:[]},{value:"CIY",text:"科摩",data:[]},{value:"QCS",text:"科森扎",data:[]},{value:"CRV",text:"克罗托内",data:[]},{value:"CUN",text:"库内奥",data:[]},{value:"LAQ",text:"拉奎拉",data:[]},{value:"SPE",text:"拉斯佩齐亚",data:[]},{value:"LCO",text:"莱科",data:[]},{value:"LCC",text:"莱切",data:[]},{value:"RNE",text:"雷焦艾米利亚",data:[]},{value:"REG",text:"雷焦卡拉布里亚",data:[]},{value:"LIV",text:"里窝那",data:[]},{value:"ROM",text:"罗马",data:[]},{value:"MCR",text:"马萨",data:[]},{value:"MTR",text:"马泰拉",data:[]},{value:"MZA",text:"蒙扎",data:[]},{value:"MIL",text:"米兰",data:[]},{value:"MOD",text:"摩德纳",data:[]},{value:"MSN",text:"墨西拿",data:[]},{value:"NAP",text:"那不勒斯",data:[]},{value:"QNU",text:"努奥罗",data:[]},{value:"NVR",text:"诺瓦拉",data:[]},{value:"PMF",text:"帕尔马",data:[]},{value:"PAV",text:"帕维亚",data:[]},{value:"PEG",text:"佩鲁贾",data:[]},{value:"CAX",text:"热那亚",data:[]},{value:"SAL",text:"萨莱诺",data:[]},{value:"QSS",text:"萨萨里",data:[]},{value:"SVN",text:"萨沃纳",data:[]},{value:"TAR",text:"塔兰托",data:[]},{value:"TPS",text:"特拉帕尼",data:[]},{value:"TRT",text:"特伦托",data:[]},{value:"VCE",text:"威尼斯",data:[]},{value:"VRL",text:"韦尔切利",data:[]},{value:"VIT",text:"维泰博",data:[]},{value:"UDN",text:"乌迪内",data:[]},{value:"SYR",text:"锡拉库扎",data:[]},{value:"SNA",text:"锡耶纳",data:[]},{value:"ALE",text:"亚历山德里亚",data:[]},{value:"ISE",text:"伊塞尔尼亚",data:[]},]},]},{value:"IND",text:"印度",data:[{value:"?",text:"?",data:[{value:"AJL",text:"艾藻尔",data:[]},{value:"BLR",text:"班加罗尔",data:[]},{value:"PNY",text:"本地治里",data:[]},{value:"BHO",text:"博帕尔",data:[]},{value:"BBI",text:"布巴内斯瓦尔",data:[]},{value:"IXC",text:"昌迪加尔",data:[]},{value:"DAM",text:"达曼",data:[]},{value:"DIU",text:"第乌",data:[]},{value:"GTO",text:"甘托克",data:[]},{value:"CJB",text:"哥印拜陀",data:[]},{value:"CCU",text:"加尔各答",data:[]},{value:"KRK",text:"加里加尔",data:[]},{value:"JLR",text:"贾巴尔普尔",data:[]},{value:"JUC",text:"贾朗达尔",data:[]},{value:"JDH",text:"焦特布尔",data:[]},{value:"MAA",text:"金奈",data:[]},{value:"KVA",text:"卡瓦拉蒂",data:[]},{value:"KOM",text:"科希马",data:[]},{value:"MAH",text:"马埃",data:[]},{value:"IXM",text:"马杜赖",data:[]},{value:"SLR",text:"森伯尔布尔",data:[]},{value:"TRV",text:"特里凡得琅",data:[]},{value:"UDR",text:"乌代布尔",data:[]},{value:"SHL",text:"西隆",data:[]},{value:"SIL",text:"锡尔萨瓦",data:[]},{value:"ICD",text:"新德里",data:[]},{value:"SRV",text:"亚南",data:[]},{value:"IMF",text:"因帕尔",data:[]},{value:"IDR",text:"印多尔",data:[]},{value:"JAI",text:"斋普尔",data:[]},]},]},{value:"IDN",text:"印度尼西亚",data:[{value:"?",text:"?",data:[{value:"BA",text:"巴厘",data:[]},{value:"BB",text:"邦加－勿里洞群岛",data:[]},{value:"SA",text:"北苏拉威西",data:[]},{value:"SU",text:"北苏门答腊",data:[]},{value:"KB",text:"大雅加达首都特区",data:[]},{value:"KI",text:"东加里曼丹",data:[]},{value:"SG",text:"东南苏拉威西",data:[]},{value:"NT",text:"东努沙登加拉",data:[]},{value:"JI",text:"东爪哇",data:[]},{value:"RI",text:"廖内",data:[]},{value:"MA",text:"马鲁古",data:[]},{value:"BE",text:"明古鲁",data:[]},{value:"LA",text:"楠榜",data:[]},{value:"KS",text:"南加里曼丹",data:[]},{value:"SN",text:"南苏拉威西",data:[]},{value:"SS",text:"南苏门答腊",data:[]},{value:"YO",text:"日惹特区",data:[]},{value:"BT",text:"万丹",data:[]},{value:"NB",text:"西努沙登加拉",data:[]},{value:"SR",text:"西苏门答腊",data:[]},{value:"JB",text:"西爪哇",data:[]},{value:"JK",text:"雅加达",data:[]},{value:"AC",text:"亚齐",data:[]},{value:"IJ",text:"伊里安查亚",data:[]},{value:"JA",text:"占碑",data:[]},{value:"KT",text:"中加里曼丹",data:[]},{value:"ST",text:"中苏拉威西",data:[]},{value:"JT",text:"中爪哇",data:[]},]},]},{value:"GBR",text:"英国",data:[{value:"NIR",text:"北爱尔兰",data:[{value:"BFS",text:"贝尔法斯特",data:[]},{value:"DRY",text:"德里",data:[]},{value:"LSB",text:"利斯本",data:[]},{value:"NYM",text:"纽里",data:[]},]},{value:"SCT",text:"苏格兰",data:[{value:"ABD",text:"阿伯丁",data:[]},{value:"EDH",text:"爱丁堡",data:[]},{value:"DND",text:"丹迪",data:[]},{value:"GLG",text:"格拉斯哥",data:[]},{value:"STG",text:"斯特灵",data:[]},{value:"INV",text:"因弗内斯",data:[]},]},{value:"WLS",text:"威尔士",data:[{value:"BAN",text:"班戈",data:[]},{value:"CDF",text:"卡迪夫",data:[]},{value:"NWP",text:"纽波特",data:[]},{value:"SWA",text:"斯旺西",data:[]},]},{value:"ENG",text:"英格兰",data:[{value:"EXE",text:"爱塞特",data:[]},{value:"BAS",text:"巴斯",data:[]},{value:"PTE",text:"彼得伯勒",data:[]},{value:"BIR",text:"伯明翰",data:[]},{value:"BRD",text:"布拉德福德",data:[]},{value:"BNH",text:"布莱顿与赫福",data:[]},{value:"BST",text:"布里斯托尔",data:[]},{value:"DER",text:"德比",data:[]},{value:"DUR",text:"德罕",data:[]},{value:"GLO",text:"格洛斯特",data:[]},{value:"KUH",text:"赫尔河畔京斯敦",data:[]},{value:"HAF",text:"赫里福德",data:[]},{value:"CAM",text:"剑桥",data:[]},{value:"CAX",text:"卡莱尔",data:[]},{value:"CNG",text:"坎特伯雷",data:[]},{value:"COV",text:"考文垂",data:[]},{value:"LAN",text:"兰开斯特",data:[]},{value:"RIP",text:"里彭",data:[]},{value:"LHF",text:"利奇菲尔德",data:[]},{value:"LIV",text:"利物浦",data:[]},{value:"LDS",text:"利茲",data:[]},{value:"LCE",text:"列斯特",data:[]},{value:"LCN",text:"林肯",data:[]},{value:"LND",text:"伦敦",data:[]},{value:"MAN",text:"曼彻斯特",data:[]},{value:"STH",text:"南安普敦",data:[]},{value:"OXF",text:"牛津",data:[]},{value:"NCL",text:"纽卡斯尔",data:[]},{value:"NGM",text:"诺丁汉",data:[]},{value:"NRW",text:"诺里奇",data:[]},{value:"POR",text:"朴茨茅斯",data:[]},{value:"PRE",text:"普雷斯顿",data:[]},{value:"PLY",text:"普利茅斯",data:[]},{value:"CST",text:"奇切斯特",data:[]},{value:"CEG",text:"切斯特",data:[]},{value:"SUN",text:"桑德兰",data:[]},{value:"TBL",text:"圣阿本斯",data:[]},{value:"SLS",text:"索尔斯堡",data:[]},{value:"SLF",text:"索福特",data:[]},{value:"TRU",text:"特鲁罗",data:[]},{value:"SOT",text:"特伦特河畔斯多克",data:[]},{value:"WLS",text:"威尔斯",data:[]},{value:"WKF",text:"韦克菲尔德",data:[]},{value:"WNE",text:"温彻斯特",data:[]},{value:"WOV",text:"伍尔弗汉普顿",data:[]},{value:"WOR",text:"伍斯特",data:[]},{value:"SHE",text:"谢菲尔德",data:[]},{value:"ELY",text:"伊利",data:[]},{value:"YOR",text:"约克",data:[]},]},]},{value:"IOT",text:"英属印度洋领地",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"JOR",text:"约旦",data:[{value:"?",text:"?",data:[{value:"AJ",text:"阿吉隆",data:[]},{value:"AM",text:"安曼",data:[]},{value:"BA",text:"拜勒加",data:[]},{value:"JA",text:"杰拉什",data:[]},{value:"KA",text:"卡拉克",data:[]},{value:"RU",text:"鲁赛法",data:[]},{value:"MN",text:"马安",data:[]},{value:"MD",text:"马德巴",data:[]},{value:"MF",text:"马夫拉克",data:[]},{value:"TA",text:"塔菲拉",data:[]},{value:"AQ",text:"亚喀巴",data:[]},{value:"IR",text:"伊尔比德",data:[]},{value:"ZA",text:"扎尔卡",data:[]},]},]},{value:"VNM",text:"越南",data:[{value:"?",text:"?",data:[{value:"HP",text:"海防",data:[]},{value:"HI",text:"河内",data:[]},{value:"HC",text:"胡志明市",data:[]},]},]},{value:"ZMB",text:"赞比亚",data:[{value:"?",text:"?",data:[{value:"NO",text:"北方",data:[]},{value:"EA",text:"东方",data:[]},{value:"LP",text:"卢阿普拉",data:[]},{value:"LK",text:"卢萨卡",data:[]},{value:"SO",text:"南方",data:[]},{value:"CB",text:"铜带",data:[]},{value:"NW",text:"西北",data:[]},{value:"WE",text:"西方",data:[]},{value:"CE",text:"中央",data:[]},]},]},{value:"JEY",text:"泽西岛",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"TCD",text:"乍得",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"GIB",text:"直布罗陀",data:[{value:"?",text:"?",data:[{value:"?",text:"?",data:[]}]}]},{value:"CHL",text:"智利",data:[{value:"?",text:"?",data:[{value:"AR",text:"阿劳卡尼亚大区",data:[]},{value:"AT",text:"阿塔卡马大区",data:[]},{value:"AN",text:"安托法加斯塔大区",data:[]},{value:"BI",text:"比奥比奥大区",data:[]},{value:"LI",text:"复活节岛",data:[]},{value:"LL",text:"湖大区",data:[]},{value:"CO",text:"科金博大区",data:[]},{value:"ML",text:"马乌莱大区",data:[]},{value:"MA",text:"麦哲伦-智利南极大区",data:[]},{value:"RM",text:"圣地亚哥",data:[]},{value:"TA",text:"塔拉帕卡大区",data:[]},{value:"VS",text:"瓦尔帕莱索大区",data:[]},{value:"AI",text:"伊瓦涅斯将军的艾森大区",data:[]},]},]},{value:"CAF",text:"中非共和国",data:[{value:"?",text:"?",data:[{value:"BB",text:"巴明吉-班戈兰",data:[]},{value:"BGF",text:"班吉直辖市",data:[]},{value:"BI",text:"宾博",data:[]},{value:"KG",text:"凯莫",data:[]},{value:"LB",text:"洛巴伊",data:[]},{value:"HS",text:"曼贝雷-卡代",data:[]},{value:"MB",text:"姆博穆",data:[]},{value:"KB",text:"纳纳-格里比齐",data:[]},{value:"NM",text:"纳纳-曼贝雷",data:[]},{value:"SE",text:"桑加-姆巴埃雷",data:[]},{value:"HK",text:"上科托",data:[]},{value:"HM",text:"上姆博穆",data:[]},{value:"UK",text:"瓦卡",data:[]},{value:"VK",text:"瓦卡加",data:[]},{value:"AC",text:"瓦姆",data:[]},{value:"OP",text:"瓦姆-彭代",data:[]},{value:"MP",text:"翁贝拉-姆波科",data:[]},{value:"BK",text:"下科托",data:[]},]},]},]}];