<?php
/* 
* LogX 博客系统 - 代码如诗
* 
* @copyright	LogX Team (http://logx.org/)
* @license	GNU General Public License V2.0
* 
 */

class Request {

	public static function G( $key, $type = 'int' ) {
		return isset($_GET[$key])?$_GET[$key]:NULL;
	}

	public static function P( $key, $type = 'int' ) {
		return isset($_POST[$key])?$_POST[$key]:NULL;
	}

	public static function C( $key, $type = 'int' ) {
		return isset($_COOKIE[DB_PREFIX.$key])?$_COOKIE[DB_PREFIX.$key]:NULL;
	}

	public static function S( $key, $type = 'int' ) {
		return isset($_SERVER[$key])?$_SERVER[$key]:NULL;
	}

	// 获得访客 ip
	public static function getIP() {
		if( preg_match('/^([0-9]{1,3}\.){3}[0-9]{1,3}$/', self::S('HTTP_X_FORWARDED_FOR','string') ) ) {
			return self::S('HTTP_X_FORWARDED_FOR','string');
		} elseif ( preg_match('/^([0-9]{1,3}\.){3}[0-9]{1,3}$/', self::S('HTTP_CLIENT_IP','string') ) ) {
			return self::S('HTTP_CLIENT_IP','string');
		} elseif ( preg_match('/^([0-9]{1,3}\.){3}[0-9]{1,3}$/', self::S('REMOTE_ADDR','string') ) ) {
			return self::S('REMOTE_ADDR','string');
		} else {
			return 'Unknown';
		}
	}

	/**
	 * @brief isAjax 判断是否为 Ajax 请求
	 *
	 * @return bool
	 */
	public static function isAjax() {
		if( self::S('HTTP_X_REQUESTED_WITH','string') != NULL ) {
			if( 'xmlhttprequest' == strtolower( self::S('HTTP_X_REQUESTED_WITH','string') ) ) {
				return TRUE;
			}
		}
		return FALSE;
	}

	public static function isSecure() {
		// 协议
		if (!$_SERVER['REQUEST_URI'] || ($https = @parse_url($_SERVER['REQUEST_URI']))===false) {
			$https = array();
		}
		if ((empty($https['scheme']) && ((isset($_SERVER['HTTP_SCHEME']) && $_SERVER['HTTP_SCHEME']=='https') || isset($_SERVER['HTTPS']) && strtolower($_SERVER['HTTPS'])!='off')) || (isset($https['scheme']) && $https['scheme']=='https')) {
			return TRUE;
		} else {
			return FALSE;
		}
	}

	public static function getDomain() {
		// 协议
		if( self::isSecure() ) {
			$protocol = 'https://';
		} else {
			$protocol = 'http://';
		}

		// 域名或IP地址  
		if( isset($_SERVER['HTTP_X_FORWARDED_HOST']) ) {
			$host = $_SERVER['HTTP_X_FORWARDED_HOST'];
		} elseif (isset($_SERVER['HTTP_HOST'])) {
			$host = $_SERVER['HTTP_HOST'];
		} else {
			/* 端口 */
			if (isset($_SERVER['SERVER_PORT'])) {
				$port = ':' . $_SERVER['SERVER_PORT'];
				
				if ((':80' == $port && 'http://' == $protocol) || (':443' == $port && 'https://' == $protocol)) {
					$port = '';
				}
			} else {
				$port = '';
			}

			if (isset($_SERVER['SERVER_NAME'])) {
				$host = $_SERVER['SERVER_NAME'] . $port;
			} elseif (isset($_SERVER['SERVER_ADDR'])) {
				$host = $_SERVER['SERVER_ADDR'] . $port;
			}
		}
		return $protocol . $host;
	}

}
