var x_current_pressed;

$(document).ready(function () {
	$('div.x-button').click(function () {
		x_current_pressed = $(this)

		$('.x-buttom').removeClass('x-button-pressed');

		$(this).addClass('x-button-pressed');

		setTimeout(function () {
			x_current_pressed.removeClass('x-button-pressed');
		}, 200);
	});
	
	$('#x-mask').click(function () {
		$(this).css('display', 'none');
		$('.popup-message').css('display', 'none')
		$('.x-popup-message').css('display', 'none');
	});
	
	$(window).resize(function () {
		setTimeout(function () {
			$('#x-mask').css({'height': $(document).height()});
			
			$('.x-popup-message').css('top', $(document).scrollTop() + $(window).height() * 0.1);
			$('#loading').css('top', $(document).scrollTop() + $(window).height() / 2 - 24);
		}, 1000);
	});
	
	$(document).scroll(function () {
		if ($('#x-mask').css('display') == 'none')
		{
			$('.x-popup-message').css('top', $(document).scrollTop() + $(window).height() * 0.1);
		}
		
		$('#loading').css('top', $(document).scrollTop() + $(window).height() / 2 - 24);
	});
});

function showXMask()
{
	$('#x-mask').css({'display': '', 'height': $(document).height()});
}

function openWriter()
{
	if (IS_GUEST)
	{
		showLogin();

		return false;
	}
	
	showXMask();
	
	$('#writer').css('display', 'block');
	
	$('#writer textarea').focus();
}

function showLogin()
{
	showXMask();
	$('#login_panel').css('display', '');
}

var comments_data = '';

function showComments(entryid)
{
	showLoading();
	
	document.getElementById('comments_panel_entryid').value = entryid;
	
	$.getJSON('?act=getcomments&entryid=' + entryid, function (data) {
		comments_data = '';
		
		$.each(data, function (i, a)
		{
			comments_data += '<li><span style="color:#666">' + a['nickname'] + ':</span> ' + a['message'] + ' <span class="time">(' + a['time'] + ')</span></li>';
		});
		
		$('#comments_data').html(comments_data);
		
		hideLoading();
		
		showXMask();
		
		$('#comments_panel').css('display', '');
	});
}

var loading_timer;
var loading_bg_count = 12;

function showLoading()
{
	$('#loading').fadeIn();
	
	loading_timer = setInterval(function () {
		loading_bg_count = loading_bg_count - 1;
		
		$('#loading_box').css('background-position', '0px ' + loading_bg_count * 40 + 'px');
		
		if (loading_bg_count == 1)
		{
			loading_bg_count = 12;
		}
	}, 100)
}

function hideLoading()
{
	$('#loading').fadeOut();
	
	clearInterval(loading_timer);
}

var get_entry_page = 1;

function getEntry()
{
	showLoading();
	
	get_entry_page++;
	
	$.get('?act=getentry&page=' + get_entry_page, function (data) {
		hideLoading();
		
		if (data == 'empty')
		{
			alert(LANG_NO_MORE_ENTRY);
			
			$('#x-button-get-entry').hide();
		}
		else
		{
			$('#entry_data').html($('#entry_data').html() + data);
		}
	});
}

function getFollow()
{
	showLoading();
	
	get_entry_page++;
	
	$.get('?act=getfollowing&page=' + get_entry_page, function (data) {
		hideLoading();
		
		if (data == 'empty')
		{
			alert(LANG_NO_MORE_FOLLOW);
			
			$('#x-button-get-follow').hide();
		}
		else
		{
			$('#entry_data').html($('#entry_data').html() + data);
		}
	});
}

function postComment()
{
	if ($('#comments_panel input[name=message]').attr('value') == '' || $('#comments_panel input[name=message]').attr('value') == '评论内容...')
	{
		alert(LANG_PLEASE_ENTER_COMMENT);
		
		$('#comments_panel input[name=message]').focus();
		
		return false;
	}
	
	showLoading();
	
	$.post('../httprequest.php?act=sendreply', $('#comments_panel form').formToArray(), function (message) {
		hideLoading();
		
		if (message == 'done')
		{
			alert(LANG_COMMENT_SENT_SUCCESS);
			
			$('#comments_panel input[name=message]').attr('value', LANG_COMMENT_CONTENTS + '...').css('color', '#BBB');
			
			showComments(document.getElementById('comments_panel_entryid').value);
		}
		else
		{
			alert(LANG_SYSTEM_ERROR);
		}
	});
}

function postLogin()
{
	showLoading();
	
	$.post('../?act=login&ajax=true&byiphone=true', $('#login_panel form').formToArray(), function (message) {
		hideLoading();
		
		if (message == 'error')
		{
			alert(LANG_LOGIN_FALIED);
			
			$('#login_panel input[name=password]').focus();
		}
		else
		{			
			window.location.reload();
		}
	});
}

function postMessage()
{
	if (document.getElementById('post_message').value == '')
	{
		alert(LANG_PLEASE_ENTER_ENTRY);
		
		document.getElementById('post_message').focus();
		
		return false;
	}
	
	showLoading();
	
	$.post('../?act=save', 'bymobile=true&byiphone=true&message=' + document.getElementById('post_message').value, function (message) {
		hideLoading();
		
		if (message == 'show_login')
		{
			$('#x-mask').click();
			
			showLogin();
		}
		else if (message == 'sucess')
		{
			alert(LANG_ENTRY_SENT_SUCCESS);
			
			window.location.reload();
		}
		else
		{
			alert(LANG_SYSTEM_ERROR);
		}
	});
}