<?php
/* PageCookery Microblog
*
* Author: Explon
*
* Copyright (C) 2007 Explon <explon@gmail.com>
*/

chdir('../');

require_once('global.php');

switch ($act)
{
	default:		
		$entry = $db->query("SELECT * FROM entry ORDER BY time DESC LIMIT 20")->result_array();
		
		foreach ($entry AS $key => $item)
		{
			$entryids .= $item['id'] . ', ';
			$entry_reply[$item['id']] = $db->query("SELECT COUNT(*) AS count FROM reply WHERE entryid = " . intval($item['id']))->row_array();
		}
		
		$entry_picture = format_result_array_key($db->query("SELECT * FROM picture WHERE entryid IN (" . substr($entryids, 0, -2) . ")")->result_array(), 'entryid');
		
		$title = SITE_NAME;
		
		$template = new Template('i_blog_home', NULL, 'entry');
	break;
	
	case 'following':
		$entry = $db->query("SELECT * FROM followlog ORDER BY time DESC LIMIT " . Pages::GetQueryLimit(intval($_GET['page']), 20))->result_array();
		
		foreach ($entry AS $key => $item)
		{
			$entry[$key]['picture'] = unserialize($item['picture']);
			$entry[$key]['message'] = nl2br(Format::ParseBBCode($item['message']));
			
			if (!$follower[$item['followid']])
			{
				$follower[$item['followid']] = $db->query("SELECT * FROM follow WHERE id = " . intval($item['followid']))->row_array();
			}
		}
		
		$title = SITE_NAME . ' - ' . _t('关注');
		
		$template = new Template('i_blog_follow', NULL, 'following');
	break;
	
	case 'getcomments':
		$reply = $db->query("SELECT * FROM reply WHERE entryid = " . intval($_GET['entryid']) . " ORDER BY time ASC")->result_array();
		
		$json_data = array();
		
		foreach ($reply AS $key => $item)
		{
			$item['time'] = Format::Date($item['time']);
			
			if (!$item['nickname'])
			{
				$item['nickname'] = _t('匿名人士');
			}
			
			$json_data[] = $item;
		}
		
		echo json_encode($json_data);
	break;
	
	case 'getentry':
		$entry = $db->query("SELECT * FROM entry ORDER BY time DESC LIMIT " . Pages::GetQueryLimit(intval($_GET['page']), 20))->result_array();
		
		if (sizeof($entry) == 0)
		{
			exit('empty');
		}
		
		foreach ($entry AS $key => $item)
		{
			$entryids .= $item['id'] . ', ';
			$entry_reply[$item['id']] = $db->query("SELECT COUNT(*) AS count FROM reply WHERE entryid = " . intval($item['id']))->row_array();
		}
		
		$entry_picture = format_result_array_key_by_id($db->query("SELECT * FROM picture WHERE entryid IN (" . substr($entryids, 0, -2) . ")")->result_array());
		
		$template = new Template('i_blog_getentry', NULL, 'mobile');
	break;
	
	case 'getfollowing':
		$entry = $db->query("SELECT * FROM followlog ORDER BY time DESC LIMIT " . Pages::GetQueryLimit(intval($_GET['page']), 20))->result_array();
		
		if (sizeof($entry) == 0)
		{
			exit('empty');
		}
		
		foreach ($entry AS $key => $item)
		{
			$entry[$key]['picture'] = unserialize($item['picture']);
			$entry[$key]['message'] = nl2br(Format::ParseBBCode($item['message']));
			
			if (!$follower[$item['followid']])
			{
				$follower[$item['followid']] = $db->query("SELECT * FROM follow WHERE id = " . intval($item['followid']))->row_array();
			}
		}
		
		$template = new Template('i_blog_getfollow', NULL, 'mobile');
	break;
}

if (is_object($template))
{
	//eval($template->Parse());
	include $template->Parse();
}

