<?php
/* PageCookery Framework
*
* Author: Explon
*
* Copyright (C) 2007 Explon <explon@gmail.com>
*/

if (function_exists('date_default_timezone_set'))
{
	date_default_timezone_set('UTC');
}

// Compares PHP version against our requirement
if (!version_compare(PHP_VERSION, '5.1.0', '>='))
{
	exit('PageCookery Framework requirement PHP 5.1.0 or higher to run. You are currently running PHP ' . PHP_VERSION . ' .');
}

if (!function_exists('mb_convert_encoding') AND !function_exists('iconv'))
{
	exit('PageCookery Framework requirement PHP enable mb_convert_encoding() or iconv() function.');
}

if (version_compare(PHP_VERSION, '6.0.0-dev', '<') AND !function_exists('set_magic_quotes_runtime'))
{
	exit('PageCookery Framework requirement PHP enable set_magic_quotes_runtime() function.');
}

// If we are on PHP >= 6.0.0 we do not need some code
if (version_compare(PHP_VERSION, '6.0.0-dev', '<'))
{
    @set_magic_quotes_runtime(0);
}

if (get_magic_quotes_gpc())
{
    function stripslashes_gpc(&$value)
    {
        $value = stripslashes($value);
    }
	
    array_walk_recursive($_GET, 'stripslashes_gpc');
    array_walk_recursive($_POST, 'stripslashes_gpc');
    array_walk_recursive($_COOKIE, 'stripslashes_gpc');
    array_walk_recursive($_REQUEST, 'stripslashes_gpc');
}

if (@ini_get('register_globals'))
{
	foreach ($_REQUEST AS $name => $value)
	{
		unset($$name);
	}
}

define('ROOT_PATH', dirname(__FILE__) . '/');

require_once(COOKERY_FRAMEWORK_DIR . 'lib/functions.php');

function __autoload($class_name)
{
	if (in_array(strtolower($class_name), array('cron', 'format', 'helper', 'image', 'iplocation', 'pages', 'rssparser', 'template', 'timer', 'upload', 'weiboclient', 'weibooauth')))
	{
		require_once(COOKERY_FRAMEWORK_DIR . 'lib/class_' . strtolower($class_name) . '.php');
	}
}

require_once('framework/CI/database/DB.php');

$runtime = new Timer();

$db_driver = 'mysql';

if (function_exists('mysqli_connect'))
{
	$db_driver = 'mysqli';
}