<?php
/* PageCookery Microblog
*
* Author: Explon
*
* Copyright (C) 2007 Explon <explon@gmail.com>
*/

chdir('../');

require_once('global.php');

if ($Own['lastfm'])
{	
	$playing = get_recent_tracks();
}

switch ($act)
{
	default:		
		$title = SITE_NAME;

		$template = new Template('m_blog_home', NULL, 'mobile');
	break;
	
	case 'login':
		$title = SITE_NAME . '- ' . _t('登录');

		$template = new Template('m_blog_login', NULL, 'mobile');
	break;
	
	case 'entry':
	case 'following':
		if ($User['id'] AND $act == 'entry')
		{
			$prefixs = $db->query("SELECT * FROM prefix WHERE id > 1 ORDER BY title ASC")->result_array();
		}
		
		if (!$_GET['page'])
		{
			$_GET['page'] = 1;
		}
		
		if ($act == 'entry')
		{
			$_table = 'entry';
		}
		else
		{
			$_table = 'followlog';
		}
		
		$entry = $db->query("SELECT SQL_CALC_FOUND_ROWS * FROM " . $_table . " ORDER BY time DESC LIMIT " . Pages::GetQueryLimit(intval($_GET['page']), 20))->result_array();
		
		$pages_total = $db->query("SELECT FOUND_ROWS() AS count")->row_array();
		
		if ($act == 'entry')
		{
			foreach ($entry AS $key => $item)
			{
				$content = explode("\n", trim(strip_tags($item['content'])));
				
				$message = '';
				
				foreach ($content AS $auto_key => $message)
				{
					if (trim($message) != '')
					{
						break;
					}
				}
				
				$entry[$key]['formated_content'] = Format::ParseBBCode($message);
			}
		}
		else
		{
			foreach ($entry AS $key => $item)
			{
				$entry[$key]['picture'] = unserialize($item['picture']);
				$entry[$key]['message'] = nl2br(Format::ParseBBCode($item['message']));
				
				if (!$follower[$item['followid']])
				{
					$follower[$item['followid']] = $db->query("SELECT * FROM follow WHERE id = " . intval($item['followid']))->row_array();
				}
			}
		}
		
		$pages_total = $entry_total['count'] / 20;
		
		if (intval($pages_total) != $pages_total)
		{
			$pages_total = intval($pages_total) + 1;
		}
		
		if ($pages_total > $_GET['page'])
		{
			$page_next = $_GET['page'] + 1;
		}
		
		if ($pages_total > 1 AND $_GET['page'] > 1)
		{
			$page_prev = $_GET['page'] - 1;
		}
		
		if (!$_GET['page'])
		{
			$page_current = 1;
		}
		else
		{
			$page_current = $_GET['page'];
		}
		
		if ($act == 'entry')
		{
			$title = _t('网 志');
			
			$template = new Template('m_blog_blog', NULL, 'mobile');
		}
		else
		{
			$title = _t('关 注');
			
			$template = new Template('m_blog_follow', NULL, 'mobile');
		}
	break;
	
	case 'view':
		$entry = $db->query("SELECT * FROM entry WHERE id = " . intval($_GET['id']))->row_array();
		
		if (!$entry['id'])
		{
			exit;
		}
		
		$entry['picture'] = $db->query("SELECT * FROM picture WHERE entryid = " . $entry['id'])->row_array();
		
		$title_message = explode("\n", trim(strip_tags($entry['content'])));
		
		$title = $title_message[0];
		
		if ($options['allow_comment'] != 'false')
		{
			$reply = $db->query("SELECT * FROM reply WHERE entryid = " . intval($entry['id']))->result_array();
			
			foreach ($reply AS $key => $message)
			{
				$reply[$key]['ip'] = explode('.', $message['ip']);
			}
		}
		
		$template = new Template('m_blog_view', NULL, 'mobile');
	break;
}

if (is_object($template))
{
	//eval($template->Parse());
	include $template->Parse();
}

