<?php
function error($msg = '', $display = false) {
	
	ob_clean();

	if(USER::uid() > 0  ||  V('-:sysConfig/force_oauth2_error_check') == 1){
		$oauth2_err = detect_oauth2_token_error($msg);
	}else{
		$oauth2_err = array('detect'=>false);
	}
	
	if (defined('IS_DEBUG') && IS_DEBUG || $display) {
		//@todo 显性显示错误
		if(true == $oauth2_err['detect']){
			TPL::module('error_oauth2_token_error_lite', array('msg'=>$msg, 'oauth2_err' => $oauth2_err));
		}else{
			echo $msg;
		}
		exit;
	}
	
	if (Xpipe::isRunning()) {
		if(true == $oauth2_err['detect']){
			//echo '<div class="api-error">' . TPL::module('error_oauth2_token_error_lite', array('msg'=>$msg, 'oauth2_err' => $oauth2_err), false) . '</div>';
			APP::redirect(W_BASE_HTTP. URL('account.oauth2_token_error', array('msg'=>base64_encode($msg))) ,4);
		}else{
			echo '<div class="api-error"><p>' . ($msg ? $msg : L('function__error__serverBusy')) . '</p></div>';
		}
		
	} else {
		if(true == $oauth2_err['detect']){
			TPL::module('error_oauth2_token_error', array('msg'=>$msg, 'oauth2_err' => $oauth2_err));
		}else{
			TPL::module('error_busy');
		}
	}
	exit;
}

/**
 * @see http://open.weibo.com/wiki/Error_code
 * @param unknown_type $msg
 * @return array
 */
function detect_oauth2_token_error($msg){
	$return = array(
		'detect' => false,
		'error_code' => 0,
		'error_type' => 'unknown_error',
	);
	if(empty($msg)){
		return $return;
	}
	
	if(0 !== strpos($msg, 'WEIBO_OAUTH2_ERROR_CODE_') && false === strpos(strtolower($msg), 'token')){
		return $return;
	}
	
	$return['detect'] = true;
	
	$match = array();
	preg_match('/^WEIBO_OAUTH2_ERROR_CODE_([0-9]+)/', $msg, $match);
	$code = 0;
	if(isset($match[1])){
		$code = $return['error_code'] = $match[1];
	}
	
	if($code == '21315' || $code == '21327'  || false !== strpos($msg, 'expire')){
		$return['error_type'] = 'expired_token';
	}elseif($code == '21317'  || false !== strpos($msg, 'reject')){
		$return['error_type'] = 'token_rejected';
	}elseif($code == '21316'  || false !== strpos($msg, 'revoke')){
		$return['error_type'] = 'token_revoked';
	}elseif($code == '21314' || false !== strpos($msg, 'used')){
		$return['error_type'] = 'token_used';
	}
	
	return $return;
	
}