<?php
/**
 * OAUTH2_AUTHRIZE_TYPE为2或者3的时候，获取AuthorizeURL的方法
 * 此部分分离出来，用于给定制版进行定制开发
 * @author yaoying
 * @version $Id: oauth2_outer_getTokenAuthorizeURL.func.php 18379 2012-07-10 07:10:50Z yaoying $
 * @param array $param 必有key：state
 * @return RST_Array
 */
function oauth2_outer_getTokenAuthorizeURL($param = array()){
	
		$redirect_uri = OAUTH2_REDIRECT_SOURCE;
		//简易校验参数
		$param['xcallfrom'] = 'xweibo';
		$param['xtimestamp'] = APP_LOCAL_TIMESTAMP;
		//checksum算法，可根据自己需要进行更改
		$param['xchecksum'] = md5(md5(substr(WB_SKEY, 0, 16), true). crc32(substr(WB_SKEY, 16)). '#'. APP_LOCAL_TIMESTAMP);
		
		if(isset($param['forcelogin']) && $param['forcelogin'] == true){
			$param['forcelogin'] = 'true';
		}
		$param = http_build_query($param);
		
		if(strpos($redirect_uri, '?') === false){
			$redirect_uri = $redirect_uri. '?'. $param;
		}else{
			$redirect_uri = $redirect_uri. '&'. $param;
		}
		
		$redirect_uri = RST($redirect_uri);
		
		return $redirect_uri;
}