DROP TABLE IF EXISTS f_comment;
CREATE TABLE `f_comment` (
  `pid` mediumint(8) NOT NULL auto_increment,
  `uid` mediumint(8) NOT NULL,
  `aid` mediumint(8) NOT NULL,
  `tid` mediumint(8) NOT NULL,
  `guest` char(25) NOT NULL,
  `content` mediumtext NOT NULL,
  `postdate` int(10) NOT NULL,
  PRIMARY KEY  (`pid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS f_content;
CREATE TABLE `f_content` (
  `tid` mediumint(8) NOT NULL auto_increment,
  `uid` mediumint(8) NOT NULL,
  `sid` tinyint(4) NOT NULL,
  `sec` tinyint(4) NOT NULL,
  `secpw` varchar(60) NOT NULL,
  `title` char(225) NOT NULL,
  `content` mediumtext NOT NULL,
  `hit` int(11) NOT NULL,
  `posttime` int(10) NOT NULL,
  PRIMARY KEY  (`tid`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS f_guestbook;
CREATE TABLE `f_guestbook` (
  `id` mediumint(8) NOT NULL auto_increment,
  `uid` mediumint(8) NOT NULL,
  `aid` mediumint(9) NOT NULL,
  `content` mediumtext NOT NULL,
  `guest` varchar(25) NOT NULL,
  `postdate` int(11) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS f_members;
CREATE TABLE `f_members` (
  `uid` mediumint(8) NOT NULL auto_increment,
  `username` char(25) NOT NULL,
  `email` char(45) NOT NULL,
  `password` char(64) NOT NULL,
  `regdate` int(10) NOT NULL,
  `level` int(10) NOT NULL,
  PRIMARY KEY  (`uid`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS f_siteinfo;
CREATE TABLE `f_siteinfo` (
  `id` mediumint(8) NOT NULL auto_increment,
  `uid` mediumint(8) NOT NULL,
  `sitename` char(125) NOT NULL,
  `blogname` char(125) NOT NULL,
  `about` mediumtext NOT NULL,
  `tblog` mediumtext NOT NULL,
  `nav` mediumtext NOT NULL,
  `banner` mediumtext NOT NULL,
  `desblog` text NOT NULL,
  `keyword` text NOT NULL,
  `style` varchar(40) NOT NULL,
  `des` text NOT NULL,
  `tongji` mediumtext NOT NULL,
  `link` mediumtext NOT NULL,
  `pagesize` smallint(6) NOT NULL,
  `latesize` smallint(6) NOT NULL,
  `comsize` smallint(6) NOT NULL,
  `messize` smallint(6) NOT NULL,
  `height` smallint(6) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS f_sort;
CREATE TABLE `f_sort` (
  `id` tinyint(4) NOT NULL auto_increment,
  `sid` tinyint(4) NOT NULL,
  `sortname` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `sortname` (`sortname`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

