<?php
class Form_News extends Zend_Form{
	public function __construct($option = null){
		parent::__construct($option);
		$this->setName('News');
		$this->setAttrib('enctype','multipart/form-data');
		$id = new Zend_Form_Element_Hidden('id');
		$title = new Zend_Form_Element_Text('title');
		$title->setLabel('Title')
			  ->setRequired(true)
			  ->addFilter('StripTags')
			  ->addFilter('StringTrim')
			  ->addValidator('NotEmpty');
		$content = new Zend_Form_Element_Textarea('content');
		$content->setLabel('Content')
			    ->setRequired(true)
				->addValidator('NotEmpty');
		$pic = new Zend_Form_Element_File('pic');
		$pic->setLabel('pic');
		$ntype = new Zend_Form_Element_Select('ntype');
		$ntype->setLabel('ntype')
			  ->addMultiOption('1',分类一)
			  ->addMultiOption('2',分类二);
		$submit = new Zend_Form_Element_Submit('submit');
		$submit->setAttrib('id','submitbutton');
		$this->addElements(array($id,$title,$content,$pic,$ntype,$submit));
	}
} 