<?php
class Model_DbTable_Article extends Zend_Db_Table_Abstract{
	protected $_name = 'article';
	
	public function getAll($tid){
		$nAll = $this->fetchAll('type='.$tid,'id desc')->toArray();
		return $nAll;
	}
	
	public function geta(){
		$all = $this->fetchAll(NULL,'id desc')->toArray();
		return $all;
	}
	
	public function search($title){
		$db = $this->getAdapter();
		$select = $this->_db->select();
		$where = $db->quoteInto('title like ?',"%$title%");
		$select->from($this->_name,'*');
		$select->where($where);
		$sql = $select->__toString();
		return $this->_db->fetchAll($sql);
	}
	
	public function getId($id){
		$select = $this->_db->select();
		$select->from($this->_name,'*');
		$select->where('id=?',$id);
		$sql = $select->__toString();
		return $this->_db->fetchRow($sql);
	}
	
	public function add($title,$content,$tag,$pic,$annex,$type,$code){
		$data = array(
			'title'=>$title,
			'content'=>$content,
			'tag'=>$tag,
			'type'=>$type,
			'time'=>time(),
		);
		if(!empty($pic)){
			$data['pic'] = $pic;
		}
		if(!empty($annex)){
			$data['annex'] = $annex;
		}
		if(!empty($code)){
			$data['code'] = $code;
		}
		$id = $this->insert($data);
		return $id;
	}
	
	public function updatea($id,$title,$content,$tag,$pic,$annex,$type,$code){
		$data = array(
			'title'=>$title,
			'content'=>$content,
			'tag'=>$tag,
			'type'=>$type,
		);
		if(!empty($pic)){
			$data['pic'] = $pic;
		}
		if(!empty($annex)){
			$data['annex'] = $annex;
		}
		if(!empty($code)){
			$data['code'] = $code;
		}
		$this->update($data,'id='.$id);
	}
	
	public function del($id){
		$this->delete('id='.$id);
	}
	
	public function delmore($array){
		foreach($array as $i){
			$this->delete('id='.$i);
		}
	}
}