<?php
class Model_DbTable_Comment extends Zend_Db_Table_Abstract{
	protected $_name = 'comment';
	
	public function getAll(){
		$all = $this->fetchAll(NULL,'id desc')->toArray();
		return $all;
	}
	
	public function getByid($id){
		$select = $this->_db->select();
		$select->from($this->_name,'*');
		$select->where('aid =?',$id);
		$select->where('auth =?','1');
		$sql = $select->__toString();
		return $this->_db->fetchAll($sql);
	}
	
	public function getId($id){
		$row = $this->fetchRow('id='.$id);
		if(!$row){
			throw new Exception('Count not find row $id');
		}
		return $row->toArray();
	}
	
	public function add($email,$name,$site,$content,$ip,$aid){
		$data = array(
			'name'=>$name,
			'email'=>$email,
			'site'=>$site,
			'content'=>$content,
			'ip'=>$ip,
			'time'=>time(),
			'auth'=>1,
			'aid'=>$aid
		);
		
		$this->insert($data);
	}
	
	public function reply($id,$reply){
		$data = array(
			'reply'=>$reply
		);
		
		$this->update($data,'id='.$id);
	}
	
	public function changea($id,$auth){
		$data = array(
			'auth'=>$auth,
		);
		
		$this->update($data,'id='.$id);
	}
	
	public function del($id){
		$this->delete('id='.$id);
	}
	
	public function delm($ar){
		foreach($ar as $id){
			$this->delete('id='.$id);
		}
	}
	
	public function delaid($id){
		$this->delete('aid='.$id);
	}
}