<?php
class ArticleController extends Zend_Controller_Action 
{
 	
	public function init()
    {	
		$this->smarty=Zend_Registry::get('smarty');
		$this->config=Zend_Registry::get('config');
		$this->smarty->assign('baseUrl',$this->_request->getBaseUrl());
    }
	public function imgcodeAction()
    {
    	Zend_Loader::loadClass('Custom_Controller_Plugin_ImgCode');
    	
    	$imagecode=new Custom_Controller_Plugin_ImgCode();
    	
    	$imagecode->image2();
    }
	
	public function indexAction()
    {	
    	$article=new Article();
		$db = $article->getAdapter();
		Zend_Loader::loadClass('Zend_Filter_StripTags');
		$filter=new Zend_Filter_StripTags();
		$type=$filter->filter(($this->_request->getParam('type')));
		$count='35';
		if($type==''){$type='list';}
		if($type=='common'){$count='10';}
		
        $query="SELECT `".TABLE_PRE."article`.*, `".TABLE_PRE."articleclass`.`name` AS `classname` FROM `".TABLE_PRE."article` INNER JOIN `".TABLE_PRE."articleclass` ON ".TABLE_PRE."article.class = `".TABLE_PRE."articleclass`.id ";

        $page=$this->_request->getParam('page');
		$condition=NULL;
		$sortby="`".TABLE_PRE."article`.id DESC";
		Zend_Loader::loadClass('Custom_Controller_Plugin_Pager');
		$basePageIndex=0;
		$Pagers = new Custom_Controller_Plugin_Pager($db,$page,$count,$condition,$sortby,$basePageIndex,$query) ;
		$pageInfo = $Pagers->getNavBar(WEB_ROOT.'/article/index/');
		$this->smarty->articles = $Pagers->findAll();
		//取到评论数量
		$comquery="SELECT count( DISTINCT `".TABLE_PRE."comment`.id ) AS commentsum, `".TABLE_PRE."comment`.`commentid`
FROM `".TABLE_PRE."comment` INNER JOIN `".TABLE_PRE."article` ON `".TABLE_PRE."comment`.`commentid` = `".TABLE_PRE."article`.id GROUP BY `".TABLE_PRE."article`.id DESC";
    	$comment=new Comment();
    	$dbcom=$comment->getAdapter();
		$arrComment=$dbcom->fetchAll($comquery);
		//取到友情链接
		$weblink=new Weblink();
		$arrLinks=$weblink->fetchAll(TABLE_PRE."weblink.show='1'",TABLE_PRE."weblink.id DESC",10)->toArray();
		$this->smarty->assign('arrLinks',$arrLinks);
		//取到最热日志
		$topArticle=$article->fetchAll(TABLE_PRE."article.show='1'",TABLE_PRE."article.viewnum  DESC",10)->toArray();
		$this->smarty->assign('topArticle',$topArticle);
		$ArticleNums=count($article->fetchAll()->toArray());
		$this->smarty->assign('ArticleNums',$ArticleNums);
		
		//取到最新留言
		$message=new Message();
		$topMessage=$message->fetchAll(TABLE_PRE."message.show='1' and ".TABLE_PRE."message.pid='0' ","id DESC",10)->toArray();
		$this->smarty->assign('topMessage',$topMessage);
		$MessageNums=count($message->fetchAll()->toArray());
		$this->smarty->assign('MessageNums',$MessageNums);
		
		//取到最新评论
		$topComment=$comment->fetchAll(TABLE_PRE."comment.show='1'",TABLE_PRE."comment.id  DESC",10)->toArray();
		$this->smarty->assign('topComment',$topComment);
		$CommentNums=count($comment->fetchAll()->toArray());
		$this->smarty->assign('CommentNums',$CommentNums);
		
		//取到日志分类
		$articleclass=new Articleclass();
		$topClass=$articleclass->fetchAll(TABLE_PRE."articleclass.pid='0'")->toArray();
		$this->smarty->assign('topClass',$topClass);
		
		//取到访问量
		$count=new Count();
		$SeeNums=count($count->fetchAll()->toArray());
		$this->smarty->assign('SeeNums',$SeeNums);
		//取到标签数量
		$taguery="SELECT ".TABLE_PRE."itemtags . * , ".TABLE_PRE."tags.name FROM ".TABLE_PRE."itemtags LEFT JOIN ".TABLE_PRE."tags ON ".TABLE_PRE."tags.id = ".TABLE_PRE."itemtags.tagid WHERE ".TABLE_PRE."itemtags.type = 'article'";
    	$itemtags=new Itemtags();		
		$dbtags = $itemtags->getAdapter();
		$arrTags=$dbtags->fetchAll($taguery);
		$this->smarty->assign('arrTags',$arrTags);
		
		//print_r($arrComment);
		$this->smarty->assign('arrComment',$arrComment);
		$this->smarty->assign('type',$type);
		$this->smarty->assign('arrArticles',$this->smarty->articles);
		$this->smarty->assign("offsetnums",$Pagers->offsetnums);
    	$this->smarty->assign("pageInfo",$pageInfo);
    	$this->smarty->display('header.phtml');  
		$this->smarty->display('article/index.phtml');
		$this->smarty->display('footer.phtml');
    	
    }
    
    public function articleAction()
    {
    	$article=new Article();
    	$comment=new Comment();
		$db = $article->getAdapter();
  		Zend_Loader::loadClass('Zend_Filter_StripTags');
		$filter=new Zend_Filter_StripTags();
		$id=$filter->filter(($this->_request->getParam('id')));
        $query="SELECT `".TABLE_PRE."article`.*, `".TABLE_PRE."articleclass`.`name` AS `classname` FROM `".TABLE_PRE."article` INNER JOIN `".TABLE_PRE."articleclass` ON ".TABLE_PRE."article.class = `".TABLE_PRE."articleclass`.id WHERE ".TABLE_PRE."article.id =$id";
		$Articleone=$db->fetchAll($query);
		//取前一篇,后一篇日志
		$Sqlone=" SELECT id,title  FROM `".TABLE_PRE."article` WHERE `id` > $id LIMIT 0 , 1 ";
		$Sqltwo="SELECT id,title FROM `".TABLE_PRE."article` WHERE `id` < $id ORDER BY id DESC LIMIT 0 , 1 ";
		$ArticleForword=$db->fetchAll($Sqltwo);
		$this->smarty->assign('ArticleForword',$ArticleForword);
		$ArticleBack=$db->fetchAll($Sqlone);
		$this->smarty->assign('ArticleBack',$ArticleBack);
		/*取到评论*/
		$page=$this->_request->getParam('page');
		$condition="".TABLE_PRE."comment.commentid=$id and ".TABLE_PRE."comment.type='article'";
		$sortby="".TABLE_PRE."comment.id DESC";
		Zend_Loader::loadClass('Custom_Controller_Plugin_Pager');
		$basePageIndex=0;
		$Pagers = new Custom_Controller_Plugin_Pager($comment,$page,'8',$condition,$sortby,$basePageIndex) ;
		
		$pageInfo = $Pagers->getNavBar(WEB_ROOT.'article/article/id/'.$id.'/');
		$arrComments = $Pagers->findAll()->toarray();
		$comentsum=$Pagers->totalCount;
		
		//取到随机日志
		$randArticle=$article->fetchAll("".TABLE_PRE."article.show='1' and ".TABLE_PRE."article.id !=$id",'RAND()',5)->toArray();
		$this->smarty->assign('randArticle',$randArticle);
		$ArticleNums=count($article->fetchAll()->toArray());
		$this->smarty->assign('ArticleNums',$ArticleNums);
		
		
		//增加浏览量
		$viewnum=$Articleone[0]['viewnum']+1;
		$set = array('viewnum' => $viewnum);
		$where = $db->quoteInto('id= ?', $id);
		$article->update($set, $where);
		
		$this->smarty->assign('comentsum',$comentsum);
		$this->smarty->assign('arrComments',$arrComments);
    	$this->smarty->assign("pageInfo",$pageInfo);
		//取到友情链接
		$weblink=new Weblink();
		$arrLinks=$weblink->fetchAll(TABLE_PRE."weblink.show='1'",TABLE_PRE."weblink.id DESC",10)->toArray();
		$this->smarty->assign('arrLinks',$arrLinks);
		//取到最热日志
		$topArticle=$article->fetchAll(TABLE_PRE."article.show='1'",TABLE_PRE."article.viewnum  DESC",10)->toArray();
		$this->smarty->assign('topArticle',$topArticle);
		
		//取到最新留言
		$message=new Message();
		$topMessage=$message->fetchAll(TABLE_PRE."message.show='1' and ".TABLE_PRE."message.pid='0' ","id DESC",10)->toArray();
		$this->smarty->assign('topMessage',$topMessage);
		$MessageNums=count($message->fetchAll()->toArray());
		$this->smarty->assign('MessageNums',$MessageNums);
		//取到访问量
		$count=new Count();
		$SeeNums=count($count->fetchAll()->toArray());
		$this->smarty->assign('SeeNums',$SeeNums);
		
		//取到最新评论
		$topComment=$comment->fetchAll(TABLE_PRE."comment.show='1'",TABLE_PRE."comment.id  DESC",10)->toArray();
		$this->smarty->assign('topComment',$topComment);
		$CommentNums=count($comment->fetchAll()->toArray());
		$this->smarty->assign('CommentNums',$CommentNums);
		
		//取到日志分类
		$articleclass=new Articleclass();
		$topClass=$articleclass->fetchAll(TABLE_PRE."articleclass.pid='0'")->toArray();
		$this->smarty->assign('topClass',$topClass);
		//取到标签数量
		$taguery="SELECT ".TABLE_PRE."itemtags . * , ".TABLE_PRE."tags.name FROM ".TABLE_PRE."itemtags LEFT JOIN ".TABLE_PRE."tags ON ".TABLE_PRE."tags.id = ".TABLE_PRE."itemtags.tagid WHERE ".TABLE_PRE."itemtags.type = 'article'";
    	$itemtags=new Itemtags();		
		$dbtags = $itemtags->getAdapter();
		$arrTags=$dbtags->fetchAll($taguery);
		$this->smarty->assign('arrTags',$arrTags);
		
		$this->smarty->assign("offsetnums",$Pagers->offsetnums);
    	$this->smarty->assign('Articleone',$Articleone);
		$this->smarty->assign('id',$id);
		$this->smarty->display('header.phtml');  
		$this->smarty->display('article/article.phtml');
		$this->smarty->display('footer.phtml');
    }
	
    
    public function rssAction()
    {
	    require_once 'Zend/Feed.php';
	    Zend_Loader::loadClass('Zend_Filter_StripTags');
	    $article=new Article();
		$filter=new Zend_Filter_StripTags();
		$id=$filter->filter(($this->_request->getParam('id')));
	    $feedArray = array(
	                'title' => 'ClubReading Books',
	                'link' => 'http://www.oophp.cn/blog/index/rss',
	                'description' => '热爱PHP技术.更愿意为开源而努力!',
	                'language' => 'en-us',
	                'charset' => 'utf-8',
	                'pubDate' => '1218721648',
	                'generator' => 'Zend Framework Zend_Feed',
	                'entries' => array()
	      );
	    
		
        $arrArticle=$article->fetchAll('id='.$id)->toArray();
		foreach($arrArticle as $article){
		    $feedArray['entries'][] = array(
		                'title' => $article['title'],
		                'link' =>'http://127.0.0.1/blog/article/index/id/'.$article['id'],
		                'guid' =>'http://127.0.0.1/blog/article/index/id/'.$article['id'],
		                'description' => $article['content'],
		                'pubDate' => '1218721648'
		                );
		            
		 }
		
		$feed = Zend_Feed::importArray($feedArray, 'rss');
		$feed->send();
	
    }
    
   public function commentAction()
    {
    	require_once 'Zend/Session/Namespace.php';
        if($this->_request->isPost()){
    		Zend_Loader::loadClass('Zend_Filter_StripTags');
    		$filter=new Zend_Filter_StripTags();
    		$username=$filter->filter($this->_request->getPost('username'));
    		$email=$filter->filter($this->_request->getPost('email'));
    		$content=$filter->filter($this->_request->getPost('content'));
    		$commentid=$filter->filter($this->_request->getPost('articleId'));
    		$headimg=$filter->filter($this->_request->getPost('headimg'));
    		$imgcode=$filter->filter($this->_request->getPost('imgcode'));
    		$authCode = new Zend_Session_Namespace('Auth_Code');
    		
    		$dateFormat =$this->config->Format->dateFormat;
        	$comment=new Comment();
        	$db=$comment->getAdapter();
        	
    		if($authCode->imagecode==$imgcode){
	    		if($username!=''&&$email!=''&&$commentid!=''&&$content!=''){
					require_once 'Zend/Validate/EmailAddress.php';
					$validator = new Zend_Validate_EmailAddress();
					if ($validator->isValid($email)) {
						Zend_Loader::loadClass('Custom_Controller_Plugin_IpLocation');
				    	Zend_Loader::loadClass('Custom_Controller_Plugin_Ipaddress');
				    	$Ipaddress=new Custom_Controller_Plugin_Ipaddress();
				    	$IP=$Ipaddress->getIP();
				    	$dir= ROOT_DIR."/blog/public/QQWry2.Dat";
				    	$iplocation=new Custom_Controller_Plugin_IpLocation($dir);
						$location=$iplocation->getlocation($IP);
						$address=iconv("gb2312","utf-8",$location['country']);
						$data=array(
						'username'=>$username,
		    			'pid'=>'0',
						'email'=>$email,
						'commentid'=>$commentid,
						'headimg'=>$headimg,
						'show'=>'1',
						'content'=>$content,
						'type'=>'article',
		    			'ip'=>$IP,
		    			'address'=>$address,
						'addtime'=>date($dateFormat),
						'updatetime'=>date($dateFormat)
						);
						$comment->insert($data);
						$db->lastInsertId();
						unset($data);
						//echo "您的评论发表成功!";
						
						/*取到评论*/
						$comment=new Comment();
						$page=$this->_request->getParam('page');
						$condition="".TABLE_PRE."comment.commentid=$commentid and ".TABLE_PRE."comment.type='article'";
						$sortby="".TABLE_PRE."comment.id DESC";
						Zend_Loader::loadClass('Custom_Controller_Plugin_Pager');
						$basePageIndex=0;
						$Pagers = new Custom_Controller_Plugin_Pager($comment,$page,'8',$condition,$sortby,$basePageIndex) ;
						
						$pageInfo = $Pagers->getNavBar(WEB_ROOT.'article/article/id/'.$commentid.'/');
						$this->smarty->comments = $Pagers->findAll();
						$this->smarty->assign('arrComments',$this->smarty->comments->toArray());
				    	$this->smarty->assign("pageInfo",$pageInfo);
				    	$this->smarty->assign('flag','0');
				    	$this->smarty->assign('message','您的评论发表成功!');
				    	$this->smarty->display('article/comment.phtml');
		
					} else {
					    //echo "对不起!您填写有电子邮箱地址有误!";
					    $this->smarty->assign('flag','5');
				    	$this->smarty->assign('message','对不起!您填写有电子邮箱地址有误!');
					    $this->smarty->display('article/comment.phtml');
					}
						
	    		}elseif($username==''){
	    			//echo "对不起!您的大名不能为空!";
	    			$this->smarty->assign('flag','1');
				    $this->smarty->assign('message','对不起!您的大名不能为空!');
	    			$this->smarty->display('article/photo.phtml');
	    		}elseif($commentid==''){
	    			//echo "对不起!评论文章编号不能为空!";
	    			$this->smarty->assign('flag','2');
				    $this->smarty->assign('message','对不起!评论文章编号不能为空!');
	    			$this->smarty->display('article/comment.phtml');
	    		}elseif($content==''){
	    			//echo "对不起!您填写的评论内容不能为空!";
	    			$this->smarty->assign('flag','3');
				    $this->smarty->assign('message','对不起!您填写的评论内容不能为空!');
	    			$this->smarty->display('article/comment.phtml');
	    		}
    		}else{
    			$this->smarty->assign('flag','4');
				$this->smarty->assign('message','对不起!您填写的验证码错误或超时!');
    			//echo "对不起!您填写的验证码错误或超时!";
    			$this->smarty->display('article/comment.phtml');
    		}
        }else{
        	
        	$this->smarty->display('login.phtml');
        }
       
    }
    
    
    
    
}
