<?php
class LinkController extends Zend_Controller_Action 
{
 	
	public function init()
    {	
		$this->smarty=Zend_Registry::get('smarty');
		$this->config=Zend_Registry::get('config');
		$this->smarty->assign('baseUrl',$this->_request->getBaseUrl());
    }
    
    public function indexAction()
    {
    	//取到友情链接
		$weblink=new Weblink();
		$arrLinks=$weblink->fetchAll(TABLE_PRE."weblink.show='1'",TABLE_PRE."weblink.id DESC",10)->toArray();
		$Links=$weblink->fetchAll(TABLE_PRE."weblink.show='1'")->toArray();
		$this->smarty->assign('Links',$Links);
		$this->smarty->assign('arrLinks',$arrLinks);
		//取到最热日志
		$article=new Article();
		$topArticle=$article->fetchAll(TABLE_PRE."article.show='1'",TABLE_PRE."article.viewnum  DESC",10)->toArray();
		$this->smarty->assign('topArticle',$topArticle);
		$ArticleNums=count($article->fetchAll()->toArray());
		$this->smarty->assign('ArticleNums',$ArticleNums);
		
		//取到最新留言
		$message=new Message();
		$topMessage=$message->fetchAll(TABLE_PRE."message.show='1' and ".TABLE_PRE."message.pid='0' ","id DESC",10)->toArray();
		$this->smarty->assign('topMessage',$topMessage);
		$MessageNums=count($message->fetchAll()->toArray());
		$this->smarty->assign('MessageNums',$MessageNums);
		//取到访问量
		$count=new Count();
		$SeeNums=count($count->fetchAll()->toArray());
		$this->smarty->assign('SeeNums',$SeeNums);
		
		//取到最新评论
		$comment=new Comment();
		$topComment=$comment->fetchAll(TABLE_PRE."comment.show='1'",TABLE_PRE."comment.id  DESC",10)->toArray();
		$this->smarty->assign('topComment',$topComment);
		
		//取到日志分类
		$articleclass=new Articleclass();
		$topClass=$articleclass->fetchAll(TABLE_PRE."articleclass.pid='0'")->toArray();
		$this->smarty->assign('topClass',$topClass);
		//取到标签数量
		$taguery="SELECT ".TABLE_PRE."itemtags . * , ".TABLE_PRE."tags.name FROM ".TABLE_PRE."itemtags LEFT JOIN ".TABLE_PRE."tags ON ".TABLE_PRE."tags.id = ".TABLE_PRE."itemtags.tagid WHERE ".TABLE_PRE."itemtags.type = 'article'";
    	$itemtags=new Itemtags();		
		$dbtags = $itemtags->getAdapter();
		$arrTags=$dbtags->fetchAll($taguery);
		$this->smarty->assign('arrTags',$arrTags);
		
		$CommentNums=count($comment->fetchAll()->toArray());
		$this->smarty->assign('CommentNums',$CommentNums);
    	$this->smarty->display('header.phtml');  
		$this->smarty->display('link.phtml');
		$this->smarty->display('footer.phtml');
    }
    
    public function addAction()
    {
        require_once 'Zend/Session/Namespace.php';
        if($this->_request->isPost()){
    		Zend_Loader::loadClass('Zend_Filter_StripTags');
    		$filter=new Zend_Filter_StripTags();
    		$title=$filter->filter($this->_request->getPost('title'));
    		$email=$filter->filter($this->_request->getPost('email'));
    		$content=$filter->filter($this->_request->getPost('content'));
    		$url=$filter->filter($this->_request->getPost('url'));
    		$imgcode=$filter->filter($this->_request->getPost('imgcode'));
    		$authCode = new Zend_Session_Namespace('Auth_Code');
    		
    		$dateFormat =$this->config->Format->dateFormat;
        	$weblink=new Weblink();
        	$db=$weblink->getAdapter();
        	
    		if($authCode->imagecode==$imgcode){
	    		if($title!=''&&$email!=''&&$url!=''&&$url!=''){
					require_once 'Zend/Validate/EmailAddress.php';
					$validator = new Zend_Validate_EmailAddress();
					if ($validator->isValid($email)) {
						$data=array(
						'title'=>$title,
		    			'url'=>$url,
						'email'=>$email,
						'show'=>'0',
						'content'=>$content,
						'addtime'=>date($dateFormat),
						'updatetime'=>date($dateFormat)
						);
						$weblink->insert($data);
						$db->lastInsertId();
						unset($data);

				    	echo '0||||您的友情链接申请成功!';
				    	
					} else {
					    echo '1||||对不起!您填写有电子邮箱地址有误!';
					}
						
	    		}elseif($title==''){
	    			
	    			 echo '2||||对不起!您的网站或博客名不能为空!';
	    		}elseif($url==''){
	    			 echo '3||||对不起!您的网站或博客地址不能为空!';
	    		}
    		}else{
    			echo '4||||对不起!您填写的验证码错误或超时!';
    		}
        }else{
        	
        	$this->smarty->display('login.phtml');
        }
    }
}