<?PHP
/*
 * date:
 */
/** Zend_Controller_Action */

class LoginController extends Zend_Controller_Action
{

	public $msg;
	public $registry;	
	public $config;
	public $view;
    /**
     * Initialize object.
     *
     * @return void
     */
	function init()
    {
        $this->registry = Zend_Registry::getInstance();
        $this->config = $this->registry['config'];
        $this->view = $this->registry['view'];
        $this->view->title = $this->config->webname;
        $this->view->author = $this->config->author;
        $this->view->baseUrl = $this->_request->getBaseUrl();
        $this->view->basePath = $this->_request->getBasePath();
        $this->view->user = (array)Zend_Auth::getInstance()->getIdentity();
    }
    public function indexAction()
    {
 		$this->view->moduletitle = 'û¼';   	
    	echo $this->view->render('index/showlogin.phtml');
    }
 	public function showloginAction()
	{
		$this->view->moduletitle = 'û¼';
        echo $this->view->render('index/showlogin.phtml');
	}
	public function loginAction()
	{
		if ($this->_request->isPost())
		{
			$StripTags = new Zend_Filter_StripTags();
            $username = $StripTags->filter($this->_request->getPost('username'));
            $password = $StripTags->filter($this->_request->getPost('password'));
		    if (empty($username)) 
		    {
                $this->view->msg = 'Please provide a username.';
            } 
            else 
            {
                $db = $this->registry['db'];
                $authAdapter = new Zend_Auth_Adapter_DbTable($db, 'zf_members', 'username', 'password');
                $authAdapter->setIdentity($username);            
                $authAdapter->setCredential(md5($password));
                $auth = Zend_Auth::getInstance();
                $result = $auth->authenticate($authAdapter);
                if ($result->isValid()) 
                {
                    $data = $authAdapter->getResultRowObject(null, 'password');
                    $auth->getStorage()->write($data);
                    //$this->view->username= $username;
                    $this->_redirect('/');
                    return;
                } 
                else 
                {
                    // failure: clear database row from session
                    $this->view->msg = 'Login failed.';
                }
            }
		}
		$this->view->moduletitle = 'û¼';
		echo $this->view->render('index/showlogin.phtml');
	}
	public function showregAction()
	{
		$this->view->moduletitle = 'ûע';
        echo $this->view->render('index/showreg.phtml');
	}
	public function regAction()
	{
        $this->view->msg = '֤עϢ<br>';
        if ($this->_request->isPost())
		{
            $StripTags = new Zend_Filter_StripTags();
		    $StringToLower = new Zend_Filter_StringToLower();
            $username = $StringToLower->filter($StripTags->filter($this->_request->getPost('username')));
            $email = $StripTags->filter($this->_request->getPost('email'));
		    $password = $this->_request->getPost('password');
		    $passwordc = $this->_request->getPost('passwordc');
		    $errno = false;
		    require_once 'Zend/Validate.php';
		    if (!Zend_Validate::is($username, 'NotEmpty'))
		    {
			    $this->view->msg .= 'ûΪգ<BR>';
			    $errno = true;
		    }
		    if (!Zend_Validate::is($username,'StringLength',array(3, 10)))
		    {
			    $this->view->msg .= 'ûַӦ3-10֮䣡<BR>';
			    $errno = true;
		    }
		    if (!Zend_Validate::is($username,'Alnum'))
		    {
		    	$this->view->msg .= 'ûӦΪĸֵϣ<BR>';
		    	$errno = true;
		    }		
		    if (!Zend_Validate::is($password, 'NotEmpty'))
		    {
		    	$this->view->msg .= '벻Ϊգ<BR>';
		    	$errno = true;
		    }
		    if($password != $passwordc)
		    {
		    	$this->view->msg .= '벻һ£<BR>';
		    	$errno = true;
		    }
		    if (!Zend_Validate::is($email, 'NotEmpty'))
		    {
		    	$this->view->msg .= 'EmailΪգ<BR>';
		    	$errno = true;
	    	}		
		    if (!Zend_Validate::is($email, 'EmailAddress'))
		    {
		    	$this->view->msg .= 'ʼʽϱ׼<BR>';
		    	$errno = true;
		    }
		    $db = $this->registry['db'];
		    $select = $db->select();
		    $select->from('zf_members', 'id')
		           ->where('username = ?', $username);
		    //$sql = $select->__toString();
		    $result = $db->fetchAll($select);  
		    //$params = array('username' => $username,'password' => $password);
		    //$result = $db->fetchAll($select, $params);
			$this->view->moduletitle = 'ûע';	    
		    if($result)
		    {
			    $this->view->msg .= $username.' ûѾڣ';	  
                echo $this->view->render('index/showreg.phtml');
		        return ;			      	
		    }
		    if($errno === true)
		    {
		    	//$this->view->message = $this->msg;
                echo $this->view->render('index/showreg.phtml');
		    	//echo '<br><br>תעҳ桭';
		        //header("refresh:3;url=./showreg");
		        return ;
		    }
		    echo '<br><br>ʼעᡭ';
            $table = new ZfMembers();
		    $data = array(
		        'username' => $username,
		        'password'  => md5($password),    
		        'email' => $email,
		    );
		    $id = $table->insert($data);
		    if($id > 0)
		    {
                $authAdapter = new Zend_Auth_Adapter_DbTable($db, 'zf_members', 'username', 'password');  
                $authAdapter->setIdentity($username);            
                $authAdapter->setCredential(md5($password));
                
                // do the authentication
                $auth = Zend_Auth::getInstance();
                $result = $auth->authenticate($authAdapter);
                if ($result->isValid()) 
                {
                    // success: store database row to auth's storage
                    // system. (Not the password though!)
                    $data = $authAdapter->getResultRowObject(null, 'password');
                    $auth->getStorage()->write($data);
                    //$this->view->username= $username;
                    $this->_redirect('/');
                    return;
                } 
		    	$this->_redirect('/showlogin');
		    	return;
		    }
		    $this->_redirect('/showreg');
		}

	}
	public function regsucAction()
	{
		echo '<br><br>';			
		echo 'ϲעɹ';
		echo '<br><br>';
		echo '<a href='.$this->view->baseUrl.'></a>';	
	}
	public function loginoutAction()
	{
		Zend_Auth::getInstance()->clearIdentity();
        $this->_redirect('/');
	}
    /**
     * ȱʡʱ
     */
    public function __call($method, $args)    
    {        
    	if ('Action' == substr($method, -6)) 
    	{            
    		// If the action method was not found, forward to the index action            
    		return $this->_forward('index');        
    	}        
    	// all other methods throw an exception        
    	throw new Exception('Invalid method "' . $method . '" called');    
    }	
}
?>