<?php
	@header('Content-type:text/html;charset=UTF-8');
	//session_cache_limiter('private, must-revalidate');
	error_reporting(E_ALL|E_STRICT);
	date_default_timezone_set('Asia/Shanghai');
	define('ROOT_DIR', dirname(dirname(__FILE__)));
	define('WEB_ROOT', 'http://127.0.0.1/blog/');
	define('CACHE_DIR', 'D:/www/blog/cache/');
	define('TABLE_PRE','oophp_');
	
	set_include_path('.'.PATH_SEPARATOR.'./library'.PATH_SEPARATOR.'./application/models/'.PATH_SEPARATOR.get_include_path());
	
	// Register the autoloader
	require_once 'Zend/Loader.php';
	Zend_Loader::registerAutoload();
	Zend_Session::start();
	//config  database  connect
	$config=new Zend_Config_Ini('./application/config/config.ini',null, true);
	Zend_Registry::set('config',$config);
	$dbAdapter=Zend_Db::factory($config->general->db->adapter,$config->general->db->config->toArray());
	$dbAdapter->query('SET NAMES UTF8');
	Zend_Db_Table::setDefaultAdapter($dbAdapter);
	Zend_Registry::set('dbAdapter',$dbAdapter);
	//config smarty 
	//$smartyParams=new Zend_Config_Ini('./application/config/config.ini','smarty');
	$smarty=new Custom_View_Smarty($config->smarty->toarray());
	Zend_Registry::set('smarty',$smarty);
	
	
	//zend cache
	
	require_once 'Zend/Cache.php';
	/*建立cache对象*/
	
	$frontendOptions = $config->cache->cache->frontend->toArray();
	$backendOptions = $config->cache->cache->backend->toArray();
	$frontendName = $frontendOptions['name'];
	unset($frontendOptions['name']);
	$backendName = $backendOptions['name'];       
	unset($backendOptions['name']);
	if (empty($backendOptions['cache_dir']))
	{
	 $backendOptions['cache_dir'] = CACHE_DIR;
	}   
	$cache = Zend_Cache::factory($frontendName, $backendName, $frontendOptions, $backendOptions);
	Zend_Registry::set('cache',$cache);
	
	

	/*
	$view = new Zend_View();
	Zend_Controller_Action_HelperBroker::getStaticHelper('viewRenderer')
	->setView($view);*/
	//create auth object
	$auth=Zend_Auth::getInstance();
	//create acl object
	$acl=new Custom_KenAcl();

	$frontController = Zend_Controller_Front::getInstance();
	$frontController->addModuleDirectory('./application/modules')
                //->setRouter($router)
                ->registerPlugin(new Custom_Controller_Plugin_Smarty())
                ->setBaseUrl('/blog')
                ->setParam('useDefaultControllerAlways', true)
                ->setParam('noViewRenderer', true)
                ->setParam('noErrorHandler', true)
                ->setParam('useDefaultControllerAlways', true)
            	->registerPlugin(new Custom_Controller_Plugin_KenAuth($auth, $acl));
	//Zend_Debug::dump($frontController->getParams(), $label=null, $echo=true);
	$frontController->throwExceptions(true); 
	$frontController->dispatch();