<?php
/**
 * Custom
 * 
 * LICENSE:
 * 
 * @category   Custom
 * @package    Custom
 * @copyright  Copyright (c)  KenJi
 * @license    
 * @version    OOPHP V1.01
 */
/**
 * Zend_Acl
 */
require_once	'Zend/Acl.php';

/**
 * Zend_Acl_Role
 */
require_once	'Zend/Acl/Role.php';

/**
 *Zend_Acl_Resource
 */
require_once	'Zend/Acl/Resource.php';

/**
 * Access Control List (ACL)
 * @category   Custom
 * @package    Custom
 * @author     
 * @copyright  Copyright (c)  KenJi
 * @license
 */
class	Custom_KenAcl	extends	Zend_Acl
{
	/**
	 * Constructor.
	 * @return void
	 */
	public function	__construct()
	{
		//Add resource
		$resource=new	Zend_Config_Ini('./application/config/resource.ini',null);
		foreach ($resource->toArray() as $key_one=>$arr) {
			$this->add(new Zend_Acl_Resource($key_one));
			foreach ($arr as $key_two=>$value){
				$this->add(new Zend_Acl_Resource($value),$key_one);
			}
		}
		
		//Add role
		$this->addRole(new Zend_Acl_Role('guest'));
		$this->addRole(new Zend_Acl_Role('member'),'guest');
		$this->addRole(new Zend_Acl_Role('admin'));
		 
    	
		//Assign ruleadmin:imgcode
		$this->allow('guest','default:index',array('index','rss'));
		$this->allow('guest','default:auth',array('login','logout'));
		$this->allow('guest','default:album',array('index','auth','photo'));
		$this->allow('guest','default:link',array('index','add'));
		$this->allow('guest','default:article',array('index','comment','rss','article'));
		$this->allow('guest','default:message',array('index','message'));
		$this->allow('guest','default:search',array('index'));
		$this->allow('guest','default:about',array('index'));
		$this->allow('guest','admin:auth',array('login','imgcode'));
		//$this->deny('guest','default:about',array('index'));
		$this->deny('member',array('admin:index'),array('index','top','menu','main'));
		//$this->deny('member', 'admin:index',null);
		//$this->removeAllow('member','admin:index',null);
		
		$this->allow('admin');
		
	}
}