<?php
/**
 * Copyright (C) 2009  Honghao Geng (genghonghao@gmail.com)
 * $Id: content.php 556 2010-01-24 05:19:53Z genghonghao $
 */

define('IN_ADMIN', TRUE);

require_once dirname(__FILE__) . '/includes/init.php';
require_once GEN_ROOT . '/languages/' . $_CONF['lang'] . '/admin/content.lang.php';

// 验证用户是否登录
if (false === verify_user()) {
    ;
    header("Location: ../login.php");
}

$tpl->assign('lang', $lang);

$action = isset($_REQUEST['act']) ? $_REQUEST['act'] : 'add_content';

// 获得当前页面的完整URL
$current_page_url = $base_url . '/' . $current_file . '?' . get_uri_param_string();

$tpl->assign('current_page_url', $current_page_url);

// 设定编辑的目录
$tpl->assign('admin_editor_path',    $base_url . '/kindeditor/');

// 设定获取本地图片的URL地址
$tpl->assign('local_image_url', './image.php?act=image_list&func=set_content');

// 添加文章
if ($action == 'add_content') {
// 所在位置
    $location_link = array("<a href='content.php?act=content.php'>" . $lang['2_content_manage']['name'] . "</a>",
            "<a href='content.php?act=$action'>" . $lang['2_content_manage']['add_content'] . "</a>"
    );
    // 相关操作
    $location_other = array("<a class='realbutton' href='content.php?act=content_list'>" . $lang['2_content_manage']['content_list'] . "</a>",
            "<a class='realbutton' href='content.php?act=category'>" . $lang['2_content_manage']['content_cate'] . "</a>",
            "<a class='realbutton' href='content.php?act=tag'>" . $lang['2_content_manage']['content_tag'] . "</a>"
    );
    // 取出标签数据
    $tag_list = array();
    $tags = $db->result("SELECT tag_id, tag_name FROM " . $db->get_table(TB_TAGS) . " ORDER BY tag_id ASC");
    foreach($tags as $val) {
        $tag_list[$val['tag_id']] = $val['tag_name'];
    }
    // 取出分类数据
    $cate_list = array();
    $cates = $db->result("SELECT category_id, category_name FROM " . $db->get_table(TB_CATEGORY) . " ORDER BY category_id ASC");
    foreach($cates as $val) {
        $cate_list[$val['category_id']] = $val['category_name'];
    }

    // 添加文章
    if (isset($_REQUEST['sub_add_content']) && !empty($_REQUEST['sub_add_content'])) {
        $subject = isset($_REQUEST['text_blog_subject']) ? trim($_REQUEST['text_blog_subject']) : '';
        $user_id = $_SESSION['user']['userid'];
        $username = $_SESSION['user']['username'];
        $cate_id = isset($_REQUEST['text_selected_category']) ? trim($_REQUEST['text_selected_category']) : '0';
        if (empty($cate_id)) {
            $cate_id = '0';
            $cate_name = '0';
        } else {
            $cate_name = $cate_list[$cate_id];
        }
        $tags_id = isset($_REQUEST['text_selected_tags']) ? trim($_REQUEST['text_selected_tags']) : '';
        if (substr($tags_id, -1) == ',') {
            $tags_id  = ',' . $tags_id;
        }

        $submit_time = time();
        $content = isset($_REQUEST['text_content']) ? trim($_REQUEST['text_content']) : '';
        $content = str_replace('../data/upload/images/', $base_root_url . '/data/upload/images/', $content);
        $is_original = isset($_REQUEST['text_blog_type']) ? trim($_REQUEST['text_blog_type']) : 1;
        $is_allow_comment = $_REQUEST['text_allow_comment'];

        $keywords = isset($_REQUEST['text_blog_keywords']) ? trim($_REQUEST['text_blog_keywords']) : '';

        $url = $base_url . "/content.php?act=add_content";

        if (!empty($subject) && !empty($content)) {
            // 编辑
            if (isset($_REQUEST['text_edit_article_id']) && is_numeric($_REQUEST['text_edit_article_id'])) {
                $aid = intval($_REQUEST['text_edit_article_id']);
                $query = $db->query("UPDATE " . $db->get_table(TB_ARTICLE) . "
                                    SET keywords='$keywords',
                                        category_id = '$cate_id',
                                        category_name = '$cate_name',
                                        tags_id = '$tags_id',
                                        last_change_time = '$submit_time',
                                        subject = '$subject',
                                        content = '$content',
                                        is_original = '$is_original',
                                        is_allow_comment = '$is_allow_comment'
                                    WHERE article_id = '$aid'
                        ");
                // 添加
            } else {
                $query = $db->query("INSERT INTO " . $db->get_table(TB_ARTICLE) .
                        "(`article_id`, `user_id`, `username`, `keywords`, `category_id`, `category_name`,
                `tags_id`, `submit_time`, `last_change_time`, `click_number`, `subject`, `content`,
                `repl_number`, `is_original`)
                VALUES(NULL, '$user_id', '$username', '$keywords', '$cate_id', '$cate_name', '$tags_id',
                '$submit_time', '$submit_time', '0', '$subject', '$content', '0', '$is_original')");
            }
            if (false !== $query) {
                redirect('Success', $lang['insert_success_text'], $current_page_url);
            } else {
                redirect('Failure', $lang['insert_db_failure'], $current_page_url);
            }
        } else {
            redirect('Failure', $lang['content_subject_not_null'], $current_page_url);
        }
    }

    // 编辑一篇文章前取出当前文章的数据
    if (isset($_REQUEST['mod']) && $_REQUEST['mod'] == 'edit' && isset($_REQUEST['aid']) && is_numeric($_REQUEST['aid'])) {
        $article_id = intval($_REQUEST['aid']);
        $result = $db->result("SELECT * FROM " . $db->get_table(TB_ARTICLE) . " WHERE `article_id`='$article_id'");
        $tpl->assign('only_article', $result[0]);
        $tags_sel = explode(',', substr($result[0]['tags_id'], 1, -1));
        $tpl->assign('tags_sel', $tags_sel);
        unset($article_id, $result, $tags_sel);
    }

    $tpl->assign('location_link', $location_link);
    $tpl->assign('location_other', $location_other);
    $tpl->assign('tags_list', $tags);
    $tpl->assign('cate_list', $cates);
    $tpl->display('add_content.html');
}

// 标签管理
elseif ($action == 'tag') {

// 判断是否是在其它页面以弹出的方式添加标签
    $notpage = isset($_REQUEST['notpage']) ? true : false;
    if (true == $notpage) {
        $tpl->assign('notpage', 'true');
    }

    // 添加新标签
    if (isset($_REQUEST['sub_add_tag']) && !empty($_REQUEST['sub_add_tag'])) {
        $tag_name = isset($_REQUEST['text_tag_name']) ? trim($_REQUEST['text_tag_name']) : null;
        $url = $base_url . "/content.php?act=tag";
        if (!empty($tag_name)) {
            $query = $db->query("INSERT INTO " . $db->get_table(TB_TAGS) . "(`tag_id`, `tag_name`) VALUES(NULL, '$tag_name')");
            if (false !== $query) {
                redirect('Success', $lang['insert_success_text'], $url);
            } else {
                redirect('Failure', $lang['insert_db_failure'], $url);
            }
        } else {
            redirect('Failure', $lang['data_not_null'], $url);
        }
    }

    // 删除标签
    if (isset($_REQUEST['sub_del_tag']) && !empty($_REQUEST['sub_del_tag'])) {
        $tags_id = isset($_REQUEST['text_tags_id']) ? $_REQUEST['text_tags_id'] : null;

        $url = $base_url . "/content.php?act=tag";

        if (isset($tags_id) && is_array($tags_id)) {
            $tags = implode(',', $tags_id);
            $query = $db->query("DELETE FROM " . $db->get_table(TB_TAGS) . " WHERE `tag_id` IN ($tags)");
            if (false !== $query) {
                redirect('Success', $lang['delete_success_text'], $url);
            } else {
                redirect('Failure', $lang['delete_db_failure'], $url);
            }
        } else {
            redirect('Failure', $lang['delete_not_null'], $url);
        }
    }

    // 所在位置
    $location_link = array("<a href='content.php'>" . $lang['2_content_manage']['name'] . "</a>",
            "<a href='content.php?act=$action'>" . $lang['2_content_manage']['content_tag'] . "</a>"
    );
    // 相关操作
    $location_other = array("<a class='realbutton' href='content.php?act=add_content'>" . $lang['2_content_manage']['add_content'] . "</a>",
            "<a class='realbutton' href='content.php?act=category'>" . $lang['2_content_manage']['content_cate'] . "</a>"
    );
    // 取出标签数据
    $tags = $db->result("SELECT tag_id, tag_name FROM " . $db->get_table(TB_TAGS) . " ORDER BY tag_id ASC");

    $tpl->assign('location_link', $location_link);
    $tpl->assign('location_other', $location_other);
    $tpl->assign('tags_list', $tags);
    $tpl->display('tag.html');
}

// 分类管理
elseif ($action == 'category') {
// 添加新分类
    if (isset($_REQUEST['sub_add_cate']) && !empty($_REQUEST['sub_add_cate'])) {
        $cate_name = isset($_REQUEST['text_cate_name']) ? trim($_REQUEST['text_cate_name']) : null;
        $url = $base_url . "/content.php?act=category";
        if (!empty($cate_name)) {
            $query = $db->query("INSERT INTO " . $db->get_table(TB_CATEGORY) . "(`category_id`, `category_name`) VALUES(NULL, '$cate_name')");
            if (false !== $query) {
                redirect('Success', $lang['insert_success_text'], $url);
            } else {
                redirect('Failure', $lang['insert_db_failure'], $url);
            }
        } else {
            redirect('Failure', $lang['data_not_null'], $url);
        }
    }

    // 删除分类
    if (isset($_REQUEST['sub_del_cate']) && !empty($_REQUEST['sub_del_cate'])) {
        $cate_id = isset($_REQUEST['text_cate_id']) ? $_REQUEST['text_cate_id'] : null;

        $url = $base_url . "/content.php?act=category";

        if (isset($cate_id) && is_array($cate_id)) {
            $cates_id = implode(',', $cate_id);
            $query = $db->query("DELETE FROM " . $db->get_table(TB_CATEGORY) . " WHERE `category_id` IN ($cates_id)");
            if (false !== $query) {
                redirect('Success', $lang['delete_success_text'], $url);
            } else {
                redirect('Failure', $lang['delete_db_failure'], $url);
            }
        } else {
            redirect('Failure', $lang['delete_not_null'], $url);
        }
    }

    // 所在位置
    $location_link = array("<a href='content.php'>" . $lang['2_content_manage']['name'] . "</a>",
            "<a href='content.php?act=$action'>" . $lang['2_content_manage']['content_cate'] . "</a>"
    );
    // 相关操作
    $location_other = array("<a class='realbutton' href='content.php?act=add_content'>" . $lang['2_content_manage']['add_content'] . "</a>",
            "<a class='realbutton' href='content.php?act=tag'>" . $lang['2_content_manage']['content_tag'] . "</a>"
    );
    // 取出标签数据
    $cate_list = $db->result("SELECT category_id, category_name FROM " . $db->get_table(TB_CATEGORY) . " ORDER BY category_id ASC");

    $tpl->assign('location_link', $location_link);
    $tpl->assign('location_other', $location_other);
    $tpl->assign('cate_list', $cate_list);
    $tpl->display('category.html');
}

// 评论过滤
elseif ($action == 'filter') {
// 添加新过滤词
    if (isset($_REQUEST['sub_add_filter']) && !empty($_REQUEST['sub_add_filter'])) {
        $filter_name = isset($_REQUEST['text_filter_name']) ? trim($_REQUEST['text_filter_name']) : null;
        if (!empty($filter_name)) {
            $query = $db->query("INSERT INTO " . $db->get_table(TB_COMMENT_FILTER) . "(`filter_id`, `filter_name`) VALUES(NULL, '$filter_name')");
            if (false !== $query) {
                redirect('Success', $lang['insert_success_text'], $current_page_url);
            } else {
                redirect('Failure', $lang['insert_db_failure'], $current_page_url);
            }
        } else {
            redirect('Failure', $lang['data_not_null'], $current_page_url);
        }
    }

    // 删除过滤词
    if (isset($_REQUEST['sub_del_filter']) && !empty($_REQUEST['sub_del_filter'])) {
        $filter_id = isset($_REQUEST['text_filter_id']) ? $_REQUEST['text_filter_id'] : null;

        if (isset($filter_id) && is_array($filter_id)) {
            $filters_id = implode(',', $filter_id);
            $query = $db->query("DELETE FROM " . $db->get_table(TB_COMMENT_FILTER) . " WHERE `filter_id` IN ($filters_id)");
            if (false !== $query) {
                redirect('Success', $lang['delete_success_text'], $current_page_url);
            } else {
                redirect('Failure', $lang['delete_db_failure'], $current_page_url);
            }
        } else {
            redirect('Failure', $lang['delete_not_null'], $current_page_url);
        }
    }

    // 所在位置
    $location_link = array("<a href='content.php'>" . $lang['2_content_manage']['name'] . "</a>",
            "<a href='content.php?act=$action'>" . $lang['2_content_manage']['comment_filter'] . "</a>"
    );
    // 相关操作
    $location_other = array("<a class='realbutton' href='content.php?act=add_content'>" . $lang['2_content_manage']['add_content'] . "</a>",
            "<a class='realbutton' href='content.php?act=content_list'>" . $lang['2_content_manage']['content_list'] . "</a>",
            "<a class='realbutton' href='content.php?act=category'>" . $lang['2_content_manage']['content_cate'] . "</a>",
            "<a class='realbutton' href='content.php?act=tag'>" . $lang['2_content_manage']['content_tag'] . "</a>"
    );
    // 取出过滤词数据
    $filter_list = $db->result("SELECT filter_id, filter_name FROM " . $db->get_table(TB_COMMENT_FILTER) . " ORDER BY filter_id ASC");

    $tpl->assign('location_link', $location_link);
    $tpl->assign('location_other', $location_other);
    $tpl->assign('filter_list', $filter_list);
    $tpl->display('comment_filter.html');
}

// 文章列表
elseif ($action == 'content_list') {

    $where = ' WHERE 1=1 ';

    // 搜索
    if (isset($_REQUEST['text_search_sub'])) {
        if (isset($_REQUEST['text_tag_search']) && $_REQUEST['text_tag_search'] != '0') {
            $w_tag_id = intval($_REQUEST['text_tag_search']);
            $tpl->assign('w_tag_id', $w_tag_id);
            $where .= " AND tags_id LIKE '%,$w_tag_id,%'";
        }
        if (isset($_REQUEST['text_cate_search']) && $_REQUEST['text_cate_search'] != '0') {
            $w_cate_id = intval($_REQUEST['text_cate_search']);
            $tpl->assign('w_cate_id', $w_cate_id);
            $where .= " AND category_id='$w_cate_id'";
        }
        if (!empty($_REQUEST['text_subject_search'])) {
            $w_subject_val = trim($_REQUEST['text_subject_search']);
            $tpl->assign('w_subject_val', $w_subject_val);
            $where .= " AND subject LIKE '%$w_subject_val%'";
        }
    }

    // 批量删除文章
    if (isset($_REQUEST['sub_del_article']) && !empty($_REQUEST['sub_del_article'])) {
        $article_id = isset($_REQUEST['text_articles_id']) ? $_REQUEST['text_articles_id'] : null;

        if (isset($article_id) && is_array($article_id)) {
            $ar_id = implode(',', $article_id);
            $query = $db->query("DELETE FROM " . $db->get_table(TB_ARTICLE) . " WHERE `article_id` IN ($ar_id)");
            if (false !== $query) {
                redirect('Success', $lang['delete_success_text'], $current_page_url);
            } else {
                redirect('Failure', $lang['delete_db_failure'], $current_page_url);
            }
        } else {
            redirect('Failure', $lang['delete_not_null'], $current_page_url);
        }
    }

    // 单独删除一篇文章
    if (isset($_REQUEST['mod']) && $_REQUEST['mod'] == 'del' && isset($_REQUEST['aid']) && is_numeric($_REQUEST['aid'])) {
        $article_id = intval($_REQUEST['aid']);
        $query = $db->query("DELETE FROM " . $db->get_table(TB_ARTICLE) . " WHERE `article_id`='$article_id'");
        $current_page_url = str_replace("&mod=del&aid=$article_id", '', $current_page_url);
        if (false !== $query) {
            unset($article_id, $query);
            redirect('Success', $lang['delete_success_text'], $current_page_url);
        } else {
            unset($article_id, $query);
            redirect('Failure', $lang['delete_db_failure'], $current_page_url);
        }

    }

    // 所在位置
    $location_link = array("<a href='content.php'>" . $lang['2_content_manage']['name'] . "</a>",
            "<a href='content.php?act=$action'>" . $lang['2_content_manage']['content_list'] . "</a>"
    );
    // 相关操作
    $location_other = array("<a class='realbutton' href='content.php?act=add_content'>" . $lang['2_content_manage']['add_content'] . "</a>",
            "<a class='realbutton' href='content.php?act=tag'>" . $lang['2_content_manage']['content_tag'] . "</a>"
    );

    // 取出标签数据
    $tags_list = $db->result("SELECT tag_id, tag_name FROM " . $db->get_table(TB_TAGS) . " ORDER BY tag_id ASC");
    // 取出标签数据
    $cate_list = $db->result("SELECT category_id, category_name FROM " . $db->get_table(TB_CATEGORY) . " ORDER BY category_id ASC");

    // 分页数据
    $temp = $db->result("SELECT COUNT(*) AS num FROM " . $db->get_table(TB_ARTICLE) . $where);
    $total = $temp[0]['num'];
    $perpage = 15;
    if (!isset($_REQUEST['page']) || is_int($_REQUEST['page'])) {
        $p = 0;
    }
    else {
        $p = ((int)$_REQUEST['page'] - 1) * $perpage;
        if ($p >= $total) {
            $p = 0;
        }
    }

    // 分页
    require GEN_ROOT . 'includes/page.class.php';
    $page = new page(array('total'=>$total,'perpage'=>$perpage));
    $tpl->assign('page', $page->show(4));

    // 取出文章数据
    $article_list = $db->result("SELECT article_id, subject, user_id, username, category_name, submit_time, click_number, repl_number FROM " . $db->get_table(TB_ARTICLE) . $where . " ORDER BY article_id DESC LIMIT $p, $perpage");

    $tpl->assign('location_link', $location_link);
    $tpl->assign('location_other', $location_other);
    $tpl->assign('article_list', $article_list);
    $tpl->assign('tags_list', $tags_list);
    $tpl->assign('cate_list', $cate_list);
    $tpl->display('content_list.html');
}

// 评论列表
elseif ($action == 'comment_list') {

    $where = ' WHERE a.article_id=r.article_id ';

    // 搜索
    if (isset($_REQUEST['text_search_sub'])) {
        if (isset($_REQUEST['text_tag_search']) && $_REQUEST['text_tag_search'] != '0') {
            $w_tag_id = intval($_REQUEST['text_tag_search']);
            $tpl->assign('w_tag_id', $w_tag_id);
            $where .= " AND a.tags_id LIKE '%,$w_tag_id,%'";
        }
        if (isset($_REQUEST['text_cate_search']) && $_REQUEST['text_cate_search'] != '0') {
            $w_cate_id = intval($_REQUEST['text_cate_search']);
            $tpl->assign('w_cate_id', $w_cate_id);
            $where .= " AND a.category_id='$w_cate_id'";
        }
        if (!empty($_REQUEST['text_subject_search'])) {
            $w_subject_val = trim($_REQUEST['text_subject_search']);
            $tpl->assign('w_subject_val', $w_subject_val);
            $where .= " AND a.subject LIKE '%$w_subject_val%'";
        }
        if (!empty($_REQUEST['text_comment_search'])) {
            $w_comment_val = trim($_REQUEST['text_comment_search']);
            $tpl->assign('w_comment_val', $w_comment_val);
            $where .= " AND r.content LIKE '%$w_comment_val%'";
        }
    }

    // 批量删除评论
    if (isset($_REQUEST['sub_del_reply']) && !empty($_REQUEST['sub_del_reply'])) {
        $reply_id = isset($_REQUEST['text_reply_id']) ? $_REQUEST['text_reply_id'] : null;
        if (isset($reply_id) && is_array($reply_id)) {
            
            // 取出article_id
            $art_list = array();
            foreach($reply_id AS $item) {
                $temp = $db->result("SELECT article_id FROM " . $db->get_table(TB_REPLY) . " WHERE `reply_id`='$item'");
                if (array_key_exists($temp[0]['article_id'], $art_list)) {
                    $art_list[$temp[0]['article_id']]++;
                } else {
                    $art_list[$temp[0]['article_id']] = 1;
                }
            }

            $ar_id = implode(',', $reply_id);
            $query = $db->query("DELETE FROM " . $db->get_table(TB_REPLY) . " WHERE `reply_id` IN ($ar_id)");
            if (false !== $query) {
                // 更新文章中的回复数
                foreach($art_list AS $key=>$val) {
                    $db->query("UPDATE " . $db->get_table(TB_ARTICLE) . " SET repl_number=repl_number-$val WHERE `article_id`='$key'");
                }
                redirect('Success', $lang['delete_success_text'], $current_page_url);
            } else {
                redirect('Failure', $lang['delete_db_failure'], $current_page_url);
            }
        } else {
            redirect('Failure', $lang['delete_not_null'], $current_page_url);
        }
    }

    // 单独删除一条评论
    if (isset($_REQUEST['mod']) && $_REQUEST['mod'] == 'del' && isset($_REQUEST['rid']) && is_numeric($_REQUEST['rid'])) {
        $reply_id = intval($_REQUEST['rid']);
        // 获取文章ID
        $article_id = $db->result("SELECT article_id FROM " . $db->get_table(TB_REPLY) . " WHERE `reply_id`='$reply_id'");
        $article_id = $article_id[0]['article_id'];

        $query = $db->query("DELETE FROM " . $db->get_table(TB_REPLY) . " WHERE `reply_id`='$reply_id'");
        $current_page_url = str_replace("&mod=del&rid=$reply_id", '', $current_page_url);
        if (false !== $query) {
            // 更新文章表中的回复数
            $db->query("UPDATE " . $db->get_table(TB_ARTICLE) . " SET repl_number=repl_number-1 WHERE `article_id`='$article_id'");

            unset($reply_id, $query);
            redirect('Success', $lang['delete_success_text'], $current_page_url);
        } else {
            unset($reply_id, $query);
            redirect('Failure', $lang['delete_db_failure'], $current_page_url);
        }

    }

    // 所在位置
    $location_link = array("<a href='content.php'>" . $lang['2_content_manage']['name'] . "</a>",
            "<a href='content.php?act=$action'>" . $lang['2_content_manage']['comment_list'] . "</a>"
    );
    // 相关操作
    $location_other = array("<a class='realbutton' href='content.php?act=add_content'>" . $lang['2_content_manage']['add_content'] . "</a>",
            "<a class='realbutton' href='content.php?act=content_list'>" . $lang['2_content_manage']['content_list'] . "</a>",
            "<a class='realbutton' href='content.php?act=tag'>" . $lang['2_content_manage']['content_tag'] . "</a>"
    );

    // 取出标签数据
    $tags_list = $db->result("SELECT tag_id, tag_name FROM " . $db->get_table(TB_TAGS) . " ORDER BY tag_id ASC");
    // 取出标签数据
    $cate_list = $db->result("SELECT category_id, category_name FROM " . $db->get_table(TB_CATEGORY) . " ORDER BY category_id ASC");

    // 分页数据
    $temp = $db->result("SELECT COUNT(*) AS num FROM " . $db->get_table(TB_ARTICLE) . " AS a, " . $db->get_table(TB_REPLY) . " AS r" . $where);
    $total = $temp[0]['num'];
    $perpage = 15;
    if (!isset($_REQUEST['page']) || is_int($_REQUEST['page'])) {
        $p = 0;
    }
    else {
        $p = ((int)$_REQUEST['page'] - 1) * $perpage;
        if ($p >= $total) {
            $p = 0;
        }
    }

    // 分页
    require GEN_ROOT . 'includes/page.class.php';
    $page = new page(array('total'=>$total,'perpage'=>$perpage));
    $tpl->assign('page', $page->show(4));

    // 取出文章数据
    $comment_list = $db->result("SELECT * FROM " . $db->get_table(TB_ARTICLE) . " AS a, " . $db->get_table(TB_REPLY) . " AS r" . $where . " ORDER BY reply_id DESC LIMIT $p, $perpage");

    $tpl->assign('location_link', $location_link);
    $tpl->assign('location_other', $location_other);
    $tpl->assign('comment_list', $comment_list);
    $tpl->assign('tags_list', $tags_list);
    $tpl->assign('cate_list', $cate_list);
    $tpl->display('comment_list.html');
}
?>